/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms.events;

import java.util.HashMap;
import java.util.Map;
import org.bedework.util.jms.events.NamedEvent;
import org.bedework.util.misc.ToString;

public class StatsEvent
extends NamedEvent {
    private static final long serialVersionUID = 1L;
    private Long longValue;
    private String strValue;
    public static final String deleteTime = "DELTIME";
    public static final String createTime = "CRETIME";
    public static final String checkNameTime = "CNAMETIME";
    public static final String checkUidTime = "CUIDTIME";
    public static final String refreshTime = "REFRESHTIME";
    private static final Map<String, StatType> statTypes = new HashMap<String, StatType>();

    public StatsEvent(String name, String strValue) {
        super("STATS", name);
        this.strValue = strValue;
    }

    public StatsEvent(String name, Long longValue) {
        super("STATS", name);
        this.longValue = longValue;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public static StatType getStatType(String name) {
        return statTypes.get(name);
    }

    @Override
    public void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        if (this.strValue == null) {
            ts.append("longValue", this.getLongValue());
        } else {
            ts.append("strValue", (Object)this.getStrValue());
        }
    }

    static {
        statTypes.put(deleteTime, StatType.lnum);
        statTypes.put(createTime, StatType.lnum);
        statTypes.put(checkNameTime, StatType.lnum);
        statTypes.put(checkUidTime, StatType.lnum);
    }

    public static enum StatType {
        valueLess,
        str,
        lnum;

    }
}

