/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bedework.util.jms.events.StatsEvent;
import org.bedework.util.jms.events.TimedEvent;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class SysEvent
implements Serializable,
Comparable<SysEvent> {
    public static final String syscodeStats = "STATS";
    public static final String syscodeTimedEvent = "TIMED_EVENT";
    private static final long serialVersionUID = 1L;
    private final String sysCode;
    private SysEvent related;
    private String dtstamp;
    private int sequence;

    public SysEvent(String sysCode) {
        this.sysCode = sysCode;
        this.updateDtstamp();
    }

    public String getSysCode() {
        return this.sysCode;
    }

    public void addMessageAttributes(List<Attribute> attrs) {
        attrs.add(new Attribute("syscode", this.getSysCode()));
    }

    public List<Attribute> getMessageAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        this.addMessageAttributes(attrs);
        return attrs;
    }

    public void setDtstamp(String val) {
        this.dtstamp = val;
    }

    public String getDtstamp() {
        return this.dtstamp;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setRelated(SysEvent val) {
        this.related = val;
    }

    public SysEvent getRelated() {
        return this.related;
    }

    public static SysEvent makeTimedEvent(String label, long millisecs) {
        return new TimedEvent(syscodeTimedEvent, label, millisecs);
    }

    public static SysEvent makeStatsEvent(String name, Long longValue) {
        return new StatsEvent(name, longValue);
    }

    private void updateDtstamp() {
        this.setDtstamp(Util.icalUTCTimestamp());
        this.setSequence(this.getSequence() + 1);
    }

    @Override
    public int compareTo(SysEvent val) {
        if (val == null) {
            return 1;
        }
        return this.sysCode.compareTo(val.sysCode);
    }

    public int hashCode() {
        return this.sysCode.hashCode();
    }

    public void toStringSegment(ToString ts) {
        ts.append("sysCode", (Object)String.valueOf(this.getSysCode()));
        ts.append("dtstamp", (Object)this.getDtstamp());
        ts.append("sequence", this.getSequence());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

