/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms.listeners;

import java.io.InvalidClassException;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.bedework.util.jms.JmsConnectionHandler;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.jms.events.SysEvent;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;

public abstract class JmsSysEventListener
implements Logged,
MessageListener,
ExceptionListener {
    private JmsConnectionHandler conn;
    private MessageConsumer consumer;
    private boolean running = true;
    private final BwLogger logger = new BwLogger();

    public void open(String queueName, Properties pr) throws NotificationException {
        this.conn = new JmsConnectionHandler(pr);
        this.conn.open(queueName);
        this.consumer = this.conn.getConsumer();
    }

    public void close() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (Throwable t) {
                this.warn(t.getMessage());
            }
        }
        this.conn.close();
    }

    public void process(boolean asynch) throws NotificationException {
        if (asynch) {
            try {
                this.consumer.setMessageListener((MessageListener)this);
                return;
            }
            catch (JMSException je) {
                throw new NotificationException(je);
            }
        }
        while (this.running) {
            Message m = this.conn.receive();
            if (m == null) {
                this.running = false;
                return;
            }
            this.onMessage(m);
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                SysEvent ev = (SysEvent)((ObjectMessage)message).getObject();
                this.action(ev);
            }
        }
        catch (NotificationException ne) {
            ne.printStackTrace();
        }
        catch (JMSException je) {
            if (Util.causeIs((Throwable)je, InvalidClassException.class)) {
                this.warn("Ignoring message of unknown class");
            }
            this.error(je);
        }
    }

    public synchronized void onException(JMSException ex) {
    }

    public abstract void action(SysEvent var1) throws NotificationException;

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

