/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms.listeners;

import java.util.Properties;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.jms.events.SysEvent;
import org.bedework.util.jms.listeners.SysEventActionClass;
import org.bedework.util.jms.listeners.SysEventListener;

public class SysEventListenerImpl
extends SysEventListener {
    private String actionClassName;
    private SysEventActionClass actionObject;
    protected String sysCode;
    protected Properties props;

    public SysEventListenerImpl(String code) {
        this.sysCode = code;
    }

    public SysEventListenerImpl(String code, SysEventActionClass actionObject) throws NotificationException {
        this.sysCode = code;
        this.setActionObject(actionObject);
    }

    @Override
    public void setActionClassName(String className) throws NotificationException {
        this.actionClassName = className;
    }

    @Override
    public void setActionObject(SysEventActionClass actionObject) throws NotificationException {
        this.actionObject = actionObject;
        if (actionObject == null) {
            this.actionClassName = null;
        } else {
            this.setActionClassName(actionObject.getClass().getName());
        }
    }

    @Override
    public void action(SysEvent ev) throws NotificationException {
        if (this.actionObject == null) {
            if (this.actionClassName == null) {
                throw new NotificationException("org.bedework.exception.noactionclassname");
            }
            Object o = null;
            try {
                o = Class.forName(this.actionClassName).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (o == null) {
                throw new NotificationException("org.bedework.exception.noactionclass", this.actionClassName);
            }
            if (!(o instanceof SysEventActionClass)) {
                throw new NotificationException("org.bedework.exception.notactionclass", this.actionClassName);
            }
            this.setActionObject(o);
        }
        this.actionObject.action(ev);
    }

    @Override
    public String toXml() throws NotificationException {
        return null;
    }
}

