/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.struts;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.servlet.MessageEmit;

public class ErrorEmitSvlt
implements MessageEmit {
    protected transient String id;
    protected transient Object caller;
    protected transient MessageResources messages;
    protected transient ActionErrors errors;
    protected transient String exceptionPname;
    protected ArrayList<Msg> msgList = new ArrayList();
    private BwLogger logger = new BwLogger();

    public void reinit(String id, Object caller, MessageResources messages, ActionErrors errors, String exceptionPname, boolean clear) {
        this.id = id;
        this.caller = caller;
        this.messages = messages;
        this.errors = errors;
        this.exceptionPname = exceptionPname;
        if (clear) {
            this.msgList.clear();
        }
    }

    public ArrayList<Msg> getMsgList() {
        return this.msgList;
    }

    public void emit(String pname) {
        if (this.debug()) {
            this.debugMsg(pname, null, null);
        }
        this.msgList.add(new Msg(this.messages, pname));
        if (this.messages == null || !this.haveOutputObject()) {
            return;
        }
        try {
            this.errors.add(this.id, new ActionMessage(pname));
        }
        catch (Throwable t) {
            this.error(this.className() + ": exception adding Action message", t);
        }
    }

    public void emit(String pname, int num) {
        if (this.debug()) {
            this.debugMsg(pname, "int", String.valueOf(num));
        }
        this.emit(pname, new Integer(num));
    }

    public void setExceptionPname(String pname) {
        this.exceptionPname = pname;
    }

    public void emit(Throwable t) {
        String msg;
        if (this.debug()) {
            this.debugMsg(this.exceptionPname, "Throwable", String.valueOf(t.getMessage()));
        }
        if ((msg = t.getMessage()) == null) {
            msg = "<No-message>";
        }
        this.error(msg, t);
        this.emit(this.exceptionPname, t.getMessage());
    }

    public void emit(String pname, Object o) {
        if (this.debug()) {
            if (o == null) {
                this.debugMsg(pname, "null object", "null");
            } else {
                this.debugMsg(pname, o.getClass().getName(), String.valueOf(o));
            }
        }
        if (o == null) {
            this.msgList.add(new Msg(this.messages, pname));
        } else {
            this.msgList.add(new Msg(this.messages, pname, o));
        }
        if (this.messages == null || !this.haveOutputObject()) {
            return;
        }
        try {
            this.errors.add(this.id, new ActionMessage(pname, o));
        }
        catch (Throwable t) {
            this.error(this.className() + ": exception adding Action error", t);
        }
    }

    public void emit(String pname, Object o1, Object o2) {
        if (this.debug()) {
            this.debugMsg(pname, "2objects", String.valueOf(o1) + "; " + String.valueOf(o2));
        }
        this.msgList.add(new Msg(this.messages, pname, o1, o2));
        if (this.messages == null || !this.haveOutputObject()) {
            return;
        }
        try {
            this.errors.add(this.id, new ActionMessage(pname, o1, o2));
        }
        catch (Throwable t) {
            this.error(this.className() + ": exception adding Action error", t);
        }
    }

    public void emit(String pname, Object o1, Object o2, Object o3) {
        if (this.debug()) {
            this.debugMsg(pname, "2objects", String.valueOf(o1) + "; " + String.valueOf(o2) + "; " + String.valueOf(o3));
        }
        this.msgList.add(new Msg(this.messages, pname, o1, o2, o3));
        if (this.messages == null || !this.haveOutputObject()) {
            return;
        }
        try {
            this.errors.add(this.id, new ActionMessage(pname, o1, o2, o3));
        }
        catch (Throwable t) {
            this.error(this.className() + ":exception adding Action error" + pname, t);
        }
    }

    public void clear() {
    }

    public boolean messagesEmitted() {
        return !this.msgList.isEmpty();
    }

    public ActionErrors getErrors() {
        return this.errors;
    }

    protected boolean haveOutputObject() {
        return this.errors != null;
    }

    protected String className() {
        return "ErrorEmitSvlt";
    }

    protected void debugMsg(String pname, String ptype, String pval) {
        this.debug("Emitted: property=" + pname + " ptype=" + ptype + " val(s)=" + pval);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public class Msg
    implements Serializable {
        private ArrayList<Object> params = new ArrayList();
        private Object p1;
        private Object p2;
        private Object p3;
        private String msgId;
        protected MessageResources messages;

        public Msg(MessageResources messages, String msgId) {
            this.messages = messages;
            this.msgId = msgId;
        }

        public Msg(MessageResources messages, String msgId, Object o) {
            this.messages = messages;
            this.msgId = msgId;
            this.addParam(o);
            this.p1 = o;
        }

        public Msg(MessageResources messages, String msgId, Object o1, Object o2) {
            this.messages = messages;
            this.msgId = msgId;
            this.addParam(o1);
            this.addParam(o2);
            this.p1 = o1;
            this.p2 = o2;
        }

        public Msg(MessageResources messages, String msgId, Object o1, Object o2, Object o3) {
            this.messages = messages;
            this.msgId = msgId;
            this.addParam(o1);
            this.addParam(o2);
            this.addParam(o3);
            this.p1 = o1;
            this.p2 = o2;
            this.p3 = o3;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public ArrayList getParams() {
            return this.params;
        }

        public String getMsg() {
            if (this.messages == null) {
                return "";
            }
            return this.messages.getMessage(this.msgId, this.p1, this.p2, this.p3);
        }

        private void addParam(Object o) {
            if (o != null) {
                this.params.add(o);
            }
        }
    }
}

