/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.bedework.util.servlet.MessageEmit;
import org.bedework.util.servlet.ReqUtil;
import org.bedework.util.struts.UtilActionForm;

public class Request
extends ReqUtil {
    protected UtilActionForm form;
    protected Action action;
    protected ActionMapping mapping;
    public static final int actionTypeUnknown = 0;
    public static final int actionTypeRender = 1;
    public static final int actionTypeAction = 2;
    public static final int actionTypeResource = 3;
    public static final String[] actionTypes = new String[]{"unknown", "render", "action", "resource"};
    protected int actionType;
    public static final String refreshIntervalReqPar = "refinterval";
    public static final String actionTypeKey = "actionType=";
    public static final String conversationKey = "conversation=";
    public static final String refreshIntervalKey = "refinterval=";
    public static final String refreshActionKey = "refaction=";
    public static final String moduleNameKey = "mdl=";
    public static final int conversationTypeUnknown = 0;
    public static final int conversationTypeStart = 1;
    public static final int conversationTypeContinue = 2;
    public static final int conversationTypeEnd = 3;
    public static final int conversationTypeOnly = 4;
    public static final int conversationTypeProcessAndOnly = 5;
    public static final String[] conversationTypes = new String[]{"unknown", "start", "continue", "end", "only", "processAndOnly"};
    protected int conversationType;
    public static final String moduleNamePar = "mdl";
    protected String moduleName;

    public Request(HttpServletRequest request, HttpServletResponse response, UtilActionForm form, Action action, ActionMapping mapping) {
        super(request, response);
        String convType;
        this.form = form;
        this.action = action;
        this.mapping = mapping;
        String at = this.getStringActionPar(actionTypeKey);
        if (at != null) {
            for (int ati = 0; ati < actionTypes.length; ++ati) {
                if (!actionTypes[ati].equals(at)) continue;
                this.actionType = ati;
                break;
            }
        }
        if ((convType = this.getStringActionPar(conversationKey)) != null) {
            for (int ati = 0; ati < conversationTypes.length; ++ati) {
                if (!conversationTypes[ati].equals(convType)) continue;
                this.conversationType = ati;
                break;
            }
        }
        this.moduleName = this.getStringActionPar(moduleNameKey);
    }

    public UtilActionForm getForm() {
        return this.form;
    }

    public Action getAction() {
        return this.action;
    }

    public ActionMapping getMapping() {
        return this.mapping;
    }

    public void error(Throwable val) {
        this.getErr().emit(val);
    }

    public void error(String pname) {
        this.getErr().emit(pname);
    }

    public void error(String pname, Object o) {
        this.getErr().emit(pname, o);
    }

    public MessageEmit getErr() {
        this.errFlag = true;
        return this.form.getErr();
    }

    public void message(String pname) {
        this.getMsg().emit(pname);
    }

    public void message(String pname, Object o) {
        this.getMsg().emit(pname, o);
    }

    public MessageEmit getMsg() {
        return this.form.getMsg();
    }

    public boolean getErrorsEmitted() {
        return this.errFlag || this.form.getErrorsEmitted();
    }

    public int getActionType() {
        return this.actionType;
    }

    public String getActionPath() {
        return this.mapping.getPath();
    }

    public String getActionParameter() {
        return this.mapping.getParameter();
    }

    public int getConversationType() {
        return this.conversationType;
    }

    public String getModuleName() {
        String nm = this.getReqPar(moduleNamePar);
        if (nm == null) {
            nm = this.moduleName;
        }
        return nm;
    }

    public Integer getRefreshInt() {
        try {
            Integer res = super.getIntReqPar(refreshIntervalReqPar);
            if (res != null) {
                return res;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getIntActionPar(refreshIntervalKey);
    }

    public String getRefreshAction() {
        return this.getStringActionPar(refreshActionKey);
    }

    public Integer getIntReqPar(String name, String errProp) throws Throwable {
        try {
            return super.getIntReqPar(name);
        }
        catch (Throwable t) {
            this.getErr().emit(errProp, (Object)this.getReqPar(name));
            return null;
        }
    }

    public Integer getIntActionPar(String name) {
        return this.getIntActionPar(name, this.getActionParameter());
    }

    public String getStringActionPar(String name) {
        return this.getStringActionPar(name, this.getActionParameter());
    }

    protected Integer getIntActionPar(String name, String par) {
        if (par == null) {
            return null;
        }
        try {
            int pos = par.indexOf(name);
            if (pos < 0) {
                return null;
            }
            int epos = par.indexOf(";", pos += name.length());
            if (epos < 0) {
                epos = par.length();
            }
            return Integer.valueOf(par.substring(pos, epos));
        }
        catch (Throwable t) {
            this.form.getErr().emit("edu.rpi.bad.actionparameter", (Object)par);
            return null;
        }
    }

    public String getStringActionPar(String name, String par) {
        if (par == null) {
            return null;
        }
        try {
            int pos = par.indexOf(name);
            if (pos < 0) {
                return null;
            }
            int epos = par.indexOf(";", pos += name.length());
            if (epos < 0) {
                epos = par.length();
            }
            return par.substring(pos, epos);
        }
        catch (Throwable t) {
            this.form.getErr().emit("edu.rpi.bad.actionparameter", (Object)par);
            return null;
        }
    }
}

