/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.servlet.HttpServletUtils;
import org.bedework.util.servlet.MessageEmit;
import org.bedework.util.struts.ErrorEmitSvlt;
import org.bedework.util.struts.MessageEmitSvlt;

public class StrutsUtil
extends HttpServletUtils {
    private static BwLogger logger = new BwLogger().setLoggedClass(HttpServletUtils.class);

    private StrutsUtil() throws Exception {
    }

    public static String getProperty(MessageResources msg, String pname, String def) throws Throwable {
        String p = msg.getMessage(pname);
        if (p == null) {
            return def;
        }
        return p;
    }

    public static String getReqProperty(MessageResources msg, String pname) throws Throwable {
        String p = StrutsUtil.getProperty(msg, pname, null);
        if (p == null) {
            logger.error("No definition for property " + pname);
            throw new Exception(": No definition for property " + pname);
        }
        return p;
    }

    public static boolean getBoolProperty(MessageResources msg, String pname, boolean def) throws Throwable {
        String p = msg.getMessage(pname);
        if (p == null) {
            return def;
        }
        return Boolean.valueOf(p);
    }

    public static int getIntProperty(MessageResources msg, String pname, int def) throws Throwable {
        String p = msg.getMessage(pname);
        if (p == null) {
            return def;
        }
        return Integer.valueOf(p);
    }

    public static MessageEmit getErrorObj(String id, Object caller, HttpServletRequest request, MessageResources messages, String errorObjAttrName, String errProp, boolean noActionErrors, boolean clear) {
        if (errorObjAttrName == null) {
            return null;
        }
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            logger.error("No session!!!!!!!");
            return null;
        }
        Object o = sess.getAttribute(errorObjAttrName);
        ErrorEmitSvlt err = null;
        if (o != null && o instanceof ErrorEmitSvlt && (noActionErrors || ((ErrorEmitSvlt)o).getErrors() != null)) {
            err = (MessageEmit)o;
        }
        if (err == null) {
            err = new ErrorEmitSvlt();
        }
        ActionErrors ae = null;
        if (!noActionErrors) {
            ae = new ActionErrors();
        }
        err.reinit(id, caller, messages, ae, errProp, clear);
        sess.setAttribute(errorObjAttrName, (Object)err);
        return err;
    }

    public static MessageEmit getErrorObj(HttpServletRequest request, String errorObjAttrName) {
        if (errorObjAttrName == null) {
            return null;
        }
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            logger.error("No session!!!!!!!");
            return null;
        }
        Object o = sess.getAttribute(errorObjAttrName);
        if (o != null && o instanceof MessageEmit) {
            return (MessageEmit)o;
        }
        return null;
    }

    public static MessageEmit getMessageObj(String id, Object caller, HttpServletRequest request, MessageResources messages, String messageObjAttrName, String errProp, boolean clear) {
        if (messageObjAttrName == null) {
            return null;
        }
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            logger.error("No session!!!!!!!");
            return null;
        }
        Object o = sess.getAttribute(messageObjAttrName);
        MessageEmitSvlt msg = null;
        if (o != null && o instanceof MessageEmitSvlt && ((MessageEmitSvlt)o).getMessages() != null) {
            msg = (MessageEmit)o;
        }
        if (msg == null) {
            msg = new MessageEmitSvlt();
        }
        ((MessageEmitSvlt)msg).reinit(id, caller, messages, new ActionMessages(), errProp, clear);
        sess.setAttribute(messageObjAttrName, (Object)msg);
        return msg;
    }

    public static MessageEmit getMessageObj(HttpServletRequest request, String messageObjAttrName) {
        if (messageObjAttrName == null) {
            return null;
        }
        HttpSession sess = request.getSession(false);
        if (sess == null) {
            logger.error("No session!!!!!!!");
            return null;
        }
        Object o = sess.getAttribute(messageObjAttrName);
        if (o != null && o instanceof MessageEmit) {
            return (MessageEmit)o;
        }
        return null;
    }
}

