/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.struts;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeDateFormatter
implements Serializable {
    private SimpleDateFormat formatter;
    private Locale curLocale;
    private int curStyle;
    private boolean usingStyle;
    public static final int time = 0;
    public static final int date = 1;
    public static final int timeDate = 2;
    public static final int dateTime = 3;
    public static final int timeShort = 4;
    public static final int dateShort = 5;
    public static final int timeDateShort = 6;
    public static final int dateTimeShort = 7;
    public static final int dflt = 3;
    private String timePattern = "h:mm a";
    private String datePattern = "MMM d, yyyy";
    private String timeDatePattern = this.timePattern + " " + this.datePattern;
    private String dateTimePattern = this.datePattern + " " + this.timePattern;
    private String timeShortPattern = "h:mm a";
    private String dateShortPattern = "M/d/yyyy";
    private String timeDateShortPattern = this.timeShortPattern + " " + this.dateShortPattern;
    private String dateTimeShortPattern = this.dateShortPattern + " " + this.timeShortPattern;
    private String defaultPattern = this.dateTimePattern;

    public TimeDateFormatter() {
        this(3);
    }

    public TimeDateFormatter(int style) {
        this(style, Locale.getDefault());
    }

    public TimeDateFormatter(int style, Locale l) {
        this.getFormatter(style, l);
    }

    public TimeDateFormatter(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public TimeDateFormatter(String pattern, Locale l) {
        this.getFormatter(pattern, l);
    }

    public String format(Date val) {
        return this.formatter.format(val);
    }

    public Date parse(String val) throws Exception {
        if (val == null) {
            return null;
        }
        return this.formatter.parse(val);
    }

    public void setStyle(int style) {
        this.getFormatter(style, this.curLocale);
    }

    public void setStylePattern(int style, String pattern) {
        if (style == 0) {
            this.timePattern = pattern;
        } else if (style == 1) {
            this.datePattern = pattern;
        } else if (style == 2) {
            this.timeDatePattern = pattern;
        } else if (style == 3) {
            this.dateTimePattern = pattern;
        } else if (style == 4) {
            this.timeShortPattern = pattern;
        } else if (style == 5) {
            this.dateShortPattern = pattern;
        } else if (style == 6) {
            this.timeDateShortPattern = pattern;
        } else if (style == 7) {
            this.dateTimeShortPattern = pattern;
        }
        if (this.usingStyle) {
            this.getFormatter(this.curStyle, this.curLocale);
        }
    }

    public void setPattern(String pattern) {
        this.getFormatter(pattern, this.curLocale);
    }

    private void getFormatter(int style, Locale l) {
        String pattern = this.defaultPattern;
        this.curLocale = l;
        this.curStyle = style;
        this.usingStyle = true;
        if (style == 0) {
            pattern = this.timePattern;
        } else if (style == 1) {
            pattern = this.datePattern;
        } else if (style == 2) {
            pattern = this.timeDatePattern;
        } else if (style == 3) {
            pattern = this.dateTimePattern;
        } else if (style == 4) {
            pattern = this.timeShortPattern;
        } else if (style == 5) {
            pattern = this.dateShortPattern;
        } else if (style == 6) {
            pattern = this.timeDateShortPattern;
        } else if (style == 7) {
            pattern = this.dateTimeShortPattern;
        }
        this.formatter = new SimpleDateFormat(pattern, new DateFormatSymbols(l));
    }

    private void getFormatter(String pattern, Locale l) {
        this.curLocale = l;
        this.usingStyle = false;
        this.formatter = new SimpleDateFormat(pattern, new DateFormatSymbols(l));
    }
}

