/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.struts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.util.MessageResources;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.servlet.HttpAppLogger;
import org.bedework.util.servlet.HttpServletUtils;
import org.bedework.util.servlet.filters.PresentationState;
import org.bedework.util.struts.ErrorEmitSvlt;
import org.bedework.util.struts.MessageEmitSvlt;
import org.bedework.util.struts.Request;
import org.bedework.util.struts.StrutsUtil;
import org.bedework.util.struts.UtilActionForm;

public abstract class UtilAbstractAction
extends Action
implements HttpAppLogger,
Logged {
    transient MessageResources messages;
    private transient String logPrefix;
    protected String requestLogout = "logout";
    public final String forwardLoggedOut = "loggedOut";
    private boolean noActionErrors = false;
    private static final int maxAppVars = 50;
    private BwLogger logger = new BwLogger();

    public abstract String performAction(Request var1, MessageResources var2) throws Throwable;

    public ActionForward execute(ActionMapping mapping, ActionForm frm, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ErrorEmitSvlt err = null;
        MessageEmitSvlt msg = null;
        String forward = "success";
        UtilActionForm form = (UtilActionForm)frm;
        try {
            this.messages = this.getResources(request);
            this.noActionErrors = StrutsUtil.getProperty(this.messages, "edu.rpi.sss.util.action.noactionerrors", "no").equals("yes");
            err = this.getErrorObj(request, this.messages);
            msg = this.getMessageObj(request, this.messages);
            this.logRequest(request);
            if (this.debug()) {
                this.debug("entry");
                this.debug("================================");
                Enumeration en = this.servlet.getInitParameterNames();
                while (en.hasMoreElements()) {
                    this.debug("attr name=" + en.nextElement());
                }
                this.debug("================================");
                this.dumpRequest(request);
            }
            if (!form.getInitialised()) {
                form.setNocache(StrutsUtil.getProperty(this.messages, "edu.rpi.sss.util.action.nocache", "no").equals("yes"));
                form.setInitialised(true);
            }
            form.setMres(this.messages);
            form.setBrowserType(StrutsUtil.getBrowserType((HttpServletRequest)request));
            form.assignCurrentUser(HttpServletUtils.remoteUser((HttpServletRequest)request));
            form.setUrl(StrutsUtil.getUrl((HttpServletRequest)request));
            form.setSchemeHostPort(StrutsUtil.getURLshp((HttpServletRequest)request));
            form.setContext(StrutsUtil.getContext((HttpServletRequest)request));
            form.setUrlPrefix(StrutsUtil.getURLPrefix((HttpServletRequest)request));
            form.setErr(err);
            form.setMsg(msg);
            form.assignSessionId(this.getSessionId(request));
            this.checkNocache(request, response, form);
            String defaultContentType = StrutsUtil.getProperty(this.messages, "edu.rpi.sss.util.action.contenttype", "text/html");
            Request req = new Request(request, response, form, this, mapping);
            this.doPresentation(req);
            String contentName = this.getContentName(req);
            if (contentName != null) {
                response.setHeader("Content-Disposition", "Attachment; Filename=\"" + contentName + "\"");
            }
            if (this.debug()) {
                this.checkSerialize(request);
            }
            if ((forward = this.checkLogOut(request, form)) != null) {
                response.setContentType("text/html");
            } else {
                response.setContentType(defaultContentType);
                forward = this.checkVarReq(req, form);
                if (forward == null) {
                    forward = this.checkForwardto(request);
                }
                if (forward == null) {
                    forward = this.performAction(req, this.messages);
                }
            }
            if (forward == null) {
                this.warn("Forward = null");
                err.emit("edu.rpi.sss.util.nullforward");
                forward = "error";
            } else if (forward.equals("FORWARD-NULL")) {
                forward = null;
            }
            if (err == null) {
                this.warn("No errors object");
            } else if (err.messagesEmitted()) {
                if (!this.noActionErrors) {
                    ActionErrors aes = err.getErrors();
                    this.saveErrors(request, (ActionMessages)aes);
                }
                if (this.debug()) {
                    this.debug(err.getMsgList().size() + " errors emitted");
                }
            } else if (this.debug()) {
                this.debug("No errors emitted");
            }
            if (msg == null) {
                this.warn("No messages object");
            } else if (msg.messagesEmitted()) {
                ActionMessages ams = msg.getMessages();
                this.saveMessages(request, ams);
                if (this.debug()) {
                    this.debug(ams.size() + " messages emitted");
                }
            } else if (this.debug()) {
                this.debug("No messages emitted");
            }
            if (this.debug()) {
                this.debug("exit to " + forward);
            }
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error("Action exception: ", t);
            }
            err.emit(t);
            forward = "error";
        }
        if (forward == null) {
            return null;
        }
        return mapping.findForward(forward);
    }

    protected void traceConfig(Request req) {
        if (!this.debug()) {
            return;
        }
        ActionConfig[] actions = req.getMapping().getModuleConfig().findActionConfigs();
        this.debug("========== Action configs ===========");
        for (ActionConfig aconfig : actions) {
            StringBuilder sb = new StringBuilder();
            sb.append(aconfig.getPath());
            String param = aconfig.getParameter();
            boolean noActionType = this.traceConfigParam(req, sb, "actionType=", param) == null;
            this.traceConfigParam(req, sb, "conversation=", param);
            this.traceConfigParam(req, sb, "refinterval=", param);
            this.traceConfigParam(req, sb, "refaction=", param);
            this.debug(sb.toString());
            if (!noActionType) continue;
            this.debug("***** Warning: no action type specified ****");
        }
    }

    private String traceConfigParam(Request req, StringBuilder sb, String name, String param) {
        String res = req.getStringActionPar(name, param);
        if (res == null) {
            return null;
        }
        sb.append(",\t");
        sb.append(name);
        sb.append(res);
        return res;
    }

    public String getContentName(Request req) throws Throwable {
        UtilActionForm form = req.getForm();
        PresentationState ps = this.getPresentationState(req);
        String contentName = ps.getContentName();
        form.setContentName(contentName);
        return contentName;
    }

    public abstract String getId();

    public boolean clearMessages() {
        return true;
    }

    public String getErrorObjAttrName() {
        return "edu.rpi.sss.util.errorobj";
    }

    public String getMessageObjAttrName() {
        return "edu.rpi.sss.util.messageobj";
    }

    public String getErrorObjErrProp() {
        return "edu.rpi.sss.util.error.exc";
    }

    public String getPresentationAttrName() {
        return "bw_presentationstate";
    }

    public MessageResources getMessages() {
        return this.messages;
    }

    public String getMessage(String name) {
        return this.messages.getMessage(name);
    }

    public String getLogPrefix(HttpServletRequest request) {
        try {
            if (this.logPrefix == null) {
                this.logPrefix = StrutsUtil.getProperty(this.getMessages(), "edu.rpi.sss.util.action.logprefix", "unknown");
            }
            return this.logPrefix;
        }
        catch (Throwable t) {
            this.error(t);
            return "LOG-PREFIX-EXCEPTION";
        }
    }

    protected boolean logOutCleanup(HttpServletRequest request, UtilActionForm form) {
        return true;
    }

    protected String checkLogOut(HttpServletRequest request, UtilActionForm form) throws Throwable {
        String reqUser = HttpServletUtils.remoteUser((HttpServletRequest)request);
        boolean forceLogout = !Util.equalsString((String)reqUser, (String)form.getCurrentUser());
        String temp = request.getParameter(this.requestLogout);
        if (forceLogout || temp != null) {
            HttpSession sess = request.getSession(false);
            if (sess != null && this.logOutCleanup(request, form)) {
                sess.invalidate();
            }
            return "loggedOut";
        }
        return null;
    }

    private void checkNocache(HttpServletRequest request, HttpServletResponse response, UtilActionForm form) {
        String reqpar = request.getParameter("nocacheSticky");
        if (reqpar != null) {
            form.setNocache(reqpar.equals("yes"));
        }
        if ((reqpar = request.getParameter("nocache")) == null && !form.getNocache()) {
            return;
        }
        boolean nocache = form.getNocache();
        if (reqpar != null) {
            nocache = reqpar.equals("yes");
        }
        if (nocache) {
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.setDateHeader("Expires", 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSerialize(HttpServletRequest request) {
        String reqpar = request.getParameter("serialize");
        if (reqpar == null) {
            return;
        }
        HttpSession sess = request.getSession(false);
        Enumeration en = sess.getAttributeNames();
        while (en.hasMoreElements()) {
            String attrname = (String)en.nextElement();
            ObjectOutputStream oo = null;
            this.info("Attempt to serialize attr " + attrname);
            Object o = sess.getAttribute(attrname);
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                oo = new ObjectOutputStream(bo);
                oo.writeObject(o);
                oo.flush();
                this.info("Serialized object " + attrname + " has size: " + bo.size());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (oo == null) continue;
                try {
                    oo.close();
                }
                catch (Throwable bo) {}
            }
        }
    }

    public HashMap<String, String> getAppVars(Request request) {
        HashMap<String, String> o = request.getSessionAttr("edu.rpi.sss.util.UtilAbstractAction.appVars");
        if (o == null || !(o instanceof HashMap)) {
            o = new HashMap<String, String>();
            request.setSessionAttr("edu.rpi.sss.util.UtilAbstractAction.appVars", o);
        }
        return o;
    }

    private String checkVarReq(Request request, UtilActionForm form) throws Throwable {
        List avs = request.getReqPars("setappvar");
        if (avs == null) {
            return null;
        }
        HashMap<String, String> appVars = this.getAppVars(request);
        for (String reqpar : avs) {
            int start;
            if (reqpar.endsWith("}")) {
                start = reqpar.indexOf(123);
            } else if (reqpar.endsWith(")")) {
                start = reqpar.indexOf(40);
            } else {
                return "badRequest";
            }
            if (start < 0) {
                return "badRequest";
            }
            String varName = reqpar.substring(0, start);
            String varVal = reqpar.substring(start + 1, reqpar.length() - 1);
            if (varVal.length() == 0) {
                varVal = null;
            }
            if (this.setAppVar(varName, varVal, appVars)) continue;
            return "badRequest";
        }
        form.setAppVarsTbl(appVars);
        return null;
    }

    public boolean setAppVar(String name, String val, HashMap<String, String> appVars) {
        if (val == null) {
            appVars.remove(name);
            return true;
        }
        if (appVars.size() > 50) {
            return false;
        }
        appVars.put(name, val);
        return true;
    }

    private String checkForwardto(HttpServletRequest request) throws Throwable {
        String reqpar = request.getParameter("forwardto");
        return reqpar;
    }

    protected String checkConfirmationId(HttpServletRequest request, UtilActionForm form) throws Throwable {
        String reqpar = request.getParameter("confirmationid");
        if (reqpar == null) {
            return null;
        }
        if (!reqpar.equals(form.getConfirmationId())) {
            return "badConformationId";
        }
        return null;
    }

    protected String requireConfirmationId(HttpServletRequest request, UtilActionForm form) throws Throwable {
        String reqpar = request.getParameter("confirmationid");
        if (reqpar == null) {
            return "missingConformationId";
        }
        if (!reqpar.equals(form.getConfirmationId())) {
            return "badConformationId";
        }
        return null;
    }

    public void doPresentation(Request request) throws Throwable {
        PresentationState ps = this.getPresentationState(request);
        if (ps == null) {
            if (this.debug()) {
                this.debug("No presentation state");
            }
            return;
        }
        if (this.debug()) {
            this.debug("Set presentation state");
        }
        HttpServletRequest req = request.getRequest();
        ps.checkBrowserType(req);
        ps.checkContentType(req);
        ps.checkContentName(req);
        ps.checkNoXSLT(req);
        ps.checkRefreshXslt(req);
        ps.checkSkinName(req);
        request.setRequestAttr(this.getPresentationAttrName(), ps);
        if (this.debug()) {
            ps.debugDump("action");
        }
    }

    public PresentationState getPresentationState(Request request) {
        PresentationState ps;
        String attrName = this.getPresentationAttrName();
        if (attrName == null || attrName.equals("NONE")) {
            return null;
        }
        Object o = request.getSessionAttr(attrName);
        if (o == null || !(o instanceof PresentationState)) {
            ps = new PresentationState();
            this.initPresentationState(request, ps);
            request.setSessionAttr(attrName, ps);
        } else {
            ps = (PresentationState)o;
        }
        return ps;
    }

    protected void initPresentationState(Request request, PresentationState ps) {
        UtilActionForm form = request.getForm();
        ps.setBrowserType(form.getBrowserType());
        try {
            ps.setNoXSLTSticky(StrutsUtil.getProperty(this.messages, "edu.rpi.sss.util.action.noxslt", "no").equals("yes"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getReqRes(String resName) throws Throwable {
        return StrutsUtil.getReqProperty(this.messages, resName);
    }

    protected String getReqPar(HttpServletRequest req, String name) throws Throwable {
        return Util.checkNull((String)req.getParameter(name));
    }

    protected Collection<String> getReqPars(HttpServletRequest req, String name) throws Throwable {
        String[] s = req.getParameterValues(name);
        ArrayList<String> res = null;
        if (s == null || s.length == 0) {
            return null;
        }
        for (String par : s) {
            if ((par = Util.checkNull((String)par)) == null) continue;
            if (res == null) {
                res = new ArrayList<String>();
            }
            res.add(par);
        }
        return res;
    }

    private ErrorEmitSvlt getErrorObj(HttpServletRequest request, MessageResources messages) {
        return (ErrorEmitSvlt)StrutsUtil.getErrorObj(this.getId(), (Object)this, request, messages, this.getErrorObjAttrName(), this.getErrorObjErrProp(), this.noActionErrors, this.clearMessages());
    }

    private MessageEmitSvlt getMessageObj(HttpServletRequest request, MessageResources messages) {
        return (MessageEmitSvlt)StrutsUtil.getMessageObj(this.getId(), (Object)this, request, messages, this.getMessageObjAttrName(), this.getErrorObjErrProp(), this.clearMessages());
    }

    public void dumpRequest(HttpServletRequest req) {
        try {
            Enumeration names = req.getParameterNames();
            String title = "Request parameters";
            this.debug(title + " - global info and uris");
            this.debug("getRequestURI = " + req.getRequestURI());
            this.debug("getRemoteUser = " + req.getRemoteUser());
            this.debug("getRequestedSessionId = " + req.getRequestedSessionId());
            this.debug("HttpUtils.getRequestURL(req) = " + req.getRequestURL());
            this.debug("query=" + req.getQueryString());
            this.debug("contentlen=" + req.getContentLength());
            this.debug("request=" + req);
            this.debug("host=" + req.getHeader("host"));
            this.debug("parameters:");
            this.debug(title);
            while (names.hasMoreElements()) {
                String[] vals;
                String key = (String)names.nextElement();
                for (String val : vals = req.getParameterValues(key)) {
                    this.debug("  " + key + " = \"" + val + "\"");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }
}

