/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.ws.Holder;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TextList;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.AcceptResponse;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.PollItemId;
import net.fortuna.ical4j.model.property.PollMode;
import net.fortuna.ical4j.model.property.PollProperties;
import net.fortuna.ical4j.model.property.PollWinner;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.RequestStatus;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Voter;
import net.fortuna.ical4j.model.property.XProperty;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.responses.GetEntityResponse;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.icalendar.EventTimeZonesRegistry;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalMalformedException;
import org.bedework.icalendar.IcalUtil;
import org.bedework.icalendar.Icalendar;
import org.bedework.icalendar.VAlarmUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.tagdefs.XcalTags;

public class BwEventUtil
extends IcalUtil {
    private static BwLogger logger = new BwLogger().setLoggedClass(BwEventUtil.class);

    public static EventInfo toEvent(IcalCallback cb, BwCalendar cal, Icalendar ical, Component val, boolean diff, boolean mergeAttendees) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        String currentPrincipal = null;
        BwPrincipal principal = cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        Holder hasXparams = new Holder((Object)Boolean.FALSE);
        int methodType = ical.getMethodType();
        String attUri = null;
        if (mergeAttendees) {
            attUri = cb.getCaladdr(cb.getPrincipal().getPrincipalRef());
        }
        String colPath = cal == null ? null : cal.getPath();
        try {
            int entityType;
            PropertyList pl = val.getProperties();
            boolean vpoll = false;
            if (pl == null) {
                return null;
            }
            if (val instanceof VEvent) {
                entityType = 0;
            } else if (val instanceof VToDo) {
                entityType = 2;
            } else if (val instanceof VJournal) {
                entityType = 3;
            } else if (val instanceof VFreeBusy) {
                entityType = 4;
            } else if (val instanceof VAvailability) {
                entityType = 5;
            } else if (val instanceof Available) {
                entityType = 6;
            } else if (val instanceof VPoll) {
                entityType = 7;
                vpoll = true;
            } else {
                throw new CalFacadeException("org.bedework.invalid.component.type", val.getName());
            }
            String guid = null;
            Property prop = pl.getProperty("UID");
            if (prop != null) {
                BwEventUtil.testXparams(prop, (Holder<Boolean>)hasXparams);
                guid = prop.getValue();
            }
            if (guid == null) {
                throw new CalFacadeException("org.bedework.exception.ical.noguid");
            }
            BwDateTime ridObj = null;
            String rid = null;
            prop = pl.getProperty("RECURRENCE-ID");
            if (prop != null) {
                BwEventUtil.testXparams(prop, (Holder<Boolean>)hasXparams);
                ridObj = BwDateTime.makeBwDateTime((DateProperty)((DateProperty)prop));
                if (ridObj.getRange() != null) {
                    logger.warn("TRANS-TO_EVENT: Got a recurrence id range");
                }
                rid = ridObj.getDate();
            }
            EventInfo masterEI = null;
            EventInfo evinfo = null;
            BwEvent ev = null;
            DtStart dtStart = (DtStart)pl.getProperty("DTSTART");
            if (rid != null && (masterEI = BwEventUtil.findMaster(guid, ical.getComponents())) != null) {
                evinfo = masterEI.findOverride(rid);
            }
            if (diff && evinfo == null && cal != null && cal.getCalType() != 5 && cal.getCalType() != 13 && cal.getCalType() != 6) {
                Collection eis;
                if (logger.debug()) {
                    logger.debug("TRANS-TO_EVENT: try to fetch event with guid=" + guid);
                }
                if (!Util.isEmpty((Collection)(eis = cb.getEvent(colPath, guid)))) {
                    if (eis.size() > 1) {
                        throw new CalFacadeException("More than one event returned for guid.");
                    }
                    evinfo = (EventInfo)eis.iterator().next();
                }
                if (logger.debug()) {
                    if (evinfo != null) {
                        logger.debug("TRANS-TO_EVENT: fetched event with guid");
                    } else {
                        logger.debug("TRANS-TO_EVENT: did not find event with guid");
                    }
                }
                if (evinfo != null) {
                    if (rid != null) {
                        masterEI = evinfo;
                        masterEI.setInstanceOnly(true);
                        evinfo = masterEI.findOverride(rid);
                        ical.addComponent(masterEI);
                    } else if (methodType == 5) {
                        evinfo.setInstanceOnly(evinfo.getEvent().getSuppressed());
                    } else {
                        evinfo.getEvent().setSuppressed(false);
                    }
                } else if (rid != null) {
                    boolean isDateType;
                    masterEI = BwEventUtil.makeNewEvent(cb, entityType, guid, colPath);
                    BwEvent e = masterEI.getEvent();
                    String bogusDate = "19980118";
                    String bogusTime = "T230000";
                    Parameter par = dtStart.getParameter("VALUE");
                    boolean bl = isDateType = par != null && par.equals((Object)Value.DATE);
                    DtStart mdtStart = isDateType ? new DtStart(new Date("19980118")) : (dtStart.isUtc() ? new DtStart("19980118T230000Z") : (dtStart.getTimeZone() == null ? new DtStart("19980118T230000") : new DtStart("19980118T230000Z", dtStart.getTimeZone())));
                    BwEventUtil.setDates(cb.getPrincipal().getPrincipalRef(), masterEI, mdtStart, null, null);
                    e.setRecurring(Boolean.valueOf(true));
                    e.setSuppressed(true);
                    ical.addComponent(masterEI);
                    evinfo = masterEI.findOverride(rid);
                    masterEI.setInstanceOnly(rid != null);
                }
            }
            if (evinfo == null) {
                evinfo = BwEventUtil.makeNewEvent(cb, entityType, guid, colPath);
            } else if (evinfo.getEvent().getEntityType() != entityType) {
                throw new CalFacadeException("org.bedework.mismatched.entity.type", val.toString());
            }
            ChangeTable chg = evinfo.getChangeset(cb.getPrincipal().getPrincipalRef());
            if (rid != null) {
                String evrid = evinfo.getEvent().getRecurrenceId();
                if (evrid == null || !evrid.equals(rid)) {
                    logger.warn("Mismatched rid ev=" + evrid + " expected " + rid);
                    chg.changed(PropertyIndex.PropertyInfoIndex.RECURRENCE_ID, (Object)evrid, (Object)rid);
                }
                if (masterEI.getEvent().getSuppressed()) {
                    masterEI.getEvent().addRdate(ridObj);
                }
            }
            ev = evinfo.getEvent();
            ev.setScheduleMethod(methodType);
            DtEnd dtEnd = null;
            if (entityType == 2) {
                Due due = (Due)pl.getProperty("DUE");
                if (due != null) {
                    dtEnd = new DtEnd(due.getParameters(), due.getValue());
                }
            } else {
                dtEnd = (DtEnd)pl.getProperty("DTEND");
            }
            Duration duration = (Duration)pl.getProperty("DURATION");
            BwEventUtil.setDates(cb.getPrincipal().getPrincipalRef(), evinfo, dtStart, dtEnd, duration);
            block46: for (Object aPl : pl) {
                PropertyIndex.PropertyInfoIndex pi;
                prop = (Property)aPl;
                BwEventUtil.testXparams(prop, (Holder<Boolean>)hasXparams);
                String pval = prop.getValue();
                if (pval != null && pval.length() == 0) {
                    pval = null;
                }
                if ((pi = prop instanceof XProperty ? PropertyIndex.PropertyInfoIndex.XPROP : PropertyIndex.PropertyInfoIndex.fromName((String)prop.getName())) == null) {
                    logger.debug("Unknown property with name " + prop.getName() + " class " + prop.getClass() + " and value " + pval);
                    continue;
                }
                chg.present(pi);
                switch (pi) {
                    case ACCEPT_RESPONSE: {
                        String sval = ((AcceptResponse)prop).getValue();
                        if (!chg.changed(pi, (Object)ev.getPollAcceptResponse(), (Object)sval)) continue block46;
                        ev.setPollAcceptResponse(sval);
                        break;
                    }
                    case ATTACH: {
                        chg.addValue(pi, (Object)BwEventUtil.getAttachment((Attach)prop));
                        break;
                    }
                    case ATTENDEE: {
                        if (methodType == 1) {
                            if (cb.getStrictness() == 2) {
                                throw new CalFacadeException("org.bedework.exception.ical.attendeesinpublish");
                            }
                            if (cb.getStrictness() == 1) {
                                // empty if block
                            }
                        }
                        Attendee attPr = (Attendee)prop;
                        if (evinfo.getNewEvent() || !mergeAttendees) {
                            chg.addValue(pi, (Object)BwEventUtil.getAttendee(cb, attPr));
                            break;
                        }
                        String pUri = cb.getCaladdr(attPr.getValue());
                        if (pUri.equals(attUri)) {
                            chg.addValue(pi, (Object)BwEventUtil.getAttendee(cb, attPr));
                            break;
                        }
                        boolean found = false;
                        for (BwAttendee att : ev.getAttendees()) {
                            if (!pUri.equals(att.getAttendeeUri())) continue;
                            chg.addValue(pi, att.clone());
                            found = true;
                            break;
                        }
                        if (found) continue block46;
                        BwAttendee att = BwEventUtil.getAttendee(cb, attPr);
                        att.setPartstat("NEEDS-ACTION");
                        chg.addValue(pi, (Object)att);
                        break;
                    }
                    case BUSYTYPE: {
                        int ibt = BwEvent.fromBusyTypeString((String)pval);
                        if (!chg.changed(pi, (Object)ev.getBusyType(), (Object)ibt)) continue block46;
                        ev.setBusyType(ibt);
                        break;
                    }
                    case CATEGORIES: {
                        Categories cats = (Categories)prop;
                        TextList cl = cats.getCategories();
                        String lang = BwEventUtil.getLang((Property)cats);
                        if (cl == null) continue block46;
                        for (String wd : cl) {
                            if (wd == null) continue;
                            BwString key = new BwString(lang, wd);
                            BwCategory cat = cb.findCategory(key);
                            if (cat == null) {
                                cat = BwCategory.makeCategory();
                                cat.setWord(key);
                                cb.addCategory(cat);
                            }
                            chg.addValue(pi, (Object)cat);
                        }
                        continue block46;
                    }
                    case CLASS: {
                        if (!chg.changed(pi, (Object)ev.getClassification(), (Object)pval)) continue block46;
                        ev.setClassification(pval);
                        break;
                    }
                    case COMMENT: {
                        chg.addValue(pi, (Object)new BwString(null, pval));
                        break;
                    }
                    case COMPLETED: {
                        if (!chg.changed(pi, (Object)ev.getCompleted(), (Object)pval)) continue block46;
                        ev.setCompleted(pval);
                        break;
                    }
                    case CONTACT: {
                        String altrep = BwEventUtil.getAltRepPar(prop);
                        String lang = BwEventUtil.getLang(prop);
                        String uid = BwEventUtil.getUidPar(prop);
                        BwString nm = new BwString(lang, pval);
                        BwContact contact = null;
                        if (uid != null) {
                            contact = cb.getContact(uid);
                        }
                        if (contact == null) {
                            contact = cb.findContact(nm);
                        }
                        if (contact == null) {
                            contact = BwContact.makeContact();
                            contact.setCn(nm);
                            contact.setLink(altrep);
                            cb.addContact(contact);
                        } else {
                            contact.setCn(nm);
                            contact.setLink(altrep);
                        }
                        chg.addValue(pi, (Object)contact);
                        break;
                    }
                    case CREATED: {
                        if (!chg.changed(pi, (Object)ev.getCreated(), (Object)pval)) continue block46;
                        ev.setCreated(pval);
                        break;
                    }
                    case DESCRIPTION: {
                        if (!chg.changed(pi, (Object)ev.getDescription(), (Object)pval)) continue block46;
                        ev.setDescription(pval);
                        break;
                    }
                    case DTEND: {
                        break;
                    }
                    case DTSTAMP: {
                        ev.setDtstamp(pval);
                        break;
                    }
                    case DTSTART: {
                        break;
                    }
                    case DUE: {
                        break;
                    }
                    case DURATION: {
                        break;
                    }
                    case EXDATE: {
                        chg.addValues(pi, BwEventUtil.makeDateTimes((DateListProperty)prop));
                        break;
                    }
                    case EXRULE: {
                        chg.addValue(pi, (Object)pval);
                        break;
                    }
                    case FREEBUSY: {
                        int fbtype;
                        FreeBusy fbusy = (FreeBusy)prop;
                        PeriodList perpl = fbusy.getPeriods();
                        Parameter par = BwEventUtil.getParameter((Property)fbusy, "FBTYPE");
                        if (par == null) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY)) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY_TENTATIVE)) {
                            fbtype = 3;
                        } else if (par.equals((Object)FbType.BUSY_UNAVAILABLE)) {
                            fbtype = 2;
                        } else if (par.equals((Object)FbType.FREE)) {
                            fbtype = 1;
                        } else {
                            if (logger.debug()) {
                                logger.debug("Unsupported parameter " + par.getName());
                            }
                            throw new IcalMalformedException("parameter " + par.getName());
                        }
                        BwFreeBusyComponent fbc = new BwFreeBusyComponent();
                        fbc.setType(fbtype);
                        for (Period per : perpl) {
                            fbc.addPeriod(per);
                        }
                        ev.addFreeBusyPeriod(fbc);
                        break;
                    }
                    case GEO: {
                        Geo g = (Geo)prop;
                        BwGeo geo = new BwGeo(g.getLatitude(), g.getLongitude());
                        if (!chg.changed(pi, (Object)ev.getGeo(), (Object)geo)) continue block46;
                        ev.setGeo(geo);
                        break;
                    }
                    case LAST_MODIFIED: {
                        if (!chg.changed(pi, (Object)ev.getLastmod(), (Object)pval)) continue block46;
                        ev.setLastmod(pval);
                        break;
                    }
                    case LOCATION: {
                        String inval;
                        String evval;
                        BwLocation evloc;
                        BwLocation loc = null;
                        String lang = BwEventUtil.getLang(prop);
                        BwString addr = null;
                        if (pval != null) {
                            if (loc == null) {
                                addr = new BwString(lang, pval);
                                loc = cb.findLocation(addr);
                            }
                            if (loc == null) {
                                loc = BwLocation.makeLocation();
                                loc.setAddress(addr);
                                cb.addLocation(loc);
                            }
                        }
                        if (chg.changed(pi, (Object)(evloc = ev.getLocation()), (Object)loc)) {
                            ev.setLocation(loc);
                            break;
                        }
                        if (loc == null || evloc == null || (evval = evloc.getAddress().getValue()).equals(inval = loc.getAddress().getValue())) continue block46;
                        chg.changed(pi, (Object)evval, (Object)inval);
                        evloc.getAddress().setValue(inval);
                        break;
                    }
                    case ORGANIZER: {
                        BwOrganizer org = BwEventUtil.getOrganizer(cb, (Organizer)prop);
                        BwOrganizer evorg = ev.getOrganizer();
                        BwOrganizer evorgCopy = evorg == null ? null : (BwOrganizer)evorg.clone();
                        if (!chg.changed(pi, (Object)evorgCopy, (Object)org)) continue block46;
                        if (evorg == null) {
                            ev.setOrganizer(org);
                            break;
                        }
                        evorg.update(org);
                        break;
                    }
                    case PERCENT_COMPLETE: {
                        Integer ival = ((PercentComplete)prop).getPercentage();
                        if (!chg.changed(pi, (Object)ev.getPercentComplete(), (Object)ival)) continue block46;
                        ev.setPercentComplete(ival);
                        break;
                    }
                    case POLL_MODE: {
                        String sval = ((PollMode)prop).getValue();
                        if (!chg.changed(pi, (Object)ev.getPollMode(), (Object)sval)) continue block46;
                        ev.setPollMode(sval);
                        break;
                    }
                    case POLL_PROPERTIES: {
                        String sval = ((PollProperties)prop).getValue();
                        if (!chg.changed(pi, (Object)ev.getPollProperties(), (Object)sval)) continue block46;
                        ev.setPollProperties(sval);
                        break;
                    }
                    case POLL_WINNER: {
                        Integer ival = ((PollWinner)prop).getPollwinner();
                        if (!chg.changed(pi, (Object)ev.getPollWinner(), (Object)ival)) continue block46;
                        ev.setPollWinner(ival);
                        break;
                    }
                    case PRIORITY: {
                        Integer ival = ((Priority)prop).getLevel();
                        if (!chg.changed(pi, (Object)ev.getPriority(), (Object)ival)) continue block46;
                        ev.setPriority(ival);
                        break;
                    }
                    case RDATE: {
                        chg.addValues(pi, BwEventUtil.makeDateTimes((DateListProperty)prop));
                        break;
                    }
                    case RECURRENCE_ID: {
                        break;
                    }
                    case RELATED_TO: {
                        RelatedTo irelto = (RelatedTo)prop;
                        BwRelatedTo relto = new BwRelatedTo();
                        String parval = IcalUtil.getParameterVal((Property)irelto, "RELTYPE");
                        if (parval != null) {
                            relto.setRelType(parval);
                        }
                        relto.setValue(irelto.getValue());
                        if (!chg.changed(pi, (Object)ev.getRelatedTo(), (Object)relto)) continue block46;
                        ev.setRelatedTo(relto);
                        break;
                    }
                    case REQUEST_STATUS: {
                        BwRequestStatus rs = BwRequestStatus.fromRequestStatus((RequestStatus)((RequestStatus)prop));
                        chg.addValue(pi, (Object)rs);
                        break;
                    }
                    case RESOURCES: {
                        TextList rl = ((Resources)prop).getResources();
                        if (rl == null) continue block46;
                        String lang = BwEventUtil.getLang(prop);
                        Iterator rit = rl.iterator();
                        while (rit.hasNext()) {
                            BwString rsrc = new BwString(lang, (String)rit.next());
                            chg.addValue(pi, (Object)rsrc);
                        }
                        continue block46;
                    }
                    case RRULE: {
                        chg.addValue(pi, (Object)pval);
                        break;
                    }
                    case SEQUENCE: {
                        int seq = ((Sequence)prop).getSequenceNo();
                        if (seq == ev.getSequence()) continue block46;
                        chg.changed(pi, (Object)ev.getSequence(), (Object)seq);
                        ev.setSequence(seq);
                        break;
                    }
                    case STATUS: {
                        if (!chg.changed(pi, (Object)ev.getStatus(), (Object)pval)) continue block46;
                        ev.setStatus(pval);
                        break;
                    }
                    case SUMMARY: {
                        if (!chg.changed(pi, (Object)ev.getSummary(), (Object)pval)) continue block46;
                        ev.setSummary(pval);
                        break;
                    }
                    case TRANSP: {
                        BwXproperty pu;
                        if (!chg.changed(pi, (Object)ev.getPeruserTransparency(cb.getPrincipal().getPrincipalRef()), (Object)pval) || (pu = ev.setPeruserTransparency(cb.getPrincipal().getPrincipalRef(), pval)) == null) continue block46;
                        chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)pu);
                        break;
                    }
                    case UID: {
                        break;
                    }
                    case URL: {
                        if (!chg.changed(pi, (Object)ev.getLink(), (Object)pval)) continue block46;
                        ev.setLink(pval);
                        break;
                    }
                    case XPROP: {
                        String name = prop.getName();
                        if (name.equalsIgnoreCase("X-BEDEWORK-COST")) {
                            if (!chg.changed(PropertyIndex.PropertyInfoIndex.COST, (Object)ev.getCost(), (Object)pval)) continue block46;
                            ev.setCost(pval);
                            break;
                        }
                        if (name.equalsIgnoreCase("X-BEDEWORK-CATEGORIES") && BwEventUtil.checkCategory(cb, chg, ev, null, pval) || name.equalsIgnoreCase("X-BEDEWORK-LOCATION") && BwEventUtil.checkLocation(cb, chg, ev, prop) || name.equalsIgnoreCase("X-BEDEWORK-CONTACT") && BwEventUtil.checkContact(cb, chg, ev, null, pval)) break;
                        XProperty xp = (XProperty)prop;
                        chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty(name, xp.getParameters().toString(), pval));
                        break;
                    }
                    default: {
                        if (!logger.debug()) continue block46;
                        logger.debug("Unsupported property with index " + pi + "; class " + prop.getClass() + " and value " + pval);
                    }
                }
            }
            if (val instanceof VAvailability) {
                BwEventUtil.processAvailable(cb, cal, ical, (VAvailability)val, evinfo);
            } else if (!(val instanceof Available)) {
                VAlarmUtil.processComponentAlarms(cb, val, ev, currentPrincipal, chg);
                if (val instanceof VPoll) {
                    BwEventUtil.processVvoters((VPoll)val, evinfo, cb, chg, mergeAttendees);
                    BwEventUtil.processCandidates((VPoll)val, evinfo, chg);
                }
            }
            if (ev.getCreated() == null) {
                if (ev.getLastmod() != null) {
                    ev.setCreated(ev.getLastmod());
                    chg.changed(PropertyIndex.PropertyInfoIndex.CREATED, null, (Object)ev.getCreated());
                } else {
                    ev.updateDtstamp();
                    chg.changed(PropertyIndex.PropertyInfoIndex.CREATED, null, (Object)ev.getCreated());
                    chg.changed(PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, null, (Object)ev.getLastmod());
                }
            }
            if (ev.getLastmod() == null) {
                ev.setLastmod(ev.getCreated());
                chg.changed(PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, null, (Object)ev.getLastmod());
            }
            BwEventUtil.processTimezones(ev, ical, chg);
            if (ev.getRecipients() != null) {
                ev.getRecipients().clear();
            }
            ev.setOriginator(null);
            if (((Boolean)hasXparams.value).booleanValue()) {
                Value v;
                Component valCopy = val.copy();
                prop = valCopy.getProperty("DESCRIPTION");
                if (prop != null) {
                    prop.setValue(null);
                }
                if ((prop = valCopy.getProperty("ATTACH")) != null && (v = (Value)prop.getParameter("VALUE")) != null) {
                    prop.setValue(String.valueOf(prop.getValue().hashCode()));
                }
                chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty("X-BEDEWORK-ICAL", null, valCopy.toString()));
            }
            chg.processChanges(ev, true);
            ev.setRecurring(new Boolean(ev.isRecurringEntity()));
            if (logger.debug()) {
                logger.debug(chg.toString());
                logger.debug(ev.toString());
            }
            if (masterEI != null) {
                return null;
            }
            return evinfo;
        }
        catch (CalFacadeException cfe) {
            if (logger.debug()) {
                logger.error((Throwable)cfe);
            }
            throw cfe;
        }
        catch (Throwable t) {
            if (logger.debug()) {
                logger.error(t);
            }
            throw new CalFacadeException(t);
        }
    }

    private static boolean checkCategory(IcalCallback cb, ChangeTable chg, BwEvent ev, String lang, String val) throws CalFacadeException {
        BwString sval = new BwString(lang, val);
        BwCategory cat = cb.findCategory(sval);
        if (cat == null) {
            return false;
        }
        Set cats = ev.getCategories();
        if (cats != null) {
            for (BwCategory c : cats) {
                if (!c.getWord().equals((Object)sval)) continue;
                return true;
            }
        }
        ev.addCategory(cat);
        chg.addValue(PropertyIndex.PropertyInfoIndex.CATEGORIES, (Object)cat);
        return true;
    }

    private static boolean checkLocation(IcalCallback cb, ChangeTable chg, BwEvent ev, Property prop) throws CalFacadeException {
        BwLocation loc;
        Parameter param = prop.getParameter(XcalTags.xBedeworkLocationKey.getLocalPart());
        String val = prop.getValue();
        BwLocation evloc = ev.getLocation();
        if (param == null) {
            BwString sval = new BwString(null, val);
            loc = cb.getLocation(sval);
            if (loc == null) {
                return false;
            }
        } else {
            GetEntityResponse resp = cb.fetchLocationByKey(param.getValue(), val);
            if (resp.getStatus() != Response.Status.ok) {
                return false;
            }
            loc = (BwLocation)resp.getEntity();
        }
        ev.setLocation(loc);
        chg.changed(PropertyIndex.PropertyInfoIndex.LOCATION, (Object)evloc, (Object)loc);
        return true;
    }

    private static boolean checkContact(IcalCallback cb, ChangeTable chg, BwEvent ev, String lang, String val) throws CalFacadeException {
        BwString sval = new BwString(lang, val);
        BwContact c = cb.findContact(sval);
        if (c == null) {
            return false;
        }
        Set cs = ev.getContacts();
        if (cs != null) {
            for (BwContact c1 : cs) {
                if (!c.getCn().equals((Object)sval)) continue;
                return true;
            }
        }
        ev.addContact(c);
        chg.addValue(PropertyIndex.PropertyInfoIndex.CONTACT, (Object)c);
        return true;
    }

    private static void testXparams(Property p, Holder<Boolean> hasXparams) {
        if (((Boolean)hasXparams.value).booleanValue()) {
            return;
        }
        ParameterList params = p.getParameters();
        for (Parameter param : params) {
            XParameter xpar;
            if (!(param instanceof XParameter) || (xpar = (XParameter)param).getName().toUpperCase().equals("X-BEDEWORK-UID")) continue;
            hasXparams.value = true;
        }
    }

    private static void processTimezones(BwEvent ev, Icalendar ical, ChangeTable chg) throws CalFacadeException {
        for (Icalendar.TimeZoneInfo tzi : ical.getTimeZones()) {
            if (tzi.tzSpec == null || EventTimeZonesRegistry.findTzValue(ev, tzi.tzid) != null) continue;
            chg.addValue(PropertyIndex.PropertyInfoIndex.XPROP, (Object)new BwXproperty("X-BEDEWORK-TZ", null, BwXproperty.escapeSemi((String)tzi.tzid) + ";" + tzi.tzSpec));
        }
    }

    private static void processAvailable(IcalCallback cb, BwCalendar cal, Icalendar ical, VAvailability val, EventInfo vavail) throws CalFacadeException {
        try {
            ComponentList avls = val.getAvailable();
            if (avls == null || avls.isEmpty()) {
                return;
            }
            for (Object o : avls) {
                if (!(o instanceof Available)) {
                    throw new IcalMalformedException("Invalid available list");
                }
                EventInfo availi = BwEventUtil.toEvent(cb, cal, ical, (Component)o, true, false);
                availi.getEvent().setOwnerHref(vavail.getEvent().getOwnerHref());
                vavail.addContainedItem(availi);
                vavail.getEvent().addAvailableUid(availi.getEvent().getUid());
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void processVvoters(VPoll val, EventInfo vpoll, IcalCallback cb, ChangeTable changes, boolean mergeAttendees) throws CalFacadeException {
        try {
            ComponentList voters = val.getVoters();
            if (voters == null || voters.isEmpty()) {
                return;
            }
            Iterator it = voters.iterator();
            TreeSet<String> vcuas = new TreeSet<String>();
            BwEvent event = vpoll.getEvent();
            if (!Util.isEmpty((Collection)event.getVvoters())) {
                event.clearVvoters();
            }
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                String vvoter = comp.toString();
                event.addVvoter(vvoter);
                changes.addValue(PropertyIndex.PropertyInfoIndex.VVOTER, (Object)vvoter);
                Property p = comp.getProperty("VOTER");
                if (p == null) {
                    throw new CalFacadeException("XXX - no voter");
                }
                String vcua = p.getValue();
                if (vcuas.contains(vcua)) {
                    throw new CalFacadeException("XXX - duplicate VVOTER for " + vcua);
                }
                BwEventUtil.processVoter((Voter)p, vpoll, cb, changes, mergeAttendees);
                vcuas.add(vcua);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void processVoter(Voter vPr, EventInfo vpoll, IcalCallback cb, ChangeTable chg, boolean mergeAttendees) throws Throwable {
        BwEvent ev = vpoll.getEvent();
        if (vpoll.getNewEvent() || !mergeAttendees) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.VOTER, (Object)BwEventUtil.getVoter(cb, vPr));
            return;
        }
        String pUri = cb.getCaladdr(vPr.getValue());
        if (pUri.equals(cb.getCaladdr(cb.getPrincipal().getPrincipalRef()))) {
            chg.addValue(PropertyIndex.PropertyInfoIndex.VOTER, (Object)BwEventUtil.getVoter(cb, vPr));
            return;
        }
        for (BwAttendee att : ev.getAttendees()) {
            if (!pUri.equals(att.getAttendeeUri())) continue;
            chg.addValue(PropertyIndex.PropertyInfoIndex.VOTER, att.clone());
            break;
        }
    }

    private static void processCandidates(VPoll val, EventInfo vpoll, ChangeTable changes) throws CalFacadeException {
        try {
            ComponentList cands = val.getCandidates();
            if (cands == null || cands.isEmpty()) {
                return;
            }
            Iterator it = cands.iterator();
            TreeSet<Integer> pids = new TreeSet<Integer>();
            BwEvent event = vpoll.getEvent();
            if (!Util.isEmpty((Collection)event.getPollItems())) {
                event.clearPollItems();
            }
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                String pollItem = comp.toString();
                event.addPollItem(pollItem);
                changes.addValue(PropertyIndex.PropertyInfoIndex.POLL_ITEM, (Object)pollItem);
                Property p = comp.getProperty("POLL-ITEM-ID");
                if (p == null) {
                    throw new CalFacadeException("XXX - no poll item id");
                }
                int pid = ((PollItemId)p).getPollitemid();
                if (pids.contains(pid)) {
                    throw new CalFacadeException("XXX - duplicate poll item id " + pid);
                }
                pids.add(pid);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static EventInfo makeNewEvent(IcalCallback cb, int entityType, String uid, String colPath) throws CalFacadeException {
        BwEventObj ev = new BwEventObj();
        EventInfo evinfo = new EventInfo((BwEvent)ev);
        ev.setEntityType(entityType);
        ev.setCreatorHref(cb.getPrincipal().getPrincipalRef());
        ev.setOwnerHref(cb.getOwner().getPrincipalRef());
        ev.setUid(uid);
        ev.setColPath(colPath);
        ChangeTable chg = evinfo.getChangeset(cb.getPrincipal().getPrincipalRef());
        chg.changed(PropertyIndex.PropertyInfoIndex.UID, null, (Object)uid);
        evinfo.setNewEvent(true);
        return evinfo;
    }

    private static EventInfo findMaster(String guid, Collection evs) {
        if (evs == null) {
            return null;
        }
        for (EventInfo ei : evs) {
            BwEvent ev = ei.getEvent();
            if (ev.getRecurrenceId() != null || !guid.equals(ev.getUid())) continue;
            return ei;
        }
        return null;
    }

    private static String getUidPar(Property p) {
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("X-BEDEWORK-UID");
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    private static String getAltRepPar(Property p) {
        AltRep par = IcalUtil.getAltRep(p);
        if (par == null) {
            return null;
        }
        return par.getValue();
    }
}

