/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.FreeBusy;
import net.fortuna.ical4j.model.property.Organizer;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalMalformedException;
import org.bedework.icalendar.IcalUtil;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;

public class BwFreeBusyUtil
extends IcalUtil {
    private static BwLogger logger = new BwLogger().setLoggedClass(BwFreeBusyUtil.class);

    public static EventInfo toFreeBusy(IcalCallback cb, VFreeBusy val) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        try {
            PropertyList pl = val.getProperties();
            if (pl == null) {
                return null;
            }
            BwEventObj fb = new BwEventObj();
            EventInfo ei = new EventInfo((BwEvent)fb);
            ChangeTable chg = ei.getChangeset(cb.getPrincipal().getPrincipalRef());
            fb.setEntityType(4);
            BwFreeBusyUtil.setDates(cb.getPrincipal().getPrincipalRef(), ei, (DtStart)pl.getProperty("DTSTART"), (DtEnd)pl.getProperty("DTEND"), (Duration)pl.getProperty("DURATION"));
            block13: for (Property prop : pl) {
                PropertyIndex.PropertyInfoIndex pi;
                String pval = prop.getValue();
                if (pval != null && pval.length() == 0) {
                    pval = null;
                }
                if ((pi = PropertyIndex.PropertyInfoIndex.fromName((String)prop.getName())) == null) {
                    logger.debug("Unknown property with name " + prop.getName() + " class " + prop.getClass() + " and value " + pval);
                    continue;
                }
                switch (pi) {
                    case ATTENDEE: {
                        BwAttendee att = BwFreeBusyUtil.getAttendee(cb, (Attendee)prop);
                        fb.addAttendee(att);
                        chg.addValue(pi, (Object)att);
                        continue block13;
                    }
                    case COMMENT: {
                        fb.addComment(null, pval);
                        chg.addValue(pi, (Object)pval);
                    }
                    case DTEND: {
                        continue block13;
                    }
                    case DTSTAMP: {
                        chg.changed(pi, (Object)fb.getDtstamp(), (Object)pval);
                        fb.setDtstamp(pval);
                    }
                    case DTSTART: {
                        continue block13;
                    }
                    case FREEBUSY: {
                        int fbtype;
                        FreeBusy fbusy = (FreeBusy)prop;
                        PeriodList perpl = fbusy.getPeriods();
                        Parameter par = BwFreeBusyUtil.getParameter((Property)fbusy, "FBTYPE");
                        if (par == null) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY)) {
                            fbtype = 0;
                        } else if (par.equals((Object)FbType.BUSY_TENTATIVE)) {
                            fbtype = 3;
                        } else if (par.equals((Object)FbType.BUSY_UNAVAILABLE)) {
                            fbtype = 2;
                        } else if (par.equals((Object)FbType.FREE)) {
                            fbtype = 1;
                        } else {
                            if (logger.debug()) {
                                logger.debug("Unsupported parameter " + par.getName());
                            }
                            throw new IcalMalformedException("parameter " + par.getName());
                        }
                        BwFreeBusyComponent fbc = new BwFreeBusyComponent();
                        fbc.setType(fbtype);
                        for (Period per : perpl) {
                            fbc.addPeriod(per);
                        }
                        fb.addFreeBusyPeriod(fbc);
                        chg.addValue(pi, (Object)fbc);
                        continue block13;
                    }
                    case ORGANIZER: {
                        BwOrganizer org = BwFreeBusyUtil.getOrganizer(cb, (Organizer)prop);
                        fb.setOrganizer(org);
                        chg.addValue(pi, (Object)org);
                        continue block13;
                    }
                    case UID: {
                        chg.changed(pi, (Object)fb.getUid(), (Object)pval);
                        fb.setUid(pval);
                        continue block13;
                    }
                }
                if (!logger.debug()) continue;
                logger.debug("Unsupported property with class " + prop.getClass() + " and value " + pval);
            }
            return ei;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }
}

