/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.CalendarException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentFactoryImpl;
import net.fortuna.ical4j.model.Escapable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactoryImpl;
import net.fortuna.ical4j.model.ParameterFactoryRegistry;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactoryRegistry;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.Available;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.VVoter;
import net.fortuna.ical4j.model.component.Vote;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Constants;
import net.fortuna.ical4j.util.Strings;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class CalendarBuilder
implements Logged {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final CalendarParser parser;
    private final ContentHandler contentHandler;
    private final TimeZoneRegistry tzRegistry;
    private List datesMissingTimezones;
    protected Calendar calendar;
    private LinkedList<Component> components = new LinkedList();
    protected Property property;
    private BwLogger logger = new BwLogger();

    public CalendarBuilder() {
        this(CalendarParserFactory.getInstance().createParser(), new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(CalendarParser parser) {
        this(parser, new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(TimeZoneRegistry tzRegistry) {
        this(CalendarParserFactory.getInstance().createParser(), new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), tzRegistry);
    }

    public Component getComponent() {
        if (this.components.size() == 0) {
            return null;
        }
        return this.components.peek();
    }

    public void startComponent(Component component) {
        this.components.push(component);
    }

    public void endComponent() {
        this.components.pop();
    }

    public CalendarBuilder(CalendarParser parser, TimeZoneRegistry tzRegistry) {
        this(parser, new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), tzRegistry);
    }

    public CalendarBuilder(CalendarParser parser, PropertyFactoryRegistry propertyFactoryRegistry, ParameterFactoryRegistry parameterFactoryRegistry, TimeZoneRegistry tzRegistry) {
        this.parser = parser;
        this.tzRegistry = tzRegistry;
        this.contentHandler = new ContentHandlerImpl(propertyFactoryRegistry, parameterFactoryRegistry);
    }

    public Calendar build(InputStream in) throws IOException, ParserException {
        return this.build(new InputStreamReader(in, DEFAULT_CHARSET));
    }

    public Calendar build(Reader in) throws IOException, ParserException {
        return this.build(new UnfoldingReader(in));
    }

    public Calendar build(UnfoldingReader uin) throws IOException, ParserException {
        this.calendar = null;
        this.components.clear();
        this.property = null;
        this.datesMissingTimezones = new ArrayList();
        this.parser.parse((Reader)uin, this.contentHandler);
        if (this.datesMissingTimezones.size() > 0 && this.tzRegistry != null) {
            this.resolveTimezones();
        }
        return this.calendar;
    }

    private void assertComponent(Component component) {
        if (component == null) {
            throw new CalendarException("Expected component not initialised");
        }
    }

    private void assertProperty(Property property) {
        if (property == null) {
            throw new CalendarException("Expected property not initialised");
        }
    }

    public final TimeZoneRegistry getRegistry() {
        return this.tzRegistry;
    }

    private void updateTimeZone(Property property, TimeZone timezone) {
        block5: {
            try {
                ((DateProperty)property).setTimeZone(timezone);
            }
            catch (ClassCastException e) {
                try {
                    ((DateListProperty)property).setTimeZone(timezone);
                }
                catch (ClassCastException e2) {
                    if (CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed")) {
                        this.error("Error setting timezone [" + timezone.getID() + "] on property [" + property.getName() + "]", e);
                        break block5;
                    }
                    throw e2;
                }
            }
        }
    }

    private void resolveTimezones() throws IOException {
        for (Property property : this.datesMissingTimezones) {
            TimeZone timezone;
            Parameter tzParam = property.getParameter("TZID");
            if (tzParam == null || (timezone = this.tzRegistry.getTimeZone(tzParam.getValue())) == null) continue;
            String strDate = property.getValue();
            if (property instanceof DateProperty) {
                ((DateProperty)property).setTimeZone(timezone);
            } else if (property instanceof DateListProperty) {
                ((DateListProperty)property).setTimeZone(timezone);
            }
            try {
                property.setValue(strDate);
            }
            catch (ParseException e) {
                throw new CalendarException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new CalendarException((Throwable)e);
            }
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private class ContentHandlerImpl
    implements ContentHandler {
        private final ComponentFactoryImpl componentFactory = ComponentFactoryImpl.getInstance();
        private final PropertyFactoryRegistry propertyFactory;
        private final ParameterFactoryRegistry parameterFactory;

        public ContentHandlerImpl(PropertyFactoryRegistry propertyFactory, ParameterFactoryRegistry parameterFactory) {
            this.propertyFactory = propertyFactory;
            this.parameterFactory = parameterFactory;
        }

        public void endCalendar() {
        }

        public void endComponent(String name) {
            CalendarBuilder.this.assertComponent(CalendarBuilder.this.getComponent());
            Component component = CalendarBuilder.this.getComponent();
            CalendarBuilder.this.endComponent();
            Component parent = CalendarBuilder.this.getComponent();
            if (parent != null) {
                if (parent instanceof VTimeZone) {
                    ((VTimeZone)parent).getObservances().add((Object)((Observance)component));
                } else if (parent instanceof VEvent) {
                    ((VEvent)parent).getAlarms().add((Object)((VAlarm)component));
                } else if (parent instanceof VToDo) {
                    ((VToDo)parent).getAlarms().add((Object)((VAlarm)component));
                } else if (parent instanceof VAvailability) {
                    ((VAvailability)parent).getAvailable().add((Object)((Available)component));
                } else if (parent instanceof VVoter) {
                    ((VVoter)parent).getVotes().add((Object)((Vote)component));
                } else if (parent instanceof VPoll) {
                    if (component instanceof VAlarm) {
                        ((VPoll)parent).getAlarms().add((Object)((VAlarm)component));
                    } else if (component instanceof VVoter) {
                        ((VPoll)parent).getVoters().add((Object)((VVoter)component));
                    } else {
                        ((VPoll)parent).getCandidates().add((Object)component);
                    }
                }
            } else {
                CalendarBuilder.this.calendar.getComponents().add((Object)((CalendarComponent)component));
                if (component instanceof VTimeZone && CalendarBuilder.this.tzRegistry != null) {
                    CalendarBuilder.this.tzRegistry.register(new TimeZone((VTimeZone)component));
                }
            }
        }

        public void endProperty(String name) {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            CalendarBuilder.this.property = Constants.forProperty((Property)CalendarBuilder.this.property);
            if (CalendarBuilder.this.getComponent() != null) {
                CalendarBuilder.this.getComponent().getProperties().add((Object)CalendarBuilder.this.property);
            } else if (CalendarBuilder.this.calendar != null) {
                CalendarBuilder.this.calendar.getProperties().add((Object)CalendarBuilder.this.property);
            }
            CalendarBuilder.this.property = null;
        }

        public void parameter(String name, String value) throws URISyntaxException {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            Parameter param = this.parameterFactory.createParameter(name.toUpperCase(), value);
            CalendarBuilder.this.property.getParameters().add(param);
            if (param instanceof TzId && CalendarBuilder.this.tzRegistry != null && !(CalendarBuilder.this.property instanceof XProperty)) {
                TimeZone timezone = CalendarBuilder.this.tzRegistry.getTimeZone(param.getValue());
                if (timezone != null) {
                    CalendarBuilder.this.updateTimeZone(CalendarBuilder.this.property, timezone);
                    if (!timezone.getID().equals(param.getValue())) {
                        ParameterList pl = CalendarBuilder.this.property.getParameters();
                        pl.replace(ParameterFactoryImpl.getInstance().createParameter("TZID", timezone.getID()));
                    }
                } else {
                    CalendarBuilder.this.datesMissingTimezones.add(CalendarBuilder.this.property);
                }
            }
        }

        public void propertyValue(String value) throws URISyntaxException, ParseException, IOException {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            if (CalendarBuilder.this.property instanceof Escapable) {
                CalendarBuilder.this.property.setValue(Strings.unescape((String)value));
            } else {
                CalendarBuilder.this.property.setValue(value);
            }
        }

        public void startCalendar() {
            CalendarBuilder.this.calendar = new Calendar();
        }

        public void startComponent(String name) {
            CalendarBuilder.this.startComponent(this.componentFactory.createComponent(name));
        }

        public void startProperty(String name) {
            CalendarBuilder.this.property = this.propertyFactory.createProperty(name.toUpperCase());
        }
    }
}

