/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.Timezones;

public class EventTimeZonesRegistry
implements TimeZoneRegistry {
    private IcalTranslator trans;
    private BwEvent ev;
    private HashMap<String, TimeZone> localTzs;

    public EventTimeZonesRegistry(IcalTranslator trans, BwEvent ev) {
        this.trans = trans;
        this.ev = ev;
    }

    public void register(TimeZone timezone) {
    }

    public void register(TimeZone timezone, boolean update) {
        this.register(timezone);
    }

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeZone getTimeZone(String id) {
        try {
            TimeZone tz = Timezones.getTz((String)id);
            if (tz != null) {
                return tz;
            }
            if (this.localTzs != null && (tz = this.localTzs.get(id)) != null) {
                return tz;
            }
            String tzSpec = EventTimeZonesRegistry.findTzValue(this.ev, id);
            if (tzSpec == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("BEGIN:VCALENDAR\n");
            sb.append(tzSpec);
            sb.append("END:VCALENDAR\n");
            IcalTranslator icalTranslator = this.trans;
            synchronized (icalTranslator) {
                tz = this.trans.tzFromTzdef(sb.toString());
            }
            if (tz != null) {
                if (this.localTzs == null) {
                    this.localTzs = new HashMap();
                }
                this.localTzs.put(id, tz);
            }
            return tz;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String findTzValue(BwEvent ev, String tzId) {
        if (ev == null) {
            return null;
        }
        List xps = ev.getXproperties();
        if (Util.isEmpty((Collection)xps)) {
            xps = ev.getXproperties(BwXproperty.escapeName((String)("X-BEDEWORK-TZ-" + tzId)));
            if (Util.isEmpty((Collection)xps)) {
                return null;
            }
            return ((BwXproperty)xps.iterator().next()).getValue();
        }
        for (BwXproperty xp : xps) {
            String id;
            String val = xp.getValue();
            int pos = BwXproperty.nextSemi((String)val, (int)0);
            if (pos < 0 || !(id = BwXproperty.unescapeSemi((String)val.substring(0, pos))).equals(tzId)) continue;
            return val.substring(pos + 1);
        }
        return null;
    }
}

