/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import ietf.params.xml.ns.icalendar_2.MethodPropType;
import ietf.params.xml.ns.icalendar_2.ProdidPropType;
import ietf.params.xml.ns.icalendar_2.VcalendarType;
import ietf.params.xml.ns.icalendar_2.VersionPropType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.VfreebusyType;
import ietf.params.xml.ns.icalendar_2.VjournalType;
import ietf.params.xml.ns.icalendar_2.VtodoType;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwVersion;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.BwEventUtil;
import org.bedework.icalendar.CalendarBuilder;
import org.bedework.icalendar.EventTimeZonesRegistry;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalMalformedException;
import org.bedework.icalendar.IcalUtil;
import org.bedework.icalendar.Icalendar;
import org.bedework.icalendar.JcalHandler;
import org.bedework.icalendar.ToXEvent;
import org.bedework.icalendar.VEventUtil;
import org.bedework.icalendar.VFreeUtil;
import org.bedework.icalendar.Xutil;
import org.bedework.util.calendar.JsonCalendarBuilder;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.calendar.WsXMLTranslator;
import org.bedework.util.calendar.XmlCalendarBuilder;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.XcalTags;

public class IcalTranslator
implements Logged,
Serializable {
    public static final String prodId = "//Bedework.org//BedeWork V" + BwVersion.bedeworkVersion + "//EN";
    protected IcalCallback cb;
    protected Pars pars = new Pars();
    private BwLogger logger = new BwLogger();

    public IcalTranslator(IcalCallback cb) {
        this.cb = cb;
    }

    public static Calendar newIcal(int methodType) throws CalFacadeException {
        Calendar cal = new Calendar();
        PropertyList pl = cal.getProperties();
        pl.add((Object)new ProdId(prodId));
        pl.add((Object)Version.VERSION_2_0);
        if (methodType > 0 && methodType < 99) {
            pl.add((Object)new Method(ScheduleMethods.methods[methodType]));
        }
        return cal;
    }

    public static String toIcalString(int methodType, BwEvent ent) throws CalFacadeException {
        Calendar cal = new Calendar();
        PropertyList pl = cal.getProperties();
        pl.add((Object)new ProdId(prodId));
        pl.add((Object)Version.VERSION_2_0);
        if (methodType > 0 && methodType < 99) {
            pl.add((Object)new Method(ScheduleMethods.methods[methodType]));
        }
        if (ent.getEntityType() != 4) {
            throw new CalFacadeException("Unexpected entity type");
        }
        VFreeBusy vfreeBusy = VFreeUtil.toVFreeBusy(ent);
        cal.getComponents().add((Object)vfreeBusy);
        CalendarOutputter co = new CalendarOutputter(false, 74);
        StringWriter wtr = new StringWriter();
        try {
            co.output(cal, (Writer)wtr);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return ((Object)wtr).toString();
    }

    public static String toIcalString(Calendar cal) throws CalFacadeException {
        StringWriter wtr = new StringWriter();
        IcalTranslator.writeCalendar(cal, wtr);
        return ((Object)wtr).toString();
    }

    public static void writeCalendar(Calendar cal, Writer wtr) throws CalFacadeException {
        CalendarOutputter co = new CalendarOutputter(false, 74);
        try {
            co.output(cal, wtr);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Calendar toIcal(EventInfo val, int methodType) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        try {
            Calendar cal = IcalTranslator.newIcal(methodType);
            this.addToCalendar(cal, val, new TreeSet<String>());
            return cal;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void writeJcal(Collection<EventInfo> vals, int methodType, Writer wtr) throws CalFacadeException {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        JcalHandler.outJcal(wtr, vals, methodType, null, currentPrincipal, new EventTimeZonesRegistry(this, null));
    }

    public void writeXmlCalendar(Collection vals, int methodType, XmlEmit xml) throws CalFacadeException {
        try {
            xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:icalendar-2.0", "X"), false);
            xml.openTag(XcalTags.icalendar);
            xml.openTag(XcalTags.vcalendar);
            xml.openTag(XcalTags.properties);
            this.xmlProp(xml, "PRODID", XcalTags.textVal, prodId);
            this.xmlProp(xml, "VERSION", XcalTags.textVal, Version.VERSION_2_0.getValue());
            xml.closeTag(XcalTags.properties);
            boolean componentsOpen = false;
            if (!this.cb.getTimezonesByReference()) {
                Calendar cal = IcalTranslator.newIcal(methodType);
                this.addIcalTimezones(cal, vals);
                for (Object o : cal.getComponents()) {
                    if (!(o instanceof VTimeZone)) continue;
                    if (!componentsOpen) {
                        xml.openTag(XcalTags.components);
                        componentsOpen = true;
                    }
                    this.xmlComponent(xml, (Component)o);
                }
            }
            String currentPrincipal = null;
            BwPrincipal principal = this.cb.getPrincipal();
            if (principal != null) {
                currentPrincipal = principal.getPrincipalRef();
            }
            for (Object o : vals) {
                if (!(o instanceof EventInfo)) continue;
                EventInfo ei = (EventInfo)o;
                BwEvent ev = ei.getEvent();
                EventTimeZonesRegistry tzreg = new EventTimeZonesRegistry(this, ev);
                Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : VEventUtil.toIcalComponent(ei, false, tzreg, currentPrincipal);
                if (!componentsOpen) {
                    xml.openTag(XcalTags.components);
                    componentsOpen = true;
                }
                this.xmlComponent(xml, (Component)comp);
                if (ei.getNumOverrides() <= 0) continue;
                for (EventInfo oei : ei.getOverrides()) {
                    ev = oei.getEvent();
                    this.xmlComponent(xml, VEventUtil.toIcalComponent(oei, true, tzreg, currentPrincipal));
                }
            }
            if (componentsOpen) {
                xml.closeTag(XcalTags.components);
            }
            xml.closeTag(XcalTags.vcalendar);
            xml.closeTag(XcalTags.icalendar);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlComponent(XmlEmit xml, Component val) throws CalFacadeException {
        try {
            QName tag = this.openTag(xml, val.getName());
            PropertyList pl = val.getProperties();
            if (pl.size() > 0) {
                xml.openTag(XcalTags.properties);
                for (Object po : pl) {
                    this.xmlProperty(xml, (Property)po);
                }
                xml.closeTag(XcalTags.properties);
            }
            ComponentList cl = null;
            if (val instanceof VTimeZone) {
                cl = ((VTimeZone)val).getObservances();
            } else if (val instanceof VEvent) {
                cl = ((VEvent)val).getAlarms();
            } else if (val instanceof VToDo) {
                cl = ((VToDo)val).getAlarms();
            }
            if (cl != null && cl.size() > 0) {
                xml.openTag(XcalTags.components);
                for (Object o : cl) {
                    this.xmlComponent(xml, (Component)o);
                }
                xml.closeTag(XcalTags.components);
            }
            xml.closeTag(tag);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlProperty(XmlEmit xml, Property val) throws CalFacadeException {
        try {
            PropertyIndex.DataType dtype;
            QName tag = this.openTag(xml, val.getName());
            ParameterList pl = val.getParameters();
            if (pl.size() > 0) {
                xml.openTag(XcalTags.parameters);
                Iterator pli = pl.iterator();
                while (pli.hasNext()) {
                    this.xmlParameter(xml, (Parameter)pli.next());
                }
                xml.closeTag(XcalTags.parameters);
            }
            PropertyIndex.PropertyInfoIndex pii = PropertyIndex.PropertyInfoIndex.fromName((String)val.getName());
            QName ptype = XcalTags.textVal;
            if (pii != null && (dtype = pii.getPtype()) != null) {
                ptype = dtype.getXcalType();
            }
            if (ptype == null) {
                this.warn("Unimplemented value type for " + val.getName());
                ptype = XcalTags.textVal;
            }
            if (ptype.equals(XcalTags.recurVal)) {
                xml.openTag(ptype);
                Recur r = val instanceof ExRule ? ((ExRule)val).getRecur() : ((RRule)val).getRecur();
                xml.property(XcalTags.freq, r.getFrequency());
                this.xmlProp(xml, XcalTags.wkst, r.getWeekStartDay().name());
                if (r.getUntil() != null) {
                    this.xmlProp(xml, XcalTags.until, r.getUntil().toString());
                }
                this.xmlProp(xml, XcalTags.count, String.valueOf(r.getCount()));
                this.xmlProp(xml, XcalTags.interval, String.valueOf(r.getInterval()));
                this.xmlProp(xml, XcalTags.bymonth, (Collection)r.getMonthList());
                this.xmlProp(xml, XcalTags.byweekno, (Collection)r.getWeekNoList());
                this.xmlProp(xml, XcalTags.byyearday, (Collection)r.getYearDayList());
                this.xmlProp(xml, XcalTags.bymonthday, (Collection)r.getMonthDayList());
                this.xmlProp(xml, XcalTags.byday, (Collection)r.getDayList());
                this.xmlProp(xml, XcalTags.byhour, (Collection)r.getHourList());
                this.xmlProp(xml, XcalTags.byminute, (Collection)r.getMinuteList());
                this.xmlProp(xml, XcalTags.bysecond, (Collection)r.getSecondList());
                this.xmlProp(xml, XcalTags.bysetpos, (Collection)r.getSetPosList());
                xml.closeTag(ptype);
            } else {
                xml.property(ptype, val.getValue());
            }
            xml.closeTag(tag);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private QName openTag(XmlEmit xml, String name) throws CalFacadeException {
        QName tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", name.toLowerCase());
        try {
            xml.openTag(tag);
            return tag;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlProp(XmlEmit xml, QName tag, String val) throws CalFacadeException {
        if (val == null) {
            return;
        }
        try {
            xml.property(tag, val);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlProp(XmlEmit xml, QName tag, Collection val) throws CalFacadeException {
        if (val == null || val.isEmpty()) {
            return;
        }
        try {
            xml.property(tag, val.toString());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlProp(XmlEmit xml, String pname, QName ptype, String val) throws CalFacadeException {
        QName tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", pname.toLowerCase());
        try {
            xml.openTag(tag);
            xml.property(ptype, val);
            xml.closeTag(tag);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void xmlParameter(XmlEmit xml, Parameter val) throws CalFacadeException {
        try {
            QName tag;
            PropertyIndex.DataType dtype;
            PropertyIndex.ParameterInfoIndex pii = PropertyIndex.ParameterInfoIndex.lookupPname((String)val.getName());
            QName ptype = XcalTags.textVal;
            if (pii != null && (dtype = pii.getPtype()) != null) {
                ptype = dtype.getXcalType();
            }
            if (ptype.equals(XcalTags.textVal)) {
                tag = new QName("urn:ietf:params:xml:ns:icalendar-2.0", val.getName().toLowerCase());
                xml.property(tag, val.getValue());
            } else {
                tag = this.openTag(xml, val.getName());
                xml.property(ptype, val.getValue());
                xml.closeTag(tag);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void writeCalendar(Collection vals, int methodType, Writer wtr) throws CalFacadeException {
        try {
            Calendar cal = this.toIcal(vals, methodType);
            IcalTranslator.writeCalendar(cal, wtr);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Calendar toIcal(Collection vals, int methodType) throws CalFacadeException {
        Calendar cal = IcalTranslator.newIcal(methodType);
        if (vals == null || vals.size() == 0) {
            return cal;
        }
        TreeSet<String> added = new TreeSet<String>();
        try {
            for (Object o : vals) {
                if (o instanceof EventInfo) {
                    this.addToCalendar(cal, (EventInfo)o, added);
                    continue;
                }
                this.warn("Unimplemented toIcal for " + o.getClass().getName());
            }
            return cal;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public TimeZone tzFromTzdef(String val) throws CalFacadeException {
        StringReader sr = new StringReader(val);
        Icalendar ic = this.fromIcal(null, sr);
        if (ic == null || ic.size() != 0 || ic.getTimeZones().size() != 1) {
            if (this.debug()) {
                this.debug("Not icalendar");
            }
            throw new CalFacadeException("Not icalendar");
        }
        return ic.getTimeZones().iterator().next().tz;
    }

    public Icalendar fromIcal(BwCalendar col, Reader rdr) throws CalFacadeException {
        return this.fromIcal(col, rdr, null, true, false);
    }

    public Icalendar fromIcal(BwCalendar col, IcalendarType ical, boolean diff) throws CalFacadeException {
        Icalendar ic = new Icalendar();
        IcalTranslator.setSystemProperties();
        WsXMLTranslator bldr = new WsXMLTranslator((TimeZoneRegistry)ic);
        try {
            Calendar cal = bldr.fromXcal(ical);
            return this.makeIc(col, ic, cal, diff, false);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Icalendar fromComp(BwCalendar col, Component comp, boolean diff, boolean mergeAttendees) throws CalFacadeException {
        try {
            Icalendar ic = new Icalendar();
            IcalTranslator.setSystemProperties();
            Calendar cal = new Calendar();
            cal.getComponents().add((Object)((CalendarComponent)comp));
            return this.makeIc(col, ic, cal, diff, mergeAttendees);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public Icalendar fromIcal(BwCalendar col, Reader rdr, String contentType, boolean diff, boolean mergeAttendees) throws CalFacadeException {
        try {
            Calendar cal;
            Icalendar ic = new Icalendar();
            IcalTranslator.setSystemProperties();
            if (contentType != null && contentType.equals("application/calendar+xml")) {
                XmlCalendarBuilder bldr = new XmlCalendarBuilder((TimeZoneRegistry)ic);
                cal = bldr.build(rdr);
            } else if (contentType != null && contentType.equals("application/calendar+json")) {
                JsonCalendarBuilder bldr = new JsonCalendarBuilder((TimeZoneRegistry)ic);
                cal = bldr.build(rdr);
            } else {
                CalendarBuilder bldr = new CalendarBuilder((CalendarParser)new CalendarParserImpl(), ic);
                UnfoldingReader ufrdr = new UnfoldingReader(rdr, true);
                cal = bldr.build(ufrdr);
            }
            return this.makeIc(col, ic, cal, diff, mergeAttendees);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (ParserException pe) {
            if (this.debug()) {
                this.error(pe);
            }
            throw new IcalMalformedException(pe.getMessage());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void addOverride(EventInfo ei, JAXBElement<? extends BaseComponentType> comp) throws CalFacadeException {
        try {
            Calendar cal = new WsXMLTranslator((TimeZoneRegistry)new Icalendar()).fromXcomp(comp);
            if (cal == null) {
                return;
            }
            Icalendar ic = new Icalendar();
            ic.addComponent(ei);
            this.makeIc(null, ic, cal, true, false);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private Icalendar makeIc(BwCalendar col, Icalendar ic, Calendar cal, boolean diff, boolean mergeAttendees) throws CalFacadeException {
        try {
            if (cal == null) {
                return ic;
            }
            PropertyList pl = cal.getProperties();
            Property prop = pl.getProperty("PRODID");
            if (prop != null) {
                ic.setProdid(prop.getValue());
            }
            if ((prop = pl.getProperty("VERSION")) != null) {
                ic.setVersion(prop.getValue());
            }
            ic.setMethod(IcalTranslator.getMethod(cal));
            prop = pl.getProperty("CALSCALE");
            if (prop != null) {
                ic.setCalscale(prop.getValue());
            }
            Collection<CalendarComponent> clist = IcalTranslator.orderedComponents(cal.getComponents());
            for (CalendarComponent comp : clist) {
                EventInfo ei;
                if (comp instanceof VFreeBusy) {
                    ei = BwEventUtil.toEvent(this.cb, col, ic, (Component)comp, diff, mergeAttendees);
                    if (ei == null) continue;
                    ic.addComponent(ei);
                    continue;
                }
                if (comp instanceof VTimeZone) {
                    ic.addTimeZone(this.doTimeZone((VTimeZone)comp));
                    continue;
                }
                if (!(comp instanceof VEvent) && !(comp instanceof VToDo) && !(comp instanceof VPoll) && !(comp instanceof VAvailability) || (ei = BwEventUtil.toEvent(this.cb, col, ic, (Component)comp, diff, mergeAttendees)) == null) continue;
                ic.addComponent(ei);
            }
            return ic;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static String getMethod(Calendar val) {
        Property prop = val.getProperties().getProperty("METHOD");
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public Calendar getTzCalendar(String tzid) throws CalFacadeException {
        try {
            Calendar cal = IcalTranslator.newIcal(0);
            this.addIcalTimezone(cal, tzid, null, Timezones.getTzRegistry());
            return cal;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public String toStringTzCalendar(String tzid) throws CalFacadeException {
        Calendar ical = this.getTzCalendar(tzid);
        CalendarOutputter calOut = new CalendarOutputter(true);
        StringWriter sw = new StringWriter();
        try {
            calOut.output(ical, (Writer)sw);
            return sw.toString();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public IcalendarType toXMLIcalendar(EventInfo val, int methodType, IcalendarType pattern, boolean wrapXprops) throws CalFacadeException {
        ArrayOfComponents aoc;
        IcalendarType ical = new IcalendarType();
        VcalendarType vcal = new VcalendarType();
        ical.getVcalendar().add(vcal);
        vcal.setProperties(new ArrayOfProperties());
        List pl = vcal.getProperties().getBasePropertyOrTzid();
        ProdidPropType prod = new ProdidPropType();
        prod.setText(prodId);
        pl.add(Xutil.of.createProdid(prod));
        VersionPropType vers = new VersionPropType();
        vers.setText("2.0");
        pl.add(Xutil.of.createVersion(vers));
        if (methodType > 0 && methodType < 99) {
            MethodPropType m = new MethodPropType();
            m.setText(ScheduleMethods.methods[methodType]);
            pl.add(Xutil.of.createMethod(m));
        }
        if ((aoc = vcal.getComponents()) == null) {
            aoc = new ArrayOfComponents();
            vcal.setComponents(aoc);
        }
        BwEvent ev = val.getEvent();
        JAXBElement<? extends BaseComponentType> el = null;
        VcalendarType vc = null;
        if (pattern != null && !pattern.getVcalendar().isEmpty()) {
            vc = (VcalendarType)pattern.getVcalendar().get(0);
        }
        BaseComponentType bc = this.matches(vc, ev.getEntityType());
        if (vc != null && bc == null) {
            return ical;
        }
        if (!ev.getSuppressed() && (el = ev.getEntityType() == 4 ? ToXEvent.toComponent(ev, false, wrapXprops, bc) : ToXEvent.toComponent(ev, false, wrapXprops, bc)) != null) {
            aoc.getBaseComponent().add(el);
        }
        if (val.getNumOverrides() == 0) {
            return ical;
        }
        for (EventInfo oei : val.getOverrides()) {
            ev = oei.getEvent();
            el = ToXEvent.toComponent(ev, true, wrapXprops, bc);
            if (el == null) continue;
            aoc.getBaseComponent().add(el);
        }
        if (val.getNumContainedItems() > 0) {
            for (EventInfo aei : val.getContainedItems()) {
                ev = aei.getEvent();
                el = ToXEvent.toComponent(ev, true, wrapXprops, bc);
                if (el == null) continue;
                aoc.getBaseComponent().add(el);
            }
        }
        return ical;
    }

    private BaseComponentType matches(VcalendarType vc, int entityType) throws CalFacadeException {
        String nm;
        if (vc == null || vc.getComponents() == null) {
            return null;
        }
        if (entityType == 0) {
            nm = VeventType.class.getName();
        } else if (entityType == 2) {
            nm = VtodoType.class.getName();
        } else if (entityType == 3) {
            nm = VjournalType.class.getName();
        } else if (entityType == 4) {
            nm = VfreebusyType.class.getName();
        } else {
            throw new CalFacadeException("org.bedework.invalid.entity.type", String.valueOf(entityType));
        }
        for (JAXBElement jbc : vc.getComponents().getBaseComponent()) {
            BaseComponentType bc = (BaseComponentType)jbc.getValue();
            if (!nm.equals(bc.getClass().getName())) continue;
            return bc;
        }
        return null;
    }

    public String toJcal(EventInfo val, int methodType, IcalendarType pattern) throws CalFacadeException {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        ArrayList<EventInfo> eis = new ArrayList<EventInfo>();
        eis.add(val);
        return JcalHandler.toJcal(eis, methodType, pattern, currentPrincipal, new EventTimeZonesRegistry(this, val.getEvent()));
    }

    public static String toJcal(Calendar val, IcalendarType pattern) throws CalFacadeException {
        return JcalHandler.toJcal(val, pattern, null);
    }

    private void addToCalendar(Calendar cal, EventInfo val, TreeSet<String> added) throws CalFacadeException {
        String currentPrincipal = null;
        BwPrincipal principal = this.cb.getPrincipal();
        if (principal != null) {
            currentPrincipal = principal.getPrincipalRef();
        }
        BwEvent ev = val.getEvent();
        EventTimeZonesRegistry tzreg = new EventTimeZonesRegistry(this, ev);
        if (!this.cb.getTimezonesByReference()) {
            this.addIcalTimezones(cal, ev, added, tzreg);
        }
        if (!ev.getSuppressed()) {
            Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : VEventUtil.toIcalComponent(val, false, tzreg, currentPrincipal);
            cal.getComponents().add((Object)((CalendarComponent)comp));
        }
        if (val.getNumOverrides() > 0) {
            for (EventInfo oei : val.getOverrides()) {
                cal.getComponents().add((Object)((CalendarComponent)VEventUtil.toIcalComponent(oei, true, tzreg, currentPrincipal)));
            }
        }
    }

    private static Collection<CalendarComponent> orderedComponents(ComponentList clist) {
        SubList<CalendarComponent> tzs = new SubList<CalendarComponent>();
        SubList<CalendarComponent> fbs = new SubList<CalendarComponent>();
        SubList<CalendarComponent> instances = new SubList<CalendarComponent>();
        SubList<CalendarComponent> masters = new SubList<CalendarComponent>();
        for (CalendarComponent c : clist) {
            if (c instanceof VFreeBusy) {
                fbs.add(c);
                continue;
            }
            if (c instanceof VTimeZone) {
                tzs.add(c);
                continue;
            }
            if (IcalUtil.getProperty((Component)c, "RECURRENCE-ID") != null) {
                instances.add(c);
                continue;
            }
            masters.add(c);
        }
        ArrayList<CalendarComponent> all = new ArrayList<CalendarComponent>();
        tzs.appendTo(all);
        masters.appendTo(all);
        instances.appendTo(all);
        fbs.appendTo(all);
        return all;
    }

    private Icalendar.TimeZoneInfo doTimeZone(VTimeZone vtz) throws CalFacadeException {
        TzId tzid = vtz.getTimeZoneId();
        if (tzid == null) {
            throw new CalFacadeException("Missing tzid property");
        }
        String id = tzid.getValue();
        try {
            TimeZone tz = Timezones.getTz((String)id);
            String tzSpec = null;
            if (tz == null) {
                tz = new TimeZone(vtz);
                tzSpec = vtz.toString();
            }
            return new Icalendar.TimeZoneInfo(id, tz, tzSpec);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void addIcalTimezones(Calendar cal, Collection vals) throws CalFacadeException {
        TreeSet<String> added = new TreeSet<String>();
        for (Object o : vals) {
            if (!(o instanceof EventInfo)) continue;
            EventInfo ei = (EventInfo)o;
            BwEvent ev = ei.getEvent();
            if (!ev.getSuppressed()) {
                this.addIcalTimezones(cal, ev, added, new EventTimeZonesRegistry(this, ev));
            }
            if (ei.getNumOverrides() <= 0) continue;
            for (EventInfo oei : ei.getOverrides()) {
                ev = oei.getEvent();
                this.addIcalTimezones(cal, ev, added, new EventTimeZonesRegistry(this, ev));
            }
        }
    }

    private void addIcalTimezones(Calendar cal, BwEvent ev, TreeSet<String> added, TimeZoneRegistry tzreg) throws CalFacadeException {
        if (ev.getEntityType() == 4) {
            return;
        }
        if (!ev.getForceUTC()) {
            this.addIcalTimezone(cal, ev.getDtstart().getTzid(), added, tzreg);
            if (ev.getEndType() == 'E') {
                this.addIcalTimezone(cal, ev.getDtend().getTzid(), added, tzreg);
            }
        }
    }

    private void addIcalTimezone(Calendar cal, String tzid, TreeSet<String> added, TimeZoneRegistry tzreg) throws CalFacadeException {
        VTimeZone vtz = null;
        if (tzid == null || added != null && added.contains(tzid)) {
            return;
        }
        TimeZone tz = tzreg.getTimeZone(tzid);
        if (tz != null) {
            vtz = tz.getVTimeZone();
        }
        if (vtz != null) {
            cal.getComponents().add((Object)vtz);
        } else if (this.debug()) {
            this.debug("Didn't find timezone with id " + tzid);
        }
        if (added != null) {
            added.add(tzid);
        }
    }

    private static void setSystemProperties() throws CalFacadeException {
        try {
            System.setProperty("ical4j.unfolding.relaxed", "true");
            System.setProperty("ical4j.parsing.relaxed", "true");
            System.setProperty("ical4j.compatibility.outlook", "true");
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private static class SubList<T> {
        ArrayList<T> list;

        private SubList() {
        }

        void add(T o) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.list.add(o);
        }

        void appendTo(Collection<T> c) {
            if (this.list != null) {
                c.addAll(this.list);
            }
        }
    }

    public static class Pars {
        public boolean simpleLocation = true;
        public boolean simpleContact = true;
    }

    public static class SkipThis {
    }
}

