/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactoryImpl;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VVoter;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.ScheduleStatus;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.StayInformed;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.PollItemId;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Voter;
import net.fortuna.ical4j.model.property.XProperty;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.AbbreviatedValue;
import org.bedework.calfacade.base.TypedUrl;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.icalendar.CalendarBuilder;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalMalformedException;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;

public class IcalUtil {
    public static AbbreviatedValue getAbbrevVal(Property p) {
        ParameterList pars = p.getParameters();
        ParameterList abbrevPars = pars.getParameters("ABBREV");
        ArrayList<String> abbrevs = new ArrayList<String>();
        for (Parameter par : abbrevPars) {
            abbrevs.add(par.getValue());
        }
        return new AbbreviatedValue(abbrevs, p.getValue());
    }

    public static void xpropertiesToIcal(PropertyList pl, List<BwXproperty> xprops) throws Throwable {
        for (BwXproperty x : xprops) {
            String xname = x.getName();
            if (xname.equals("X-BEDEWORK-ICAL-PROP")) {
                ArrayList<BwXproperty.Xpar> params = x.getParameters();
                String pname = ((BwXproperty.Xpar)params.get(0)).getValue();
                if (params.size() == 1) {
                    params = null;
                } else {
                    params = new ArrayList<BwXproperty.Xpar>(params);
                    params.remove(0);
                }
                if (pname.equals("UID")) {
                    pl.add((Object)new Uid(IcalUtil.makeXparlist(params), x.getValue()));
                }
            }
            if (x.getSkip() || xname.startsWith("X-BEDEWORK-TZ-")) continue;
            IcalUtil.addXproperty(pl, xname, x.getParameters(), x.getValue());
        }
    }

    public static ParameterList makeXparlist(List<BwXproperty.Xpar> pars) throws Throwable {
        ParameterList xparl = new ParameterList();
        if (pars == null) {
            return xparl;
        }
        for (BwXproperty.Xpar xpar : pars) {
            String xval = xpar.getValue();
            if (xval.indexOf(":") >= 0 || xval.indexOf(";") >= 0 || xval.indexOf(",") >= 0) {
                xval = "\"" + xval + "\"";
            }
            xparl.add(ParameterFactoryImpl.getInstance().createParameter(xpar.getName().toUpperCase(), xval));
        }
        return xparl;
    }

    public static void addXproperty(PropertyList pl, String name, List<BwXproperty.Xpar> pars, String val) throws Throwable {
        if (val == null) {
            return;
        }
        pl.add((Object)new XProperty(name, IcalUtil.makeXparlist(pars), val));
    }

    public static TypedUrl getTypedUrl(Property p) {
        TypedUrl tu = new TypedUrl();
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("TYPE");
        if (par != null) {
            tu.setType(par.getValue());
        }
        tu.setValue(p.getValue());
        return tu;
    }

    public static String getLang(Property p) {
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("LANGUAGE");
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static String getVenue(Property p) {
        ParameterList pars = p.getParameters();
        Parameter par = pars.getParameter("VVENUE");
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static Organizer setOrganizer(BwOrganizer val) throws Throwable {
        ParameterList pars = new ParameterList();
        String temp = val.getScheduleStatus();
        if (temp != null) {
            pars.add((Parameter)new ScheduleStatus(temp));
        }
        if ((temp = val.getCn()) != null) {
            pars.add((Parameter)new Cn(temp));
        }
        if ((temp = val.getDir()) != null) {
            pars.add((Parameter)new Dir(temp));
        }
        if ((temp = val.getLanguage()) != null) {
            pars.add((Parameter)new Language(temp));
        }
        if ((temp = val.getSentBy()) != null) {
            pars.add((Parameter)new SentBy(temp));
        }
        Organizer prop = new Organizer(pars, val.getOrganizerUri());
        return prop;
    }

    public static BwOrganizer getOrganizer(IcalCallback cb, Organizer orgProp) throws Throwable {
        BwOrganizer org = new BwOrganizer();
        org.setOrganizerUri(cb.getCaladdr(orgProp.getValue()));
        ParameterList pars = orgProp.getParameters();
        org.setCn(IcalUtil.getOptStr(pars, "CN"));
        org.setDir(IcalUtil.getOptStr(pars, "DIR"));
        org.setLanguage(IcalUtil.getOptStr(pars, "LANGUAGE"));
        org.setScheduleStatus(IcalUtil.getOptStr(pars, "SCHEDULE-STATUS"));
        org.setSentBy(IcalUtil.getOptStr(pars, "SENT-BY"));
        return org;
    }

    public static Attach setAttachment(BwAttachment val) throws Throwable {
        ParameterList pars = new ParameterList();
        String temp = val.getFmtType();
        if (temp != null) {
            pars.add((Parameter)new FmtType(temp));
        }
        if ((temp = val.getEncoding()) == null) {
            return new Attach(pars, val.getUri());
        }
        pars.add((Parameter)new Encoding(temp));
        temp = val.getValueType();
        if (temp != null) {
            pars.add((Parameter)new Value(temp));
        }
        return new Attach(pars, val.getValue());
    }

    public static BwAttachment getAttachment(Attach attProp) throws Throwable {
        BwAttachment att = new BwAttachment();
        ParameterList pars = attProp.getParameters();
        att.setFmtType(IcalUtil.getOptStr(pars, "FMTTYPE"));
        att.setValueType(IcalUtil.getOptStr(pars, "VALUE"));
        att.setEncoding(IcalUtil.getOptStr(pars, "ENCODING"));
        if (att.getEncoding() == null) {
            att.setUri(attProp.getValue());
        } else {
            att.setValue(attProp.getValue());
        }
        return att;
    }

    public static Attendee setAttendee(BwAttendee val) throws Throwable {
        Attendee prop = new Attendee(val.getAttendeeUri());
        ParameterList pars = prop.getParameters();
        IcalUtil.setAttendeeVoter(val, pars);
        String temp = val.getPartstat();
        if (temp != null && !temp.equals("NEEDS-ACTION")) {
            pars.add((Parameter)new PartStat(temp));
        }
        return prop;
    }

    public static Voter setVoter(BwAttendee val) throws Throwable {
        Voter prop = new Voter(val.getAttendeeUri());
        ParameterList pars = prop.getParameters();
        IcalUtil.setAttendeeVoter(val, pars);
        String temp = val.getPartstat();
        pars.add((Parameter)new PartStat(temp));
        return prop;
    }

    public static Map<String, VVoter> parseVpollVvoters(BwEvent poll) throws Throwable {
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\n");
        sb.append("PRODID://Bedework.org//BedeWork V3.9//EN\n");
        sb.append("VERSION:2.0\n");
        sb.append("BEGIN:VPOLL\n");
        sb.append("UID:0123\n");
        if (!Util.isEmpty((Collection)poll.getVvoters())) {
            for (String s : poll.getVvoters()) {
                sb.append(s);
            }
        }
        sb.append("END:VPOLL\n");
        sb.append("END:VCALENDAR\n");
        try {
            StringReader sr = new StringReader(sb.toString());
            Icalendar ic = new Icalendar();
            CalendarBuilder bldr = new CalendarBuilder((CalendarParser)new CalendarParserImpl(), ic);
            UnfoldingReader ufrdr = new UnfoldingReader((Reader)sr, true);
            Calendar ical = bldr.build(ufrdr);
            HashMap<String, VVoter> voters = new HashMap<String, VVoter>();
            VPoll vpoll = (VPoll)ical.getComponent("VPOLL");
            for (Object o : vpoll.getVoters()) {
                VVoter vvoter = (VVoter)o;
                Voter v = (Voter)vvoter.getProperty("VOTER");
                if (v == null) continue;
                voters.put(v.getValue(), vvoter);
            }
            return voters;
        }
        catch (ParserException pe) {
            throw new IcalMalformedException(pe.getMessage());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static Map<Integer, Component> parseVpollCandidates(BwEvent poll) throws Throwable {
        StringBuilder sb = new StringBuilder();
        sb.append("BEGIN:VCALENDAR\n");
        sb.append("PRODID://Bedework.org//BedeWork V3.9//EN\n");
        sb.append("VERSION:2.0\n");
        if (!Util.isEmpty((Collection)poll.getPollItems())) {
            for (String s : poll.getPollItems()) {
                sb.append(s);
            }
        }
        sb.append("END:VCALENDAR\n");
        try {
            StringReader sr = new StringReader(sb.toString());
            Icalendar ic = new Icalendar();
            CalendarBuilder bldr = new CalendarBuilder((CalendarParser)new CalendarParserImpl(), ic);
            UnfoldingReader ufrdr = new UnfoldingReader((Reader)sr, true);
            Calendar ical = bldr.build(ufrdr);
            HashMap<Integer, Component> comps = new HashMap<Integer, Component>();
            for (Object o : ical.getComponents()) {
                Component comp = (Component)o;
                PollItemId pid = (PollItemId)comp.getProperty("POLL-ITEM-ID");
                if (pid == null) continue;
                comps.put(pid.getPollitemid(), comp);
            }
            return comps;
        }
        catch (ParserException pe) {
            throw new IcalMalformedException(pe.getMessage());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void setAttendeeVoter(BwAttendee val, ParameterList pars) throws Throwable {
        String temp;
        if (val.getRsvp()) {
            pars.add((Parameter)Rsvp.TRUE);
        }
        if ((temp = val.getCn()) != null) {
            pars.add((Parameter)new Cn(temp));
        }
        if ((temp = val.getScheduleStatus()) != null) {
            pars.add((Parameter)new ScheduleStatus(temp));
        }
        if ((temp = val.getCuType()) != null) {
            pars.add((Parameter)new CuType(temp));
        }
        if ((temp = val.getDelegatedFrom()) != null) {
            pars.add((Parameter)new DelegatedFrom(temp));
        }
        if ((temp = val.getDelegatedTo()) != null) {
            pars.add((Parameter)new DelegatedTo(temp));
        }
        if ((temp = val.getDir()) != null) {
            pars.add((Parameter)new Dir(temp));
        }
        if ((temp = val.getLanguage()) != null) {
            pars.add((Parameter)new Language(temp));
        }
        if ((temp = val.getMember()) != null) {
            pars.add((Parameter)new Member(temp));
        }
        if ((temp = val.getRole()) != null) {
            pars.add((Parameter)new Role(temp));
        }
        if ((temp = val.getSentBy()) != null) {
            pars.add((Parameter)new SentBy(temp));
        }
    }

    public static BwAttendee getAttendee(IcalCallback cb, Attendee attProp) throws Throwable {
        ParameterList pars = attProp.getParameters();
        BwAttendee att = IcalUtil.initAttendeeVoter(cb, attProp.getValue(), pars);
        att.setPartstat(IcalUtil.getOptStr(pars, "PARTSTAT"));
        if (att.getPartstat() == null) {
            att.setPartstat("NEEDS-ACTION");
        }
        att.setRole(IcalUtil.getOptStr(pars, "ROLE"));
        return att;
    }

    public static BwAttendee getVoter(IcalCallback cb, Voter vProp) throws Throwable {
        ParameterList pars = vProp.getParameters();
        BwAttendee att = IcalUtil.initAttendeeVoter(cb, vProp.getValue(), pars);
        att.setType(1);
        Parameter par = pars.getParameter("STAY-INFORMED");
        if (par != null) {
            att.setStayInformed(((StayInformed)par).getStayInformed().booleanValue());
        }
        return att;
    }

    public static BwAttendee initAttendeeVoter(IcalCallback cb, String val, ParameterList pars) throws Throwable {
        BwAttendee att = new BwAttendee();
        att.setAttendeeUri(cb.getCaladdr(val));
        att.setCn(IcalUtil.getOptStr(pars, "CN"));
        att.setCuType(IcalUtil.getOptStr(pars, "CUTYPE"));
        att.setDelegatedFrom(IcalUtil.getOptStr(pars, "DELEGATED-FROM"));
        att.setDelegatedTo(IcalUtil.getOptStr(pars, "DELEGATED-TO"));
        att.setDir(IcalUtil.getOptStr(pars, "DIR"));
        att.setLanguage(IcalUtil.getOptStr(pars, "LANGUAGE"));
        att.setMember(IcalUtil.getOptStr(pars, "MEMBER"));
        att.setScheduleStatus(IcalUtil.getOptStr(pars, "SCHEDULE-STATUS"));
        att.setSentBy(IcalUtil.getOptStr(pars, "SENT-BY"));
        Parameter par = pars.getParameter("RSVP");
        if (par != null) {
            att.setRsvp(((Rsvp)par).getRsvp().booleanValue());
        }
        return att;
    }

    public static BwAlarm.TriggerVal getTrigger(PropertyList pl, boolean absentOk) throws Throwable {
        Trigger prop = (Trigger)pl.getProperty("TRIGGER");
        BwAlarm.TriggerVal tr = new BwAlarm.TriggerVal();
        if (prop == null) {
            if (!absentOk) {
                throw new IcalMalformedException("Invalid alarm - no trigger");
            }
            return tr;
        }
        tr.trigger = prop.getValue();
        if (prop.getDateTime() != null) {
            tr.triggerDateTime = true;
            return tr;
        }
        ParameterList pars = prop.getParameters();
        if (pars == null) {
            tr.triggerStart = true;
            return tr;
        }
        Parameter par = pars.getParameter("RELATED");
        if (par == null) {
            tr.triggerStart = true;
            return tr;
        }
        tr.triggerStart = "START".equals(par.getValue());
        return tr;
    }

    public static DurationRepeat getDurationRepeat(PropertyList pl) throws Throwable {
        DurationRepeat dr = new DurationRepeat();
        Property prop = pl.getProperty("DURATION");
        if (prop == null) {
            return dr;
        }
        dr.duration = prop.getValue();
        prop = pl.getProperty("REPEAT");
        if (prop == null) {
            throw new IcalMalformedException("Invalid alarm - no repeat");
        }
        dr.repeat = ((Repeat)prop).getCount();
        return dr;
    }

    public static Collection<BwDateTime> makeDateTimes(DateListProperty val) throws Throwable {
        DateList dl = val.getDates();
        TreeSet<BwDateTime> ts = new TreeSet<BwDateTime>();
        Parameter par = IcalUtil.getParameter((Property)val, "VALUE");
        boolean isDateType = par != null && par.equals((Object)Value.DATE);
        String tzidval = null;
        Parameter tzid = IcalUtil.getParameter((Property)val, "TZID");
        if (tzid != null) {
            tzidval = tzid.getValue();
        }
        for (Date dt : dl) {
            ts.add(BwDateTime.makeBwDateTime((boolean)isDateType, (String)dt.toString(), (String)tzidval));
        }
        return ts;
    }

    public static void addComponent(Calendar cal, Component comp) {
        cal.getComponents().add((Object)((CalendarComponent)comp));
    }

    public static void addProperty(Component comp, Property val) {
        PropertyList props = comp.getProperties();
        props.add((Object)val);
    }

    public static void addParameter(Property prop, Parameter val) {
        ParameterList parl = prop.getParameters();
        parl.add(val);
    }

    public static Parameter getParameter(Property prop, String name) {
        ParameterList parl = prop.getParameters();
        if (parl == null) {
            return null;
        }
        return parl.getParameter(name);
    }

    public static String getParameterVal(Property prop, String name) {
        ParameterList parl = prop.getParameters();
        if (parl == null) {
            return null;
        }
        Parameter par = parl.getParameter(name);
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static Property getProperty(Component comp, String name) {
        PropertyList props = comp.getProperties();
        return props.getProperty(name);
    }

    public static PropertyList getProperties(Component comp, String name) {
        PropertyList props = comp.getProperties();
        if ((props = props.getProperties(name)) != null && props.size() == 0) {
            return null;
        }
        return props;
    }

    public static Iterator<?> getReqStrs(PropertyList pl, String name) throws Throwable {
        PropertyList props = pl.getProperties(name);
        if (props == null || props.isEmpty()) {
            throw new IcalMalformedException("Missing required property " + name);
        }
        return props.iterator();
    }

    public static String getReqStr(PropertyList pl, String name) throws Throwable {
        Property prop = pl.getProperty(name);
        if (prop == null) {
            throw new IcalMalformedException("Missing required property " + name);
        }
        return prop.getValue();
    }

    public static String getOptStr(PropertyList pl, String name) throws Throwable {
        Property prop = pl.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public static String getPropertyVal(Component comp, String name) {
        Property prop = IcalUtil.getProperty(comp, name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public static String getOptStr(ParameterList pl, String name) throws Throwable {
        Parameter par = pl.getParameter(name);
        if (par == null) {
            return null;
        }
        return par.getValue();
    }

    public static AltRep getAltRep(Property prop) {
        return (AltRep)prop.getParameters().getParameter("ALTREP");
    }

    public static DateTime makeDateTime(BwDateTime dt) throws Throwable {
        return new DateTime(dt.getDtval());
    }

    public static void setDates(String userHref, EventInfo ei, DtStart dtStart, DtEnd dtEnd, Duration duration) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        ChangeTable chg = ei.getChangeset(userHref);
        boolean scheduleReply = ev.getScheduleMethod() == 3;
        boolean todo = ev.getEntityType() == 2;
        boolean vpoll = ev.getEntityType() == 7;
        try {
            String durVal;
            Dur dur;
            if (dtStart == null) {
                if (!(scheduleReply || todo || vpoll)) {
                    throw new CalFacadeException("org.bedework.error.nostartdate");
                }
                if (dtEnd != null) {
                    dtStart = new DtStart(dtEnd.getParameters(), dtEnd.getValue());
                } else {
                    Date now = new Date(new java.util.Date().getTime());
                    dtStart = new DtStart(now);
                    dtStart.getParameters().add((Parameter)Value.DATE);
                }
                ev.setNoStart(Boolean.valueOf(true));
            } else {
                ev.setNoStart(Boolean.valueOf(false));
            }
            if (dtStart != null) {
                BwDateTime bwDtStart = BwDateTime.makeBwDateTime((DateProperty)dtStart);
                if (!CalFacadeUtil.eqObjval((Object)ev.getDtstart(), (Object)bwDtStart)) {
                    chg.changed(PropertyIndex.PropertyInfoIndex.DTSTART, (Object)ev.getDtstart(), (Object)bwDtStart);
                    ev.setDtstart(bwDtStart);
                }
            }
            char endType = 'N';
            if (dtEnd != null) {
                endType = 'E';
            } else if (scheduleReply || todo || vpoll) {
                Dur years = new Dur(520);
                Date now = new Date(new java.util.Date().getTime());
                dtEnd = new DtEnd(new Date(years.getTime((java.util.Date)now)));
                dtEnd.getParameters().add((Parameter)Value.DATE);
            }
            if (dtEnd != null) {
                BwDateTime bwDtEnd = BwDateTime.makeBwDateTime((DateProperty)dtEnd);
                if (!CalFacadeUtil.eqObjval((Object)ev.getDtend(), (Object)bwDtEnd)) {
                    chg.changed(PropertyIndex.PropertyInfoIndex.DTEND, (Object)ev.getDtend(), (Object)bwDtEnd);
                    ev.setDtend(bwDtEnd);
                }
            }
            if (duration != null) {
                if (endType != 'N' && ev.getEntityType() != 4) {
                    throw new CalFacadeException("org.bedework.exception.ical.endandduration");
                }
                endType = 'D';
                String durVal2 = duration.getValue();
                if (!durVal2.equals(ev.getDuration())) {
                    chg.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)ev.getDuration(), (Object)durVal2);
                    ev.setDuration(durVal2);
                }
                dur = duration.getDuration();
                ev.setDtend(BwDateTime.makeDateTime((DateProperty)dtStart, (boolean)ev.getDtstart().getDateType(), (Dur)dur));
            } else if (!scheduleReply && endType == 'N' && !todo) {
                boolean dateOnly = ev.getDtstart().getDateType();
                dur = dateOnly ? new Dur(1, 0, 0, 0) : new Dur(0, 0, 0, 0);
                BwDateTime bwDtEnd = BwDateTime.makeDateTime((DateProperty)dtStart, (boolean)dateOnly, (Dur)dur);
                if (!CalFacadeUtil.eqObjval((Object)ev.getDtend(), (Object)bwDtEnd)) {
                    chg.changed(PropertyIndex.PropertyInfoIndex.DTEND, (Object)ev.getDtend(), (Object)bwDtEnd);
                    ev.setDtend(bwDtEnd);
                }
            }
            if (endType != 'D' && ev.getDtstart() != null && ev.getDtend() != null && !(durVal = BwDateTime.makeDuration((BwDateTime)ev.getDtstart(), (BwDateTime)ev.getDtend()).toString()).equals(ev.getDuration())) {
                chg.changed(PropertyIndex.PropertyInfoIndex.DURATION, (Object)ev.getDuration(), (Object)durVal);
                ev.setDuration(durVal);
            }
            ev.setEndType(endType);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    static class DurationRepeat {
        String duration;
        int repeat;

        DurationRepeat() {
        }
    }
}

