/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.timezones.Timezones;

public class Icalendar
implements TimeZoneRegistry,
ScheduleMethods,
Serializable {
    private String prodid;
    private String version;
    private String calscale;
    private String method;
    private HashMap<String, TimeZone> localTzs;
    private Collection<TimeZoneInfo> timeZones;
    private Collection<Object> components;
    private IcalDefs.IcalComponentType componentType = IcalDefs.IcalComponentType.none;

    public void setProdid(String val) {
        this.prodid = val;
    }

    public String getProdid() {
        return this.prodid;
    }

    public void setVersion(String val) {
        this.version = val;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCalscale(String val) {
        this.calscale = val;
    }

    public String getCalscale() {
        return this.calscale;
    }

    public void setMethod(String val) {
        this.method = val;
    }

    public String getMethod() {
        return this.method;
    }

    public Collection<TimeZoneInfo> getTimeZones() {
        if (this.timeZones == null) {
            this.timeZones = new ArrayList<TimeZoneInfo>();
        }
        return this.timeZones;
    }

    public void addTimeZone(TimeZoneInfo tzi) {
        this.getTimeZones().add(tzi);
    }

    public void setComponents(Collection<Object> val) {
        this.components = val;
    }

    public Collection<Object> getComponents() {
        if (this.components == null) {
            this.components = new ArrayList<Object>();
        }
        return this.components;
    }

    public void setComponentType(IcalDefs.IcalComponentType val) {
        this.componentType = this.componentType == IcalDefs.IcalComponentType.none || this.componentType == val ? val : IcalDefs.IcalComponentType.mixed;
    }

    public IcalDefs.IcalComponentType getComponentType() {
        return this.componentType;
    }

    public void setMethodType(int val) {
        if (val == 0) {
            this.setMethod(null);
            return;
        }
        this.setMethod(Icalendar.getMethodName(val));
    }

    public int getMethodType() {
        return Icalendar.getMethodType(this.method);
    }

    public static int getMethodType(String val) {
        if (val == null) {
            return 0;
        }
        for (int i = 1; i < methods.length; ++i) {
            if (!methods[i].equals(val)) continue;
            return i;
        }
        return 99;
    }

    public static String getMethodName(int mt) {
        if (mt < methods.length) {
            return methods[mt];
        }
        return "UNKNOWN";
    }

    public BwOrganizer getOrganizer() {
        Object o;
        if (this.size() != 1) {
            return null;
        }
        if (this.getComponentType() == IcalDefs.IcalComponentType.event) {
            EventInfo ei = (EventInfo)this.iterator().next();
            return ei.getEvent().getOrganizer();
        }
        if (this.getComponentType() == IcalDefs.IcalComponentType.freebusy && (o = this.iterator().next()) instanceof EventInfo) {
            EventInfo ei = (EventInfo)o;
            return ei.getEvent().getOrganizer();
        }
        return null;
    }

    public EventInfo getEventInfo() {
        return (EventInfo)this.iterator().next();
    }

    public void addComponent(Object val) {
        if (val instanceof EventInfo) {
            BwEvent ev = ((EventInfo)val).getEvent();
            if (ev.getEntityType() == 0) {
                this.setComponentType(IcalDefs.IcalComponentType.event);
            } else if (ev.getEntityType() == 2) {
                this.setComponentType(IcalDefs.IcalComponentType.todo);
            } else if (ev.getEntityType() == 3) {
                this.setComponentType(IcalDefs.IcalComponentType.journal);
            } else if (ev.getEntityType() == 4) {
                this.setComponentType(IcalDefs.IcalComponentType.freebusy);
            } else if (ev.getEntityType() == 5) {
                this.setComponentType(IcalDefs.IcalComponentType.vavailability);
            } else if (ev.getEntityType() == 6) {
                this.setComponentType(IcalDefs.IcalComponentType.available);
            } else if (ev.getEntityType() == 7) {
                this.setComponentType(IcalDefs.IcalComponentType.vpoll);
            } else {
                throw new RuntimeException("org.bedework.bad.entitytype");
            }
        }
        this.getComponents().add(val);
    }

    public Iterator iterator() {
        return this.components.iterator();
    }

    public int size() {
        if (this.components == null) {
            return 0;
        }
        return this.components.size();
    }

    public boolean validItipMethodType() {
        return Icalendar.validItipMethodType(this.getMethodType());
    }

    public boolean requestMethodType() {
        return Icalendar.itipRequestMethodType(this.getMethodType());
    }

    public boolean replyMethodType() {
        return Icalendar.itipReplyMethodType(this.getMethodType());
    }

    public static boolean itipRequestMethodType(int mt) {
        return mt == 4 || mt == 5 || mt == 8 || mt == 1 || mt == 9 || mt == 2;
    }

    public static boolean itipReplyMethodType(int mt) {
        return mt == 7 || mt == 6 || mt == 3;
    }

    public static boolean validItipMethodType(int val) {
        if (val == 0) {
            return false;
        }
        if (val == 99) {
            return false;
        }
        return val < methods.length;
    }

    public static boolean validItipMethodType(int val, IcalDefs.IcalComponentType type) {
        if (val == 0) {
            return false;
        }
        if (val >= methods.length) {
            return false;
        }
        if (type == IcalDefs.IcalComponentType.todo || type == IcalDefs.IcalComponentType.event) {
            return val != 9;
        }
        if (type == IcalDefs.IcalComponentType.vpoll) {
            return true;
        }
        if (type == IcalDefs.IcalComponentType.freebusy) {
            return val == 1 || val == 2 || val == 3;
        }
        return true;
    }

    public static int findMethodType(String val) {
        if (val == null) {
            return 0;
        }
        for (int i = 1; i < methods.length; ++i) {
            if (!methods[i].equals(val)) continue;
            return i;
        }
        return 99;
    }

    public void register(TimeZone timezone) {
        try {
            TimeZone tz = Timezones.getTz((String)timezone.getID());
            if (tz != null) {
                return;
            }
            if (this.localTzs == null) {
                this.localTzs = new HashMap();
            }
            this.localTzs.put(timezone.getID(), timezone);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void register(TimeZone timezone, boolean update) {
        this.register(timezone);
    }

    public void clear() {
        if (this.localTzs != null) {
            this.localTzs.clear();
        }
    }

    public TimeZone getTimeZone(String id) {
        try {
            TimeZone tz = Timezones.getTz((String)id);
            if (tz != null) {
                return tz;
            }
            if (this.localTzs == null) {
                return null;
            }
            return this.localTzs.get(id);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Icalendar{prodid=");
        sb.append(this.getProdid());
        sb.append(", version=");
        sb.append(this.getVersion());
        sb.append("\n, method=");
        sb.append(String.valueOf(this.getMethod()));
        sb.append(", methodType=");
        sb.append(this.getMethodType());
        sb.append(", componentType=");
        sb.append(this.getComponentType());
        sb.append("}");
        return sb.toString();
    }

    public static class TimeZoneInfo {
        public String tzid;
        public TimeZone tz;
        public String tzSpec;

        public TimeZoneInfo(String tzid, TimeZone tz, String tzSpec) {
            this.tzid = tzid;
            this.tz = tz;
            this.tzSpec = tzSpec;
        }
    }
}

