/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.component.VVoter;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.EventTimeZonesRegistry;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.JsonProperty;
import org.bedework.icalendar.VEventUtil;
import org.bedework.icalendar.VFreeUtil;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.logging.BwLogger;

public class JcalHandler
implements Serializable {
    private static BwLogger logger = new BwLogger().setLoggedClass(JcalHandler.class);
    private static final JsonFactory jsonFactory = new JsonFactory();

    public static String toJcal(Collection<EventInfo> vals, int methodType, IcalendarType pattern, String currentPrincipal, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        StringWriter sw = new StringWriter();
        JcalHandler.outJcal(sw, vals, methodType, pattern, currentPrincipal, tzreg);
        return sw.toString();
    }

    public static String toJcal(Calendar cal, IcalendarType pattern, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        StringWriter sw = new StringWriter();
        JcalHandler.outJcal(sw, cal, pattern, tzreg);
        return sw.toString();
    }

    public static void outJcal(Writer wtr, Calendar cal, IcalendarType pattern, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        try {
            JsonGenerator jgen = jsonFactory.createGenerator(wtr);
            if (logger.debug()) {
                jgen.useDefaultPrettyPrinter();
            }
            jgen.writeStartArray();
            jgen.writeString("vcalendar");
            jgen.writeStartArray();
            for (Object o : cal.getProperties()) {
                JsonProperty.addFields(jgen, (Property)o);
            }
            jgen.writeEndArray();
            jgen.writeStartArray();
            for (Object o : cal.getComponents()) {
                Component comp = (Component)o;
                JcalHandler.outComp(jgen, comp);
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
            jgen.flush();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void outJcal(Writer wtr, Collection<EventInfo> vals, int methodType, IcalendarType pattern, String currentPrincipal, EventTimeZonesRegistry tzreg) throws CalFacadeException {
        try {
            JsonGenerator jgen = jsonFactory.createJsonGenerator(wtr);
            if (logger.debug()) {
                jgen.useDefaultPrettyPrinter();
            }
            jgen.writeStartArray();
            JcalHandler.calendarProps(jgen, methodType);
            jgen.writeStartArray();
            for (EventInfo ei : vals) {
                BwEvent ev = ei.getEvent();
                Object comp = ev.getEntityType() == 4 ? VFreeUtil.toVFreeBusy(ev) : VEventUtil.toIcalComponent(ei, false, tzreg, currentPrincipal);
                JcalHandler.outComp(jgen, (Component)comp);
                if (ei.getNumOverrides() <= 0) continue;
                for (EventInfo oei : ei.getOverrides()) {
                    ev = oei.getEvent();
                    JcalHandler.outComp(jgen, VEventUtil.toIcalComponent(oei, true, tzreg, currentPrincipal));
                }
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
            jgen.flush();
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void outComp(JsonGenerator jgen, Component comp) throws CalFacadeException {
        try {
            jgen.writeStartArray();
            jgen.writeString(comp.getName().toLowerCase());
            jgen.writeStartArray();
            for (Object o : comp.getProperties()) {
                JsonProperty.addFields(jgen, (Property)o);
            }
            jgen.writeEndArray();
            jgen.writeStartArray();
            ComponentList cl = null;
            if (comp instanceof VEvent) {
                cl = ((VEvent)comp).getAlarms();
            } else if (comp instanceof VToDo) {
                cl = ((VToDo)comp).getAlarms();
            } else if (comp instanceof VAvailability) {
                cl = ((VAvailability)comp).getAvailable();
            } else if (comp instanceof VPoll) {
                cl = ((VPoll)comp).getVoters();
            } else if (comp instanceof VVoter) {
                cl = ((VVoter)comp).getVotes();
            }
            if (cl != null) {
                for (Object o : cl) {
                    JcalHandler.outComp(jgen, (Component)o);
                }
                if (comp instanceof VPoll) {
                    for (Object o : ((VPoll)comp).getCandidates()) {
                        JcalHandler.outComp(jgen, (Component)o);
                    }
                }
            }
            jgen.writeEndArray();
            jgen.writeEndArray();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void calendarProps(JsonGenerator jgen, int methodType) throws CalFacadeException {
        try {
            jgen.writeString("vcalendar");
            jgen.writeStartArray();
            JsonProperty.addFields(jgen, (Property)new ProdId(IcalTranslator.prodId));
            JsonProperty.addFields(jgen, (Property)Version.VERSION_2_0);
            if (methodType > 0 && methodType < 99) {
                JsonProperty.addFields(jgen, (Property)new Method(ScheduleMethods.methods[methodType]));
            }
            jgen.writeEndArray();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    static {
        jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jsonFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

