/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fortuna.ical4j.model.AddressList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Member;
import org.bedework.calfacade.exc.CalFacadeException;

public class JsonParameters
implements Serializable {
    private static Map<String, String> multiMap = new HashMap<String, String>();

    public static void addFields(JsonGenerator jgen, Property prop) throws CalFacadeException {
        try {
            jgen.writeStartObject();
            ParameterList pl = prop.getParameters();
            if (pl != null && pl.size() > 0) {
                for (Parameter p : pl) {
                    String nm = p.getName().toLowerCase();
                    jgen.writeFieldName(nm);
                    if (multiMap.get(nm) == null) {
                        jgen.writeString(p.getValue());
                        continue;
                    }
                    JsonParameters.outValue(jgen, p);
                }
            }
            jgen.writeEndObject();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void outValue(JsonGenerator jgen, Parameter par) throws Throwable {
        if (par instanceof DelegatedFrom) {
            DelegatedFrom d = (DelegatedFrom)par;
            JsonParameters.outAddrs(jgen, d.getDelegators());
            return;
        }
        if (par instanceof DelegatedTo) {
            DelegatedTo d = (DelegatedTo)par;
            JsonParameters.outAddrs(jgen, d.getDelegatees());
            return;
        }
        if (par instanceof Member) {
            Member m = (Member)par;
            JsonParameters.outAddrs(jgen, m.getGroups());
            return;
        }
    }

    private static void outAddrs(JsonGenerator jgen, AddressList al) throws Throwable {
        if (al.size() == 1) {
            jgen.writeString(((URI)al.iterator().next()).toString());
            return;
        }
        jgen.writeStartArray();
        Iterator it = al.iterator();
        while (it.hasNext()) {
            jgen.writeString(it.next().toString());
        }
        jgen.writeEndArray();
    }

    static {
        multiMap.put("delegated-from", "");
        multiMap.put("delegated-to", "");
        multiMap.put("member", "");
    }
}

