/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwRecurrenceInstance;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.VEventUtil;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.misc.Util;

public class RecurUtil {
    private static BwLogger logger = new BwLogger().setLoggedClass(RecurUtil.class);

    public static RecurRange getRange(BwEvent ev, int maxYears) throws CalFacadeException {
        Date dt;
        BwDateTime pend;
        PropertyList evprops = new PropertyList();
        VEventUtil.doRecurring(ev, evprops);
        RecurRange rr = new RecurRange();
        DtStart start = ev.getDtstart().makeDtStart();
        DtEnd end = ev.getDtend().makeDtEnd();
        Duration duration = new Duration(null, ev.getDuration());
        rr.rangeStart = start.getDate();
        for (Object o : evprops) {
            if (!(o instanceof RDate)) continue;
            RDate rd = (RDate)o;
            for (Object o1 : rd.getDates()) {
                Date d = (Date)o1;
                if (!d.before((java.util.Date)rr.rangeStart)) continue;
                rr.rangeStart = d;
            }
        }
        Dur dur = new Dur(maxYears * 365, 0, 0, 0);
        Date maxRangeEnd = new Date(dur.getTime((java.util.Date)rr.rangeStart));
        if (ev.getParent() != null && (pend = ev.getParent().getDtend()) != null && (dt = pend.makeDate()).before((java.util.Date)maxRangeEnd)) {
            maxRangeEnd = dt;
        }
        rr.rangeEnd = RecurUtil.getLatestRecurrenceDate(evprops, start, end, duration, maxRangeEnd);
        if (rr.rangeEnd == null || rr.rangeEnd.after((java.util.Date)maxRangeEnd)) {
            rr.rangeEnd = maxRangeEnd;
        }
        return rr;
    }

    public static RecurPeriods getPeriods(BwEvent ev, int maxYears, int maxInstances) throws CalFacadeException {
        return RecurUtil.getPeriods(ev, maxYears, maxInstances, null, null);
    }

    public static RecurPeriods getPeriods(BwEvent ev, int maxYears, int maxInstances, String startRange, String endRange) throws CalFacadeException {
        Date dt;
        BwDateTime pend;
        PropertyList evprops = new PropertyList();
        VEventUtil.doRecurring(ev, evprops);
        RecurPeriods rp = new RecurPeriods();
        DtStart start = ev.getDtstart().makeDtStart();
        if (startRange != null) {
            try {
                rp.rangeStart = new DateTime(startRange);
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        } else {
            rp.rangeStart = start.getDate();
            for (Object o : evprops) {
                if (!(o instanceof RDate)) continue;
                RDate rd = (RDate)o;
                for (Object o1 : rd.getDates()) {
                    Date d = (Date)o1;
                    if (!d.before((java.util.Date)rp.rangeStart)) continue;
                    rp.rangeStart = d;
                }
            }
        }
        Dur dur = new Dur(maxYears * 365, 0, 0, 0);
        Date maxRangeEnd = new Date(dur.getTime((java.util.Date)rp.rangeStart));
        if (ev.getParent() != null && (pend = ev.getParent().getDtend()) != null && (dt = pend.makeDate()).before((java.util.Date)maxRangeEnd)) {
            maxRangeEnd = dt;
        }
        DtEnd end = ev.getDtend().makeDtEnd();
        if (endRange != null) {
            try {
                rp.rangeEnd = new DateTime(endRange);
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        } else {
            Duration duration = new Duration(null, ev.getDuration());
            rp.rangeEnd = RecurUtil.getLatestRecurrenceDate(evprops, start, end, duration, maxRangeEnd);
            if (rp.rangeEnd == null || rp.rangeEnd.after((java.util.Date)maxRangeEnd)) {
                rp.rangeEnd = maxRangeEnd;
            }
        }
        Period rangePeriod = new Period(new DateTime((java.util.Date)rp.rangeStart), new DateTime((java.util.Date)rp.rangeEnd));
        VEvent vev = new VEvent();
        PropertyList vevprops = vev.getProperties();
        vevprops.addAll((Collection)evprops);
        if (!ev.getSuppressed()) {
            vevprops.add((Object)start);
            vevprops.add((Object)end);
        } else {
            Dur evdur = new Dur(ev.getDuration());
            Dur setback = evdur.add(new Dur(1, 0, 0, 0));
            boolean dateOnly = ev.getDtstart().getDateType();
            Object adjustedEnd = dateOnly ? new Date((java.util.Date)rp.rangeStart) : new DateTime((java.util.Date)rp.rangeStart);
            adjustedEnd.setTime(setback.negate().getTime((java.util.Date)rp.rangeStart).getTime());
            vevprops.add((Object)new DtEnd(adjustedEnd));
            Object adjustedStart = dateOnly ? new Date((java.util.Date)adjustedEnd) : new DateTime((java.util.Date)adjustedEnd);
            adjustedStart.setTime(evdur.negate().getTime((java.util.Date)adjustedEnd).getTime());
            vevprops.add((Object)new DtStart(adjustedStart));
        }
        PeriodList pl = vev.calculateRecurrenceSet(rangePeriod);
        if (pl.size() <= maxInstances) {
            rp.instances = pl;
        } else {
            rp.instances = new TreeSet<Period>();
            for (Object o : pl) {
                rp.instances.add((Period)o);
                if (rp.instances.size() != maxInstances) continue;
                break;
            }
        }
        return rp;
    }

    public static BwRecurrenceInstance fromRecurrencId(BwEvent master, String recurrenceId) throws CalFacadeException {
        String stzid = master.getDtstart().getTzid();
        boolean dateOnly = master.getDtstart().getDateType();
        BwDateTime rstart = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)recurrenceId, (String)stzid);
        BwDateTime rend = rstart.addDuration(BwDuration.makeDuration((String)master.getDuration()));
        BwRecurrenceInstance ri = new BwRecurrenceInstance();
        ri.setDtstart(rstart);
        ri.setDtend(rend);
        ri.setRecurrenceId(ri.getDtstart().getDate());
        ri.setMaster(master);
        return ri;
    }

    public static Collection<Recurrence> getRecurrences(EventInfo ei, int maxYears, int maxInstances, String fromDate, String toDate) throws CalFacadeException {
        try {
            BwEvent ev = ei.getEvent();
            RecurPeriods rp = RecurUtil.getPeriods(ev, maxYears, maxInstances);
            if (rp.instances.isEmpty()) {
                return null;
            }
            ArrayList<Recurrence> recurrences = new ArrayList<Recurrence>();
            String stzid = ev.getDtstart().getTzid();
            int instanceCt = maxInstances;
            boolean dateOnly = ev.getDtstart().getDateType();
            HashMap<String, BwEvent> overrides = new HashMap<String, BwEvent>();
            if (!Util.isEmpty((Collection)ei.getOverrideProxies())) {
                for (BwEvent ov : ei.getOverrideProxies()) {
                    overrides.put(ov.getRecurrenceId(), ov);
                }
            }
            for (Period p : rp.instances) {
                String dtval = p.getStart().toString();
                if (dateOnly) {
                    dtval = dtval.substring(0, 8);
                }
                BwDateTime rstart = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)dtval, (String)stzid);
                String rid = rstart.getDate();
                BwDateTime rend = null;
                BwEvent override = (BwEvent)overrides.get(rid);
                if (override != null) {
                    rstart = override.getDtstart();
                    rend = override.getDtend();
                } else {
                    dtval = p.getEnd().toString();
                    if (dateOnly) {
                        dtval = dtval.substring(0, 8);
                    }
                    rend = BwDateTime.makeBwDateTime((boolean)dateOnly, (String)dtval, (String)stzid);
                }
                if (!RecurUtil.inDateTimeRange(fromDate, toDate, rstart.getDate(), rend.getDate())) continue;
                recurrences.add(new Recurrence(rstart, rend, rid, override));
                if (--instanceCt != 0) continue;
                break;
            }
            return recurrences;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static boolean inDateTimeRange(String rangeStart, String rangeEnd, String periodStart, String periodEnd) {
        int evstSt = rangeEnd == null ? -1 : periodStart.compareTo(rangeEnd);
        if (evstSt >= 0) {
            return false;
        }
        int evendSt = rangeStart == null ? 1 : periodEnd.compareTo(rangeStart);
        return evendSt > 0 || periodStart.equals(periodEnd) && evendSt >= 0;
    }

    private static Date getLatestRecurrenceDate(PropertyList evprops, DtStart vstart, DtEnd enddt, Duration d, Date maxRangeEnd) throws CalFacadeException {
        try {
            Dur dur;
            Date start = vstart.getDate();
            DateTime until = null;
            if (d != null) {
                dur = d.getDuration();
            } else {
                Date evend = enddt == null ? start : enddt.getDate();
                dur = new Dur((java.util.Date)start, (java.util.Date)evend);
            }
            dur = dur.getWeeks() != 0 ? new Dur(dur.getWeeks() + 1) : new Dur(dur.getDays() + 1, dur.getHours(), dur.getMinutes(), dur.getSeconds());
            PropertyList rrules = evprops.getProperties("RRULE");
            PropertyList rdts = evprops.getProperties("RDATE");
            if (rrules == null && rdts == null) {
                return null;
            }
            if (rrules != null) {
                for (RRule r : rrules) {
                    Date nextUntil = RecurUtil.getLastDate(r.getRecur(), start, maxRangeEnd);
                    if (nextUntil == null) {
                        return null;
                    }
                    if (logger.debug()) {
                        logger.debug("Last date for recur=" + nextUntil);
                    }
                    if (until != null && !nextUntil.after((java.util.Date)until)) continue;
                    until = nextUntil;
                }
                if (until == null) {
                    return null;
                }
            }
            if (rdts != null) {
                for (RRule r : rdts) {
                    if (Value.PERIOD.equals((Object)r.getParameter("VALUE"))) {
                        PeriodList pl = r.getPeriods();
                        for (Period p : pl) {
                            DateTime nextUntil = p.getEnd();
                            if (nextUntil == null) {
                                nextUntil = p.getStart();
                            }
                            if (until != null && !nextUntil.after((java.util.Date)until)) continue;
                            until = nextUntil;
                        }
                        continue;
                    }
                    DateList startDates = r.getDates();
                    for (int j = 0; j < startDates.size(); ++j) {
                        Date startDate = startDates.get(j);
                        Date endDate = new Date(dur.getTime((java.util.Date)startDate));
                        if (until != null && !endDate.after((java.util.Date)until)) continue;
                        until = endDate;
                    }
                }
            }
            if (logger.debug()) {
                logger.debug("Last date before fix=" + until);
            }
            if (until instanceof DateTime) {
                until = new DateTime(dur.getTime(until));
                until.setUtc(true);
            } else {
                until = new Date(dur.getTime(until));
            }
            if (logger.debug()) {
                logger.debug("Last date after fix=" + until);
            }
            return until;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static Date getLastDate(Recur r, Date start, Date maxRangeEnd) {
        Date seed = start;
        Date until = r.getUntil();
        if (until != null) {
            return until;
        }
        int count = r.getCount();
        if (count < 1) {
            return null;
        }
        Dur days100 = new Dur(100, 0, 0, 0);
        int counted = 0;
        while (counted < count && start.before((java.util.Date)maxRangeEnd)) {
            DateTime end = new DateTime(days100.getTime((java.util.Date)start));
            DateList dl = r.getDates(seed, start, (Date)end, Value.DATE_TIME);
            int sz = dl.size();
            counted += sz;
            if (sz != 0) {
                until = dl.get(sz - 1);
            }
            start = end;
        }
        return until;
    }

    public static class Recurrence {
        public BwDateTime start;
        public BwDateTime end;
        public String recurrenceId;
        public BwEvent override;

        public Recurrence(BwDateTime start, BwDateTime end, String recurrenceId, BwEvent override) {
            this.start = start;
            this.end = end;
            this.recurrenceId = recurrenceId;
            this.override = override;
        }
    }

    public static class RecurPeriods {
        public Collection<Period> instances;
        public Date rangeStart;
        public Date rangeEnd;
    }

    public static class RecurRange {
        public Date rangeStart;
        public Date rangeEnd;
    }
}

