/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import ietf.params.xml.ns.icalendar_2.ArrayOfComponents;
import ietf.params.xml.ns.icalendar_2.ArrayOfParameters;
import ietf.params.xml.ns.icalendar_2.ArrayOfProperties;
import ietf.params.xml.ns.icalendar_2.AttachPropType;
import ietf.params.xml.ns.icalendar_2.AttendeePropType;
import ietf.params.xml.ns.icalendar_2.BaseComponentType;
import ietf.params.xml.ns.icalendar_2.BasePropertyType;
import ietf.params.xml.ns.icalendar_2.CategoriesPropType;
import ietf.params.xml.ns.icalendar_2.ClassPropType;
import ietf.params.xml.ns.icalendar_2.CnParamType;
import ietf.params.xml.ns.icalendar_2.CommentPropType;
import ietf.params.xml.ns.icalendar_2.CompletedPropType;
import ietf.params.xml.ns.icalendar_2.ContactPropType;
import ietf.params.xml.ns.icalendar_2.CreatedPropType;
import ietf.params.xml.ns.icalendar_2.CutypeParamType;
import ietf.params.xml.ns.icalendar_2.DateDatetimePropertyType;
import ietf.params.xml.ns.icalendar_2.DelegatedFromParamType;
import ietf.params.xml.ns.icalendar_2.DelegatedToParamType;
import ietf.params.xml.ns.icalendar_2.DescriptionPropType;
import ietf.params.xml.ns.icalendar_2.DirParamType;
import ietf.params.xml.ns.icalendar_2.DtendPropType;
import ietf.params.xml.ns.icalendar_2.DtstampPropType;
import ietf.params.xml.ns.icalendar_2.DtstartPropType;
import ietf.params.xml.ns.icalendar_2.DuePropType;
import ietf.params.xml.ns.icalendar_2.DurationPropType;
import ietf.params.xml.ns.icalendar_2.FbtypeParamType;
import ietf.params.xml.ns.icalendar_2.FreebusyPropType;
import ietf.params.xml.ns.icalendar_2.FreqRecurType;
import ietf.params.xml.ns.icalendar_2.GeoPropType;
import ietf.params.xml.ns.icalendar_2.LanguageParamType;
import ietf.params.xml.ns.icalendar_2.LastModifiedPropType;
import ietf.params.xml.ns.icalendar_2.LocationPropType;
import ietf.params.xml.ns.icalendar_2.MemberParamType;
import ietf.params.xml.ns.icalendar_2.OrganizerPropType;
import ietf.params.xml.ns.icalendar_2.PartstatParamType;
import ietf.params.xml.ns.icalendar_2.PercentCompletePropType;
import ietf.params.xml.ns.icalendar_2.PeriodType;
import ietf.params.xml.ns.icalendar_2.PriorityPropType;
import ietf.params.xml.ns.icalendar_2.RecurType;
import ietf.params.xml.ns.icalendar_2.RecurrenceIdPropType;
import ietf.params.xml.ns.icalendar_2.RelatedToPropType;
import ietf.params.xml.ns.icalendar_2.ReltypeParamType;
import ietf.params.xml.ns.icalendar_2.ResourcesPropType;
import ietf.params.xml.ns.icalendar_2.RoleParamType;
import ietf.params.xml.ns.icalendar_2.RrulePropType;
import ietf.params.xml.ns.icalendar_2.RsvpParamType;
import ietf.params.xml.ns.icalendar_2.ScheduleStatusParamType;
import ietf.params.xml.ns.icalendar_2.SentByParamType;
import ietf.params.xml.ns.icalendar_2.SequencePropType;
import ietf.params.xml.ns.icalendar_2.StatusPropType;
import ietf.params.xml.ns.icalendar_2.SummaryPropType;
import ietf.params.xml.ns.icalendar_2.TranspPropType;
import ietf.params.xml.ns.icalendar_2.UidPropType;
import ietf.params.xml.ns.icalendar_2.UntilRecurType;
import ietf.params.xml.ns.icalendar_2.UrlPropType;
import ietf.params.xml.ns.icalendar_2.ValarmType;
import ietf.params.xml.ns.icalendar_2.VeventType;
import ietf.params.xml.ns.icalendar_2.VfreebusyType;
import ietf.params.xml.ns.icalendar_2.VjournalType;
import ietf.params.xml.ns.icalendar_2.VtodoType;
import ietf.params.xml.ns.icalendar_2.XBedeworkCostPropType;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.property.RRule;
import org.bedework.access.EvaluatedAccessCache;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwGeo;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwLongString;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRelatedTo;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.base.BwStringBase;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.icalendar.Xalarms;
import org.bedework.icalendar.Xutil;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.logging.BwLogger;

public class ToXEvent
extends Xutil {
    private static BwLogger logger = new BwLogger().setLoggedClass(EvaluatedAccessCache.class);

    public static JAXBElement<? extends BaseComponentType> toComponent(BwEvent val, boolean isOverride, boolean wrapXprops, BaseComponentType pattern) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        boolean isInstance = false;
        try {
            StatusPropType s;
            String status;
            BwRelatedTo relto;
            Integer prio;
            PercentCompletePropType p;
            Integer pc;
            BwOrganizer org;
            BwLocation loc;
            BwGeo geo;
            List fbps;
            BwLongString bwstr;
            Object c;
            Object pval;
            CategoriesPropType c2;
            BwDateTime dts;
            Object strval;
            JAXBElement el;
            boolean freeBusy = false;
            boolean todo = false;
            int entityType = val.getEntityType();
            if (entityType == 0) {
                el = of.createVevent(new VeventType());
            } else if (entityType == 2) {
                el = of.createVtodo(new VtodoType());
                todo = true;
            } else if (entityType == 3) {
                el = of.createVjournal(new VjournalType());
            } else if (entityType == 4) {
                el = of.createVfreebusy(new VfreebusyType());
                freeBusy = true;
            } else {
                throw new CalFacadeException("org.bedework.invalid.entity.type", String.valueOf(entityType));
            }
            BaseComponentType comp = (BaseComponentType)el.getValue();
            Class<?> masterClass = comp.getClass();
            comp.setProperties(new ArrayOfProperties());
            List pl = comp.getProperties().getBasePropertyOrTzid();
            if (ToXEvent.emit(pattern, masterClass, RecurrenceIdPropType.class) && (strval = val.getRecurrenceId()) != null && ((String)strval).length() > 0) {
                isInstance = true;
                dts = val.getDtstart();
                RecurrenceIdPropType ri = new RecurrenceIdPropType();
                String tzid = null;
                if (dts.getDateType()) {
                    if (((String)strval).length() > 8) {
                        strval = ((String)strval).substring(0, 8);
                    }
                    ri.setDate(XcalUtil.fromDtval((String)strval));
                } else {
                    if (!val.getForceUTC() && dts != null && !dts.isUTC()) {
                        tzid = dts.getTzid();
                    }
                    XcalUtil.initDt((DateDatetimePropertyType)ri, (String)strval, tzid);
                }
                pl.add(of.createRecurrenceId(ri));
            }
            ToXEvent.processEventAlarm(val, comp, pattern, masterClass);
            if (ToXEvent.emit(pattern, masterClass, AttachPropType.class) && val.getNumAttachments() > 0) {
                strval = val.getAttachments().iterator();
                while (strval.hasNext()) {
                    dts = (BwAttachment)strval.next();
                }
            }
            if (ToXEvent.emit(pattern, masterClass, AttendeePropType.class) && val.getNumAttendees() > 0) {
                strval = val.getAttendees().iterator();
                while (strval.hasNext()) {
                    BwAttendee att = (BwAttendee)strval.next();
                    pl.add(of.createAttendee(ToXEvent.makeAttendee(att)));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, CategoriesPropType.class) && val.getNumCategories() > 0) {
                strval = val.getCategories().iterator();
                while (strval.hasNext()) {
                    BwCategory cat = (BwCategory)strval.next();
                    c2 = new CategoriesPropType();
                    c2.getText().add(cat.getWord().getValue());
                    pl.add(of.createCategories((CategoriesPropType)ToXEvent.langProp((BasePropertyType)c2, (BwStringBase)cat.getWord())));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, ClassPropType.class) && (pval = val.getClassification()) != null) {
                ClassPropType c3 = new ClassPropType();
                c3.setText((String)pval);
                pl.add(of.createClass(c3));
            }
            if (ToXEvent.emit(pattern, masterClass, CommentPropType.class) && val.getNumComments() > 0) {
                for (BwString str : val.getComments()) {
                    c2 = new CommentPropType();
                    c2.setText(str.getValue());
                    pl.add(of.createComment((CommentPropType)ToXEvent.langProp((BasePropertyType)c2, (BwStringBase)str)));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, CompletedPropType.class) && entityType == 2 && val.getCompleted() != null) {
                c = new CompletedPropType();
                c.setUtcDateTime(XcalUtil.getXMlUTCCal((String)val.getCompleted()));
                pl.add(of.createCompleted((CompletedPropType)c));
            }
            if (ToXEvent.emit(pattern, masterClass, ContactPropType.class) && val.getNumContacts() > 0) {
                for (BwContact ctct : val.getContacts()) {
                    c2 = new ContactPropType();
                    c2.setText(ctct.getCn().getValue());
                    pl.add(of.createContact((ContactPropType)ToXEvent.langProp(ToXEvent.uidProp(ToXEvent.altrepProp((BasePropertyType)c2, ctct.getLink()), ctct.getUid()), (BwStringBase)ctct.getCn())));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, CreatedPropType.class)) {
                CreatedPropType created = new CreatedPropType();
                created.setUtcDateTime(XcalUtil.getXMlUTCCal((String)val.getCreated()));
                pl.add(of.createCreated(created));
            }
            if (ToXEvent.emit(pattern, masterClass, DescriptionPropType.class) && (bwstr = val.findDescription(null)) != null) {
                DescriptionPropType desc = new DescriptionPropType();
                if (bwstr.getValue().contains("\u00c2")) {
                    logger.warn("Odd character \u00c2 in description: " + bwstr.getValue());
                }
                desc.setText(bwstr.getValue());
                pl.add(of.createDescription((DescriptionPropType)ToXEvent.langProp((BasePropertyType)desc, (BwStringBase)bwstr)));
            }
            if (todo && ToXEvent.emit(pattern, masterClass, DuePropType.class) || !todo && ToXEvent.emit(pattern, masterClass, DtendPropType.class)) {
                if (val.getEndType() == 'E') {
                    if (todo) {
                        DuePropType due = (DuePropType)ToXEvent.makeDateDatetime((DateDatetimePropertyType)new DuePropType(), val.getDtend(), freeBusy | val.getForceUTC());
                        pl.add(of.createDue(due));
                    } else {
                        DtendPropType dtend = (DtendPropType)ToXEvent.makeDateDatetime((DateDatetimePropertyType)new DtendPropType(), val.getDtend(), freeBusy | val.getForceUTC());
                        pl.add(of.createDtend(dtend));
                    }
                } else if (val.getEndType() == 'D') {
                    DurationPropType dur = new DurationPropType();
                    dur.setDuration(val.getDuration());
                    pl.add(of.createDuration(dur));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, DtstampPropType.class)) {
                DtstampPropType dtstamp = new DtstampPropType();
                dtstamp.setUtcDateTime(XcalUtil.getXMlUTCCal((String)val.getDtstamp()));
                pl.add(of.createDtstamp(dtstamp));
            }
            if (ToXEvent.emit(pattern, masterClass, DtstartPropType.class) && (val.getNoStart() == null || !val.getNoStart().booleanValue())) {
                DtstartPropType dtstart = (DtstartPropType)ToXEvent.makeDateDatetime((DateDatetimePropertyType)new DtstartPropType(), val.getDtstart(), freeBusy | val.getForceUTC());
                pl.add(of.createDtstart(dtstart));
            }
            if (ToXEvent.emit(pattern, masterClass, FreebusyPropType.class) && entityType == 4 && (fbps = val.getFreeBusyPeriods()) != null) {
                for (BwFreeBusyComponent fbc : fbps) {
                    FreebusyPropType fb = new FreebusyPropType();
                    ArrayOfParameters pars = ToXEvent.getAop((BasePropertyType)fb);
                    FbtypeParamType f = new FbtypeParamType();
                    f.setText(BwFreeBusyComponent.fbtypes[fbc.getType()]);
                    JAXBElement param = of.createFbtype(f);
                    pars.getBaseParameter().add(param);
                    List pdl = fb.getPeriod();
                    for (Period p2 : fbc.getPeriods()) {
                        PeriodType np = new PeriodType();
                        np.setStart(XcalUtil.getXMlUTCCal((String)p2.getStart().toString()));
                        np.setEnd(XcalUtil.getXMlUTCCal((String)p2.getEnd().toString()));
                        pdl.add(np);
                    }
                    pl.add(of.createFreebusy(fb));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, GeoPropType.class) && (geo = val.getGeo()) != null) {
                GeoPropType g = new GeoPropType();
                g.setLatitude(geo.getLatitude().floatValue());
                g.setLatitude(geo.getLongitude().floatValue());
                pl.add(of.createGeo(g));
            }
            if (ToXEvent.emit(pattern, masterClass, LastModifiedPropType.class)) {
                LastModifiedPropType lm = new LastModifiedPropType();
                lm.setUtcDateTime(XcalUtil.getXMlUTCCal((String)val.getLastmod()));
                pl.add(of.createLastModified(lm));
            }
            if (ToXEvent.emit(pattern, masterClass, LocationPropType.class) && (loc = val.getLocation()) != null) {
                LocationPropType l = new LocationPropType();
                l.setText(loc.getAddress().getValue());
                pl.add(of.createLocation((LocationPropType)ToXEvent.langProp(ToXEvent.uidProp((BasePropertyType)l, loc.getUid()), (BwStringBase)loc.getAddress())));
            }
            if (ToXEvent.emit(pattern, masterClass, OrganizerPropType.class) && (org = val.getOrganizer()) != null) {
                pl.add(of.createOrganizer(ToXEvent.makeOrganizer(org)));
            }
            if (ToXEvent.emit(pattern, masterClass, PercentCompletePropType.class) && (pc = val.getPercentComplete()) != null) {
                p = new PercentCompletePropType();
                p.setInteger(BigInteger.valueOf(pc.intValue()));
                pl.add(of.createPercentComplete(p));
            }
            if (ToXEvent.emit(pattern, masterClass, PriorityPropType.class) && (prio = val.getPriority()) != null) {
                p = new PriorityPropType();
                p.setInteger(BigInteger.valueOf(prio.intValue()));
                pl.add(of.createPriority((PriorityPropType)p));
            }
            if (ToXEvent.emit(pattern, masterClass, RelatedToPropType.class) && (relto = val.getRelatedTo()) != null) {
                RelatedToPropType rt = new RelatedToPropType();
                rt.setUid(relto.getValue());
                if (relto.getRelType() != null) {
                    ArrayOfParameters pars = ToXEvent.getAop((BasePropertyType)rt);
                    ReltypeParamType r = new ReltypeParamType();
                    r.setText(relto.getRelType());
                    JAXBElement param = of.createReltype(r);
                    pars.getBaseParameter().add(param);
                }
                pl.add(of.createRelatedTo(rt));
            }
            if (ToXEvent.emit(pattern, masterClass, ResourcesPropType.class) && val.getNumResources() > 0) {
                ResourcesPropType r = new ResourcesPropType();
                List rl = r.getText();
                for (BwString str : val.getResources()) {
                    rl.add(str.getValue());
                }
                pl.add(of.createResources(r));
            }
            if (ToXEvent.emit(pattern, masterClass, SequencePropType.class) && val.getSequence() > 0) {
                SequencePropType s2 = new SequencePropType();
                s2.setInteger(BigInteger.valueOf(val.getSequence()));
                pl.add(of.createSequence(s2));
            }
            if (ToXEvent.emit(pattern, masterClass, StatusPropType.class) && (status = val.getStatus()) != null && !status.equals("MASTER-SUPPRESSED")) {
                s = new StatusPropType();
                s.setText(status);
                pl.add(of.createStatus(s));
            }
            if (ToXEvent.emit(pattern, masterClass, SummaryPropType.class) && (bwstr = val.findSummary(null)) != null) {
                s = new SummaryPropType();
                s.setText(bwstr.getValue());
                s = (SummaryPropType)ToXEvent.langProp((BasePropertyType)s, (BwStringBase)bwstr);
                pl.add(of.createSummary((SummaryPropType)s));
            }
            if (ToXEvent.emit(pattern, masterClass, TranspPropType.class) && (strval = val.getTransparency()) != null && ((String)strval).length() > 0) {
                TranspPropType t = new TranspPropType();
                t.setText((String)strval);
                pl.add(of.createTransp(t));
            }
            if (ToXEvent.emit(pattern, masterClass, UidPropType.class)) {
                UidPropType uid = new UidPropType();
                uid.setText(val.getUid());
                pl.add(of.createUid(uid));
            }
            if (ToXEvent.emit(pattern, masterClass, UrlPropType.class)) {
                strval = val.getLink();
                if (strval != null) {
                    strval = ((String)strval).trim();
                }
                if (strval != null && ((String)strval).length() > 0) {
                    UrlPropType u = new UrlPropType();
                    u.setUri((String)strval);
                    pl.add(of.createUrl(u));
                }
            }
            if (ToXEvent.emit(pattern, masterClass, XBedeworkCostPropType.class) && val.getCost() != null) {
                c = new XBedeworkCostPropType();
                c.setText(val.getCost());
                pl.add(of.createXBedeworkCost((XBedeworkCostPropType)c));
            }
            if (val.getNumXproperties() > 0) {
                try {
                    ToXEvent.xpropertiesToXcal(pl, val.getXproperties(), pattern, masterClass, wrapXprops);
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
            if (!isInstance && !isOverride && val.testRecurring()) {
                ToXEvent.doRecurring(pattern, masterClass, val, pl);
            }
            return el;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void doRecurring(BaseComponentType pattern, Class compCl, BwEvent val, List<JAXBElement<? extends BasePropertyType>> pl) throws CalFacadeException {
        try {
            if (ToXEvent.emit(pattern, compCl, RrulePropType.class) && val.hasRrules()) {
                for (String s : val.getRrules()) {
                    Date until;
                    RRule rule = new RRule();
                    rule.setValue(s);
                    Recur r = rule.getRecur();
                    RecurType rt = new RecurType();
                    rt.setFreq(FreqRecurType.fromValue((String)r.getFrequency()));
                    if (r.getCount() > 0) {
                        rt.setCount(BigInteger.valueOf(r.getCount()));
                    }
                    if ((until = r.getUntil()) != null) {
                        UntilRecurType u = new UntilRecurType();
                        XcalUtil.initUntilRecur((UntilRecurType)u, (String)until.toString());
                    }
                    if (r.getInterval() > 0) {
                        rt.setInterval(String.valueOf(r.getInterval()));
                    }
                    ToXEvent.listFromNumberList(rt.getBysecond(), r.getSecondList());
                    ToXEvent.listFromNumberList(rt.getByminute(), r.getMinuteList());
                    ToXEvent.listFromNumberList(rt.getByhour(), r.getHourList());
                    if (r.getDayList() != null) {
                        List l = rt.getByday();
                        for (WeekDay wd : r.getDayList()) {
                            l.add(wd.getDay().name());
                        }
                    }
                    ToXEvent.listFromNumberList(rt.getByyearday(), r.getYearDayList());
                    ToXEvent.intlistFromNumberList(rt.getBymonthday(), r.getMonthDayList());
                    ToXEvent.listFromNumberList(rt.getByweekno(), r.getWeekNoList());
                    ToXEvent.intlistFromNumberList(rt.getBymonth(), r.getMonthList());
                    ToXEvent.bigintlistFromNumberList(rt.getBysetpos(), r.getSetPosList());
                    RrulePropType rrp = new RrulePropType();
                    rrp.setRecur(rt);
                    pl.add((JAXBElement<? extends BasePropertyType>)of.createRrule(rrp));
                }
            }
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static AttendeePropType makeAttendee(BwAttendee val) throws Throwable {
        String temp;
        JAXBElement param;
        AttendeePropType prop = new AttendeePropType();
        prop.setCalAddress(val.getAttendeeUri());
        ArrayOfParameters pars = new ArrayOfParameters();
        prop.setParameters(pars);
        if (val.getRsvp()) {
            RsvpParamType r = new RsvpParamType();
            r.setBoolean(true);
            param = of.createRsvp(r);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getCn()) != null) {
            CnParamType cn = new CnParamType();
            cn.setText(temp);
            param = of.createCn(cn);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getPartstat()) == null) {
            temp = "NEEDS-ACTION";
        }
        PartstatParamType partstat = new PartstatParamType();
        partstat.setText(temp);
        param = of.createPartstat(partstat);
        pars.getBaseParameter().add(param);
        temp = val.getScheduleStatus();
        if (temp != null) {
            ScheduleStatusParamType ss = new ScheduleStatusParamType();
            ss.setText(temp);
            param = of.createScheduleStatus(ss);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getCuType()) != null) {
            CutypeParamType c = new CutypeParamType();
            c.setText(val.getCuType());
            param = of.createCutype(c);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getDelegatedFrom()) != null) {
            DelegatedFromParamType df = new DelegatedFromParamType();
            df.getCalAddress().add(temp);
            param = of.createDelegatedFrom(df);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getDelegatedTo()) != null) {
            DelegatedToParamType dt = new DelegatedToParamType();
            dt.getCalAddress().add(temp);
            param = of.createDelegatedTo(dt);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getDir()) != null) {
            DirParamType d = new DirParamType();
            d.setUri(temp);
            param = of.createDir(d);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getLanguage()) != null) {
            LanguageParamType l = new LanguageParamType();
            l.setText(temp);
            param = of.createLanguage(l);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getMember()) != null) {
            MemberParamType m = new MemberParamType();
            m.getCalAddress().add(temp);
            param = of.createMember(m);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getRole()) != null) {
            RoleParamType r = new RoleParamType();
            r.setText(val.getRole());
            param = of.createRole(r);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getSentBy()) != null) {
            SentByParamType sb = new SentByParamType();
            sb.setCalAddress(temp);
            param = of.createSentBy(sb);
            pars.getBaseParameter().add(param);
        }
        return prop;
    }

    public static OrganizerPropType makeOrganizer(BwOrganizer val) throws Throwable {
        JAXBElement param;
        OrganizerPropType prop = new OrganizerPropType();
        prop.setCalAddress(val.getOrganizerUri());
        ArrayOfParameters pars = new ArrayOfParameters();
        prop.setParameters(pars);
        String temp = val.getScheduleStatus();
        if (temp != null) {
            ScheduleStatusParamType ss = new ScheduleStatusParamType();
            ss.setText(temp);
            param = of.createScheduleStatus(ss);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getCn()) != null) {
            CnParamType cn = new CnParamType();
            cn.setText(temp);
            param = of.createCn(cn);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getDir()) != null) {
            DirParamType d = new DirParamType();
            d.setUri(temp);
            param = of.createDir(d);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getLanguage()) != null) {
            LanguageParamType l = new LanguageParamType();
            l.setText(temp);
            param = of.createLanguage(l);
            pars.getBaseParameter().add(param);
        }
        if ((temp = val.getSentBy()) != null) {
            SentByParamType sb = new SentByParamType();
            sb.setCalAddress(temp);
            param = of.createSentBy(sb);
            pars.getBaseParameter().add(param);
        }
        return prop;
    }

    public static void processEventAlarm(BwEvent ev, BaseComponentType comp, BaseComponentType pattern, Class masterClass) throws CalFacadeException {
        ArrayOfComponents aoc;
        if (!ToXEvent.emit(pattern, masterClass, ValarmType.class)) {
            return;
        }
        Set als = ev.getAlarms();
        if (als == null || als.isEmpty()) {
            return;
        }
        if (!(comp instanceof VeventType) && !(comp instanceof VtodoType)) {
            logger.warn("Entity of class " + ev.getClass() + " has alarms but not allowed by entity of type " + comp.getClass());
        }
        if ((aoc = comp.getComponents()) == null) {
            aoc = new ArrayOfComponents();
            comp.setComponents(aoc);
        }
        for (BwAlarm alarm : als) {
            ValarmType va = Xalarms.toXAlarm(ev, alarm, pattern, masterClass);
            aoc.getBaseComponent().add(of.createValarm(va));
        }
    }
}

