/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.icalendar;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VPoll;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalMalformedException;
import org.bedework.icalendar.IcalUtil;
import org.bedework.util.calendar.PropertyIndex;

public class VAlarmUtil
extends IcalUtil {
    public static void processComponentAlarms(IcalCallback cb, Component val, BwEvent ev, String currentPrincipal, ChangeTable chg) throws CalFacadeException {
        try {
            ComponentList als = null;
            if (val instanceof VEvent) {
                als = ((VEvent)val).getAlarms();
            } else if (val instanceof VToDo) {
                als = ((VToDo)val).getAlarms();
            } else if (val instanceof VPoll) {
                als = ((VPoll)val).getAlarms();
            } else {
                return;
            }
            if (als == null || als.isEmpty()) {
                return;
            }
            for (Object o : als) {
                BwAlarm al;
                if (!(o instanceof VAlarm)) {
                    throw new IcalMalformedException("Invalid alarm list");
                }
                VAlarm va = (VAlarm)o;
                PropertyList pl = va.getProperties();
                if (pl == null) {
                    throw new IcalMalformedException("Invalid alarm list");
                }
                Property prop2 = pl.getProperty("X-MOZ-LASTACK");
                boolean mozlastAck = prop2 != null;
                String mozSnoozeTime = null;
                if (mozlastAck) {
                    prop2 = pl.getProperty("X-MOZ-SNOOZE-TIME");
                    if (prop2 == null) continue;
                    mozSnoozeTime = prop2.getValue();
                }
                if ((prop2 = pl.getProperty("ACTION")) == null) {
                    throw new IcalMalformedException("Invalid alarm");
                }
                String actionStr = prop2.getValue();
                BwAlarm.TriggerVal tr = VAlarmUtil.getTrigger(pl, "NONE".equals(actionStr));
                if (mozSnoozeTime != null) {
                    tr.trigger = mozSnoozeTime;
                    tr.triggerDateTime = true;
                    tr.triggerStart = false;
                }
                IcalUtil.DurationRepeat dr = VAlarmUtil.getDurationRepeat(pl);
                if ("EMAIL".equals(actionStr)) {
                    al = BwAlarm.emailAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr(pl, "ATTACH"), (String)VAlarmUtil.getReqStr(pl, "DESCRIPTION"), (String)VAlarmUtil.getReqStr(pl, "SUMMARY"), null);
                    Iterator<?> atts = VAlarmUtil.getReqStrs(pl, "ATTENDEE");
                    while (atts.hasNext()) {
                        al.addAttendee(VAlarmUtil.getAttendee(cb, (Attendee)atts.next()));
                    }
                } else {
                    al = "AUDIO".equals(actionStr) ? BwAlarm.audioAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr(pl, "ATTACH")) : ("DISPLAY".equals(actionStr) ? BwAlarm.displayAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getReqStr(pl, "DESCRIPTION")) : ("PROCEDURE".equals(actionStr) ? BwAlarm.procedureAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getReqStr(pl, "ATTACH"), (String)VAlarmUtil.getOptStr(pl, "DESCRIPTION")) : ("NONE".equals(actionStr) ? BwAlarm.noneAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr(pl, "DESCRIPTION")) : BwAlarm.otherAlarm((BwEvent)ev, (String)ev.getCreatorHref(), (String)actionStr, (BwAlarm.TriggerVal)tr, (String)dr.duration, (int)dr.repeat, (String)VAlarmUtil.getOptStr(pl, "DESCRIPTION")))));
                }
                for (Property prop2 : pl) {
                    if (prop2 instanceof XProperty) {
                        XProperty xp = (XProperty)prop2;
                        al.addXproperty(new BwXproperty(xp.getName(), xp.getParameters().toString(), xp.getValue()));
                        continue;
                    }
                    if (!(prop2 instanceof Uid)) continue;
                    Uid p = (Uid)prop2;
                    al.addXproperty(BwXproperty.makeIcalProperty((String)p.getName(), (String)p.getParameters().toString(), (String)p.getValue()));
                }
                al.setEvent(ev);
                al.setOwnerHref(currentPrincipal);
                chg.addValue(PropertyIndex.PropertyInfoIndex.VALARM, (Object)al);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static void processEventAlarm(BwEvent ev, Component comp, String currentPrincipal) throws CalFacadeException {
        if (currentPrincipal == null) {
            return;
        }
        Set als = ev.getAlarms();
        if (als == null || als.isEmpty()) {
            return;
        }
        ComponentList vals = null;
        if (comp instanceof VEvent) {
            vals = ((VEvent)comp).getAlarms();
        } else if (comp instanceof VToDo) {
            vals = ((VToDo)comp).getAlarms();
        } else {
            throw new CalFacadeException("org.bedework.invalid.component.type", comp.getName());
        }
        for (BwAlarm alarm : als) {
            if (!currentPrincipal.equals(alarm.getOwnerHref())) continue;
            vals.add((Object)VAlarmUtil.setAlarm(ev, alarm));
        }
    }

    private static VAlarm setAlarm(BwEvent ev, BwAlarm val) throws CalFacadeException {
        try {
            String action;
            VAlarm alarm = new VAlarm();
            int atype = val.getAlarmType();
            if (atype != 5) {
                action = BwAlarm.alarmTypes[atype];
            } else {
                List xps = val.getXicalProperties("ACTION");
                action = ((BwXproperty)xps.get(0)).getValue();
            }
            VAlarmUtil.addProperty((Component)alarm, (Property)new Action(action));
            if (val.getTriggerDateTime()) {
                DateTime dt = new DateTime(val.getTrigger());
                VAlarmUtil.addProperty((Component)alarm, (Property)new Trigger(dt));
            } else {
                Trigger tr = new Trigger(new Dur(val.getTrigger()));
                if (!val.getTriggerStart()) {
                    VAlarmUtil.addParameter((Property)tr, (Parameter)Related.END);
                } else {
                    VAlarmUtil.addParameter((Property)tr, (Parameter)Related.START);
                }
                VAlarmUtil.addProperty((Component)alarm, (Property)tr);
            }
            if (val.getDuration() != null) {
                VAlarmUtil.addProperty((Component)alarm, (Property)new Duration(new Dur(val.getDuration())));
                VAlarmUtil.addProperty((Component)alarm, (Property)new Repeat(val.getRepeat()));
            }
            if (atype == 0) {
                if (val.getAttach() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                }
            } else if (atype == 1) {
                if (val.getDescription() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                } else {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(ev.getSummary()));
                }
            } else if (atype == 2) {
                if (val.getAttach() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                }
                VAlarmUtil.checkRequiredProperty(val.getDescription(), "alarm-description");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                VAlarmUtil.checkRequiredProperty(val.getSummary(), "alarm-summary");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Summary(val.getSummary()));
                if (val.getNumAttendees() > 0) {
                    for (BwAttendee att : val.getAttendees()) {
                        VAlarmUtil.addProperty((Component)alarm, (Property)VAlarmUtil.setAttendee(att));
                    }
                }
            } else if (atype == 3) {
                VAlarmUtil.checkRequiredProperty(val.getAttach(), "alarm-attach");
                VAlarmUtil.addProperty((Component)alarm, (Property)new Attach(new URI(val.getAttach())));
                if (val.getDescription() != null) {
                    VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
                }
            } else if (val.getDescription() != null) {
                VAlarmUtil.addProperty((Component)alarm, (Property)new Description(val.getDescription()));
            }
            if (val.getNumXproperties() > 0) {
                IcalUtil.xpropertiesToIcal(alarm.getProperties(), val.getXproperties());
            }
            return alarm;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static void checkRequiredProperty(String val, String name) throws CalFacadeException {
        if (val == null) {
            throw new CalFacadeException("org.bedework.icalendar.missing.required.property", name);
        }
    }
}

