/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.MesssageHandler;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;

public abstract class AbstractScheduler
extends CalSvcDb
implements MesssageHandler {
    public AbstractScheduler() {
        super(null);
    }

    protected String getParentPath(String href) {
        int pos = href.lastIndexOf("/");
        if (pos <= 0) {
            return null;
        }
        return href.substring(0, pos);
    }

    protected String getName(String href) {
        int pos = href.lastIndexOf("/");
        if (pos <= 0) {
            return href;
        }
        if (pos == href.length() - 1) {
            return null;
        }
        return href.substring(pos + 1);
    }

    protected CalSvcI getSvci(String principalHref, String logId) throws CalFacadeException {
        long after;
        CalSvcIPars runAsPars = CalSvcIPars.getServicePars((String)logId, (String)principalHref, (boolean)false, (boolean)"/principals/users/root".equals(principalHref));
        long before = System.currentTimeMillis();
        CalSvcI svci = new CalSvcFactoryDefault().getSvc(runAsPars);
        this.setSvc(svci);
        if (this.trace()) {
            after = System.currentTimeMillis();
            this.trace(String.format("Getsvc took %s", after - before));
            before = after;
        }
        svci.open();
        svci.beginTransaction();
        if (this.trace()) {
            after = System.currentTimeMillis();
            this.trace(String.format("open + beginTransaction took %s", after - before));
            before = after;
        }
        return svci;
    }

    protected void rollback(CalSvcI svci) {
        svci.rollbackTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSvci(CalSvcI svci) throws CalFacadeException {
        if (svci == null || !svci.isOpen()) {
            return;
        }
        CalFacadeException exc = null;
        try {
            try {
                svci.endTransaction();
            }
            catch (CalFacadeException cfe) {
                this.rollback(svci);
                exc = cfe;
            }
        }
        finally {
            svci.close();
        }
        if (exc != null) {
            throw exc;
        }
    }
}

