/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.bedework.access.Access;
import org.bedework.access.AccessException;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.Acl;
import org.bedework.access.CurrentAccess;
import org.bedework.access.Privilege;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.CalSuitesI;
import org.bedework.util.misc.Util;

class CalSuites
extends CalSvcDb
implements CalSuitesI {
    private BwCalSuiteWrapper currentCalSuite;

    CalSuites(CalSvc svci) {
        super(svci);
    }

    public BwCalSuiteWrapper add(String name, String adminGroupName, String rootCollectionPath, String submissionsPath) throws CalFacadeException {
        BwCalSuite cs = this.getCal().getCalSuite(name);
        if (cs != null) {
            throw new CalFacadeException("org.bedework.svci.duplicate.calsuite");
        }
        cs = new BwCalSuite();
        cs.setName(name);
        this.setRootCol(cs, rootCollectionPath);
        this.setupSharableEntity((BwShareableDbentity)cs, this.getPrincipal().getPrincipalRef());
        this.setSubmissionsCol(cs, submissionsPath);
        this.validateGroup(cs, adminGroupName);
        this.getCal().saveOrUpdate(cs);
        return this.wrap(cs, false);
    }

    public void set(BwCalSuiteWrapper val) {
        this.currentCalSuite = val;
    }

    public BwCalSuiteWrapper get() throws CalFacadeException {
        if (this.currentCalSuite == null) {
            return null;
        }
        this.checkCollections((BwCalSuite)this.currentCalSuite);
        return this.currentCalSuite;
    }

    private void checkCollections(BwCalSuite cs) throws CalFacadeException {
        if (cs.getSubmissionsRoot() == null && cs.getSubmissionsRootPath() != null) {
            cs.setSubmissionsRoot(this.getCols().get(cs.getSubmissionsRootPath()));
        }
        if (cs.getRootCollection() == null && cs.getRootCollectionPath() != null) {
            cs.setRootCollection(this.getCols().get(cs.getRootCollectionPath()));
        }
    }

    public BwCalSuiteWrapper get(String name) throws CalFacadeException {
        BwCalSuite cs = this.getCal().getCalSuite(name);
        if (cs == null) {
            return null;
        }
        this.checkCollections(cs);
        return this.wrap(cs, false);
    }

    public BwCalSuiteWrapper get(BwAdminGroup group) throws CalFacadeException {
        BwCalSuite cs = this.getCal().get(group);
        if (cs == null) {
            return null;
        }
        this.checkCollections(cs);
        return this.wrap(cs, false);
    }

    public Collection<BwCalSuite> getAll() throws CalFacadeException {
        Collection css = this.getCal().getAllCalSuites();
        TreeSet<BwCalSuite> retCss = new TreeSet<BwCalSuite>();
        for (BwCalSuite cs : css) {
            this.checkCollections(cs);
            BwCalSuiteWrapper w = this.wrap(cs, true);
            if (w == null) continue;
            retCss.add((BwCalSuite)w);
        }
        return retCss;
    }

    public void update(BwCalSuiteWrapper csw, String adminGroupName, String rootCollectionPath, String submissionsPath) throws CalFacadeException {
        BwCalSuite cs = csw.fetchEntity();
        if (adminGroupName != null) {
            this.validateGroup(cs, adminGroupName);
        }
        this.setRootCol(cs, rootCollectionPath);
        this.setSubmissionsCol(cs, submissionsPath);
        this.getCal().saveOrUpdate(cs);
    }

    public void delete(BwCalSuiteWrapper val) throws CalFacadeException {
        this.getCal().delete(val.fetchEntity());
    }

    public String getResourcesPath(BwCalSuite suite, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        if (cl == CalSuitesI.ResourceClass.global) {
            return this.getBasicSyspars().getGlobalResourcesPath();
        }
        BwPrincipal eventsOwner = this.getPrincipal(suite.getGroup().getOwnerHref());
        String home = this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)eventsOwner);
        BwPreferences prefs = this.getPrefs(eventsOwner);
        String col = null;
        if (cl == CalSuitesI.ResourceClass.admin) {
            col = prefs.getAdminResourcesDirectory();
            if (col == null) {
                col = ".adminResources";
            }
        } else if (cl == CalSuitesI.ResourceClass.calsuite && (col = prefs.getSuiteResourcesDirectory()) == null) {
            col = ".csResources";
        }
        if (col != null) {
            return Util.buildPath((boolean)false, (String[])new String[]{home, "/", col});
        }
        throw new RuntimeException("System error");
    }

    public List<BwResource> getResources(BwCalSuite suite, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        return this.getRess().getAll(this.getResourcesPath(suite, cl));
    }

    public BwResource getResource(BwCalSuite suite, String name, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        try {
            BwResource r = this.getRess().get(Util.buildPath((boolean)false, (String[])new String[]{this.getResourcesPath(suite, cl), "/", name}));
            if (r != null) {
                this.getRess().getContent(r);
            }
            return r;
        }
        catch (CalFacadeException cfe) {
            if ("org.bedework.exception.calendarnotfound".equals(cfe.getMessage())) {
                return null;
            }
            throw cfe;
        }
    }

    public void addResource(BwCalSuite suite, BwResource res, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        res.setColPath(this.getResourcesPath(suite, cl));
        this.getRess().save(res, false);
    }

    public void deleteResource(BwCalSuite suite, String name, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        this.getRess().delete(Util.buildPath((boolean)false, (String[])new String[]{this.getResourcesPath(suite, cl), "/", name}));
    }

    private BwCalendar getResourcesDir(BwCalSuite suite, CalSuitesI.ResourceClass cl) throws CalFacadeException {
        String path = this.getResourcesPath(suite, cl);
        if (path == null) {
            throw new CalFacadeException("org.bedework.svci.no.calsuite.resource.collection");
        }
        BwCalendar resCol = this.getCols().get(path);
        if (resCol != null) {
            return resCol;
        }
        resCol = new BwCalendar();
        resCol.setName(path.substring(path.lastIndexOf("/") + 1));
        resCol.setSummary(resCol.getName());
        resCol.setCreatorHref(suite.getOwnerHref());
        if (cl == CalSuitesI.ResourceClass.calsuite) {
            resCol.setOwnerHref(suite.getOwnerHref());
        } else {
            resCol.setOwnerHref(this.getPublicUser().getPrincipalRef());
        }
        String parentPath = path.substring(0, path.lastIndexOf("/"));
        resCol = this.getCols().add(resCol, parentPath);
        try {
            ArrayList<Privilege> readPrivs = new ArrayList<Privilege>();
            readPrivs.add(Access.read);
            ArrayList<Ace> aces = new ArrayList<Ace>();
            aces.add(Ace.makeAce((AceWho)AceWho.all, readPrivs, null));
            this.getSvc().changeAccess((BwShareableDbentity<?>)resCol, (Collection<Ace>)aces, true);
        }
        catch (AccessException ae) {
            throw new CalFacadeException((Throwable)ae);
        }
        return resCol;
    }

    private void setRootCol(BwCalSuite cs, String rootCollectionPath) throws CalFacadeException {
        if (rootCollectionPath == null || rootCollectionPath.equals(cs.getRootCollectionPath())) {
            return;
        }
        BwCalendar rootCol = this.getCols().get(rootCollectionPath);
        if (rootCol == null) {
            throw new CalFacadeException("org.bedework.svci.calsuite.unknown.root.collection", rootCollectionPath);
        }
        cs.setRootCollection(rootCol);
        cs.setRootCollectionPath(rootCol.getPath());
    }

    private void setSubmissionsCol(BwCalSuite cs, String submissionsPath) throws CalFacadeException {
        if (submissionsPath == null || submissionsPath.equals(cs.getSubmissionsRoot().getPath())) {
            return;
        }
        BwCalendar submissionsCol = this.getCols().get(submissionsPath);
        if (submissionsCol == null) {
            throw new CalFacadeException("org.bedework.svci.calsuite.unknown.submissions.collection", submissionsPath);
        }
        cs.setSubmissionsRoot(submissionsCol);
        cs.setSubmissionsRootPath(submissionsCol.getPath());
    }

    private BwCalendar validateGroup(BwCalSuite cs, String groupName) throws CalFacadeException {
        if (groupName.length() > 255) {
            throw new CalFacadeException("org.bedework.svci.calsuite.group.name.too.long");
        }
        BwAdminGroup agrp = (BwAdminGroup)this.getSvc().getAdminDirectories().findGroup(groupName);
        if (agrp == null) {
            throw new CalFacadeException("org.bedework.exception.groupnotfound", groupName);
        }
        BwCalSuiteWrapper csw = this.get(agrp);
        if (csw != null && !csw.equals((Object)cs)) {
            throw new CalFacadeException("org.bedework.svci.calsuite.group.assigned", csw.getName());
        }
        BwPrincipal eventsOwner = this.getPrincipal(agrp.getOwnerHref());
        if (eventsOwner == null) {
            throw new CalFacadeException("org.bedework.svci.calsuite.badowner");
        }
        BwCalendar home = this.getCols().getHomeDb(eventsOwner, true);
        if (home == null) {
            throw new CalFacadeException("org.bedework.svci.calsuite.missing.group.owner.home");
        }
        cs.setGroup(agrp);
        ArrayList<Privilege> allPrivs = new ArrayList<Privilege>();
        allPrivs.add(Access.all);
        ArrayList<Privilege> readPrivs = new ArrayList<Privilege>();
        readPrivs.add(Access.read);
        ArrayList<Ace> aces = new ArrayList<Ace>();
        try {
            aces.add(Ace.makeAce((AceWho)AceWho.owner, allPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.getAceWho((String)eventsOwner.getAccount(), (int)1, (boolean)false), allPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.getAceWho(null, (int)8, (boolean)false), readPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.all, readPrivs, null));
            this.getSvc().changeAccess((BwShareableDbentity<?>)home, (Collection<Ace>)aces, true);
            this.getSvc().changeAccess((BwShareableDbentity<?>)cs, (Collection<Ace>)aces, true);
            String aclStr = new String(new Acl(aces).encode());
            eventsOwner.setCategoryAccess(aclStr);
            eventsOwner.setLocationAccess(aclStr);
            eventsOwner.setContactAccess(aclStr);
        }
        catch (AccessException ae) {
            throw new CalFacadeException((Throwable)ae);
        }
        this.getSvc().getUsersHandler().update(eventsOwner);
        return home;
    }

    private BwCalSuiteWrapper wrap(BwCalSuite cs, boolean alwaysReturn) throws CalFacadeException {
        CurrentAccess ca = this.checkAccess((BwShareableDbentity)cs, 25, alwaysReturn);
        if (ca == null || !ca.getAccessAllowed()) {
            return null;
        }
        BwCalSuiteWrapper w = new BwCalSuiteWrapper(cs, ca);
        BwAdminGroup agrp = cs.getGroup();
        if (agrp == null) {
            return w;
        }
        BwPrincipal eventsOwner = this.getSvc().getUsersHandler().getPrincipal(agrp.getOwnerHref());
        if (eventsOwner == null) {
            return w;
        }
        w.setResourcesHome(this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)eventsOwner));
        return w;
    }
}

