/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.bedework.access.CurrentAccess;
import org.bedework.calcorei.Calintf;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calfacade.wrappers.CalendarWrapper;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvc.Events;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.UsersI;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Uid;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.Response;
import org.bedework.util.security.PwEncryptionIntf;

public class CalSvcDb
implements Logged,
Serializable {
    private CalSvc svci;
    private CalSvcIPars pars;
    private BwLogger logger = new BwLogger();

    public CalSvcDb(CalSvc svci) {
        this.setSvc(svci);
    }

    public void open() {
    }

    public void close() {
    }

    public static String getEncodedUuid() {
        return new String(Base64.encodeBase64((byte[])UUID.randomUUID().toString().getBytes()));
    }

    void touchCalendar(String href) throws CalFacadeException {
        this.getSvc().touchCalendar(href);
    }

    void touchCalendar(BwCalendar col) throws CalFacadeException {
        this.getSvc().touchCalendar(col);
    }

    protected Timestamp getCurrentTimestamp() {
        return this.getSvc().getCurrentTimestamp();
    }

    protected BwPrincipal caladdrToPrincipal(String href) throws CalFacadeException {
        return this.getSvc().getDirectories().caladdrToPrincipal(href);
    }

    protected String principalToCaladdr(BwPrincipal p) throws CalFacadeException {
        return this.getSvc().getDirectories().principalToCaladdr(p);
    }

    protected void pushPrincipal(String href) throws CalFacadeException {
        BwPrincipal pr = this.caladdrToPrincipal(href);
        if (pr == null) {
            throw new CalFacadeException("org.bedework.exception.badrequest", "unknown principal");
        }
        this.getSvc().pushPrincipal(pr);
    }

    protected boolean pushPrincipalReturn(String href) throws CalFacadeException {
        BwPrincipal pr = this.caladdrToPrincipal(href);
        if (pr == null) {
            return false;
        }
        this.getSvc().pushPrincipal(pr);
        return true;
    }

    protected void pushPrincipal(BwPrincipal pr) throws CalFacadeException {
        this.getSvc().pushPrincipal(pr);
    }

    protected void popPrincipal() throws CalFacadeException {
        this.getSvc().popPrincipal();
    }

    protected PwEncryptionIntf getEncrypter() throws CalFacadeException {
        return this.getSvc().getEncrypter();
    }

    protected List<BwCalendar> findAlias(String val) throws CalFacadeException {
        return ((Calendars)this.getCols()).findUserAlias(val);
    }

    protected GetEntitiesResponse<EventInfo> getEventsByUid(String colPath, String guid) {
        Events events = (Events)this.getSvc().getEventsHandler();
        GetEntitiesResponse resp = new GetEntitiesResponse();
        try {
            Collection<EventInfo> ents = events.getByUid(colPath, guid, null, RecurringRetrievalMode.overrides);
            if (Util.isEmpty(ents)) {
                resp.setStatus(Response.Status.notFound);
            } else {
                resp.setEntities(ents);
            }
            return resp;
        }
        catch (Throwable t) {
            return (GetEntitiesResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    protected Response deleteEvent(EventInfo ei, boolean scheduling, boolean sendSchedulingReply) {
        Events events = (Events)this.getSvc().getEventsHandler();
        Response resp = new Response();
        try {
            boolean deleted = events.delete(ei, scheduling, sendSchedulingReply);
            if (!deleted) {
                resp.setStatus(Response.Status.notFound);
            }
            return resp;
        }
        catch (CalFacadeException cfe) {
            return Response.error((Response)resp, (Throwable)cfe);
        }
    }

    protected BwCalendar getSpecialCalendar(BwPrincipal owner, int calType, boolean create, int access) throws CalFacadeException {
        return ((Calendars)this.getCols()).getSpecial(owner, calType, create, access);
    }

    public void postNotification(SysEvent ev) {
        this.getSvc().postNotification((SysEventBase)ev);
    }

    protected Collection<EventInfo> getEvents(Collection<BwCalendar> cols, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, RecurringRetrievalMode recurRetrieval, boolean freeBusy) throws CalFacadeException {
        Events events = (Events)this.getSvc().getEventsHandler();
        return events.getMatching(cols, filter, startDate, endDate, retrieveList, BwIndexer.DeletedState.noDeleted, recurRetrieval, freeBusy);
    }

    protected EventInfo getEvent(BwCalendar col, String name, String recurrenceId) throws CalFacadeException {
        return this.getSvc().getEventsHandler().get(col, name, recurrenceId, null);
    }

    protected CollectionAndName getCollectionAndName(String path) throws CalFacadeException {
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        int pos = path.substring(0, end).lastIndexOf("/");
        if (pos < 0) {
            throw new CalFacadeException("org.bedework.exception.badrequest");
        }
        CollectionAndName res = new CollectionAndName();
        res.name = path.substring(pos + 1, end);
        if (pos == 0) {
            res.coll = null;
        } else {
            res.coll = this.getCols().get(path.substring(0, pos));
            if (res.coll == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound");
            }
        }
        return res;
    }

    protected CalSvcIPars getPars() {
        return this.pars;
    }

    protected boolean isSuper() {
        return this.pars.getPublicAdmin() && this.svci.getSuperUser();
    }

    protected boolean isGuest() {
        return this.pars.isGuest();
    }

    protected boolean isPublicAdmin() {
        return this.pars.getPublicAdmin();
    }

    protected boolean isPublicAuth() {
        return this.pars.getPublicAuth();
    }

    protected BwPrincipal getPrincipal() {
        return this.svci.getPrincipal();
    }

    protected String getPrincipalHref() {
        return this.svci.getPrincipal().getPrincipalRef();
    }

    protected String getOwnerHref() {
        if (this.getSvc().getPars().getPublicAdmin() || this.getPrincipal().getUnauthenticated()) {
            return this.getUsers().getPublicUser().getPrincipalRef();
        }
        return this.getPrincipal().getPrincipalRef();
    }

    public BwIndexer getIndexer(String docType) {
        return this.svci.getIndexer(docType);
    }

    public BwIndexer getIndexer(boolean publick, String docType) {
        return this.svci.getIndexer(publick, docType);
    }

    protected BwPrincipal getPrincipal(String href) throws CalFacadeException {
        return this.svci.getUsersHandler().getPrincipal(href);
    }

    protected PrincipalInfo getPrincipalInfo() {
        return this.svci.getPrincipalInfo();
    }

    protected BwPrincipalInfo getBwPrincipalInfo() throws CalFacadeException {
        return this.svci.getDirectories().getDirInfo(this.getPrincipal());
    }

    public void setSvc(CalSvcI svci) {
        this.svci = (CalSvc)svci;
        if (svci != null) {
            this.pars = this.svci.getPars();
        }
    }

    protected CalSvc getSvc() {
        return this.svci;
    }

    protected CalendarsI getCols() {
        return this.svci.getCalendarsHandler();
    }

    protected NotificationsI getNotes() {
        return this.svci.getNotificationsHandler();
    }

    protected ResourcesI getRess() {
        return this.svci.getResourcesHandler();
    }

    protected BwPreferences getPrefs() {
        return this.svci.getPrefsHandler().get();
    }

    protected BwPreferences getPrefs(BwPrincipal principal) {
        return this.svci.getPrefsHandler().get(principal);
    }

    protected void update(BwPreferences prefs) {
        this.svci.getPrefsHandler().update(prefs);
    }

    protected UsersI getUsers() {
        return this.svci.getUsersHandler();
    }

    protected Calintf getCal() {
        try {
            return this.svci.getCal();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Calintf getCal(BwCalendar cal) throws CalFacadeException {
        return this.svci.getCal(cal);
    }

    protected BwPrincipal getPublicUser() {
        return this.getSvc().getUsersHandler().getPublicUser();
    }

    protected CurrentAccess checkAccess(BwShareableDbentity ent, int desiredAccess, boolean returnResult) throws CalFacadeException {
        return this.svci.checkAccess(ent, desiredAccess, returnResult);
    }

    protected void assignGuid(BwEvent val) {
        if (val == null) {
            return;
        }
        if (val.getName() != null && val.getUid() != null) {
            return;
        }
        String guidPrefix = "CAL-" + Uid.getUid();
        if (val.getName() == null) {
            val.setName(guidPrefix + ".ics");
        }
        if (val.getUid() != null) {
            return;
        }
        val.setUid(guidPrefix + this.getSvc().getSystemProperties().getSystemid());
    }

    protected void checkOwnerOrSuper(Object o) throws CalFacadeException {
        if (this.isGuest()) {
            throw new CalFacadeAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwOwnedDbentity)) {
            throw new CalFacadeAccessException();
        }
        BwOwnedDbentity ent = (BwOwnedDbentity)o;
        if (this.getPrincipal().getPrincipalRef().equals(ent.getOwnerHref())) {
            return;
        }
        throw new CalFacadeAccessException();
    }

    protected void setupSharableEntity(BwShareableDbentity entity, String ownerHref) {
        if (entity.getCreatorHref() == null) {
            entity.setCreatorHref(ownerHref);
        }
        this.setupOwnedEntity((BwOwnedDbentity)entity, ownerHref);
    }

    protected void setupOwnedEntity(BwOwnedDbentity entity, String ownerHref) {
        entity.setPublick(Boolean.valueOf(this.isPublicAdmin()));
        if (entity.getOwnerHref() == null) {
            if (entity.getPublick().booleanValue()) {
                entity.setOwnerHref(this.getPublicUser().getPrincipalRef());
            } else {
                entity.setOwnerHref(ownerHref);
            }
        }
    }

    protected BwPrincipal getEntityOwner(BwPrincipal owner) {
        if (this.isPublicAdmin() || this.isGuest()) {
            return this.getPublicUser();
        }
        return owner;
    }

    protected BasicSystemProperties getBasicSyspars() {
        return this.getSvc().getBasicSystemProperties();
    }

    protected AuthProperties getAuthpars() {
        return this.getSvc().getAuthProperties();
    }

    protected SystemProperties getSyspars() {
        return this.getSvc().getSystemProperties();
    }

    protected BwCalendar unwrap(BwCalendar val) {
        if (val == null) {
            return null;
        }
        if (!(val instanceof CalendarWrapper)) {
            return val;
        }
        return ((CalendarWrapper)val).fetchEntity();
    }

    public SplitResult splitUri(String uri) throws CalFacadeException {
        int pos;
        int end = uri.length();
        if (uri.endsWith("/")) {
            --end;
        }
        if ((pos = uri.lastIndexOf("/", end)) < 0) {
            throw new CalFacadeException("Invalid uri: " + uri);
        }
        if (pos == 0) {
            return new SplitResult(uri, null);
        }
        return new SplitResult(uri.substring(0, pos), uri.substring(pos + 1, end));
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static class SplitResult {
        String path;
        String name;

        SplitResult(String path, String name) {
            this.path = path;
            this.name = name;
        }
    }

    protected static class CollectionAndName {
        public BwCalendar coll;
        public String name;

        protected CollectionAndName() {
        }
    }
}

