/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.EventPropertiesImpl;
import org.bedework.calsvci.Contacts;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;

public class ContactsImpl
extends EventPropertiesImpl<BwContact>
implements Contacts {
    public ContactsImpl(CalSvc svci) {
        super(svci);
    }

    public void init(boolean adminCanEditAllPublic) {
        super.init(BwContact.class.getCanonicalName(), adminCanEditAllPublic);
    }

    @Override
    String getDocType() {
        return "contact";
    }

    @Override
    Collection<BwContact> fetchAllIndexed(boolean publick, String ownerHref) throws CalFacadeException {
        return this.filterDeleted(this.getIndexer(publick, ownerHref).fetchAllContacts());
    }

    @Override
    BwContact fetchIndexedByUid(String uid) throws CalFacadeException {
        return this.getIndexer().fetchContact(uid, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.UID});
    }

    @Override
    BwContact fetchIndexed(String href) throws CalFacadeException {
        return this.getIndexer().fetchContact(href, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.HREF});
    }

    @Override
    GetEntityResponse<BwContact> findPersistent(BwContact val, String ownerHref) {
        return this.findPersistent(val.getFinderKeyValue(), ownerHref);
    }

    @Override
    public boolean exists(Response resp, BwContact val) {
        GetEntityResponse getResp = this.findPersistent(val.getFinderKeyValue(), val.getOwnerHref());
        if (getResp.isError()) {
            Response.fromResponse((Response)resp, getResp);
            return false;
        }
        return getResp.isOk();
    }

    public BwContact find(BwString val) throws CalFacadeException {
        return this.getIndexer().fetchContact(val.getValue(), new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.CN, PropertyIndex.PropertyInfoIndex.VALUE});
    }

    public GetEntitiesResponse<BwContact> find(String fexpr, int from, int size) {
        SimpleFilterParser.ParseResult pr = this.getSvc().getFilterParser().parse(fexpr, false, null);
        if (!pr.ok) {
            return (GetEntitiesResponse)Response.error((Response)new GetEntitiesResponse(), (String)pr.message);
        }
        return this.getIndexer().findContacts(pr.filter, from, size);
    }
}

