/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bedework.access.PrivilegeDefs;
import org.bedework.calcorei.CoreEventPropertiesI;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.EventPropertiesReference;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvci.EventProperties;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.GetEntityResponse;
import org.bedework.util.misc.response.Response;

public abstract class EventPropertiesImpl<T extends BwEventProperty<?>>
extends CalSvcDb
implements EventProperties<T>,
PrivilegeDefs {
    private final FlushMap<String, Collection<T>> cached = new FlushMap(300000L, 2000);
    private final FlushMap<String, T> cachedByUid = new FlushMap(300000L, 2000);
    private Class<T> ourClass;
    private CoreEventPropertiesI<T> coreHdlr;
    private boolean adminCanEditAllPublic;
    private String lastChangeToken;

    abstract String getDocType();

    abstract Collection<T> fetchAllIndexed(boolean var1, String var2) throws CalFacadeException;

    abstract T fetchIndexedByUid(String var1) throws CalFacadeException;

    abstract T fetchIndexed(String var1) throws CalFacadeException;

    abstract GetEntityResponse<T> findPersistent(T var1, String var2);

    abstract boolean exists(Response var1, T var2);

    public EventPropertiesImpl(CalSvc svci) {
        super(svci);
    }

    public void init(String className, boolean adminCanEditAllPublic) {
        this.adminCanEditAllPublic = adminCanEditAllPublic;
        try {
            this.ourClass = Class.forName(className);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Collection<T> getPublic() throws CalFacadeException {
        return this.get(true, null);
    }

    Collection<T> filterDeleted(Collection<T> ents) {
        if (this.isSuper()) {
            return ents;
        }
        return ents.stream().filter(ent -> !"deleted".equals(ent.getStatus())).collect(Collectors.toList());
    }

    public Collection<T> get() throws CalFacadeException {
        return this.get(this.isPublicAdmin(), null);
    }

    public Collection<T> getEditable() throws CalFacadeException {
        if (!this.isPublicAdmin()) {
            return this.get(false, null);
        }
        if (this.isSuper() || this.adminCanEditAllPublic) {
            return this.getPublic();
        }
        return this.get(true, this.getPrincipal().getPrincipalRef());
    }

    public GetEntityResponse<T> getByUid(String uid) {
        GetEntityResponse resp = new GetEntityResponse();
        T ent = this.getCachedByUid(uid);
        if (ent != null) {
            resp.setEntity(ent);
            return resp;
        }
        try {
            ent = this.fetchIndexedByUid(uid);
            if (ent == null) {
                return (GetEntityResponse)Response.notFound((Response)resp);
            }
            this.putCachedByUid(uid, ent);
            resp.setEntity(ent);
            return resp;
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    public T get(String href) throws CalFacadeException {
        return this.fetchIndexed(href);
    }

    public GetEntitiesResponse<T> getByUids(Collection<String> uids) {
        GetEntitiesResponse resp = new GetEntitiesResponse();
        if (Util.isEmpty(uids)) {
            return resp;
        }
        for (String uid : uids) {
            GetEntityResponse<T> ent = this.getByUid(uid);
            if (ent.isOk()) {
                resp.addEntity((Object)((BwEventProperty)ent.getEntity()));
                continue;
            }
            if (ent.isNotFound()) continue;
            return (GetEntitiesResponse)Response.fromResponse((Response)resp, ent);
        }
        return resp;
    }

    public T getPersistent(String uid) throws CalFacadeException {
        return (T)this.getCoreHdlr().get(uid);
    }

    public GetEntityResponse<T> findPersistent(BwString val) {
        GetEntityResponse resp = new GetEntityResponse();
        BwPrincipal owner = !this.isPublicAdmin() ? this.getPrincipal() : this.getPublicUser();
        try {
            BwEventProperty ent = this.getCoreHdlr().find(val, owner.getPrincipalRef());
            if (ent == null) {
                return (GetEntityResponse)Response.notFound((Response)resp);
            }
            resp.setEntity((Object)ent);
            return (GetEntityResponse)Response.ok((Response)resp, null);
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    public Response add(T val) {
        Response resp = new Response();
        this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
        if (!this.updateOK(resp, val)) {
            return resp;
        }
        boolean exists = this.exists(resp, val);
        if (resp.isError()) {
            return resp;
        }
        if (exists) {
            resp.setStatus(Response.Status.exists);
            return resp;
        }
        if (this.debug()) {
            this.debug("Add " + val);
        }
        if (val.getCreatorHref() == null || val.getOwnerHref() == null) {
            return Response.error((Response)resp, (String)"Owner and creator must be set");
        }
        try {
            this.getCal().saveOrUpdate(val);
            ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty<?>)val);
            this.getCoreHdlr().checkUnique(val.getFinderKeyValue(), val.getOwnerHref());
            this.getCal().indexEntity(val);
            Collection<T> ents = this.get();
            if (ents != null) {
                ents.add(val);
            }
            this.putCachedByUid(val.getUid(), val);
            return resp;
        }
        catch (Throwable t) {
            return Response.error((Response)resp, (Throwable)t);
        }
    }

    public void update(T val) throws CalFacadeException {
        if (val.getCreatorHref() == null || val.getOwnerHref() == null) {
            throw new RuntimeException("Owner and creator must be set");
        }
        if (this.check(val) == null) {
            throw new CalFacadeAccessException();
        }
        this.getCal().saveOrUpdate(val);
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty<?>)val);
        this.getCoreHdlr().checkUnique(val.getFinderKeyValue(), val.getOwnerHref());
        Collection<T> ents = this.get();
        if (ents != null) {
            ents.remove(val);
            ents.add(val);
        }
        this.putCachedByUid(val.getUid(), val);
    }

    public int delete(T val) throws CalFacadeException {
        T ent = val;
        if (val.unsaved()) {
            ent = this.getPersistent(val.getUid());
        }
        this.deleteOK(ent);
        if (this.getCoreHdlr().getRefsCount(ent) != 0L) {
            return 2;
        }
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(true, (BwEventProperty<?>)ent);
        this.getCoreHdlr().deleteProp(ent);
        this.getSvc().getIndexer((BwOwnedDbentity<?>)ent).unindexEntity(ent);
        Collection<T> ents = this.get();
        if (ents != null) {
            ents.remove(ent);
        }
        this.removeCachedByUid(ent.getUid());
        return 0;
    }

    public Collection<EventPropertiesReference> getRefs(T val) throws CalFacadeException {
        T persistent = this.getPersistent(val.getUid());
        if (persistent == null) {
            return null;
        }
        return this.getCoreHdlr().getRefs(persistent);
    }

    public EventProperties.EnsureEntityExistsResult<T> ensureExists(T val, String ownerHref) {
        EventProperties.EnsureEntityExistsResult eeer = new EventProperties.EnsureEntityExistsResult();
        if (!val.unsaved()) {
            eeer.setEntity(val);
            return eeer;
        }
        String oh = ownerHref == null ? this.getPrincipal().getPrincipalRef() : ownerHref;
        try {
            GetEntityResponse<T> resp = this.findPersistent(val, oh);
            if (resp.isError()) {
                Response.fromResponse((Response)eeer, resp);
                return eeer;
            }
            if (resp.isOk()) {
                eeer.setEntity((Object)((BwEventProperty)resp.getEntity()));
                return eeer;
            }
            this.setupSharableEntity((BwShareableDbentity)val, ownerHref);
            Response addResp = this.add(val);
            if (!addResp.isOk()) {
                return (EventProperties.EnsureEntityExistsResult)Response.fromResponse((Response)eeer, (Response)addResp);
            }
            eeer.added = true;
            eeer.setEntity(val);
            return eeer;
        }
        catch (Throwable t) {
            return (EventProperties.EnsureEntityExistsResult)Response.error((Response)eeer, (Throwable)t);
        }
    }

    public int reindex(BwIndexer indexer) throws CalFacadeException {
        BwPrincipal owner = !this.isPublicAdmin() ? this.getPrincipal() : this.getPublicUser();
        Collection ents = this.getCoreHdlr().getAll(owner.getPrincipalRef());
        if (Util.isEmpty((Collection)ents)) {
            return 0;
        }
        for (BwEventProperty ent : ents) {
            indexer.indexEntity((Object)ent);
        }
        return ents.size();
    }

    public BwIndexer getIndexer() {
        return this.getIndexer(this.getDocType());
    }

    @Override
    public BwIndexer getIndexer(boolean getPublic, String ownerHref) {
        boolean publick;
        String href;
        try {
            href = this.checkHref(ownerHref);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        boolean bl = publick = getPublic || this.isGuest() || this.isPublicAdmin();
        if (publick) {
            return this.getSvc().getIndexer(true, this.getDocType());
        }
        return this.getSvc().getIndexer(href, this.getDocType());
    }

    protected CoreEventPropertiesI<T> getCoreHdlr() {
        if (this.coreHdlr == null) {
            this.coreHdlr = this.getCal().getEvPropsHandler(this.ourClass);
        }
        return this.coreHdlr;
    }

    protected boolean indexChanged() {
        try {
            String token = this.getIndexer().currentChangeToken();
            boolean changed = this.lastChangeToken == null || !this.lastChangeToken.equals(token);
            this.lastChangeToken = token;
            return changed;
        }
        catch (Throwable t) {
            this.error(t);
            return true;
        }
    }

    protected Collection<T> getCached(String ownerHref) {
        this.checkChache();
        return (Collection)this.cached.get((Object)ownerHref);
    }

    protected void putCached(String ownerHref, Collection<T> vals) {
        this.cached.put((Object)ownerHref, vals);
    }

    protected void removeCached(String ownerHref) {
        this.cached.remove((Object)ownerHref);
    }

    protected T getCachedByUid(String uid) {
        this.checkChache();
        return (T)((BwEventProperty)this.cachedByUid.get((Object)uid));
    }

    protected void putCachedByUid(String uid, T val) {
        this.cachedByUid.put((Object)uid, val);
    }

    protected void removeCachedByUid(String uid) {
        this.cachedByUid.remove((Object)uid);
    }

    protected GetEntityResponse<T> findPersistent(BwString val, String ownerHref) {
        GetEntityResponse resp = new GetEntityResponse();
        try {
            BwEventProperty ent = this.getCoreHdlr().find(val, ownerHref);
            if (ent == null) {
                resp.setStatus(Response.Status.notFound);
            } else {
                resp.setEntity((Object)ent);
            }
            return resp;
        }
        catch (CalFacadeException cfe) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)cfe);
        }
    }

    private void checkChache() {
        if (this.indexChanged()) {
            this.cached.clear();
            this.cachedByUid.clear();
        }
    }

    private Collection<T> get(boolean publick, String creatorHref) throws CalFacadeException {
        String ownerHref = publick ? this.getPublicUser().getPrincipalRef() : this.getPrincipal().getPrincipalRef();
        Collection<T> ents = this.getCached(ownerHref);
        if (ents == null) {
            ents = this.fetchAllIndexed(publick, ownerHref);
            if (Util.isEmpty(ents)) {
                return new ArrayList();
            }
            this.putCached(ownerHref, ents);
        }
        for (BwEventProperty ent : ents) {
            this.putCachedByUid(ent.getUid(), ent);
        }
        if (creatorHref == null) {
            return this.filterDeleted(ents);
        }
        ArrayList<BwEventProperty> someEnts = new ArrayList<BwEventProperty>();
        for (BwEventProperty ent : ents) {
            if (!ent.getCreatorHref().equals(creatorHref)) continue;
            someEnts.add(ent);
        }
        return this.filterDeleted(someEnts);
    }

    private String checkHref(String ownerHref) {
        if (ownerHref != null) {
            return ownerHref;
        }
        return BwPrincipal.publicUserHref;
    }

    private T check(T ent) {
        if (ent == null) {
            return null;
        }
        return ent;
    }

    private void deleteOK(T o) throws CalFacadeException {
        if (o == null) {
            return;
        }
        if (this.isGuest()) {
            throw new CalFacadeAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!this.isPublicAdmin()) {
            this.getSvc().checkAccess((BwShareableDbentity<?>)o, 14, false);
            return;
        }
        if (this.adminCanEditAllPublic || o.getCreatorHref().equals(this.getPrincipal().getPrincipalRef())) {
            return;
        }
        throw new CalFacadeAccessException();
    }

    private boolean updateOK(Response resp, Object o) {
        if (this.isGuest()) {
            resp.setStatus(Response.Status.noAccess);
            return false;
        }
        if (this.isSuper()) {
            return true;
        }
        if (!(o instanceof BwShareableDbentity)) {
            resp.setStatus(Response.Status.noAccess);
            return false;
        }
        if (!this.isPublicAdmin()) {
            return true;
        }
        BwShareableDbentity ent = (BwShareableDbentity)o;
        if (this.adminCanEditAllPublic || ent.getCreatorHref().equals(this.getPrincipal().getPrincipalRef())) {
            return true;
        }
        resp.setStatus(Response.Status.noAccess);
        return false;
    }
}

