/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.property.CalendarAddress;
import net.fortuna.ical4j.model.property.DtStart;
import org.bedework.access.CurrentAccess;
import org.bedework.calcorei.CoreCalendarsI;
import org.bedework.calcorei.CoreEventInfo;
import org.bedework.calcorei.CoreEventsI;
import org.bedework.caldav.util.filter.BooleanFilter;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.EventListEntry;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeForbidden;
import org.bedework.calfacade.filter.RetrieveList;
import org.bedework.calfacade.filter.SfpTokenizer;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.requests.GetInstancesRequest;
import org.bedework.calfacade.responses.InstancesResponse;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvc.scheduling.SchedulingIntf;
import org.bedework.calsvci.Categories;
import org.bedework.calsvci.EventProperties;
import org.bedework.calsvci.EventsI;
import org.bedework.convert.IcalTranslator;
import org.bedework.convert.Icalendar;
import org.bedework.convert.RecurUtil;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.sysevents.events.EntityFetchEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.GetEntitiesResponse;
import org.bedework.util.misc.response.Response;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;

class Events
extends CalSvcDb
implements EventsI {
    private static final String ValidateAlarmPrefix = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:bedework-validate\nBEGIN:VEVENT\nDTSTART:20101231T230000\nDTEND:20110101T010000\nSUMMARY:Just checking\nUID:1234\nDTSTAMP:20101125T112600\n";
    private static final String ValidateAlarmSuffix = "END:VEVENT\nEND:VCALENDAR\n";

    Events(CalSvc svci) {
        super(svci);
    }

    public Collection<EventInfo> getByUid(String colPath, String guid, String recurrenceId, RecurringRetrievalMode recurRetrieval) throws CalFacadeException {
        Set<EventInfo> res = this.postProcess(this.getCal().getEvent(colPath, guid));
        int num = res.size();
        if (num == 0) {
            return res;
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        if (recurrenceId == null && (recurRetrieval == null || recurRetrieval.mode != RecurringRetrievalMode.Rmode.expanded)) {
            return res;
        }
        if (recurrenceId == null) {
            return this.processExpanded(res, recurRetrieval);
        }
        if (num > 1) {
            throw new RuntimeException("cannot return rid for multiple events");
        }
        ArrayList<EventInfo> eis = new ArrayList<EventInfo>();
        eis.add(this.makeInstance((EventInfo)res.iterator().next(), recurrenceId));
        return eis;
    }

    private Collection<EventInfo> processExpanded(Collection<EventInfo> events, RecurringRetrievalMode recurRetrieval) {
        ArrayList<EventInfo> res = new ArrayList<EventInfo>();
        for (EventInfo ei : events) {
            Collection instances;
            BwEvent ev = ei.getEvent();
            if (!ev.getRecurring().booleanValue()) {
                res.add(ei);
                continue;
            }
            CurrentAccess ca = ei.getCurrentAccess();
            Set oveis = ei.getOverrides();
            if (!Util.isEmpty((Collection)oveis)) {
                for (EventInfo oei : oveis) {
                    if (!oei.getEvent().inDateTimeRange(recurRetrieval.start.getDate(), recurRetrieval.end.getDate())) continue;
                    oei.setRetrievedEvent(ei);
                    res.add(oei);
                }
            }
            if ((instances = RecurUtil.getRecurrences((EventInfo)ei, (int)this.getAuthpars().getMaxYears(), (int)this.getAuthpars().getMaxInstances(), (String)recurRetrieval.getStartDate(), (String)recurRetrieval.getEndDate())) == null) {
                return res;
            }
            for (RecurUtil.Recurrence rec : instances) {
                if (rec.override != null) continue;
                BwEventAnnotation ann = new BwEventAnnotation();
                ann.setDtstart(rec.start);
                ann.setDtend(rec.end);
                ann.setRecurrenceId(rec.recurrenceId);
                ann.setOwnerHref(ev.getOwnerHref());
                ann.setOverride(Boolean.valueOf(true));
                ann.setTombstoned(Boolean.valueOf(false));
                ann.setName(ev.getName());
                ann.setUid(ev.getUid());
                ann.setTarget(ev);
                ann.setMaster(ev);
                BwEventProxy proxy = new BwEventProxy(ann);
                EventInfo oei = new EventInfo((BwEvent)proxy);
                oei.setCurrentAccess(ca);
                oei.setRetrievedEvent(ei);
                res.add(oei);
            }
        }
        return res;
    }

    private EventInfo makeInstance(EventInfo ei, String recurrenceId) {
        BwDateTime rstart;
        boolean dateOnly;
        BwEvent ev = ei.getEvent();
        if (!ev.getRecurring().booleanValue()) {
            return ei;
        }
        if (!Util.isEmpty((Collection)ei.getOverrides())) {
            for (EventInfo oei : ei.getOverrides()) {
                if (!oei.getEvent().getRecurrenceId().equals(recurrenceId)) continue;
                oei.setRetrievedEvent(ei);
                oei.setCurrentAccess(ei.getCurrentAccess());
                return oei;
            }
        }
        if (dateOnly = ev.getDtstart().getDateType()) {
            rstart = BwDateTime.makeBwDateTime((boolean)true, (String)recurrenceId.substring(0, 8), null);
        } else {
            DateTime dt;
            try {
                dt = new DateTime(recurrenceId);
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
            DtStart ds = ev.getDtstart().makeDtStart();
            dt.setTimeZone(ds.getTimeZone());
            rstart = BwDateTime.makeBwDateTime((Date)dt);
        }
        BwDateTime rend = rstart.addDuration(BwDuration.makeDuration((String)ev.getDuration()));
        BwEventAnnotation ann = new BwEventAnnotation();
        ann.setDtstart(rstart);
        ann.setDtend(rend);
        ann.setRecurrenceId(recurrenceId);
        ann.setOwnerHref(ev.getOwnerHref());
        ann.setOverride(Boolean.valueOf(true));
        ann.setTombstoned(Boolean.valueOf(false));
        ann.setName(ev.getName());
        ann.setUid(ev.getUid());
        ann.setTarget(ev);
        ann.setMaster(ev);
        BwEventProxy proxy = new BwEventProxy(ann);
        EventInfo oei = new EventInfo((BwEvent)proxy);
        oei.setCurrentAccess(ei.getCurrentAccess());
        oei.setRetrievedEvent(ei);
        return oei;
    }

    public EventInfo get(String colPath, String name) throws CalFacadeException {
        return this.get(colPath, name, null);
    }

    public EventInfo get(String colPath, String name, String recurrenceId) throws CalFacadeException {
        EventInfo res = this.postProcess(this.getCal().getEvent(Util.buildPath((boolean)false, (String[])new String[]{colPath, "/", name})));
        int num = 0;
        if (res != null) {
            num = 1;
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        if (res == null) {
            return null;
        }
        if (recurrenceId == null) {
            return res;
        }
        return this.makeInstance(res, recurrenceId);
    }

    public EventInfo get(BwCalendar col, String name, String recurrenceId, List<String> retrieveList) throws CalFacadeException {
        String path;
        block7: {
            if (col == null || name == null) {
                throw new CalFacadeException("org.bedework.exception.badrequest");
            }
            if (col.getInternalAlias()) {
                String expr = "(vpath='" + SfpTokenizer.escapeQuotes((String)col.getPath()) + "') and (name='" + SfpTokenizer.escapeQuotes((String)name) + "')";
                SimpleFilterParser sfp = this.getSvc().getFilterParser();
                SimpleFilterParser.ParseResult pr = sfp.parse(expr, true, null);
                if (!pr.ok) {
                    throw new CalFacadeException("Failed to parse " + expr + ": message was " + pr.message);
                }
                Collection<EventInfo> evs = this.getEvents(null, pr.filter, null, null, (List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry>)RetrieveList.getRetrieveList(retrieveList), BwIndexer.DeletedState.noDeleted, RecurringRetrievalMode.overrides);
                if (evs.size() == 0) {
                    return null;
                }
                if (evs.size() == 1) {
                    return evs.iterator().next();
                }
                throw new CalFacadeException("Multiple results");
            }
            path = col.getPath();
            if (col.getCalType() == 11) {
                SortedSet eles = col.getEventList();
                for (EventListEntry ele : eles) {
                    if (!ele.getName().equals(name)) continue;
                    path = ele.getPath();
                    break block7;
                }
                return null;
            }
        }
        return this.get(path, name, null);
    }

    public Collection<EventInfo> getEvents(BwCalendar cal, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, BwIndexer.DeletedState delState, RecurringRetrievalMode recurRetrieval) throws CalFacadeException {
        Set<BwCalendar> cals = null;
        if (cal != null) {
            cals = Collections.singleton(cal);
        }
        Collection<EventInfo> res = this.getMatching(cals, filter, startDate, endDate, retrieveList, delState, recurRetrieval, false);
        int num = 0;
        if (res != null) {
            num = res.size();
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        return res;
    }

    public boolean delete(EventInfo ei, boolean sendSchedulingMessage) throws CalFacadeException {
        return this.delete(ei, false, sendSchedulingMessage);
    }

    public EventInfo.UpdateResult add(EventInfo ei, boolean noInvites, boolean schedulingInbox, boolean autoCreateCollection, boolean rollbackOnError) {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        try {
            Collection overrides;
            Integer maxAttendees;
            EventsI.RealiasResult raResp;
            if (this.getPrincipalInfo().getSubscriptionsOnly()) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.noAccess, (String)"User has read only access");
            }
            updResult.adding = true;
            updResult.hasChanged = true;
            BwEvent event = ei.getEvent();
            this.adjustEntities(ei);
            BwPreferences prefs = this.getPrefs();
            if (prefs != null) {
                GetEntitiesResponse resp = this.getSvc().getCategoriesHandler().getByUids((Collection)prefs.getDefaultCategoryUids());
                if (resp.isOk()) {
                    for (BwCategory cat : resp.getEntities()) {
                        event.addCategory(cat);
                    }
                } else {
                    return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)resp);
                }
            }
            if (!(raResp = this.reAlias(event)).isOk()) {
                return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)raResp);
            }
            this.assignGuid(event);
            if (!this.updateEntities(updResult, event)) {
                return updResult;
            }
            BwCalendar cal = this.validate(event, true, schedulingInbox, autoCreateCollection);
            if (cal == null) {
                throw new RuntimeException("No calendar for event");
            }
            if (event instanceof BwEventProxy) {
                BwEventProxy proxy = (BwEventProxy)event;
                BwEventAnnotation override = proxy.getRef();
                this.setupSharableEntity((BwShareableDbentity)override, this.getPrincipal().getPrincipalRef());
            } else {
                this.setupSharableEntity((BwShareableDbentity)event, this.getPrincipal().getPrincipalRef());
                if (ei.getNumContainedItems() > 0) {
                    for (EventInfo aei : ei.getContainedItems()) {
                        BwEvent av = aei.getEvent();
                        av.setParent(event);
                        this.setupSharableEntity((BwShareableDbentity)av, this.getPrincipal().getPrincipalRef());
                    }
                }
            }
            BwCalendar undereffedCal = cal;
            if (cal.getInternalAlias()) {
                boolean setCats = this.getSvc().getPars().getPublicAdmin();
                if (!setCats) {
                    cal = this.getCols().resolveAlias(cal, true, false);
                } else {
                    while (true) {
                        Set cats = cal.getCategories();
                        for (BwCategory cat : cats) {
                            event.addCategory(cat);
                        }
                        if (!cal.getInternalAlias()) break;
                        cal = this.getCols().resolveAlias(cal, false, false);
                    }
                }
                event.setColPath(cal.getPath());
            }
            if (!cal.getCalendarCollection()) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.noAccess);
            }
            if (!event.getPublick().booleanValue() && Util.isEmpty((Collection)event.getAlarms())) {
                this.setDefaultAlarms(ei, undereffedCal);
            }
            boolean schedulingObject = false;
            if (cal.getCollectionInfo().scheduling && (event.getOrganizerSchedulingObject().booleanValue() || event.getAttendeeSchedulingObject().booleanValue())) {
                schedulingObject = true;
            }
            if ((maxAttendees = this.getSvc().getAuthProperties().getMaxAttendeesPerInstance()) != null && !Util.isEmpty((Collection)event.getAttendees()) && event.getAttendees().size() > maxAttendees) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.limitExceeded, (String)"org.bedework.error.scheduling.toomany.attendees");
            }
            Timestamp currentTimestamp = this.getCurrentTimestamp();
            event.setDtstamps(currentTimestamp);
            if (schedulingObject) {
                event.updateStag(currentTimestamp);
            }
            if ((overrides = ei.getOverrideProxies()) != null) {
                for (BwEventProxy ovei : overrides) {
                    this.setScheduleState((BwEvent)ovei, true, schedulingInbox);
                    if (maxAttendees != null && !Util.isEmpty((Collection)ovei.getAttendees()) && ovei.getAttendees().size() > maxAttendees) {
                        return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.limitExceeded, (String)"org.bedework.error.scheduling.toomany.attendees");
                    }
                    ovei.setDtstamps(currentTimestamp);
                    if (cal.getCollectionInfo().scheduling && (ovei.getOrganizerSchedulingObject().booleanValue() || ovei.getAttendeeSchedulingObject().booleanValue())) {
                        schedulingObject = true;
                    }
                    if (ovei.getOrganizerSchedulingObject().booleanValue()) {
                        for (BwAttendee att : ovei.getAttendees()) {
                            if (!att.getPartstat().equals("NEEDS-ACTION")) continue;
                            att.setRsvp(true);
                        }
                    }
                    if (schedulingObject) {
                        ovei.updateStag(currentTimestamp);
                    }
                    BwEventAnnotation ann = ovei.getRef();
                    ann.setColPath(event.getColPath());
                    ann.setName(event.getName());
                }
            }
            if (event.getOrganizerSchedulingObject().booleanValue()) {
                for (Object att : event.getAttendees()) {
                    if (!att.getPartstat().equals("NEEDS-ACTION")) continue;
                    att.setRsvp(true);
                }
            }
            CoreEventsI.UpdateEventResult uer = this.getCal().addEvent(ei, schedulingInbox, rollbackOnError);
            if (ei.getNumContainedItems() > 0) {
                for (EventInfo oei : ei.getContainedItems()) {
                    oei.getEvent().setName(event.getName());
                    CoreEventsI.UpdateEventResult auer = this.getCal().addEvent(oei, schedulingInbox, rollbackOnError);
                    if (auer.errorCode == null) continue;
                    return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.failed, (String)("Status " + auer.errorCode + " from addEvent"));
                }
            }
            updResult.failedOverrides = uer.failedOverrides;
            if (!noInvites) {
                if (event.getAttendeeSchedulingObject().booleanValue()) {
                    updResult.reply = true;
                }
                if (cal.getCollectionInfo().scheduling && schedulingObject) {
                    SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                    if (this.debug()) {
                        this.debug("schedule event");
                    }
                    sched.implicitSchedule(ei, false);
                }
            }
            return updResult;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            this.getSvc().rollbackTransaction();
            this.reindex(ei);
            return (EventInfo.UpdateResult)Response.error((Response)updResult, (Throwable)t);
        }
    }

    public void reindex(EventInfo ei) {
        try {
            this.getCal().reindex(ei);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites) {
        return this.update(ei, noInvites, null, false, true);
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites, String fromAttUri) {
        return this.update(ei, noInvites, fromAttUri, false, false);
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites, String fromAttUri, boolean alwaysWrite, boolean clientUpdate) {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        try {
            boolean sendit;
            ChangeTable ct;
            boolean schedulingObject;
            BwEvent event = ei.getEvent();
            if (!this.updateEntities(updResult, event)) {
                return updResult;
            }
            BwCalendar cal = this.validate(event, false, false, false);
            if (cal == null) {
                throw new RuntimeException("No calendar for event");
            }
            this.adjustEntities(ei);
            EventsI.RealiasResult raResp = this.reAlias(event);
            if (!raResp.isOk()) {
                return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)raResp);
            }
            boolean organizerSchedulingObject = false;
            boolean attendeeSchedulingObject = false;
            if (cal.getCollectionInfo().scheduling) {
                organizerSchedulingObject = event.getOrganizerSchedulingObject();
                attendeeSchedulingObject = event.getAttendeeSchedulingObject();
            }
            boolean bl = schedulingObject = organizerSchedulingObject || attendeeSchedulingObject;
            if (schedulingObject && clientUpdate && !event.getSignificantChange() && (ct = event.getChangeset(this.getPrincipalHref())) != null) {
                event.setSignificantChange(ct.getSignificantChange());
            }
            if (event.getSignificantChange() && schedulingObject) {
                event.updateStag(this.getCurrentTimestamp());
            }
            boolean changed = alwaysWrite || this.checkChanges(ei, organizerSchedulingObject, attendeeSchedulingObject) || ei.getOverridesChanged();
            boolean sequenceChange = ei.getUpdResult().sequenceChange;
            boolean doReschedule = ei.getUpdResult().doReschedule;
            if (ei.getNumOverrides() > 0) {
                for (Object oei : ei.getOverrides()) {
                    this.setScheduleState(oei.getEvent(), false, false);
                    if (cal.getCollectionInfo().scheduling && oei.getEvent().getAttendeeSchedulingObject().booleanValue()) {
                        schedulingObject = true;
                        attendeeSchedulingObject = true;
                    }
                    if (this.checkChanges((EventInfo)oei, organizerSchedulingObject, attendeeSchedulingObject)) {
                        changed = true;
                        if (oei.getUpdResult().sequenceChange) {
                            sequenceChange = true;
                        }
                    }
                    if (schedulingObject) {
                        oei.getEvent().updateStag(this.getCurrentTimestamp());
                    }
                    doReschedule = doReschedule || oei.getUpdResult().doReschedule;
                }
            }
            if (!changed) {
                if (this.debug()) {
                    this.debug("No changes to event: returning");
                }
                return ei.getUpdResult();
            }
            event.setDtstamps(this.getCurrentTimestamp());
            if (organizerSchedulingObject && sequenceChange) {
                event.setSequence(event.getSequence() + 1);
            }
            CoreEventsI.UpdateEventResult uer = this.getCal().updateEvent(ei);
            updResult.deletedInstances = uer.deleted;
            updResult.fromAttUri = fromAttUri;
            if (noInvites || !schedulingObject || !event.getSignificantChange()) {
                if (this.debug() && !noInvites && schedulingObject) {
                    this.debug("Skipping a scheduling object with insignificant changes?");
                }
                return updResult;
            }
            if (organizerSchedulingObject) {
                for (Object att : event.getAttendees()) {
                    if (!att.getPartstat().equals("NEEDS-ACTION")) continue;
                    att.setRsvp(true);
                }
            }
            boolean bl2 = sendit = organizerSchedulingObject || updResult.reply;
            if (!sendit && !Util.isEmpty((Collection)ei.getOverrides())) {
                for (EventInfo oei : ei.getOverrides()) {
                    if (!oei.getUpdResult().reply) continue;
                    sendit = true;
                    break;
                }
            }
            if (sendit) {
                SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                sched.implicitSchedule(ei, false);
            }
            return updResult;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            this.getSvc().rollbackTransaction();
            this.reindex(ei);
            return (EventInfo.UpdateResult)Response.error((Response)updResult, (Throwable)t);
        }
    }

    private boolean checkChanges(EventInfo ei, boolean organizerSchedulingObject, boolean attendeeSchedulingObject) throws CalFacadeException {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        if (ei.getChangeset(this.getPrincipalHref()).isEmpty()) {
            updResult.hasChanged = true;
            if (attendeeSchedulingObject) {
                updResult.reply = true;
            }
            return true;
        }
        if (this.debug()) {
            ei.getChangeset(this.getPrincipalHref()).dumpEntries();
        }
        ChangeTable ct = ei.getChangeset(this.getPrincipalHref());
        Collection ctes = ct.getEntries();
        updResult.sequenceChange = ct.getSequenceChangeNeeded();
        for (ChangeTableEntry cte : ctes) {
            BwIcalPropertyInfo.BwIcalPropertyInfoEntry pie;
            if (!cte.getChanged()) continue;
            updResult.hasChanged = true;
            PropertyIndex.PropertyInfoIndex pi = cte.getIndex();
            if (!organizerSchedulingObject && pi.equals((Object)PropertyIndex.PropertyInfoIndex.ORGANIZER)) {
                BwOrganizer oldOrg = (BwOrganizer)cte.getOldVal();
                BwOrganizer newOrg = (BwOrganizer)cte.getNewVal();
                if (oldOrg == null || newOrg == null || !oldOrg.getOrganizerUri().equals(newOrg.getOrganizerUri())) {
                    throw new CalFacadeForbidden(CaldavTags.attendeeAllowed, "Cannot change organizer");
                }
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.ATTENDEE) || pi.equals((Object)PropertyIndex.PropertyInfoIndex.VOTER)) {
                updResult.deletedAttendees = cte.getRemovedValues();
                if (attendeeSchedulingObject) {
                    updResult.reply = true;
                } else if (!Util.isEmpty((Collection)updResult.deletedAttendees)) {
                    updResult.sequenceChange = true;
                }
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.POLL_WINNER) && !attendeeSchedulingObject) {
                updResult.pollWinner = ei.getEvent().getPollWinner();
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.POLL_ITEM) && attendeeSchedulingObject) {
                updResult.reply = true;
            }
            if (!organizerSchedulingObject || !(pie = BwIcalPropertyInfo.getPinfo((PropertyIndex.PropertyInfoIndex)cte.getIndex())).getReschedule()) continue;
            updResult.doReschedule = true;
        }
        return updResult.hasChanged;
    }

    public void markDeleted(BwEvent event) throws CalFacadeException {
        BwEventProxy proxy = BwEventProxy.makeAnnotation((BwEvent)event, (String)event.getOwnerHref(), (boolean)false);
        BwCalendar cal = this.getCal().getSpecialCalendar(null, (BwPrincipal)this.getPrincipal(), (int)3, (boolean)true, (int)1).cal;
        proxy.setOwnerHref(this.getPrincipal().getPrincipalRef());
        proxy.setDeleted(true);
        proxy.setColPath(cal.getPath());
        this.add(new EventInfo((BwEvent)proxy), true, false, false, false);
    }

    public EventsI.CopyMoveStatus copyMoveNamed(EventInfo fromEi, BwCalendar to, String name, boolean copy, boolean overwrite, boolean newGuidOK) throws CalFacadeException {
        BwEvent ev = fromEi.getEvent();
        String fromPath = ev.getColPath();
        boolean sameCal = fromPath.equals(to.getPath());
        if (name == null) {
            name = ev.getName();
        }
        if (sameCal && name.equals(ev.getName())) {
            return EventsI.CopyMoveStatus.noop;
        }
        try {
            EventInfo destEi = this.get(to.getPath(), name);
            if (destEi != null) {
                if (!overwrite) {
                    return EventsI.CopyMoveStatus.destinationExists;
                }
                if (!destEi.getEvent().getUid().equals(ev.getUid())) {
                    return EventsI.CopyMoveStatus.changedUid;
                }
            }
            if (!copy) {
                if (!sameCal) {
                    BwCalendar from = this.getCols().get(fromPath);
                    this.getCal().moveEvent(ev, from, to);
                    this.getCal().touchCalendar(from);
                } else {
                    ev.setName(name);
                }
                ev.updateStag(this.getCurrentTimestamp());
                this.update(fromEi, false, null);
            } else {
                BwEvent newEvent = (BwEvent)ev.clone();
                newEvent.setName(name);
                newEvent.setAccess(null);
                EventInfo newEi = new EventInfo(newEvent);
                if (fromEi.getOverrideProxies() != null) {
                    for (BwEventProxy proxy : fromEi.getOverrideProxies()) {
                        newEi.addOverride(new EventInfo((BwEvent)proxy.clone(newEvent, newEvent)));
                    }
                }
                if (sameCal && newGuidOK) {
                    newEvent.setUid(null);
                    this.assignGuid(newEvent);
                }
                if (destEi != null) {
                    this.delete(destEi, false);
                }
                newEvent.setColPath(to.getPath());
                newEvent.updateStag(this.getCurrentTimestamp());
                this.add(newEi, true, false, false, true);
            }
            if (destEi != null) {
                return EventsI.CopyMoveStatus.ok;
            }
            return EventsI.CopyMoveStatus.created;
        }
        catch (CalFacadeException cfe) {
            if (cfe.getMessage().equals("org.bedework.exception.duplicateguid")) {
                return EventsI.CopyMoveStatus.duplicateUid;
            }
            throw cfe;
        }
    }

    public void claim(BwEvent ev) {
        ev.setOwnerHref(null);
        ev.setCreatorHref(null);
        this.setupSharableEntity((BwShareableDbentity)ev, this.getPrincipal().getPrincipalRef());
    }

    public EventsI.RealiasResult reAlias(BwEvent ev) {
        EventsI.RealiasResult resp = new EventsI.RealiasResult(new TreeSet());
        List aliases = ev.getXproperties("X-BEDEWORK-ALIAS");
        if (!Util.isEmpty((Collection)aliases)) {
            for (BwXproperty alias : aliases) {
                this.doCats(resp, alias.getValue(), ev);
            }
        }
        this.doCats(resp, ev.getColPath(), ev);
        return resp;
    }

    public InstancesResponse getInstances(GetInstancesRequest req) {
        InstancesResponse resp = new InstancesResponse();
        resp.setId(req.getId());
        if (!req.validate((Response)resp)) {
            return resp;
        }
        BwEventObj ev = new BwEventObj();
        try {
            BwDateTime st = req.getStartDt();
            ev.setDtstart(st);
            ev.setDtend(req.getEndDt());
            ev.addRrule(req.getRrule());
            if (!Util.isEmpty((Collection)req.getExdates())) {
                for (String dt : req.getExdates()) {
                    ev.addExdate(BwDateTime.makeBwDateTime((boolean)st.getDateType(), (String)dt, (String)st.getTzid()));
                }
            }
            if (!Util.isEmpty((Collection)req.getRdates())) {
                for (String dt : req.getRdates()) {
                    ev.addRdate(BwDateTime.makeBwDateTime((boolean)st.getDateType(), (String)dt, (String)st.getTzid()));
                }
            }
            RecurUtil.RecurPeriods rp = RecurUtil.getPeriods((BwEvent)ev, (int)this.getAuthpars().getMaxYears(), (int)this.getAuthpars().getMaxInstances(), (String)req.getBegin(), (String)req.getEnd());
            resp.setInstances(rp.instances);
            return resp;
        }
        catch (Throwable t) {
            return (InstancesResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    private void doCats(EventsI.RealiasResult resp, String colHref, BwEvent ev) {
        try {
            Set cats = this.getCols().getCategorySet(colHref);
            if (Util.isEmpty((Collection)cats)) {
                return;
            }
            resp.getCats().addAll(cats);
            for (BwCategory cat : cats) {
                if (!ev.addCategory(cat)) continue;
                ChangeTable changes = ev.getChangeset(this.getPrincipalHref());
                ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
                cte.addAddedValue((Object)cat);
            }
        }
        catch (Throwable t) {
            Response.error((Response)new EventsI.RealiasResult(null), (String)t.getMessage());
        }
    }

    public EventsI.SetEntityCategoriesResult setEntityCategories(CategorisedEntity ent, Set<BwCategory> extraCats, Set<String> defCatUids, Set<String> allDefCatUids, Collection<String> strCatUids, ChangeTable changes) throws CalFacadeException {
        BwCategory entcat;
        EventsI.SetEntityCategoriesResult secr = new EventsI.SetEntityCategoriesResult();
        Set entcats = ent.getCategories();
        HashMap<String, BwCategory> entcatMap = new HashMap<String, BwCategory>();
        if (!Util.isEmpty((Collection)entcats)) {
            for (Object entcat2 : entcats) {
                entcatMap.put(entcat2.getUid(), (BwCategory)entcat2);
            }
        }
        if (Util.isEmpty(strCatUids) && Util.isEmpty(extraCats) && Util.isEmpty(defCatUids) && Util.isEmpty(allDefCatUids)) {
            if (!Util.isEmpty((Collection)entcats)) {
                if (changes != null) {
                    ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
                    cte.setRemovedValues(new ArrayList(entcats));
                }
                secr.numRemoved = entcats.size();
                entcats.clear();
            }
            secr.rcode = 0;
            return secr;
        }
        TreeSet<BwCategory> cats = new TreeSet<BwCategory>();
        if (extraCats != null) {
            cats.addAll(extraCats);
        }
        if (!Util.isEmpty(defCatUids)) {
            for (String string : defCatUids) {
                BwCategory cat = (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(string);
                if (cat == null) continue;
                cats.add(cat);
            }
        }
        if (!Util.isEmpty(allDefCatUids) && entcats != null) {
            for (String string : allDefCatUids) {
                entcat = (BwCategory)entcatMap.get(string);
                if (entcat == null) continue;
                cats.add(entcat);
            }
        }
        if (!Util.isEmpty(strCatUids)) {
            for (String string : strCatUids) {
                entcat = (BwCategory)entcatMap.get(string);
                if (entcat != null) {
                    cats.add(entcat);
                    continue;
                }
                BwCategory cat = (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(string);
                if (cat == null) continue;
                cats.add(cat);
            }
        }
        ArrayList<BwCategory> toRemove = new ArrayList<BwCategory>();
        if (entcats != null) {
            for (BwCategory evcat : entcats) {
                if (cats.contains(evcat)) {
                    cats.remove(evcat);
                    continue;
                }
                toRemove.add(evcat);
            }
        }
        for (BwCategory cat : cats) {
            ent.addCategory(cat);
            ++secr.numAdded;
        }
        for (BwCategory cat : toRemove) {
            if (!entcats.remove(cat)) continue;
            ++secr.numRemoved;
        }
        if (changes != null && secr.numAdded > 0 && secr.numRemoved > 0) {
            ChangeTableEntry changeTableEntry = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
            changeTableEntry.setRemovedValues(toRemove);
            changeTableEntry.setAddedValues(cats);
        }
        secr.rcode = 0;
        return secr;
    }

    boolean updateEntities(EventInfo.UpdateResult updResult, BwEvent event) {
        BwLocation loc;
        BwContact ct;
        Categories cathdlr = this.getSvc().getCategoriesHandler();
        Set cats = event.getCategories();
        TreeSet<BwCategory> removeCats = new TreeSet<BwCategory>();
        TreeSet<BwCategory> addCats = new TreeSet<BwCategory>();
        if (cats != null) {
            for (BwCategory cat : cats) {
                if (!cat.unsaved()) continue;
                EventProperties.EnsureEntityExistsResult eeer = cathdlr.ensureExists((BwEventProperty)cat, event.getOwnerHref());
                removeCats.add(cat);
                if (!eeer.isOk()) {
                    Response.fromResponse((Response)updResult, (Response)eeer);
                    return false;
                }
                addCats.add((BwCategory)eeer.getEntity());
            }
            for (BwCategory cat : removeCats) {
                event.removeCategory(cat);
            }
            for (BwCategory cat : addCats) {
                event.addCategory(cat);
            }
        }
        if ((ct = event.getContact()) != null) {
            EventProperties.EnsureEntityExistsResult eeers = this.getSvc().getContactsHandler().ensureExists((BwEventProperty)ct, ct.getOwnerHref());
            if (!eeers.isOk()) {
                Response.fromResponse((Response)updResult, (Response)eeers);
                return false;
            }
            if (eeers.added) {
                ++updResult.contactsAdded;
            }
            event.setContact((BwContact)eeers.getEntity());
        }
        if ((loc = event.getLocation()) != null) {
            EventProperties.EnsureEntityExistsResult eeerl = this.getSvc().getLocationsHandler().ensureExists((BwEventProperty)loc, loc.getOwnerHref());
            if (!eeerl.isOk()) {
                Response.fromResponse((Response)updResult, (Response)eeerl);
                return false;
            }
            if (eeerl.added) {
                ++updResult.locationsAdded;
            }
            event.setLocation((BwLocation)eeerl.getEntity());
        }
        return true;
    }

    Collection<EventInfo> getMatching(Collection<BwCalendar> cals, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, BwIndexer.DeletedState delState, RecurringRetrievalMode recurRetrieval, boolean freeBusy) throws CalFacadeException {
        TreeSet<EventInfo> ts = new TreeSet<EventInfo>();
        if (filter != null && filter.equals(BooleanFilter.falseFilter)) {
            return ts;
        }
        ArrayList<BwCalendar> calSet = null;
        if (cals != null) {
            calSet = new ArrayList<BwCalendar>();
            for (BwCalendar cal : cals) {
                this.buildCalendarSet(calSet, cal, freeBusy);
            }
        }
        ts.addAll(this.postProcess(this.getCal().getEvents(calSet, filter, startDate, endDate, retrieveList, delState, recurRetrieval, freeBusy)));
        return ts;
    }

    boolean isVisible(BwCalendar col, String entityName) throws CalFacadeException {
        return this.getEvent(col, entityName, null) != null;
    }

    Set<EventInfo> getSynchEvents(String path, String lastmod) throws CalFacadeException {
        return this.postProcess(this.getCal().getSynchEvents(path, lastmod));
    }

    public boolean delete(EventInfo ei, boolean scheduling, boolean sendSchedulingMessage) throws CalFacadeException {
        return this.delete(ei, scheduling, sendSchedulingMessage, false);
    }

    boolean delete(EventInfo ei, boolean scheduling, boolean sendSchedulingMessage, boolean reallyDelete) throws CalFacadeException {
        BwEvent event;
        block13: {
            if (ei == null) {
                return false;
            }
            event = ei.getEvent();
            if (!event.getTombstoned().booleanValue()) {
                BwCalendar cal = this.getCols().get(event.getColPath());
                boolean schedulingObject = false;
                boolean organizerSchedulingObject = false;
                this.setScheduleState(event, false, false);
                if (cal.getCollectionInfo().scheduling && (event.getOrganizerSchedulingObject().booleanValue() || event.getAttendeeSchedulingObject().booleanValue())) {
                    schedulingObject = true;
                    organizerSchedulingObject = event.getOrganizerSchedulingObject();
                }
                if (!schedulingObject && event.getRecurring().booleanValue() && !Util.isEmpty((Collection)ei.getOverrideProxies())) {
                    for (BwEventProxy ove : ei.getOverrideProxies()) {
                        this.setScheduleState((BwEvent)ove, false, false);
                        if (!cal.getCollectionInfo().scheduling || !ove.getOrganizerSchedulingObject().booleanValue() && !ove.getAttendeeSchedulingObject().booleanValue()) continue;
                        schedulingObject = true;
                        organizerSchedulingObject = ove.getOrganizerSchedulingObject();
                        break;
                    }
                }
                if (sendSchedulingMessage && schedulingObject) {
                    try {
                        SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                        if (!organizerSchedulingObject) {
                            sched.sendReply(ei, 2, null);
                        } else {
                            EventInfo.UpdateResult uer = ei.getUpdResult();
                            uer.deleting = true;
                            event.setSequence(event.getSequence() + 1);
                            sched.implicitSchedule(ei, false);
                        }
                    }
                    catch (CalFacadeException cfe) {
                        if (!this.debug()) break block13;
                        this.error(cfe);
                    }
                }
            }
        }
        if (!this.getCal().deleteEvent((EventInfo)ei, (boolean)scheduling, (boolean)reallyDelete).eventDeleted) {
            this.getSvc().rollbackTransaction();
            return false;
        }
        if (event.getEntityType() != 5) {
            return true;
        }
        for (EventInfo aei : ei.getContainedItems()) {
            if (this.getCal().deleteEvent((EventInfo)aei, (boolean)scheduling, (boolean)true).eventDeleted) continue;
            this.getSvc().rollbackTransaction();
            return false;
        }
        return true;
    }

    private void adjustEntities(EventInfo event) {
    }

    private void buildCalendarSet(Collection<BwCalendar> cals, BwCalendar calendar, boolean freeBusy) throws CalFacadeException {
        if (calendar == null) {
            return;
        }
        int desiredAccess = 1;
        if (freeBusy) {
            desiredAccess = 4;
        }
        if ((calendar = this.getCols().get(calendar.getPath())) == null) {
            return;
        }
        if (!this.getSvc().checkAccess((BwShareableDbentity<?>)calendar, desiredAccess, true).getAccessAllowed()) {
            return;
        }
        if (calendar.getInternalAlias()) {
            BwCalendar saveColl = calendar;
            this.getCols().resolveAlias(calendar, true, freeBusy);
            while (calendar.getInternalAlias()) {
                if ((calendar = calendar.getAliasTarget()) != null) continue;
                saveColl.setLastRefreshStatus("403: Forbidden");
                return;
            }
        }
        if (calendar.getCalendarCollection() || calendar.getExternalSub() || cals.isEmpty() && calendar.getSpecial()) {
            cals.add(calendar);
            return;
        }
        if (calendar.getCalType() != 0) {
            return;
        }
        for (BwCalendar c : this.getCols().getChildren(calendar)) {
            this.buildCalendarSet(cals, c, freeBusy);
        }
    }

    private BwCalendar validate(BwEvent ev, boolean adding, boolean schedulingInbox, boolean autoCreateCollection) throws CalFacadeException {
        if (ev.getColPath() == null) {
            throw new CalFacadeException("org.bedework.exception.noeventcalendar");
        }
        if (ev.getNoStart() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "noStart");
        }
        if (ev.getDtstart() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "dtstart");
        }
        if (ev.getDtend() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "dtend");
        }
        if (ev.getDuration() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "duration");
        }
        if (ev.getRecurring() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "recurring");
        }
        if (ev.getEntityType() != 4 && ev.getSummary() == null) {
            throw new CalFacadeException("org.bedework.exception.missingeventproperty", "summary");
        }
        String checkedString = this.checkString(ev.getSummary());
        if (checkedString != null) {
            ev.setSummary(checkedString);
        }
        if ((checkedString = this.checkString(ev.getDescription())) != null) {
            ev.setDescription(checkedString);
        }
        this.setScheduleState(ev, adding, schedulingInbox);
        BwCalendar col = this.getCols().get(ev.getColPath());
        if (col == null) {
            int calType;
            String entityType;
            if (!autoCreateCollection) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound");
            }
            switch (entityType = IcalDefs.entityTypeIcalNames[ev.getEntityType()]) {
                case "VEVENT": {
                    calType = 1;
                    break;
                }
                case "VTODO": {
                    calType = 15;
                    break;
                }
                case "VPOLL": {
                    calType = 12;
                    break;
                }
                default: {
                    throw new CalFacadeException("org.bedework.exception.noeventcalendar");
                }
            }
            CoreCalendarsI.GetSpecialCalendarResult gscr = this.getCal().getSpecialCalendar(null, this.getPrincipal(), calType, true, 25);
            if (gscr.cal == null) {
                throw new CalFacadeException("org.bedework.exception.noeventcalendar");
            }
            col = gscr.cal;
        }
        if (this.getPars().getPublicAdmin() && !this.getPars().getService()) {
            Preferences prefs = (Preferences)this.getSvc().getPrefsHandler();
            prefs.updateAdminPrefs(false, col, ev.getCategories(), ev.getLocation(), ev.getContact());
        }
        return col;
    }

    private String checkString(String val) {
        if (val == null) {
            return null;
        }
        String s1 = val.replaceAll("(\\r|\\n|\\r\\n)+", "\n");
        boolean changed = !s1.equals(val);
        String s2 = s1.replaceAll("[\u0000-\t\u000b-\f\u000e-\u0019\u007f]+", "");
        if (!s2.equals(s1)) {
            changed = true;
        }
        if (!changed) {
            return null;
        }
        return s2;
    }

    private void setScheduleState(BwEvent ev, boolean adding, boolean schedulingInbox) throws CalFacadeException {
        boolean weAreOrganizer;
        ev.setOrganizerSchedulingObject(Boolean.valueOf(false));
        ev.setAttendeeSchedulingObject(Boolean.valueOf(false));
        if (ev.getEntityType() != 0 && ev.getEntityType() != 2 && ev.getEntityType() != 7) {
            return;
        }
        BwOrganizer org = ev.getOrganizer();
        Set atts = ev.getAttendees();
        if (Util.isEmpty((Collection)atts) || org == null) {
            return;
        }
        String curPrincipal = this.getSvc().getPrincipal().getPrincipalRef();
        Directories dirs = this.getSvc().getDirectories();
        BwPrincipal evPrincipal = dirs.caladdrToPrincipal(org.getOrganizerUri());
        boolean bl = weAreOrganizer = evPrincipal != null && evPrincipal.getPrincipalRef().equals(curPrincipal);
        if (!weAreOrganizer) {
            for (BwAttendee att : atts) {
                evPrincipal = this.getSvc().getDirectories().caladdrToPrincipal(att.getAttendeeUri());
                if (evPrincipal == null || !evPrincipal.getPrincipalRef().equals(curPrincipal)) continue;
                ev.setAttendeeSchedulingObject(Boolean.valueOf(true));
                break;
            }
            return;
        }
        ev.setOrganizerSchedulingObject(Boolean.valueOf(true));
        ChangeTable chg = ev.getChangeset(this.getPrincipalHref());
        TreeSet<BwAttendee> groups = new TreeSet<BwAttendee>();
        if (!schedulingInbox) {
            ChangeTableEntry cte = chg.getEntry(PropertyIndex.PropertyInfoIndex.ATTENDEE);
            block4: for (BwAttendee att : atts) {
                BwPrincipal attPrincipal;
                if (CuType.GROUP.getValue().equals(att.getCuType())) {
                    groups.add(att);
                }
                if ((attPrincipal = this.getSvc().getDirectories().caladdrToPrincipal(att.getAttendeeUri())) != null && attPrincipal.getPrincipalRef().equals(curPrincipal) || att.getPartstat().equals("NEEDS-ACTION")) continue;
                if (adding) {
                    att.setPartstat("NEEDS-ACTION");
                    continue;
                }
                if (cte == null || Util.isEmpty((Collection)cte.getAddedValues())) continue;
                for (Object o : cte.getAddedValues()) {
                    BwAttendee chgAtt = (BwAttendee)o;
                    if (!chgAtt.getCn().equals(att.getCn())) continue;
                    att.setPartstat("NEEDS-ACTION");
                    continue block4;
                }
            }
        }
        try {
            boolean vpoll;
            Map voters = null;
            boolean bl2 = vpoll = ev.getEntityType() == 7;
            if (vpoll) {
                voters = IcalUtil.parseVpollVoters((BwEvent)ev);
                ev.clearVoters();
            }
            for (BwAttendee att : groups) {
                BwPrincipalInfo pi;
                Holder trunc = new Holder();
                List groupPis = dirs.find(att.getAttendeeUri(), att.getCuType(), true, trunc);
                if (groupPis == null || groupPis.size() != 1 || (pi = (BwPrincipalInfo)groupPis.get(0)).getMembers() == null) continue;
                CalendarAddress groupVoterCa = null;
                PropertyList pl = null;
                if (vpoll) {
                    Participant groupVoter = (Participant)voters.get(att.getAttendeeUri());
                    if (groupVoter == null) {
                        if (!this.debug()) continue;
                        this.warn("No voter found for " + att.getAttendeeUri());
                        continue;
                    }
                    voters.remove(att.getAttendeeUri());
                    pl = groupVoter.getProperties();
                    groupVoterCa = (CalendarAddress)groupVoter.getProperty("CALENDAR-ADDRESS");
                }
                ev.removeAttendee(att);
                chg.changed(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)att, null);
                for (BwPrincipalInfo mbrPi : pi.getMembers()) {
                    if (mbrPi.getCaladruri() == null) continue;
                    BwAttendee mbrAtt = new BwAttendee();
                    mbrAtt.setType(att.getType());
                    mbrAtt.setAttendeeUri(mbrPi.getCaladruri());
                    mbrAtt.setCn(mbrPi.getEmail());
                    mbrAtt.setCuType(mbrPi.getKind());
                    mbrAtt.setMember(att.getAttendeeUri());
                    ev.addAttendee(mbrAtt);
                    chg.addValue(PropertyIndex.PropertyInfoIndex.ATTENDEE, (Object)mbrAtt);
                    if (!vpoll) continue;
                    Participant voter = IcalUtil.setVoter((BwAttendee)mbrAtt);
                    ev.addVoter(voter.toString());
                }
            }
            if (vpoll) {
                for (Participant v : voters.values()) {
                    ev.addVoter(v.toString());
                }
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        if (ev instanceof BwEventProxy) {
            return;
        }
        if ("Jasig Scheduling Assistant".equals(this.getPars().getClientId())) {
            ev.addXproperty(new BwXproperty("X-BEDEWORK-SCHED-ASSIST", null, "true"));
        }
    }

    private EventInfo postProcess(CoreEventInfo cei) {
        if (cei == null) {
            return null;
        }
        BwEvent ev = cei.getEvent();
        if (ev instanceof BwEventAnnotation) {
            ev = new BwEventProxy((BwEventAnnotation)ev);
        }
        TreeSet<EventInfo> overrides = new TreeSet<EventInfo>();
        if (cei.getOverrides() != null) {
            for (CoreEventInfo ocei : cei.getOverrides()) {
                BwEventProxy op = (BwEventProxy)ocei.getEvent();
                overrides.add(new EventInfo((BwEvent)op));
            }
        }
        EventInfo ei = new EventInfo(ev, overrides);
        if (cei.getNumContainedItems() > 0) {
            for (CoreEventInfo ccei : cei.getContainedItems()) {
                BwEvent cv = ccei.getEvent();
                ei.addContainedItem(new EventInfo(cv));
            }
        }
        ei.setCurrentAccess(cei.getCurrentAccess());
        return ei;
    }

    private Set<EventInfo> postProcess(Collection<CoreEventInfo> ceis) {
        TreeSet<EventInfo> eis = new TreeSet<EventInfo>();
        for (CoreEventInfo cei : ceis) {
            eis.add(this.postProcess(cei));
        }
        return eis;
    }

    private void setDefaultAlarms(EventInfo ei, BwCalendar col) throws CalFacadeException {
        boolean isTask;
        BwEvent event = ei.getEvent();
        boolean isEvent = event.getEntityType() == 0;
        boolean bl = isTask = event.getEntityType() == 2;
        if (!isEvent && !isTask) {
            return;
        }
        boolean isDate = event.getDtstart().getDateType();
        String al = this.getDefaultAlarmDef(col, isEvent, isDate);
        if (al == null) {
            al = this.getDefaultAlarmDef(this.getCols().getHome(), isEvent, isDate);
        }
        if (al == null || al.length() == 0) {
            return;
        }
        Set<BwAlarm> alarms = this.compileAlarms(al);
        if (alarms == null) {
            return;
        }
        for (BwAlarm alarm : alarms) {
            alarm.addXproperty(new BwXproperty("X-APPLE-DEFAULT-ALARM", null, "TRUE"));
            event.addAlarm(alarm);
            ei.getChangeset(this.getPrincipalHref()).addValue(PropertyIndex.PropertyInfoIndex.VALARM, (Object)alarm);
        }
    }

    private String getDefaultAlarmDef(BwCalendar col, boolean isEvent, boolean isDate) {
        if (col == null) {
            return null;
        }
        QName pname = isEvent ? (isDate ? CaldavTags.defaultAlarmVeventDate : CaldavTags.defaultAlarmVeventDatetime) : (isDate ? CaldavTags.defaultAlarmVtodoDate : CaldavTags.defaultAlarmVtodoDatetime);
        return col.getProperty(NamespaceAbbrevs.prefixed((QName)pname));
    }

    public Set<BwAlarm> compileAlarms(String val) {
        try {
            StringReader sr = new StringReader(ValidateAlarmPrefix + val + ValidateAlarmSuffix);
            IcalTranslator trans = new IcalTranslator(this.getSvc().getIcalCallback());
            Icalendar ic = trans.fromIcal(null, (Reader)sr);
            if (ic == null || ic.getEventInfo() == null) {
                if (this.debug()) {
                    this.debug("Not single event");
                }
                return null;
            }
            EventInfo ei = ic.getEventInfo();
            BwEvent ev = ei.getEvent();
            Set alarms = ev.getAlarms();
            if (Util.isEmpty((Collection)alarms)) {
                return null;
            }
            return alarms;
        }
        catch (CalFacadeException cfe) {
            if (this.debug()) {
                this.error(cfe);
            }
            return null;
        }
    }
}

