/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import ietf.params.xml.ns.caldav.FilterType;
import java.util.Collection;
import org.bedework.caldav.util.filter.parse.EventQuery;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.responses.GetFilterDefResponse;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.FiltersI;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;

class Filters
extends CalSvcDb
implements FiltersI {
    Filters(CalSvc svci) {
        super(svci);
    }

    public SimpleFilterParser.ParseResult parse(BwFilterDef val) {
        String def = val.getDefinition();
        if (def.length() > 5 && def.startsWith("<?xml")) {
            SimpleFilterParser.ParseResult pr = new SimpleFilterParser.ParseResult();
            try {
                FilterType f = org.bedework.caldav.util.filter.parse.Filters.parse((String)def);
                EventQuery eq = org.bedework.caldav.util.filter.parse.Filters.getQuery((FilterType)f);
                val.setFilters(eq.filter);
                pr.ok = true;
            }
            catch (Throwable t) {
                pr.ok = false;
                pr.message = t.getMessage();
                pr.cfe = new CalFacadeException(t);
            }
            return pr;
        }
        String source = "BwFilterDef:" + val.getOwnerHref() + ":" + val.getName();
        SimpleFilterParser.ParseResult pr = this.getSvc().getFilterParser().parse(def, false, source);
        if (pr.ok) {
            val.setFilters(pr.filter);
        }
        return pr;
    }

    public void validate(String val) throws CalFacadeException {
        try {
            org.bedework.caldav.util.filter.parse.Filters.parse((String)val);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void save(BwFilterDef val) throws CalFacadeException {
        this.setupOwnedEntity((BwOwnedDbentity)val, this.getPrincipal().getPrincipalRef());
        this.validate(val.getDefinition());
        this.getCal().save(val, this.getEntityOwner(this.getPrincipal()));
    }

    public GetFilterDefResponse get(String name) {
        GetFilterDefResponse gfdr = new GetFilterDefResponse();
        try {
            BwFilterDef fdef = this.getCal().getFilterDef(name, this.getEntityOwner(this.getPrincipal()));
            if (fdef == null) {
                gfdr.setStatus(Response.Status.notFound);
            } else {
                gfdr.setStatus(Response.Status.ok);
                gfdr.setFilterDef(fdef);
            }
        }
        catch (CalFacadeException cfe) {
            gfdr.setStatus(Response.Status.failed);
            gfdr.setMessage(cfe.getLocalizedMessage());
        }
        return gfdr;
    }

    public Collection<BwFilterDef> getAll() throws CalFacadeException {
        BwPrincipal owner = this.getEntityOwner(this.getPrincipal());
        return this.getCal().getAllFilterDefs(owner);
    }

    public void update(BwFilterDef val) throws CalFacadeException {
        if (!this.getSvc().getSuperUser() && !this.getPrincipal().equals((Object)val.getOwnerHref())) {
            throw new CalFacadeAccessException();
        }
        this.getCal().update(val);
    }

    public void delete(String name) throws CalFacadeException {
        this.getCal().deleteFilterDef(name, this.getEntityOwner(this.getPrincipal()));
    }

    public SimpleFilterParser.ParseResult parseSort(String val) {
        return this.getSvc().getFilterParser().parseSort(val);
    }

    public int reindex(BwIndexer indexer) throws CalFacadeException {
        BwPrincipal owner = !this.isPublicAdmin() ? this.getPrincipal() : this.getPublicUser();
        Collection<BwFilterDef> filters = this.getAll();
        if (Util.isEmpty(filters)) {
            return 0;
        }
        for (BwFilterDef f : filters) {
            indexer.indexEntity((Object)f);
        }
        return filters.size();
    }
}

