/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeForbidden;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.ResourcesI;
import org.bedework.util.misc.Util;

class ResourcesImpl
extends CalSvcDb
implements ResourcesI {
    ResourcesImpl(CalSvc svci) {
        super(svci);
    }

    public boolean saveNotification(BwResource val) throws CalFacadeException {
        return this.save(val, true, true);
    }

    public boolean save(BwResource val, boolean returnIfExists) throws CalFacadeException {
        return this.save(val, false, returnIfExists);
    }

    public BwResource get(String path) throws CalFacadeException {
        return this.getCal().getResource(path, 1);
    }

    public void getContent(BwResource val) throws CalFacadeException {
        this.getCal().getResourceContent(val);
    }

    public List<BwResource> getAll(String path) throws CalFacadeException {
        return this.getCal().getResources(path, false, null, -1);
    }

    public List<BwResource> get(String path, int count) throws CalFacadeException {
        return this.getCal().getResources(path, false, null, count);
    }

    public void update(BwResource val, boolean updateContent) throws CalFacadeException {
        this.checkAccess((BwShareableDbentity)val, 5, false);
        try {
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().saveOrUpdate(val);
            if (updateContent && val.getContent() != null) {
                BwResourceContent rc = val.getContent();
                rc.setColPath(val.getColPath());
                rc.setName(val.getName());
                this.getCal().saveOrUpdateContent(val, rc);
            }
            this.touchCalendar(this.getCols().get(val.getColPath()));
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
    }

    public void delete(String path) throws CalFacadeException {
        this.getCal().deleteResource(path);
    }

    public boolean copyMove(BwResource val, String to, String name, boolean copy, boolean overwrite) throws CalFacadeException {
        try {
            this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
            BwCalendar collTo = this.getCols().get(to);
            if (collTo == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound", to);
            }
            if (collTo.getCalType() != 0) {
                throw new CalFacadeException("org.bedework.exception.badrequest", to);
            }
            int access = copy ? 5 : 9;
            this.checkAccess((BwShareableDbentity)collTo, access, false);
            BwResource r = this.getCal().getResource(Util.buildPath((boolean)false, (String[])new String[]{to, "/", val.getName()}), access);
            boolean createdNew = false;
            this.getContent(val);
            if (r != null) {
                if (!overwrite) {
                    throw new CalFacadeException("org.bedework.exception.targetexists", val.getName());
                }
                this.getContent(r);
                r.setContentType(val.getContentType());
                BwResourceContent rc = r.getContent();
                BwResourceContent toRc = val.getContent();
                r.setContentLength(toRc.getValue().length());
                r.updateLastmod(this.getCurrentTimestamp());
                rc.setValue(val.getContent().getValue());
                this.getCal().saveOrUpdate(r);
                this.getCal().saveOrUpdateContent(r, rc);
            } else {
                r = new BwResource();
                this.setupSharableEntity((BwShareableDbentity)r, this.getPrincipal().getPrincipalRef());
                r.setName(name);
                r.setColPath(collTo.getPath());
                r.setContentType(val.getContentType());
                r.setContentLength(val.getContentLength());
                r.updateLastmod(this.getCurrentTimestamp());
                this.getCal().saveOrUpdate(r);
                BwResourceContent fromRc = val.getContent();
                BwResourceContent rc = new BwResourceContent();
                rc.setColPath(collTo.getPath());
                rc.setName(val.getName());
                rc.setValue(fromRc.getValue());
                this.getCal().saveOrUpdateContent(val, rc);
                createdNew = true;
            }
            if (!copy) {
                BwCalendar collFrom = this.getCols().get(val.getColPath());
                this.checkAccess((BwShareableDbentity)collFrom, 14, false);
                this.getCal().delete(val);
                this.touchCalendar(val.getColPath());
            }
            this.touchCalendar(to);
            return createdNew;
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            throw new CalFacadeException(t);
        }
    }

    public int[] reindex(BwIndexer indexer, BwIndexer contentIndexer, BwIndexer collectionIndexer) throws CalFacadeException {
        Iterator<BwResource> ents = this.isPublicAdmin() ? this.getSvc().getPublicObjectIterator(BwResource.class) : this.getSvc().getPrincipalObjectIterator(BwResource.class);
        int resCt = 0;
        int resContentCt = 0;
        TreeSet<String> checkedCollections = new TreeSet<String>();
        while (ents.hasNext()) {
            BwResource ent = ents.next();
            if (!ent.getTombstoned()) {
                try {
                    this.getContent(ent);
                }
                catch (Throwable t) {
                    this.error(t);
                }
            }
            String parentPath = ent.getColPath();
            boolean create = true;
            if (!checkedCollections.contains(parentPath)) {
                block13: {
                    block12: {
                        try {
                            BwCalendar col = this.getSvc().getCalendarsHandler().get(parentPath);
                            if (col != null) {
                                create = false;
                                if (this.getSvc().getCalendarsHandler().getIdx(parentPath) == null) {
                                    collectionIndexer.indexEntity((Object)col);
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!this.debug()) break block12;
                            this.error(t);
                        }
                    }
                    if (create) {
                        CalSvcDb.SplitResult sr = this.splitUri(parentPath);
                        BwCalendar parent = new BwCalendar();
                        parent.setCalType(0);
                        parent.setColPath(sr.path);
                        parent.setPath(parentPath);
                        parent.setName(sr.name);
                        parent.setPublick(ent.getPublick());
                        parent.setOwnerHref(ent.getOwnerHref());
                        parent.setCreatorHref(ent.getCreatorHref());
                        try {
                            BwCalendar newCol = this.getSvc().getCalendarsHandler().add(parent, sr.path);
                            collectionIndexer.indexEntity((Object)newCol);
                        }
                        catch (Throwable t) {
                            if (!this.debug()) break block13;
                            this.error(t);
                        }
                    }
                }
                checkedCollections.add(parentPath);
            }
            indexer.indexEntity((Object)ent);
            ++resCt;
            if (ent.getContent() == null) continue;
            contentIndexer.indexEntity((Object)ent.getContent());
            ++resContentCt;
        }
        return new int[]{resCt, resContentCt};
    }

    List<BwResource> getSynchResources(String path, String lastmod) throws CalFacadeException {
        return this.getCal().getResources(path, true, lastmod, -1);
    }

    private boolean save(BwResource val, boolean forNotification, boolean returnIfExists) throws CalFacadeException {
        try {
            BwResource r;
            String path = val.getColPath();
            if (path == null) {
                throw new CalFacadeException("No col path for " + val.getName());
            }
            BwCalendar coll = this.getCols().get(path);
            if (coll == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound", path);
            }
            if (forNotification) {
                if (coll.getCalType() != 10) {
                    throw new CalFacadeException("org.bedework.exception.badrequest", path);
                }
            } else if (this.getPrincipalInfo().getSubscriptionsOnly()) {
                throw new CalFacadeForbidden("User has read only access");
            }
            if ((r = this.getCal().getResource(val.getHref(), 25)) != null) {
                if (returnIfExists) {
                    return false;
                }
                throw new CalFacadeException("org.bedework.exception.duplicate.resource", val.getName());
            }
            BwResourceContent rc = val.getContent();
            if (rc == null) {
                throw new CalFacadeException("org.bedework.exception.missing.resource.content");
            }
            this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
            val.setColPath(path);
            if (coll.getCalType() == 1 || coll.getCalType() == 8) {
                throw new CalFacadeException("org.bedework.exception.badrequest", path);
            }
            this.checkAccess((BwShareableDbentity)coll, 9, false);
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().add(val);
            rc.setColPath(val.getColPath());
            rc.setName(val.getName());
            this.getCal().addContent(val, rc);
            this.touchCalendar(coll);
            return true;
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
    }
}

