/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.calcorei.CoreEventInfo;
import org.bedework.calcorei.CoreEventsI;
import org.bedework.caldav.util.sharing.AccessType;
import org.bedework.caldav.util.sharing.InviteType;
import org.bedework.caldav.util.sharing.UserType;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwFilterDef;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.RestoreIntf;
import org.bedework.util.logging.Logged;
import org.bedework.util.xml.tagdefs.AppleServerTags;

class RestoreImpl
extends CalSvcDb
implements RestoreIntf {
    private Logged log;
    protected int currentMode = 1;
    private boolean transactionStarted;
    private int curBatchSize;
    private int batchSize;

    RestoreImpl(CalSvc svci) throws CalFacadeException {
        super(svci);
    }

    public void setLogger(Logged val) {
        this.log = val;
    }

    public void setBatchSize(int val) {
        this.batchSize = val;
    }

    public void endTransactionNow() throws Throwable {
        if (this.transactionStarted) {
            this.getSvc().endTransaction();
            this.getSvc().close();
        }
        this.transactionStarted = false;
        this.curBatchSize = 0;
    }

    public void endTransaction() throws Throwable {
        if (this.batchSize > 0 && this.curBatchSize < this.batchSize) {
            return;
        }
        this.endTransactionNow();
    }

    public void checkEmptySystem() throws Throwable {
        try {
            this.startTransaction();
            if (this.getSvc().getSysparsHandler().present()) {
                throw new CalFacadeException("System is not empty - restore terminated");
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreSyspars(BwSystem o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restorePrincipal(BwPrincipal o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate(o);
        }
        catch (Throwable t) {
            this.handleException(t, "Exception restoring user " + o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreAdminGroup(BwAdminGroup o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate((BwPrincipal)o);
            if (this.debug()) {
                this.log.debug("Saved admin group " + o);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void addAdminGroupMember(BwAdminGroup o, BwPrincipal pr) throws Throwable {
        try {
            this.startTransaction();
            this.getCal().addMember((BwGroup)o, pr, true);
        }
        finally {
            this.endTransaction();
        }
    }

    public BwAdminGroup getAdminGroup(String account) throws Throwable {
        this.startTransaction();
        return (BwAdminGroup)this.getCal().findGroup(account, true);
    }

    public void restoreAuthUser(BwAuthUser o) throws Throwable {
        try {
            this.startTransaction();
            this.getCal().saveOrUpdate((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreEvent(EventInfo ei) throws Throwable {
        try {
            this.startTransaction();
            CoreEventsI.UpdateEventResult uer = this.getCal().addEvent(ei, false, false);
            if (!uer.addedUpdated) {
                throw new CalFacadeException(uer.errorCode);
            }
            if (uer.failedOverrides != null) {
                this.error("Following overrides failed for event ");
                this.error(ei.getEvent().toString());
                for (BwEventProxy proxy : uer.failedOverrides) {
                    this.error(proxy.toString());
                }
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public BwEvent getEvent(BwPrincipal owner, String colPath, String recurrenceId, String uid) throws Throwable {
        this.startTransaction();
        Collection ceis = this.getCal().getEvent(colPath, uid);
        if (ceis.size() != 1) {
            this.error("Expected one event for {" + colPath + ", " + recurrenceId + ", " + uid + "} found " + ceis.size());
            return null;
        }
        CoreEventInfo ei = (CoreEventInfo)ceis.iterator().next();
        BwEvent ev = null;
        if (recurrenceId == null) {
            ev = ei.getEvent();
        } else {
            for (CoreEventInfo cei : ei.getOverrides()) {
                if (!cei.getEvent().getRecurrenceId().equals(recurrenceId)) continue;
                ev = cei.getEvent();
                break;
            }
        }
        if (ev == null) {
            return null;
        }
        if (ev instanceof BwEventAnnotation) {
            ev = new BwEventProxy((BwEventAnnotation)ev);
        }
        return ev;
    }

    public void restoreCategory(BwCategory o) throws Throwable {
        try {
            this.startTransaction();
            this.getCal().saveOrUpdate((BwEventProperty)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreCalSuite(BwCalSuite o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate(o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreLocation(BwLocation o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate((BwEventProperty)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreContact(BwContact o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate((BwEventProperty)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreFilter(BwFilterDef o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate((BwUnversionedDbentity)o);
        }
        finally {
            this.endTransaction();
        }
    }

    public void restoreResource(BwResource o) throws Throwable {
        try {
            this.startTransaction();
            o.markUnsaved();
            this.getCal().saveOrUpdate(o);
            BwResourceContent rc = o.getContent();
            rc.markUnsaved();
            rc.setValue(this.getSvc().getBlob(rc.getByteValue()));
            this.getCal().saveOrUpdate((BwUnversionedDbentity)rc);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUserPrefs(BwPreferences o) throws Throwable {
        try {
            this.startTransaction();
            BwPreferences p = this.getSvc().getPreferences(o.getOwnerHref());
            if (p != null) {
                this.warn("Found instance of preferences for " + o.getOwnerHref());
                o.setId(p.getId());
                p = (BwPreferences)this.getSvc().merge((BwUnversionedDbentity<?>)o);
            } else {
                p = o;
                Collection v = p.getViews();
                if (v != null) {
                    for (BwView view : v) {
                        view.markUnsaved();
                    }
                }
                p.markUnsaved();
            }
            this.getCal().saveOrUpdate(o);
        }
        finally {
            this.endTransaction();
        }
    }

    public BwCalendar getCalendar(String path) throws Throwable {
        this.startTransaction();
        return this.getCols().get(path);
    }

    public BwCategory getCategory(String uid) throws Throwable {
        this.startTransaction();
        return (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(uid);
    }

    public BwContact getContact(String uid) throws Throwable {
        this.startTransaction();
        return (BwContact)this.getSvc().getContactsHandler().getPersistent(uid);
    }

    public BwLocation getLocation(String uid) throws Throwable {
        this.startTransaction();
        return (BwLocation)this.getSvc().getLocationsHandler().getPersistent(uid);
    }

    @Override
    public BwPrincipal getPrincipal(String href) throws CalFacadeException {
        this.startTransaction();
        return this.getSvc().getUsersHandler().getPrincipal(href);
    }

    public void saveRootCalendar(BwCalendar val) throws Throwable {
        val.markUnsaved();
        try {
            this.startTransaction();
            this.getCal().saveOrUpdate((BwUnversionedDbentity)val);
        }
        finally {
            this.endTransaction();
        }
    }

    public void addCalendar(BwCalendar o) throws Throwable {
        o.markUnsaved();
        try {
            this.startTransaction();
            this.getCal().saveOrUpdate((BwUnversionedDbentity)o);
            ++this.curBatchSize;
        }
        finally {
            this.endTransaction();
        }
    }

    public RestoreIntf.FixAliasResult fixSharee(BwCalendar col, String shareeHref, AccessType a) throws CalFacadeException {
        String shareeCua;
        InviteType invite;
        UserType uentry;
        TreeSet<String> paths = new TreeSet<String>();
        BwCalendar curCol = col;
        while (curCol.getInternalAlias()) {
            if (paths.contains(curCol.getPath())) {
                return RestoreIntf.FixAliasResult.circular;
            }
            paths.add(curCol.getPath());
            try {
                curCol = this.getCols().resolveAliasIdx(curCol, false, false);
            }
            catch (CalFacadeAccessException ignored) {
                break;
            }
            if (curCol != null) continue;
            return RestoreIntf.FixAliasResult.broken;
        }
        if ((uentry = (invite = this.getSvc().getSharingHandler().getInviteStatus(col)).finduser(shareeCua = this.getSvc().getDirectories().userToCaladdr(shareeHref))) != null) {
            return RestoreIntf.FixAliasResult.ok;
        }
        uentry = new UserType();
        uentry.setHref(shareeCua);
        uentry.setInviteStatus(AppleServerTags.inviteAccepted);
        uentry.setAccess(a);
        invite.getUsers().add(uentry);
        try {
            col.setQproperty(AppleServerTags.invite, invite.toXml());
            this.getCols().update(col);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return RestoreIntf.FixAliasResult.reshared;
    }

    private void startTransaction() throws CalFacadeException {
        if (this.transactionStarted) {
            return;
        }
        this.getSvc().open();
        this.getSvc().beginTransaction();
        this.transactionStarted = true;
    }

    private void handleException(Throwable t, String msg) {
        if (this.log == null) {
            return;
        }
        this.log.error(msg, t);
    }

    public void info(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.info(msg);
    }

    public void warn(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.warn(msg);
    }

    public void error(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.error(msg);
    }
}

