/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.DirConfigProperties;
import org.bedework.calfacade.configs.LdapConfigProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeUnimplementedException;
import org.bedework.calsvc.directory.AbstractDirImpl;

public class UserGroupsLdapImpl
extends AbstractDirImpl {
    @Override
    public boolean validPrincipal(String href) {
        if (href == null) {
            return false;
        }
        if (this.lookupValidPrincipal(href)) {
            return true;
        }
        boolean valid = !href.startsWith("invalid");
        try {
            new URI(href);
        }
        catch (Throwable t) {
            valid = false;
        }
        if (valid) {
            this.addValidPrincipal(href);
        }
        return valid;
    }

    public Collection<BwGroup> getGroups(BwPrincipal val) throws CalFacadeException {
        return this.getGroups(this.getProps(), val);
    }

    public Collection<BwGroup> getAllGroups(BwPrincipal val) throws CalFacadeException {
        Collection<BwGroup> groups = this.getGroups(this.getProps(), val);
        TreeSet<BwGroup> allGroups = new TreeSet<BwGroup>(groups);
        for (BwGroup grp : groups) {
            Collection<BwGroup> gg = this.getAllGroups((BwPrincipal)grp);
            if (gg.isEmpty()) continue;
            allGroups.addAll(gg);
        }
        return allGroups;
    }

    public boolean getGroupMaintOK() {
        return false;
    }

    public Collection<BwGroup> getAll(boolean populate) throws CalFacadeException {
        Collection<BwGroup> gs = this.getGroups(this.getProps(), null);
        if (!populate) {
            return gs;
        }
        for (BwGroup g : gs) {
            this.getMembers(g);
        }
        return gs;
    }

    public void getMembers(BwGroup group) throws CalFacadeException {
        this.getGroupMembers(this.getProps(), group);
    }

    public void addGroup(BwGroup group) throws CalFacadeException {
        if (this.findGroup(group.getAccount()) != null) {
            throw new CalFacadeException("org.bedework.exception.duplicateadmingroup");
        }
        throw new CalFacadeUnimplementedException();
    }

    public BwGroup findGroup(String name) {
        return this.findGroup(this.getProps(), name);
    }

    public void addMember(BwGroup group, BwPrincipal val) throws CalFacadeException {
        BwGroup ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new CalFacadeException("Group " + group + " does not exist");
        }
        if (!this.checkPathForSelf(group, val)) {
            throw new CalFacadeException("org.bedework.exception.alreadyonagrouppath");
        }
        throw new CalFacadeUnimplementedException();
    }

    public void removeMember(BwGroup group, BwPrincipal val) throws CalFacadeException {
        BwGroup ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new CalFacadeException("Group " + group + " does not exist");
        }
        throw new CalFacadeUnimplementedException();
    }

    public void removeGroup(BwGroup group) throws CalFacadeException {
        throw new CalFacadeUnimplementedException();
    }

    public void updateGroup(BwGroup group) throws CalFacadeException {
        throw new CalFacadeUnimplementedException();
    }

    public Collection<BwGroup> findGroupParents(BwGroup group) throws CalFacadeException {
        throw new CalFacadeUnimplementedException();
    }

    public String getConfigName() {
        return "user-ldap-group";
    }

    private boolean checkPathForSelf(BwGroup group, BwPrincipal val) throws CalFacadeException {
        if (group.equals((Object)val)) {
            return false;
        }
        throw new CalFacadeUnimplementedException();
    }

    private InitialLdapContext createLdapInitContext(LdapConfigProperties props) throws CalFacadeException {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", props.getInitialContextFactory());
        env.setProperty("java.naming.security.authentication", props.getSecurityAuthentication());
        env.setProperty("java.naming.security.protocol", props.getSecurityProtocol());
        env.setProperty("java.naming.provider.url", props.getProviderUrl());
        String protocol = env.getProperty("java.naming.security.protocol");
        Object providerURL = env.getProperty("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "389" : "636");
            env.setProperty("java.naming.provider.url", (String)providerURL);
        }
        if (props.getAuthDn() != null) {
            env.setProperty("java.naming.security.principal", props.getAuthDn());
            env.put("java.naming.security.credentials", props.getAuthPw());
        }
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            if (this.debug()) {
                this.debug("Logged into LDAP server, " + ctx);
            }
            return ctx;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
    }

    private BwGroup findGroup(DirConfigProperties dirProps, String groupName) {
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitContext(props);
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(props.getGroupIdAttr(), groupName);
            String[] idAttr = new String[]{props.getGroupIdAttr()};
            BwGroup group = null;
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, idAttr);
            while (response.hasMore()) {
                if (group != null) {
                    throw new CalFacadeException("org.bedework.ldap.groups.multiple.result");
                }
                group = new BwGroup();
                group.setAccount(groupName);
                group.setPrincipalRef(this.makePrincipalUri(groupName, 2));
            }
            BwGroup bwGroup = group;
            return bwGroup;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new RuntimeException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
    }

    private Collection<BwGroup> getGroups(DirConfigProperties dirProps, BwPrincipal principal) throws CalFacadeException {
        ArrayList<BwGroup> groups = new ArrayList<BwGroup>();
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        if (props.getGroupMemberAttr() == null) {
            this.warn("No group member attribute set - assuming no groups");
            return groups;
        }
        InitialLdapContext ctx = null;
        String member = null;
        if (principal != null) {
            if (principal.getKind() == 1) {
                member = this.getUserEntryValue(props, principal);
            } else if (principal.getKind() == 2) {
                member = this.getGroupEntryValue(props, principal);
            }
        }
        try {
            try {
                ctx = this.createLdapInitContext(props);
            }
            catch (Throwable t) {
                this.warn("*******************************************");
                this.warn("No group information available");
                this.error(t);
                ArrayList<BwGroup> arrayList = groups;
                if (ctx != null) {
                    this.closeContext(ctx);
                }
                return arrayList;
            }
            BasicAttributes matchAttrs = new BasicAttributes(true);
            if (member != null) {
                matchAttrs.put(props.getGroupMemberAttr(), member);
            }
            String[] idAttr = new String[]{props.getGroupIdAttr()};
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, idAttr);
            while (response.hasMore()) {
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                Attribute nmAttr = attrs.get(props.getGroupIdAttr());
                if (nmAttr.size() != 1) {
                    throw new CalFacadeException("org.bedework.ldap.groups.multiple.result");
                }
                BwGroup group = new BwGroup();
                group.setAccount(nmAttr.get(0).toString());
                group.setPrincipalRef(this.makePrincipalUri(group.getAccount(), 2));
                groups.add(group);
            }
            ArrayList<BwGroup> arrayList = groups;
            return arrayList;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
    }

    private void getGroupMembers(DirConfigProperties dirProps, BwGroup group) throws CalFacadeException {
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitContext(props);
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(props.getGroupIdAttr(), group.getAccount());
            String[] memberAttr = new String[]{props.getGroupMemberAttr()};
            ArrayList<String> mbrs = null;
            boolean beenHere = false;
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, memberAttr);
            while (response.hasMore()) {
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                if (beenHere) {
                    throw new CalFacadeException("org.bedework.ldap.groups.multiple.result");
                }
                beenHere = true;
                Attribute membersAttr = attrs.get(props.getGroupMemberAttr());
                mbrs = new ArrayList<String>();
                for (int m = 0; m < membersAttr.size(); ++m) {
                    mbrs.add(membersAttr.get(m).toString());
                }
            }
            String memberContext = props.getGroupMemberContextDn();
            String memberSearchAttr = props.getGroupMemberSearchAttr();
            String[] idAttr = new String[]{props.getGroupMemberUserIdAttr(), props.getGroupMemberGroupIdAttr(), "objectclass"};
            for (String mbr : mbrs) {
                Attribute attr;
                String oc;
                if (memberContext != null) {
                    matchAttrs = new BasicAttributes(true);
                    matchAttrs.put(memberSearchAttr, mbr);
                    response = ctx.search(memberContext, (Attributes)matchAttrs, idAttr);
                } else {
                    response = ctx.search(memberContext, null, idAttr);
                }
                if (!response.hasMore()) continue;
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                Attribute ocsAttr = attrs.get("objectclass");
                String userOc = props.getUserObjectClass();
                String groupOc = props.getGroupObjectClass();
                boolean isGroup = false;
                for (int oci = 0; oci < ocsAttr.size() && !userOc.equals(oc = ocsAttr.get(oci).toString()); ++oci) {
                    if (!groupOc.equals(oc)) continue;
                    isGroup = true;
                    break;
                }
                BwPrincipal p = null;
                if (isGroup) {
                    p = BwPrincipal.makeGroupPrincipal();
                    attr = attrs.get(props.getGroupMemberGroupIdAttr());
                } else {
                    p = BwPrincipal.makeUserPrincipal();
                    attr = attrs.get(props.getGroupMemberUserIdAttr());
                }
                if (attr.size() != 1) {
                    throw new CalFacadeException("org.bedework.ldap.groups.multiple.result");
                }
                p.setAccount(attr.get(0).toString());
                p.setPrincipalRef(this.makePrincipalUri(p.getAccount(), p.getKind()));
                group.addGroupMember(p);
            }
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
        for (BwGroup g : group.getGroups()) {
            this.getGroupMembers((DirConfigProperties)props, g);
        }
    }

    private String getUserEntryValue(LdapConfigProperties props, BwPrincipal p) {
        return this.makeUserDn(props, p);
    }

    private String getGroupEntryValue(LdapConfigProperties props, BwPrincipal p) {
        return this.makeGroupDn(props, p);
    }

    private String makeUserDn(LdapConfigProperties props, BwPrincipal p) {
        return props.getUserDnPrefix() + p.getAccount() + props.getUserDnSuffix();
    }

    private String makeGroupDn(LdapConfigProperties props, BwPrincipal p) {
        return props.getGroupDnPrefix() + p.getAccount() + props.getGroupDnSuffix();
    }

    private void closeContext(InitialLdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

