/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.jmx;

import org.bedework.caldav.util.sharing.AccessType;
import org.bedework.caldav.util.sharing.SetType;
import org.bedework.caldav.util.sharing.ShareType;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.jmx.NotificationConfMBean;
import org.bedework.calsvc.jmx.NotificationPropertiesImpl;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.util.jmx.ConfBase;

public class NotificationConf
extends ConfBase<NotificationPropertiesImpl>
implements NotificationConfMBean {
    public static final String confuriPname = "org.bedework.bwengine.confuri";
    private CalSvcI svci;

    public NotificationConf() {
        super(NotificationConf.getServiceName("notifications"));
        this.setConfigName("notifications");
        this.setConfigPname(confuriPname);
    }

    public static String getServiceName(String name) {
        return "org.bedework.bwengine:service=" + name;
    }

    public void setOutboundEnabled(boolean val) {
        ((NotificationPropertiesImpl)this.getConfig()).setOutboundEnabled(val);
    }

    public boolean getOutboundEnabled() {
        return ((NotificationPropertiesImpl)this.getConfig()).getOutboundEnabled();
    }

    public void setNotifierURI(String val) {
        ((NotificationPropertiesImpl)this.getConfig()).setNotifierURI(val);
    }

    public String getNotifierURI() {
        return ((NotificationPropertiesImpl)this.getConfig()).getNotifierURI();
    }

    public void setNotifierId(String val) {
        ((NotificationPropertiesImpl)this.getConfig()).setNotifierId(val);
    }

    public String getNotifierId() {
        return ((NotificationPropertiesImpl)this.getConfig()).getNotifierId();
    }

    public void setNotifierToken(String val) {
        ((NotificationPropertiesImpl)this.getConfig()).setNotifierToken(val);
    }

    public String getNotifierToken() {
        return ((NotificationPropertiesImpl)this.getConfig()).getNotifierToken();
    }

    public void setNotificationDirHref(String val) {
        ((NotificationPropertiesImpl)this.getConfig()).setNotificationDirHref(val);
    }

    public String getNotificationDirHref() {
        return ((NotificationPropertiesImpl)this.getConfig()).getNotificationDirHref();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String sendInvite(String cua, String href) {
        try {
            ShareType share = new ShareType();
            SetType set = new SetType();
            set.setHref(cua);
            set.setSummary("Test Collection");
            AccessType at = new AccessType();
            at.setRead(Boolean.valueOf(true));
            set.setAccess(at);
            share.getSet().add(set);
            try (CalSvcI svci = this.getSvci(this.getNotifierId());){
                BwCalendar col = svci.getCalendarsHandler().get(href);
                if (col == null) {
                    String string = "No such collection";
                    return string;
                }
                svci.getSharingHandler().share(col, share);
            }
            this.svci.endTransaction();
            return "ok";
        }
        catch (Throwable t) {
            this.error(t);
            return t.getLocalizedMessage();
        }
    }

    @Override
    public String loadConfig() {
        return this.loadConfig(NotificationPropertiesImpl.class);
    }

    private CalSvcI getSvci(String account) throws CalFacadeException {
        if (this.svci != null && this.svci.isOpen()) {
            return this.svci;
        }
        if (this.svci == null) {
            CalSvcIPars pars = CalSvcIPars.getServicePars((String)"notifications", (String)account, (boolean)false, (boolean)true);
            this.svci = new CalSvcFactoryDefault().getSvc(pars);
        }
        this.svci.open();
        this.svci.beginTransaction();
        return this.svci;
    }
}

