/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import java.util.Map;
import net.fortuna.ical4j.model.component.Participant;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.SchedulingInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OrganizerSchedulingHandler;
import org.bedework.convert.Icalendar;
import org.bedework.convert.ical.IcalUtil;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;

public abstract class AttendeeSchedulingHandler
extends OrganizerSchedulingHandler {
    AttendeeSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    public ScheduleResult requestRefresh(EventInfo ei, String comment) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        if (ev.getScheduleMethod() != 2) {
            sr.errorCode = "org.bedework.error.scheduling.badmethod";
            return sr;
        }
        BwAttendee att = this.findUserAttendee(ei);
        if (att == null) {
            throw new CalFacadeException("org.bedework.error.scheduling.notattendee");
        }
        BwEventObj outEv = new BwEventObj();
        EventInfo outEi = new EventInfo((BwEvent)outEv);
        outEv.setScheduleMethod(6);
        outEv.addRecipient(ev.getOrganizer().getOrganizerUri());
        outEv.setOriginator(att.getAttendeeUri());
        outEv.updateDtstamp();
        outEv.setOrganizer((BwOrganizer)ev.getOrganizer().clone());
        outEv.getOrganizer().setDtstamp(outEv.getDtstamp());
        outEv.addAttendee((BwAttendee)att.clone());
        outEv.setUid(ev.getUid());
        outEv.setRecurrenceId(ev.getRecurrenceId());
        outEv.setDtstart(ev.getDtstart());
        outEv.setDtend(ev.getDtend());
        outEv.setDuration(ev.getDuration());
        outEv.setNoStart(ev.getNoStart());
        outEv.setRecurring(Boolean.valueOf(false));
        if (comment != null) {
            outEv.addComment(new BwString(null, comment));
        }
        sr = this.scheduleResponse(outEi);
        outEv.setScheduleState(1);
        return sr;
    }

    public ScheduleResult attendeeRespond(EventInfo ei, int method) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        SchedulingInfo si = ei.getSchedulingInfo();
        BwAttendee att = this.findUserAttendee(ei);
        if (att == null) {
            sr.errorCode = "org.bedework.error.scheduling.notattendee";
        } else if (ev.getOriginator() == null) {
            sr.errorCode = "org.bedework.error.scheduling.noOriginator";
        } else {
            EventInfo outEi = this.copyEventInfo(ei, this.getPrincipal());
            BwEvent outEv = outEi.getEvent();
            if (!Util.isEmpty((Collection)outEv.getRecipients())) {
                outEv.getRecipients().clear();
            }
            if (!Util.isEmpty((Collection)outEv.getAttendees())) {
                outEv.getAttendees().clear();
            }
            if (si.getOrganizer() == null) {
                throw new RuntimeException("No organizer");
            }
            outEv.addRecipient(si.getOrganizer().getOrganizerUri());
            outEv.setOriginator(att.getAttendeeUri());
            outEv.updateDtstamp();
            si.getOrganizer().setDtstamp(outEv.getDtstamp());
            String delegate = att.getDelegatedTo();
            if (delegate != null) {
                outEv.setScheduleMethod(3);
                BwAttendee delAtt = new BwAttendee();
                delAtt.setAttendeeUri(delegate);
                delAtt.setDelegatedFrom(att.getAttendeeUri());
                delAtt.setPartstat("NEEDS-ACTION");
                delAtt.setRsvp(true);
                delAtt.setRole(att.getRole());
                outEv.addAttendee(delAtt);
                EventInfo delegateEi = this.copyEventInfo(ei, this.getPrincipal());
                BwEvent delegateEv = delegateEi.getEvent();
                delegateEv.addRecipient(delegate);
                delegateEv.addAttendee((BwAttendee)delAtt.clone());
                delegateEv.setScheduleMethod(2);
                att.setPartstat("DELEGATED");
                att.setRsvp(false);
                att.setDelegatedTo(delegate);
                this.schedule(delegateEi, null, null, false);
            } else if (method == 3) {
                ei.setOnlyAttendee(outEi, att.getAttendeeUri());
                if (ev.getEntityType() == 7) {
                    this.setPollResponse(outEi, ei, att.getAttendeeUri());
                }
                outEv.setScheduleMethod(3);
            } else if (method == 7) {
                ei.setOnlyAttendee(outEi, att.getAttendeeUri());
                outEv.setScheduleMethod(7);
            } else {
                throw new RuntimeException("Never get here");
            }
            outEv.addRequestStatus(new BwRequestStatus(IcalDefs.requestStatusSuccess.getCode(), IcalDefs.requestStatusSuccess.getDescription()));
            sr = this.scheduleResponse(outEi);
            outEv.setScheduleState(1);
            si.getOrganizer().setScheduleStatus("1.2");
        }
        return sr;
    }

    public ScheduleResult scheduleResponse(EventInfo ei) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        try {
            Response addResp;
            int smethod = ei.getEvent().getScheduleMethod();
            if (!Icalendar.itipReplyMethodType((int)smethod)) {
                sr.errorCode = "org.bedework.error.scheduling.badmethod";
                return sr;
            }
            int outAccess = 12;
            if (ei.getSchedulingInfo().getMaxAttendees() > 1) {
                sr.errorCode = "org.bedework.error.scheduling.bad.attendees";
            }
            if (!this.initScheduleEvent(ei, true, false)) {
                return sr;
            }
            BwCalendar outBox = this.getSpecialCalendar(this.getPrincipal(), 6, true, outAccess);
            this.sendSchedule(sr, ei, null, null, false);
            if (sr.ignored) {
                return sr;
            }
            if (!sr.externalRcs.isEmpty() && !(addResp = this.addToOutBox(ei, outBox, sr.externalRcs)).isOk()) {
                sr.errorCode = addResp.getMessage();
            }
            return sr;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            if (t instanceof CalFacadeException) {
                throw (CalFacadeException)t;
            }
            throw new CalFacadeException(t);
        }
    }

    private void setPollResponse(EventInfo outEi, EventInfo ei, String attUri) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        BwEvent outEv = outEi.getEvent();
        try {
            Map voters = IcalUtil.parseVpollVoters((BwEvent)ev);
            outEv.clearVoters();
            Participant v = (Participant)voters.get(attUri);
            if (v == null) {
                this.warn("No participant element for " + attUri);
                return;
            }
            outEv.addVoter(v.toString());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }
}

