/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OutboundSchedulingHandler;
import org.bedework.convert.Icalendar;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;

public abstract class OrganizerSchedulingHandler
extends OutboundSchedulingHandler {
    OrganizerSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    public ScheduleResult schedule(EventInfo ei, String recipient, String fromAttUri, boolean iSchedule) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        try {
            Response addResp;
            if (!Icalendar.itipRequestMethodType((int)ev.getScheduleMethod())) {
                sr.errorCode = "org.bedework.error.scheduling.badmethod";
                return sr;
            }
            boolean freeBusyRequest = ev.getEntityType() == 4;
            int outAccess = freeBusyRequest ? 13 : 11;
            if (!this.initScheduleEvent(ei, false, iSchedule)) {
                return sr;
            }
            BwCalendar outBox = null;
            BwPrincipal currentUser = this.getPrincipal();
            if (!currentUser.getUnauthenticated()) {
                outBox = this.getSpecialCalendar(this.getPrincipal(), 6, true, outAccess);
            }
            this.sendSchedule(sr, ei, recipient, fromAttUri, true);
            if (sr.errorCode != null || sr.ignored) {
                return sr;
            }
            if (freeBusyRequest) {
                return sr;
            }
            if (!(iSchedule || outBox == null || Util.isEmpty((Collection)sr.externalRcs) || (addResp = this.addToOutBox(ei, outBox, sr.externalRcs)).isOk())) {
                sr.errorCode = addResp.getMessage();
            }
            return sr;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            if (t instanceof CalFacadeException) {
                throw (CalFacadeException)t;
            }
            throw new CalFacadeException(t);
        }
    }

    public ScheduleResult declineCounter(EventInfo ei, String comment, BwAttendee fromAtt) throws CalFacadeException {
        EventInfo outEi = this.copyEventInfo(ei, this.getPrincipal());
        BwEvent ev = outEi.getEvent();
        ev.setScheduleMethod(8);
        if (comment != null) {
            ev.addComment(null, comment);
        }
        return this.schedule(outEi, fromAtt.getAttendeeUri(), null, false);
    }
}

