/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.SchedulingInfo;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.scheduling.SchedulingIntf;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.misc.response.Response;

public abstract class SchedulingBase
extends CalSvcDb
implements SchedulingIntf {
    private static AtomicLong suffixValue = new AtomicLong();

    SchedulingBase(CalSvc svci) {
        super(svci);
    }

    protected void addAutoScheduleMessage(boolean inBox, String principalHref, String eventName) {
        this.postNotification(SysEvent.makeEntityQueuedEvent((SysEventBase.SysCode)SysEventBase.SysCode.SCHEDULE_QUEUED, (String)principalHref, (String)eventName, (boolean)inBox));
    }

    protected boolean significantChange(EventInfo ei) {
        if (ei.getNewEvent() || ei.getChangeset(this.getPrincipalHref()).getSignificantChange()) {
            return true;
        }
        BwEvent ev = ei.getEvent();
        boolean override = ev instanceof BwEventProxy;
        if (override || ei.getOverrides() == null) {
            return false;
        }
        for (EventInfo oei : ei.getOverrides()) {
            if (!this.significantChange(oei)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EventInfo copyEventInfo(EventInfo ei, BwPrincipal owner) {
        return this.copyEventInfo(ei, false, owner);
    }

    protected EventInfo copyEventInfo(EventInfo ei, boolean significantChangesOnly, BwPrincipal owner) {
        boolean reply;
        BwEvent ev = ei.getEvent();
        BwEvent newEv = this.copyEvent(ev, null, owner);
        StringBuilder changeInfo = new StringBuilder();
        changeInfo.append(ev.getDtstamp());
        boolean cancel = ev.getScheduleMethod() == 5;
        boolean adding = ei.getUpdResult().adding;
        boolean bl = reply = ev.getScheduleMethod() == 3;
        if (cancel) {
            changeInfo.append(";CANCEL");
        } else if (adding) {
            changeInfo.append(";CREATE");
        } else if (reply) {
            changeInfo.append(";REPLY");
        } else {
            changeInfo.append(";UPDATE");
        }
        if (adding || cancel) {
            changeInfo.append(";MASTER");
        } else {
            this.addChangeInfo(ei, changeInfo, "MASTER");
        }
        if (!ev.getRecurring().booleanValue()) {
            this.setChangeInfo(newEv, changeInfo);
            return new EventInfo(newEv);
        }
        if (cancel) {
            Set overrides = ei.getOverrides();
            if (overrides != null) {
                for (EventInfo oei : overrides) {
                    for (BwAttendee ovatt : oei.getEvent().getAttendees()) {
                        if (newEv.findAttendee(ovatt.getAttendeeUri()) != null) continue;
                        newEv.addAttendee((BwAttendee)ovatt.clone());
                    }
                }
            }
            this.setChangeInfo(newEv, changeInfo);
            return new EventInfo(newEv);
        }
        boolean fromOrganizer = ev.getOrganizerSchedulingObject();
        if (!fromOrganizer && !Util.isEmpty((Collection)ei.getOverrides())) {
            for (EventInfo oei : ei.getOverrides()) {
                if (!oei.getEvent().getOrganizerSchedulingObject().booleanValue()) continue;
                fromOrganizer = true;
                break;
            }
        }
        boolean attendeeInMaster = false;
        String uri = this.getSvc().getDirectories().principalToCaladdr(owner);
        if (fromOrganizer) {
            attendeeInMaster = ev.findAttendee(uri) != null;
        }
        String masterStatus = newEv.getStatus();
        boolean masterSuppressed = false;
        if (fromOrganizer && !attendeeInMaster) {
            if (this.debug()) {
                this.debug("Sending invite with suppressed master");
            }
            masterSuppressed = true;
        }
        ArrayList deletedRecurids = null;
        if (masterSuppressed) {
            if (!Util.isEmpty((Collection)ei.getUpdResult().deletedInstances)) {
                deletedRecurids = new ArrayList(ei.getUpdResult().deletedInstances);
            }
            if (newEv.getRrules() != null) {
                newEv.getRrules().clear();
            }
            if (newEv.getRdates() != null) {
                newEv.getRdates().clear();
            }
            if (newEv.getExrules() != null) {
                newEv.getExrules().clear();
            }
            if (newEv.getExdates() != null) {
                newEv.getExdates().clear();
            }
            newEv.setSuppressed(true);
        }
        Set overrides = ei.getOverrides();
        TreeSet<EventInfo> newovs = new TreeSet<EventInfo>();
        if (overrides != null) {
            for (EventInfo oei : overrides) {
                boolean attendeeInOverride;
                BwEvent oev = oei.getEvent();
                boolean bl2 = attendeeInOverride = oev.findAttendee(uri) != null;
                if (!masterSuppressed && attendeeInMaster && attendeeInOverride && significantChangesOnly) {
                    boolean significant = oei.getChangeset(this.getPrincipalHref()).getSignificantChange();
                    if (!oei.getNewEvent() && !significant) continue;
                }
                if (fromOrganizer) {
                    BwDateTime bwrdt;
                    String rid;
                    if (!masterSuppressed && attendeeInMaster) {
                        if (!attendeeInOverride) {
                            rid = oev.getRecurrenceId();
                            bwrdt = BwDateTime.fromUTC((rid.length() == 8 ? 1 : 0) != 0, (String)rid);
                            newEv.addExdate(bwrdt);
                            continue;
                        }
                    } else {
                        if (!attendeeInOverride) continue;
                        rid = oev.getRecurrenceId();
                        bwrdt = BwDateTime.fromUTC((rid.length() == 8 ? 1 : 0) != 0, (String)rid);
                        newEv.addRdate(bwrdt);
                        if (deletedRecurids != null && deletedRecurids.contains(oev.getRecurrenceId())) {
                            oev.setStatus("CANCELLED");
                        } else if (oev.getStatus() != null && oev.getStatus().equals("MASTER-SUPPRESSED")) {
                            oev.setStatus(masterStatus);
                        }
                        oev.setSequence(ev.getSequence());
                    }
                }
                if (adding || cancel) {
                    changeInfo.append(";RID=");
                    changeInfo.append(oev.getRecurrenceId());
                } else {
                    this.addChangeInfo(ei, changeInfo, oev.getRecurrenceId());
                }
                newovs.add(new EventInfo(this.copyEvent(oev, newEv, owner)));
            }
        }
        this.setChangeInfo(newEv, changeInfo);
        return new EventInfo(newEv, newovs);
    }

    private void addChangeInfo(EventInfo ei, StringBuilder changeInfo, String entity) {
        if (ei.getChangeset(this.getPrincipalHref()).isEmpty()) {
            this.appendEntity(changeInfo, entity);
            return;
        }
        boolean changed = false;
        Collection ctes = ei.getChangeset(this.getPrincipalHref()).getEntries();
        for (ChangeTableEntry cte : ctes) {
            if (!cte.getChanged()) continue;
            if (!changed) {
                this.appendEntity(changeInfo, entity);
                changeInfo.append(";CHANGES");
            }
            changed = true;
            changeInfo.append(";");
            if (cte.getIndex() == PropertyIndex.PropertyInfoIndex.DTEND && ei.getEvent().getEntityType() == 2) {
                changeInfo.append(PropertyIndex.PropertyInfoIndex.DUE.toString());
                continue;
            }
            changeInfo.append(cte.getIndex().toString());
        }
    }

    private void appendEntity(StringBuilder changeInfo, String entity) {
        changeInfo.append(";");
        if ("MASTER".equals(entity)) {
            changeInfo.append(entity);
        } else {
            changeInfo.append("RID=");
            changeInfo.append(entity);
        }
    }

    private void setChangeInfo(BwEvent ev, StringBuilder changeInfo) {
        if (changeInfo.length() == 0) {
            return;
        }
        ev.removeXproperties("X-BEDEWORK-CHANGES");
        ev.addXproperty(new BwXproperty("X-BEDEWORK-CHANGES", null, changeInfo.toString()));
    }

    protected BwEvent copyEvent(BwEvent origEv, BwEvent masterEv, BwPrincipal owner) {
        BwContact contact;
        BwEvent newEv;
        BwEventProxy proxy = null;
        String ownerHref = owner.getPrincipalRef();
        if (origEv instanceof BwEventProxy) {
            proxy = (BwEventProxy)origEv;
            if (masterEv == null) {
                newEv = new BwEventObj();
                origEv.copyTo(newEv);
                newEv.setRecurring(Boolean.valueOf(false));
                proxy = null;
            } else {
                proxy = proxy.clone(masterEv, masterEv);
                newEv = proxy.getRef();
            }
        } else {
            newEv = (BwEvent)origEv.clone();
        }
        if (!Util.isEmpty((Collection)newEv.getAttendees())) {
            for (BwAttendee att : newEv.getAttendees()) {
                att.setScheduleStatus(null);
            }
        }
        if (newEv.getOrganizer() != null) {
            newEv.getOrganizer().setScheduleStatus(null);
        }
        newEv.setOwnerHref(ownerHref);
        newEv.setCreatorHref(ownerHref);
        newEv.setDtstamps(this.getCurrentTimestamp());
        if (owner.equals((Object)this.getPrincipal())) {
            if (proxy != null) {
                return proxy;
            }
            return newEv;
        }
        BwLocation loc = newEv.getLocation();
        if (loc != null) {
            loc = (BwLocation)loc.clone();
            loc.setOwnerHref(ownerHref);
            loc.setCreatorHref(ownerHref);
            loc.initUid();
            newEv.setLocation(loc);
        }
        if ((contact = newEv.getContact()) != null) {
            contact = (BwContact)contact.clone();
            contact.setOwnerHref(ownerHref);
            contact.setCreatorHref(ownerHref);
            contact.initUid();
            newEv.setContact(contact);
        }
        if (proxy != null) {
            return proxy;
        }
        return newEv;
    }

    @Override
    public Response addEvent(EventInfo ei, String namePrefix, int calType, boolean noInvites) {
        boolean schedulingBox;
        BwEvent ev = ei.getEvent();
        Object prefix = namePrefix;
        boolean bl = schedulingBox = calType == 5 || calType == 13 || calType == 6;
        if (schedulingBox) {
            prefix = (String)prefix + suffixValue.getAndIncrement();
        }
        for (int i = 0; i < 100; ++i) {
            ev.setName((String)prefix + ".ics");
            EventInfo.UpdateResult resp = this.getSvc().getEventsHandler().add(ei, noInvites, schedulingBox, true, false);
            if (resp.isOk()) {
                return resp;
            }
            if (!"org.bedework.exception.duplicatename".equals(resp.getMessage())) {
                if ("org.bedework.exception.duplicateguid".equals(resp.getMessage())) {
                    this.getSvc().rollbackTransaction();
                }
                return resp;
            }
            prefix = (String)prefix + suffixValue.getAndIncrement();
        }
        this.getSvc().rollbackTransaction();
        return Response.notOk((Response)new Response(), (Response.Status)Response.Status.failed, (String)"org.bedework.exception.duplicatename");
    }

    protected BwAttendee findUserAttendee(EventInfo ei) {
        BwAttendee att;
        Directories dir = this.getSvc().getDirectories();
        String thisPref = this.getPrincipal().getPrincipalRef();
        BwEvent ev = ei.getEvent();
        if (!ev.getSuppressed() && (att = this.findUserAttendee(ev, thisPref)) != null) {
            return att;
        }
        if (ei.getNumOverrides() > 0) {
            for (EventInfo oei : ei.getOverrides()) {
                BwEvent oev = oei.getEvent();
                BwAttendee att2 = this.findUserAttendee(oev, thisPref);
                if (att2 == null) continue;
                return att2;
            }
        }
        return null;
    }

    private BwAttendee findUserAttendee(BwEvent ev, String ourPref) {
        Directories dir = this.getSvc().getDirectories();
        for (BwAttendee att : ev.getAttendees()) {
            BwPrincipal p = dir.caladdrToPrincipal(att.getAttendeeUri());
            if (p == null || !ourPref.equals(p.getPrincipalRef())) continue;
            return att;
        }
        return null;
    }

    public void setupReschedule(EventInfo ei) throws CalFacadeException {
        BwEvent event = ei.getEvent();
        BwAttendee userAttendee = this.findUserAttendee(ei);
        for (BwAttendee att : event.getAttendees()) {
            if (att.equals((Object)userAttendee)) continue;
            att.setPartstat("NEEDS-ACTION");
            att.setRsvp(true);
        }
    }

    protected boolean initScheduleEvent(EventInfo ei, boolean response, boolean iSchedule) {
        SchedulingInfo si = ei.getSchedulingInfo();
        BwEvent event = ei.getEvent();
        if (!iSchedule) {
            if (!Util.isEmpty((Collection)event.getRecipients())) {
                event.getRecipients().clear();
            }
            if (response) {
                event.addRecipient(si.getOrganizer().getOrganizerUri());
            } else {
                this.getRecipients(event, event);
                if (ei.getNumOverrides() > 0) {
                    for (EventInfo oei : ei.getOverrides()) {
                        this.getRecipients(event, oei.getEvent());
                    }
                }
            }
        }
        this.setupSharableEntity((BwShareableDbentity)event, this.getPrincipal().getPrincipalRef());
        event.setDtstamps(this.getCurrentTimestamp());
        this.assignGuid(event);
        if (event.getNumAttendees() > 0) {
            for (BwAttendee att : event.getAttendees()) {
                if (att.getScheduleAgent() != 0) continue;
                att.setSequence(event.getSequence());
                att.setDtstamp(event.getDtstamp());
                if (!response) continue;
                att.setScheduleStatus("2.0");
            }
        }
        return true;
    }

    private void getRecipients(BwEvent master, BwEvent ev) {
        if (ev.getAttendees() == null) {
            return;
        }
        for (BwAttendee att : ev.getAttendees()) {
            if (att.getScheduleAgent() != 0) continue;
            String uri = att.getAttendeeUri();
            master.addRecipient(uri);
        }
    }
}

