/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling.hosts;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.james.jdkim.IscheduleDKIMSigner;
import org.apache.james.jdkim.api.Headers;
import org.bedework.caldav.server.IscheduleMessage;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.scheduling.hosts.HostInfo;
import org.bedework.util.misc.Util;

public class IscheduleOut
extends IscheduleMessage {
    private String method;
    private String domain;
    private List<Header> headers;
    private List<String> contentLines;
    private byte[] contentBytes;

    public IscheduleOut(String domain) {
        this.domain = domain;
        this.addHeader("ischedule-version", "1.0");
        this.addHeader("cache-control", "no-cache");
        this.addHeader("cache-control", "no-transform");
    }

    public void sign(HostInfo hinfo, PrivateKey key) throws CalFacadeException {
        try {
            StringBuilder template = new StringBuilder("v=1; s=selector; d=");
            template.append(this.domain);
            template.append("; ");
            template.append("h=content-type:ischedule-version:originator:recipient");
            template.append("; c=ischedule-relaxed/simple; ");
            if (hinfo.getIScheduleUsePublicKey()) {
                template.append("q=private-exchange; ");
            } else {
                template.append("q=http/well-known; ");
            }
            template.append("a=rsa-sha256; bh=; b=;");
            String dkimSig = new IscheduleDKIMSigner(template.toString(), key).sign((Headers)this, this.getInputStream());
            if (dkimSig == null) {
                return;
            }
            int pos = dkimSig.indexOf(":");
            this.addHeader(dkimSig.substring(0, pos), dkimSig.substring(pos + 1));
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void setMethod(String val) {
        this.method = val;
    }

    public String getMethod() {
        return this.method;
    }

    public void setContentType(String val) {
        this.replaceHeader("content-type", val);
    }

    public String getContentType() {
        List l = this.getFieldVals("content-type");
        if (Util.isEmpty((Collection)l)) {
            return null;
        }
        return (String)l.iterator().next();
    }

    public List<Header> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
            for (String hname : this.getFields()) {
                if (hname.equalsIgnoreCase("content-type")) continue;
                for (String hval : this.getFieldVals(hname)) {
                    this.headers.add((Header)new BasicHeader(hname, hval));
                }
            }
        }
        return this.headers;
    }

    public void addContentLine(String val) {
        if (this.contentLines == null) {
            this.contentLines = new ArrayList<String>();
        }
        this.contentLines.add(val);
        this.contentBytes = null;
    }

    public int getContentLength() throws CalFacadeException {
        if (this.contentLines == null) {
            return 0;
        }
        return this.getBytes().length;
    }

    public byte[] getContentBytes() throws CalFacadeException {
        if (this.contentLines == null) {
            return null;
        }
        return this.getBytes();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    private void replaceHeader(String name, String val) {
        List l = this.getFields(name.toLowerCase());
        if (Util.isEmpty((Collection)l)) {
            super.addHeader(name, val);
        } else {
            l.clear();
            l.add(val);
        }
    }

    private int getNumRecipients() {
        List l = this.getFields("recipient");
        if (Util.isEmpty((Collection)l)) {
            return 0;
        }
        return l.size();
    }

    private byte[] getBytes() {
        if (this.contentBytes != null) {
            return this.contentBytes;
        }
        StringBuilder sb = new StringBuilder();
        for (String ln : this.contentLines) {
            sb.append(ln);
            if (ln.endsWith("\n")) continue;
            sb.append("\n");
        }
        this.contentBytes = sb.toString().getBytes();
        return this.contentBytes;
    }
}

