/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.sysmon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.calfacade.MonitorStat;
import org.bedework.calsvc.sysmon.DataAvg;
import org.bedework.sysevents.events.MillisecsEvent;
import org.bedework.sysevents.events.StatsEvent;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.TimedEvent;

public class DataValues {
    private Map<SysEventBase.SysCode, DataAvg> dvMap = new HashMap<SysEventBase.SysCode, DataAvg>();
    private Map<String, DataAvg> timedValuesMap = new HashMap<String, DataAvg>();
    private Map<String, DataAvg> statMap = new HashMap<String, DataAvg>();

    public DataValues() {
        this.addDv("Avg web response time", SysEventBase.SysCode.WEB_OUT);
        this.addDv("Avg CalDAV response time", SysEventBase.SysCode.CALDAV_OUT);
        this.addDv("Avg login time", SysEventBase.SysCode.USER_LOGIN);
        this.addDv("Avg service login time", SysEventBase.SysCode.SERVICE_USER_LOGIN);
    }

    public void update(SysEvent ev) {
        SysEventBase.SysCode sc = ev.getSysCode();
        if (ev instanceof TimedEvent) {
            TimedEvent te = (TimedEvent)ev;
            String lbl = te.getLabel();
            DataAvg dv = this.timedValuesMap.get(lbl);
            if (dv == null) {
                dv = new DataAvg(lbl, ev.getSysCode());
                this.timedValuesMap.put(lbl, dv);
            }
            dv.inc(te.getMillis());
            return;
        }
        if (ev instanceof MillisecsEvent) {
            DataAvg dv = this.dvMap.get(sc);
            if (dv != null) {
                dv.inc(((MillisecsEvent)ev).getMillis());
            }
            return;
        }
        if (sc == SysEventBase.SysCode.STATS) {
            StatsEvent.StatType st;
            StatsEvent se = (StatsEvent)ev;
            String sname = se.getName();
            DataAvg da = this.statMap.get(sname);
            if (da == null) {
                da = new DataAvg(sname, sc);
                this.statMap.put(sname, da);
            }
            if ((st = StatsEvent.getStatType((String)sname)) != StatsEvent.StatType.lnum) {
                da.inc(1.0);
            } else if (se.getLongValue() != null) {
                da.inc(se.getLongValue().longValue());
            }
            return;
        }
    }

    public void getValues(List<String> vals) {
        for (DataAvg da : this.dvMap.values()) {
            vals.add(da.toString());
        }
    }

    public void getStats(List<MonitorStat> stats) {
        long val;
        for (DataAvg da : this.dvMap.values()) {
            stats.add(da.getStat());
        }
        for (DataAvg da : this.timedValuesMap.values()) {
            val = (long)(da.getValue() / da.getCount());
            stats.add(new MonitorStat(da.getName(), Long.valueOf((long)da.getCount()), String.valueOf(val)));
        }
        for (DataAvg da : this.statMap.values()) {
            val = (long)(da.getValue() / da.getCount());
            stats.add(new MonitorStat(da.getName(), Long.valueOf((long)da.getCount()), String.valueOf(val)));
        }
    }

    private DataAvg addDv(String name, SysEventBase.SysCode scode) {
        DataAvg dv = new DataAvg(name, scode);
        this.dvMap.put(scode, dv);
        return dv;
    }
}

