/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents.events;

import java.util.ArrayList;
import java.util.List;
import org.bedework.access.AccessPrincipal;
import org.bedework.sysevents.events.CollectionDeletedEvent;
import org.bedework.sysevents.events.CollectionMovedEvent;
import org.bedework.sysevents.events.CollectionUpdateEvent;
import org.bedework.sysevents.events.EntityDeletedEvent;
import org.bedework.sysevents.events.EntityMovedEvent;
import org.bedework.sysevents.events.EntityQueuedEvent;
import org.bedework.sysevents.events.EntityUpdateEvent;
import org.bedework.sysevents.events.PrincipalEvent;
import org.bedework.sysevents.events.StatsEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.TimedEvent;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

public class SysEvent
implements SysEventBase,
Comparable<SysEvent> {
    private static final long serialVersionUID = 1L;
    private SysEventBase.SysCode sysCode;
    private SysEvent related;
    private boolean indexable;
    private boolean indexed;
    private String dtstamp;
    private int sequence;

    public SysEvent(SysEventBase.SysCode sysCode) {
        this.sysCode = sysCode;
        this.indexable = sysCode.getIndexable();
        this.updateDtstamp();
    }

    @Override
    public SysEventBase.SysCode getSysCode() {
        return this.sysCode;
    }

    @Override
    public List<SysEventBase.Attribute> getMessageAttributes() {
        ArrayList<SysEventBase.Attribute> attrs = new ArrayList<SysEventBase.Attribute>();
        attrs.add(new SysEventBase.Attribute("syscode", String.valueOf((Object)this.getSysCode())));
        attrs.add(new SysEventBase.Attribute("indexable", String.valueOf(this.getIndexable())));
        attrs.add(new SysEventBase.Attribute("indexed", String.valueOf(this.getIndexed())));
        attrs.add(new SysEventBase.Attribute("changeEvent", String.valueOf(this.getSysCode().getNotifiableEvent() || this.getSysCode() == SysEventBase.SysCode.SUGGESTED || this.getSysCode() == SysEventBase.SysCode.SUGGESTED_RESPONSE)));
        return attrs;
    }

    public void setDtstamp(String val) {
        this.dtstamp = val;
    }

    public String getDtstamp() {
        return this.dtstamp;
    }

    public void setSequence(int val) {
        this.sequence = val;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean getIndexable() {
        return this.indexable;
    }

    public void setIndexed(boolean val) {
        this.indexed = val;
    }

    public boolean getIndexed() {
        return this.indexed;
    }

    public void setRelated(SysEvent val) {
        this.related = val;
    }

    public SysEvent getRelated() {
        return this.related;
    }

    public static SysEvent makePrincipalEvent(SysEventBase.SysCode code, AccessPrincipal pr, long millisecs) {
        return new PrincipalEvent(code, pr.getPrincipalRef(), millisecs);
    }

    public static SysEvent makeTimedEvent(String label, long millisecs) {
        return new TimedEvent(SysEventBase.SysCode.TIMED_EVENT, label, millisecs);
    }

    public static SysEvent makeCollectionUpdateEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean indexed) {
        return new CollectionUpdateEvent(code, authPrincipalHref, ownerHref, href, shared, indexed);
    }

    public static SysEvent makeCollectionDeletedEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean publick, boolean indexed) {
        return new CollectionDeletedEvent(code, authPrincipalHref, ownerHref, href, shared, publick, indexed);
    }

    public static SysEvent makeCollectionMovedEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean indexed, String oldHref, boolean oldShared) {
        return new CollectionMovedEvent(code, authPrincipalHref, ownerHref, href, shared, indexed, oldHref, oldShared);
    }

    public static SysEvent makeEntityDeletedEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean publick, boolean indexed, String type, String rid, String notification, String targetPrincipalHref) {
        return new EntityDeletedEvent(code, authPrincipalHref, ownerHref, href, shared, publick, indexed, type, rid, notification, targetPrincipalHref);
    }

    public static SysEvent makeEntityUpdateEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean indexed, String rid, String notification, String targetPrincipalHref) {
        return new EntityUpdateEvent(code, authPrincipalHref, ownerHref, href, shared, indexed, rid, notification, targetPrincipalHref);
    }

    public static SysEvent makeStatsEvent(String name, Long longValue) {
        return new StatsEvent(name, longValue);
    }

    public static SysEvent makeEntityMovedEvent(SysEventBase.SysCode code, String authPrincipalHref, String ownerHref, String href, boolean shared, boolean indexed, String oldHref, boolean oldShared) {
        return new EntityMovedEvent(code, authPrincipalHref, ownerHref, href, shared, indexed, oldHref, oldShared);
    }

    public static SysEvent makeEntityQueuedEvent(SysEventBase.SysCode code, String ownerHref, String name, boolean inBox) {
        return new EntityQueuedEvent(code, ownerHref, name, inBox);
    }

    private void updateDtstamp() {
        this.setDtstamp(Util.icalUTCTimestamp());
        this.setSequence(this.getSequence() + 1);
    }

    @Override
    public int compareTo(SysEvent val) {
        return this.sysCode.compareTo(val.sysCode);
    }

    public int hashCode() {
        return this.sysCode.hashCode();
    }

    public void toStringSegment(ToString ts) {
        ts.append("sysCode", (Object)String.valueOf((Object)this.getSysCode()));
        ts.append("dtstamp", (Object)this.getDtstamp());
        ts.append("sequence", this.getSequence());
        ts.append("indexable", this.getIndexable());
        ts.append("indexed", this.getIndexed());
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        return ts.toString();
    }
}

