/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents.events;

import java.io.Serializable;
import java.util.List;

public interface SysEventBase
extends Serializable {
    public static final long serialVersionUID = 1L;
    public static final int info = 1;
    public static final int trace = 2;
    public static final int debug = 4;
    public static final int warn = 8;
    public static final int severe = 16;
    public static final int fatal = 32;
    public static final int priv = 1;
    public static final int user = 2;
    public static final boolean isIndexable = true;
    public static final boolean notIndexable = false;
    public static final boolean isNotifiableEvent = true;

    public SysCode getSysCode();

    public List<Attribute> getMessageAttributes();

    public static class Attribute {
        public String name;
        public String value;

        public Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static enum SysCode {
        STARTUP(1, 1),
        SHUTDOWN(1, 1),
        EXCEPTION_WARN(8, 1),
        EXCEPTION_FATAL(32, 1),
        WEB_IN(1, 1),
        WEB_OUT(1, 1),
        CALDAV_IN(1, 1),
        CALDAV_OUT(1, 1),
        STATS(1, 1),
        TIMED_EVENT(1, 1),
        NEW_USER(1, 1),
        USER_LOGIN(1, 1),
        USER_LOGOUT(1, 1),
        USER_SVCINIT(1, 1),
        COLLECTION_ADDED(1, 2, true, true, true),
        COLLECTION_TOMBSTONED(1, 2, true, true, true),
        COLLECTION_DELETED(1, 2, true, true, true),
        COLLECTION_MOVED(1, 2, true, true, true),
        COLLECTION_UPDATED(1, 2, true, true, true),
        ENTITY_FETCHED(1, 2),
        ENTITY_ADDED(1, 2, true, true, false),
        ENTITY_TOMBSTONED(1, 2, true, true, false),
        ENTITY_DELETED(1, 2, true, true, false),
        ENTITY_UPDATED(1, 2, true, true, false),
        ENTITY_MOVED(1, 2, true, true, false),
        SCHEDULE_QUEUED(1, 2),
        SERVICE_USER_LOGIN(1, 1),
        APPROVAL_NEEDED(1, 1, false, true, false),
        APPROVAL_STATUS(1, 1, false, true, false),
        SUGGESTED(1, 1, false, true, false),
        SUGGESTED_RESPONSE(1, 1, false, true, false);

        private final int severity;
        private final int privLevel;
        private final boolean indexable;
        private boolean notifiableEvent;
        private boolean collectionRef;

        private SysCode(int severity, int privLevel) {
            this(severity, privLevel, false);
        }

        private SysCode(int severity, int privLevel, boolean indexable) {
            this.severity = severity;
            this.privLevel = privLevel;
            this.indexable = indexable;
        }

        private SysCode(int severity, int privLevel, boolean indexable, boolean notifiableEvent, boolean collectionRef) {
            this.severity = severity;
            this.privLevel = privLevel;
            this.indexable = indexable;
            this.notifiableEvent = true;
            this.collectionRef = collectionRef;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getPrivLevel() {
            return this.privLevel;
        }

        public boolean getIndexable() {
            return this.indexable;
        }

        public boolean getNotifiableEvent() {
            return this.notifiableEvent;
        }

        public boolean getCollectionRef() {
            return this.collectionRef;
        }
    }
}

