/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdl.EBnEnrRsAc;
import org.beigesoft.acc.mdl.EBnEnrRsTy;
import org.beigesoft.acc.mdl.EBnEnrSt;
import org.beigesoft.acc.mdlp.Acnt;
import org.beigesoft.acc.mdlp.BnStLn;
import org.beigesoft.acc.mdlp.DbCr;
import org.beigesoft.acc.mdlp.Entr;
import org.beigesoft.acc.mdlp.PaymFr;
import org.beigesoft.acc.mdlp.PaymTo;
import org.beigesoft.acc.mdlp.PrepFr;
import org.beigesoft.acc.mdlp.PrepTo;
import org.beigesoft.acc.mdlp.PurInv;
import org.beigesoft.acc.mdlp.SalInv;
import org.beigesoft.acc.srv.IRvInvLn;
import org.beigesoft.acc.srv.ISrEntr;
import org.beigesoft.acc.srv.ISrToPa;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.AOrId;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.ISrvDt;

public class BnStLnSv
implements IPrcEnt<BnStLn, Long> {
    private IOrm orm;
    private II18n i18n;
    private ISrEntr srEntr;
    private ISrvDt srvDt;
    private ISrToPa srToPa;
    private IRvInvLn<PurInv, ?> rvPuLn;
    private IRvInvLn<SalInv, ?> rvSaLn;

    public final BnStLn process(Map<String, Object> pRvs, BnStLn pEnt, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        this.getOrm().refrEnt(pRvs, vs, (IHasId)pEnt.getOwnr());
        long owVrWs = Long.parseLong(pRqDt.getParam("owVr"));
        if (owVrWs != pEnt.getOwnr().getVer()) {
            throw new ExcCode(1151, "dirty_read");
        }
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        if (!pEnt.getDbOr().equals(this.getOrm().getDbId())) {
            throw new ExcCode(100, "can_not_change_foreign_src");
        }
        BnStLn old = (BnStLn)this.getOrm().retEnt(pRvs, vs, (IHasId)pEnt);
        if (old.getRsAc() != null) {
            throw new ExcCode(100, "Attempt to edit completed bank statement line!");
        }
        pEnt.setStas(old.getStas());
        pEnt.setAmnt(old.getAmnt());
        pEnt.setDat(old.getDat());
        pEnt.setDsSt(old.getDsSt());
        if (pEnt.getAmnt().compareTo(BigDecimal.ZERO) == 0) {
            throw new ExcCode(1003, "amount_is_zero");
        }
        DateFormat dtFrm = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        String prepId = pRqDt.getParam("prepId");
        if (prepId != null && !"".equals(prepId)) {
            this.makePrepMatchingReversed(pRvs, vs, prepId, pEnt, dtFrm, cpf);
        } else {
            String paymId = pRqDt.getParam("paymId");
            if (paymId != null && !"".equals(paymId)) {
                this.makePaymMatchingReversed(pRvs, vs, paymId, pEnt, dtFrm, cpf);
            } else {
                String entrId = pRqDt.getParam("entrId");
                if (entrId != null && !"".equals(entrId)) {
                    this.makeAccentryMatchingReversed(pRvs, vs, entrId, pEnt, dtFrm, cpf);
                } else {
                    String adjDocType = pRqDt.getParam("adjDocType");
                    if (adjDocType != null && !"".equals(adjDocType) && !"-".equals(adjDocType)) {
                        if (EBnEnrSt.VOIDED.equals((Object)pEnt.getStas())) {
                            throw new ExcCode(100, "can_not_create_for_voided");
                        }
                        if ("1".equals(adjDocType)) {
                            this.createPrep(pRvs, vs, pEnt, dtFrm, cpf, pRqDt);
                        } else if ("2".equals(adjDocType)) {
                            this.createPaym(pRvs, vs, pEnt, dtFrm, cpf, pRqDt);
                        } else {
                            this.createAccentry(pRvs, vs, pEnt, dtFrm, cpf, pRqDt);
                        }
                    } else {
                        throw new ExcCode(1001, "Wrong parameters!");
                    }
                }
            }
        }
        Object[] upFds = new String[]{"dsSt", "rsAc", "rsDs", "rsRcId", "rsRcTy", "ver"};
        Arrays.sort(upFds);
        vs.put("ndFds", upFds);
        this.orm.update(pRvs, vs, (IHasId)pEnt);
        vs.clear();
        pRvs.put("msgSuc", "update_ok");
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setOwnr((IHasId)pEnt.getOwnr());
        return null;
    }

    public final void createPaym(Map<String, Object> pRvs, Map<String, Object> pVs, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf, IReqDt pRqDt) throws Exception {
        BigDecimal toFc;
        String forTotStr = pRqDt.getParam("toFc");
        if (forTotStr == null || "".equals(forTotStr)) {
            toFc = BigDecimal.ZERO;
        } else {
            if (pCpf.getDcSpv() != null) {
                forTotStr = forTotStr.replace(pCpf.getDcGrSpv(), "").replace(pCpf.getDcSpv(), ".");
            }
            toFc = new BigDecimal(forTotStr);
        }
        String accCashStr = pRqDt.getParam("accCash");
        Acnt accCash = new Acnt();
        accCash.setIid(accCashStr);
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)accCash);
        if (accCash.getIid() == null) {
            throw new Exception("cant_find_account");
        }
        Date dat = this.srvDt.from8601DateTime(pRqDt.getParam("dat"));
        EBnEnrRsTy rsRcTy = null;
        EBnEnrRsAc rsAc = EBnEnrRsAc.CREATE;
        String rsDs = null;
        Long rsRcId = null;
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            String invStr = pRqDt.getParam("invoice");
            SalInv inv = new SalInv();
            inv.setIid(Long.parseLong(invStr));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)inv);
            if (inv.getIid() == null) {
                throw new Exception("Can't find debtor invoice# " + invStr);
            }
            rsRcTy = EBnEnrRsTy.PREPFR;
            PaymFr pay = new PaymFr();
            pay.setDbOr(this.getOrm().getDbId());
            pay.setDat(dat);
            pay.setInv(inv);
            pay.setAcc(accCash);
            pay.setSaNm(pBsl.getOwnr().getBnka().getNme());
            pay.setSaId(pBsl.getOwnr().getBnka().getIid());
            pay.setSaTy(1003);
            pay.setTot(pBsl.getAmnt().abs());
            pay.setToFc(toFc);
            pay.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
            pay.setMdEnr(true);
            this.getOrm().insIdLn(pRvs, pVs, (IHasId)pay);
            this.srEntr.mkEntrs(pRvs, pay);
            this.srToPa.mkToPa(pRvs, pay.getInv(), this.rvSaLn);
            Object[] fdsIa = new String[]{"pdsc", "toPa", "paFc", "ver"};
            Arrays.sort(fdsIa);
            pVs.put("ndFds", fdsIa);
            this.orm.update(pRvs, pVs, (IHasId)pay.getInv());
            pVs.clear();
            rsRcId = pay.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, pay, pay.getDat(), pCpf);
        } else {
            String invStr = pRqDt.getParam("invoice");
            PurInv inv = new PurInv();
            inv.setIid(Long.parseLong(invStr));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)inv);
            if (inv.getIid() == null) {
                throw new Exception("Can't find debtor invoice# " + invStr);
            }
            rsRcTy = EBnEnrRsTy.PREPTO;
            PaymTo pay = new PaymTo();
            pay.setDbOr(this.getOrm().getDbId());
            pay.setDat(dat);
            pay.setInv(inv);
            pay.setAcc(accCash);
            pay.setSaNm(pBsl.getOwnr().getBnka().getNme());
            pay.setSaId(pBsl.getOwnr().getBnka().getIid());
            pay.setSaTy(1003);
            pay.setTot(pBsl.getAmnt().abs());
            pay.setToFc(toFc);
            pay.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
            pay.setMdEnr(true);
            this.getOrm().insIdLn(pRvs, pVs, (IHasId)pay);
            this.srEntr.mkEntrs(pRvs, pay);
            this.srToPa.mkToPa(pRvs, pay.getInv(), this.rvPuLn);
            Object[] fdsIa = new String[]{"pdsc", "toPa", "paFc", "ver"};
            Arrays.sort(fdsIa);
            pVs.put("ndFds", fdsIa);
            this.orm.update(pRvs, pVs, (IHasId)pay.getInv());
            pVs.clear();
            rsRcId = pay.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, pay, pay.getDat(), pCpf);
        }
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final void createPrep(Map<String, Object> pRvs, Map<String, Object> pVs, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf, IReqDt pRqDt) throws Exception {
        BigDecimal toFc;
        String forTotStr = pRqDt.getParam("toFc");
        if (forTotStr == null || "".equals(forTotStr)) {
            toFc = BigDecimal.ZERO;
        } else {
            if (pCpf.getDcSpv() != null) {
                forTotStr = forTotStr.replace(pCpf.getDcGrSpv(), "").replace(pCpf.getDcSpv(), ".");
            }
            toFc = new BigDecimal(forTotStr);
        }
        String dcIdStr = pRqDt.getParam("dbcr");
        DbCr dc = new DbCr();
        dc.setIid(Long.parseLong(dcIdStr));
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)dc);
        if (dc.getIid() == null) {
            throw new Exception("cant_find_debtor_creditor");
        }
        String accCashStr = pRqDt.getParam("accCash");
        Acnt accCash = new Acnt();
        accCash.setIid(accCashStr);
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)accCash);
        if (accCash.getIid() == null) {
            throw new Exception("cant_find_account");
        }
        Date dat = this.srvDt.from8601DateTime(pRqDt.getParam("dat"));
        EBnEnrRsTy rsRcTy = null;
        EBnEnrRsAc rsAc = EBnEnrRsAc.CREATE;
        String rsDs = null;
        Long rsRcId = null;
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            rsRcTy = EBnEnrRsTy.PREPFR;
            PrepFr prep = new PrepFr();
            prep.setDbOr(this.getOrm().getDbId());
            prep.setDat(dat);
            prep.setDbcr(dc);
            prep.setAcc(accCash);
            prep.setSaNm(pBsl.getOwnr().getBnka().getNme());
            prep.setSaId(pBsl.getOwnr().getBnka().getIid());
            prep.setSaTy(1003);
            prep.setTot(pBsl.getAmnt().abs());
            prep.setToFc(toFc);
            prep.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
            prep.setMdEnr(true);
            this.getOrm().insIdLn(pRvs, pVs, (IHasId)prep);
            this.srEntr.mkEntrs(pRvs, prep);
            rsRcId = prep.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, prep, prep.getDat(), pCpf);
        } else {
            rsRcTy = EBnEnrRsTy.PREPTO;
            PrepTo prep = new PrepTo();
            prep.setDbOr(this.getOrm().getDbId());
            prep.setDbcr(dc);
            prep.setDat(dat);
            prep.setAcc(accCash);
            prep.setSaNm(pBsl.getOwnr().getBnka().getNme());
            prep.setSaId(pBsl.getOwnr().getBnka().getIid());
            prep.setSaTy(1003);
            prep.setTot(pBsl.getAmnt().abs());
            prep.setToFc(toFc);
            prep.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
            prep.setMdEnr(true);
            this.getOrm().insIdLn(pRvs, pVs, (IHasId)prep);
            this.srEntr.mkEntrs(pRvs, prep);
            rsRcId = prep.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, prep, prep.getDat(), pCpf);
        }
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final void createAccentry(Map<String, Object> pRvs, Map<String, Object> pVs, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf, IReqDt pRqDt) throws Exception {
        String subcorAccNm = null;
        Long subcorAccId = null;
        String accCashStr = pRqDt.getParam("accCash");
        Acnt accCash = new Acnt();
        accCash.setIid(accCashStr);
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)accCash);
        if (accCash.getIid() == null) {
            throw new Exception("cant_find_account");
        }
        String corAccStr = pRqDt.getParam("corAcc");
        Acnt corAcc = new Acnt();
        corAcc.setIid(corAccStr);
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)corAcc);
        if (corAcc.getIid() == null) {
            throw new Exception("cant_find_account");
        }
        if (corAcc.getSaTy() != null) {
            subcorAccNm = pRqDt.getParam("subcorAccNm");
            String subcorAccIdStr = pRqDt.getParam("subcorAccId");
            subcorAccId = Long.parseLong(subcorAccIdStr);
        }
        Date dat = this.srvDt.from8601DateTime(pRqDt.getParam("dat"));
        EBnEnrRsTy rsRcTy = EBnEnrRsTy.ACC_ENTRY;
        EBnEnrRsAc rsAc = EBnEnrRsAc.CREATE;
        String rsDs = null;
        Long rsRcId = null;
        Entr entr = new Entr();
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            entr.setAcDb(accCash);
            entr.setSadNm(pBsl.getOwnr().getBnka().getNme());
            entr.setSadId(pBsl.getOwnr().getBnka().getIid());
            entr.setSadTy(1003);
            entr.setAcCr(corAcc);
            entr.setSacNm(subcorAccNm);
            entr.setSacId(subcorAccId);
            entr.setSacTy(corAcc.getSaTy());
        } else {
            entr.setAcDb(corAcc);
            entr.setSadNm(subcorAccNm);
            entr.setSadId(subcorAccId);
            entr.setSadTy(corAcc.getSaTy());
            entr.setAcCr(accCash);
            entr.setSacNm(pBsl.getOwnr().getBnka().getNme());
            entr.setSacId(pBsl.getOwnr().getBnka().getIid());
            entr.setSacTy(1003);
        }
        entr.setSrTy(pBsl.cnsTy());
        entr.setSrId(pBsl.getIid());
        entr.setDbOr(pBsl.getDbOr());
        entr.setDat(dat);
        entr.setDebt(pBsl.getAmnt().abs());
        entr.setCred(entr.getDebt());
        entr.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
        this.getOrm().insIdLn(pRvs, pVs, (IHasId)entr);
        rsRcId = entr.getIid();
        rsDs = this.makeBslResDescr(rsAc, pDtFrm, entr, entr.getDat(), pCpf);
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final void makeAccentryMatchingReversed(Map<String, Object> pRvs, Map<String, Object> pVs, String pEntryId, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf) throws Exception {
        EBnEnrRsTy rsRcTy = EBnEnrRsTy.ACC_ENTRY;
        EBnEnrRsAc rsAc = null;
        String rsDs = null;
        Long rsRcId = null;
        Entr entr = new Entr();
        entr.setIid(Long.parseLong(pEntryId));
        this.getOrm().refrEnt(pRvs, pVs, (IHasId)entr);
        if (entr.getIid() == null) {
            throw new ExcCode(1003, "cant_found_accentry");
        }
        if (entr.getSrTy() == 1010) {
            throw new ExcCode(1003, "AlreadyDone");
        }
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0 && pBsl.getAmnt().compareTo(entr.getDebt()) != 0 && entr.getSadTy() != 1003 && !pBsl.getOwnr().getBnka().getIid().equals(entr.getSadId())) {
            throw new ExcCode(1003, "record_is_not_matching");
        }
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) < 0 && pBsl.getAmnt().abs().compareTo(entr.getCred()) != 0 && entr.getSacTy() != 1003 && !pBsl.getOwnr().getBnka().getIid().equals(entr.getSacId())) {
            throw new ExcCode(1003, "record_is_not_matching");
        }
        if (EBnEnrSt.VOIDED.equals((Object)pBsl.getStas())) {
            if (!entr.getDbOr().equals(this.getOrm().getDbId())) {
                throw new ExcCode(100, "can_not_change_foreign_src");
            }
            rsAc = EBnEnrRsAc.CREATE;
            Entr revd = entr;
            entr = new Entr();
            entr.setIsNew(true);
            entr.setSrTy(pBsl.cnsTy());
            entr.setSrId(pBsl.getIid());
            entr.setDbOr(revd.getDbOr());
            entr.setRvId(revd.getIid());
            entr.setDat(new Date(revd.getDat().getTime() + 1L));
            entr.setAcDb(revd.getAcDb());
            entr.setSadNm(revd.getSadNm());
            entr.setSadId(revd.getSadId());
            entr.setSadTy(revd.getSadTy());
            entr.setDebt(revd.getDebt().negate());
            entr.setAcCr(revd.getAcCr());
            entr.setSacNm(revd.getSacNm());
            entr.setSacId(revd.getSacId());
            entr.setSacTy(revd.getSacTy());
            entr.setCred(revd.getCred().negate());
            entr.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf) + " " + this.getI18n().getMsg("revd_n", pCpf.getLngDef().getIid()) + entr.getDbOr() + "-" + entr.getRvId());
            this.getOrm().insIdLn(pRvs, pVs, (IHasId)entr);
            String oldDesr = "";
            if (revd.getDscr() != null) {
                oldDesr = revd.getDscr();
            }
            revd.setDscr(oldDesr + " " + this.getI18n().getMsg("reversing_n", pCpf.getLngDef().getIid()) + entr.getDbOr() + "-" + entr.getIid());
            revd.setRvId(entr.getIid());
            this.getOrm().update(pRvs, pVs, (IHasId)revd);
        } else {
            rsAc = EBnEnrRsAc.MATCH;
        }
        rsRcId = entr.getIid();
        rsDs = this.makeBslResDescr(rsAc, pDtFrm, entr, entr.getDat(), pCpf);
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final void makePaymMatchingReversed(Map<String, Object> pRvs, Map<String, Object> pVs, String pPayId, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf) throws Exception {
        EBnEnrRsTy rsRcTy = null;
        EBnEnrRsAc rsAc = null;
        String rsDs = null;
        Long rsRcId = null;
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            PaymFr pay = new PaymFr();
            pay.setIid(Long.parseLong(pPayId));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)pay);
            if (!pay.getMdEnr().booleanValue() || pBsl.getAmnt().abs().compareTo(pay.getTot()) != 0 || pay.getSaTy() != 1003 || !pBsl.getOwnr().getBnka().getIid().equals(pay.getSaId())) {
                throw new ExcCode(1003, "record_is_not_matching");
            }
            rsRcTy = EBnEnrRsTy.PAYMFR;
            if (EBnEnrSt.VOIDED.equals((Object)pBsl.getStas()) && pay.getRvId() == null) {
                rsAc = EBnEnrRsAc.CREATE;
                PaymFr revd = pay;
                pay = new PaymFr();
                pay.setDbOr(this.orm.getDbId());
                pay.setIsNew(true);
                pay.setAcc(revd.getAcc());
                pay.setSaNm(revd.getSaNm());
                pay.setSaId(revd.getSaId());
                pay.setSaTy(1003);
                pay.setInv(revd.getInv());
                pay.setToFc(revd.getToFc().negate());
                pay.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
                this.srEntr.revEntrs(pRvs, pay, revd);
            } else {
                rsAc = EBnEnrRsAc.MATCH;
            }
            rsRcId = pay.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, pay, pay.getDat(), pCpf);
        } else {
            PaymTo pay = new PaymTo();
            pay.setIid(Long.parseLong(pPayId));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)pay);
            if (!pay.getMdEnr().booleanValue() || pBsl.getAmnt().abs().compareTo(pay.getTot()) != 0 || pay.getSaTy() != 1003 || !pBsl.getOwnr().getBnka().getIid().equals(pay.getSaId())) {
                throw new ExcCode(1003, "record_is_not_matching");
            }
            rsRcTy = EBnEnrRsTy.PAYMTO;
            if (EBnEnrSt.VOIDED.equals((Object)pBsl.getStas()) && pay.getRvId() == null) {
                rsAc = EBnEnrRsAc.CREATE;
                PaymTo revd = pay;
                pay = new PaymTo();
                pay.setDbOr(this.orm.getDbId());
                pay.setIsNew(true);
                pay.setAcc(revd.getAcc());
                pay.setSaNm(revd.getSaNm());
                pay.setSaId(revd.getSaId());
                pay.setSaTy(1003);
                pay.setInv(revd.getInv());
                pay.setToFc(revd.getToFc().negate());
                pay.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
                this.srEntr.revEntrs(pRvs, pay, revd);
            } else {
                rsAc = EBnEnrRsAc.MATCH;
            }
            rsRcId = pay.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, pay, pay.getDat(), pCpf);
        }
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final void makePrepMatchingReversed(Map<String, Object> pRvs, Map<String, Object> pVs, String pPrepayId, BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf) throws Exception {
        EBnEnrRsTy rsRcTy = null;
        EBnEnrRsAc rsAc = null;
        String rsDs = null;
        Long rsRcId = null;
        if (pBsl.getAmnt().compareTo(BigDecimal.ZERO) > 0) {
            PrepFr prep = new PrepFr();
            prep.setIid(Long.parseLong(pPrepayId));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)prep);
            if (!prep.getMdEnr().booleanValue() || pBsl.getAmnt().abs().compareTo(prep.getTot()) != 0 || prep.getSaTy() != 1003 || !pBsl.getOwnr().getBnka().getIid().equals(prep.getSaId())) {
                throw new ExcCode(1003, "record_is_not_matching");
            }
            rsRcTy = EBnEnrRsTy.PREPFR;
            if (EBnEnrSt.VOIDED.equals((Object)pBsl.getStas()) && prep.getRvId() == null) {
                rsAc = EBnEnrRsAc.CREATE;
                PrepFr revd = prep;
                prep = new PrepFr();
                prep.setDbOr(this.orm.getDbId());
                prep.setIsNew(true);
                prep.setAcc(revd.getAcc());
                prep.setSaNm(revd.getSaNm());
                prep.setSaId(revd.getSaId());
                prep.setSaTy(1003);
                prep.setDbcr(revd.getDbcr());
                prep.setToFc(revd.getToFc().negate());
                prep.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
                this.srEntr.revEntrs(pRvs, prep, revd);
            } else {
                rsAc = EBnEnrRsAc.MATCH;
            }
            rsRcId = prep.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, prep, prep.getDat(), pCpf);
        } else {
            PrepTo prep = new PrepTo();
            prep.setIid(Long.parseLong(pPrepayId));
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)prep);
            if (!prep.getMdEnr().booleanValue() || pBsl.getAmnt().abs().compareTo(prep.getTot()) != 0 || prep.getSaTy() != 1003 || !pBsl.getOwnr().getBnka().getIid().equals(prep.getSaId())) {
                throw new ExcCode(1003, "record_is_not_matching");
            }
            rsRcTy = EBnEnrRsTy.PREPTO;
            if (EBnEnrSt.VOIDED.equals((Object)pBsl.getStas()) && prep.getRvId() == null) {
                rsAc = EBnEnrRsAc.CREATE;
                PrepTo revd = prep;
                prep = new PrepTo();
                prep.setDbOr(this.orm.getDbId());
                prep.setIsNew(true);
                prep.setAcc(revd.getAcc());
                prep.setSaNm(revd.getSaNm());
                prep.setSaId(revd.getSaId());
                prep.setSaTy(1003);
                prep.setDbcr(revd.getDbcr());
                prep.setToFc(revd.getToFc().negate());
                prep.setDscr(this.makeDescrForCreated(pBsl, pDtFrm, pCpf));
                this.srEntr.revEntrs(pRvs, prep, revd);
            } else {
                rsAc = EBnEnrRsAc.MATCH;
            }
            rsRcId = prep.getIid();
            rsDs = this.makeBslResDescr(rsAc, pDtFrm, prep, prep.getDat(), pCpf);
        }
        pBsl.setRsAc(rsAc);
        pBsl.setRsRcTy(rsRcTy);
        pBsl.setRsRcId(rsRcId);
        pBsl.setRsDs(rsDs);
    }

    public final String makeBslResDescr(EBnEnrRsAc pResAct, DateFormat pDtFrm, AOrId pRecord, Date pDate, CmnPrf pCpf) {
        StringBuffer sb = new StringBuffer();
        if (EBnEnrRsAc.MATCH.equals((Object)pResAct)) {
            sb.append(this.getI18n().getMsg("Found", pCpf.getLngDef().getIid()));
        } else {
            sb.append(this.getI18n().getMsg("Created", pCpf.getLngDef().getIid()));
        }
        sb.append(" " + this.getI18n().getMsg(pRecord.getClass().getSimpleName() + "sht", pCpf.getLngDef().getIid()));
        sb.append("#" + pRecord.getDbOr() + "-" + pRecord.getIid() + ", " + pDtFrm.format(pDate));
        return sb.toString();
    }

    public final String makeDescrForCreated(BnStLn pBsl, DateFormat pDtFrm, CmnPrf pCpf) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getI18n().getMsg("Created", pCpf.getLngDef().getIid()) + " " + this.getI18n().getMsg("by", pCpf.getLngDef().getIid()));
        sb.append(" " + this.getI18n().getMsg(pBsl.getClass().getSimpleName() + "sht", pCpf.getLngDef().getIid()));
        sb.append("#" + pBsl.getDbOr() + "-" + pBsl.getIid() + ", " + pDtFrm.format(pBsl.getDat()));
        sb.append(" (" + pBsl.getDsSt() + ")");
        return sb.toString();
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ISrEntr getSrEntr() {
        return this.srEntr;
    }

    public final void setSrEntr(ISrEntr pSrEntr) {
        this.srEntr = pSrEntr;
    }

    public final ISrvDt getSrvDt() {
        return this.srvDt;
    }

    public final void setSrvDt(ISrvDt pSrvDt) {
        this.srvDt = pSrvDt;
    }

    public final ISrToPa getSrToPa() {
        return this.srToPa;
    }

    public final void setSrToPa(ISrToPa pSrToPa) {
        this.srToPa = pSrToPa;
    }

    public final IRvInvLn<PurInv, ?> getRvPuLn() {
        return this.rvPuLn;
    }

    public final void setRvPuLn(IRvInvLn<PurInv, ?> pRvPuLn) {
        this.rvPuLn = pRvPuLn;
    }

    public final IRvInvLn<SalInv, ?> getRvSaLn() {
        return this.rvSaLn;
    }

    public final void setRvSaLn(IRvInvLn<SalInv, ?> pRvSaLn) {
        this.rvSaLn = pRvSaLn;
    }
}

