/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.EBnEnrSt;
import org.beigesoft.acc.mdlp.BnStLn;
import org.beigesoft.acc.mdlp.BnkStm;
import org.beigesoft.acc.srv.UtlBas;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.mdlp.CsvCl;
import org.beigesoft.mdlp.IOrId;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.ICsvRdr;
import org.beigesoft.srv.II18n;

public class BnkStmSv
implements IPrcEnt<BnkStm, Long> {
    private IOrm orm;
    private UtlBas utlBas;
    private II18n i18n;
    private ICsvRdr csvRdr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BnkStm process(Map<String, Object> pRvs, BnkStm pEnt, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        this.utlBas.chDtForg(pRvs, (IOrId)pEnt, pEnt.getDat());
        if (pEnt.getIsNew().booleanValue()) {
            this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getMth());
            vs.put("CsvMthdpLv", 0);
            pEnt.getMth().getMth().setClns(this.orm.retLstCnd(pRvs, vs, CsvCl.class, "where OWNR=" + pEnt.getMth().getMth().getIid()));
            vs.clear();
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(pEnt.getMth().getDtCl().getFrmt());
            }
            catch (Exception ee) {
                throw new ExcCode(1003, "!Wrong date format! Format: " + pEnt.getMth().getDtCl().getFrmt(), (Throwable)ee);
            }
            String[] seps = null;
            if (pEnt.getMth().getAmCl().getFrmt() != null) {
                try {
                    seps = pEnt.getMth().getAmCl().getFrmt().split(",");
                    for (int i = 0; i < 2; ++i) {
                        if ("SPACE".equals(seps[i])) {
                            seps[i] = " ";
                            continue;
                        }
                        if (!"COMMA".equals(seps[i])) continue;
                        seps[i] = ",";
                    }
                }
                catch (Exception ee) {
                    throw new ExcCode(1003, "!Wrong amount format! Format: " + pEnt.getMth().getAmCl().getFrmt(), (Throwable)ee);
                }
            }
            String fileUplNm = (String)pRqDt.getAttr("fileUplNm");
            pEnt.setSrcNm(fileUplNm + "/" + pEnt.getMth().getNme());
            this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
            try (InputStreamReader rdr = null;){
                List csvRow;
                InputStream ins = (InputStream)pRqDt.getAttr("fileUplIs");
                rdr = new InputStreamReader(ins, Charset.forName(pEnt.getMth().getMth().getChrst()).newDecoder());
                int r = 0;
                while ((csvRow = this.csvRdr.readNext(pRvs, (Reader)rdr, pEnt.getMth().getMth())) != null) {
                    if (++r == 1 && pEnt.getMth().getMth().getHasHd().booleanValue()) continue;
                    BnStLn bsl = new BnStLn();
                    bsl.setDbOr(this.orm.getDbId());
                    bsl.setOwnr(pEnt);
                    String dateStr = (String)csvRow.get(pEnt.getMth().getDtCl().getIndx() - 1);
                    try {
                        bsl.setDat(sdf.parse(dateStr));
                    }
                    catch (Exception ee) {
                        throw new ExcCode(1003, "!Wrong date value! Value/Format: " + dateStr + "/" + pEnt.getMth().getDtCl().getFrmt(), (Throwable)ee);
                    }
                    String amStr = (String)csvRow.get(pEnt.getMth().getAmCl().getIndx() - 1);
                    try {
                        if (seps != null) {
                            if (!"NONE".equals(seps[0])) {
                                amStr = amStr.replace(seps[0], ".");
                            }
                            if (!"NONE".equals(seps[1])) {
                                amStr = amStr.replace(seps[1], "");
                            }
                        }
                        bsl.setAmnt(new BigDecimal(amStr));
                    }
                    catch (Exception ee) {
                        throw new ExcCode(1003, "Wrong amount value! Value/Format: " + amStr + "/" + pEnt.getMth().getAmCl().getFrmt(), (Throwable)ee);
                    }
                    String descr = null;
                    if (pEnt.getMth().getDsCl() != null) {
                        descr = (String)csvRow.get(pEnt.getMth().getDsCl().getIndx() - 1);
                    }
                    if (pEnt.getMth().getStCl() != null) {
                        String stStr = (String)csvRow.get(pEnt.getMth().getStCl().getIndx() - 1);
                        descr = descr == null ? stStr : descr + "/" + stStr;
                        if (pEnt.getMth().getAcWds() != null && !pEnt.getMth().getAcWds().contains(stStr)) {
                            bsl.setStas(EBnEnrSt.OTHER);
                        }
                        if (pEnt.getMth().getVdWds() != null && pEnt.getMth().getVdWds().contains(stStr)) {
                            bsl.setStas(EBnEnrSt.VOIDED);
                        }
                    }
                    bsl.setDsSt(descr);
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)bsl);
                }
            }
            pRvs.put("msgSuc", "insert_ok");
        } else {
            Object[] upFds = new String[]{"dat", "dscr", "ver", "bnka"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            this.getOrm().update(pRvs, vs, (IHasId)pEnt);
            vs.clear();
            pRvs.put("msgSuc", "update_ok");
        }
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setEnt((IHasId)pEnt);
        return pEnt;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final UtlBas getUtlBas() {
        return this.utlBas;
    }

    public final void setUtlBas(UtlBas pUtlBas) {
        this.utlBas = pUtlBas;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ICsvRdr getCsvRdr() {
        return this.csvRdr;
    }

    public final void setCsvRdr(ICsvRdr pCsvRdr) {
        this.csvRdr = pCsvRdr;
    }
}

