/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.MnfPrc;
import org.beigesoft.acc.mdlp.MnpAcs;
import org.beigesoft.acc.mdlp.MnpMcs;
import org.beigesoft.acc.srv.ISrDrItEnr;
import org.beigesoft.acc.srv.ISrEntr;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.acc.srv.UtlBas;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.srv.II18n;

public class MnfPrcSv
implements IPrcEnt<MnfPrc, Long> {
    private IOrm orm;
    private ISrEntr srEntr;
    private UtlBas utlBas;
    private ISrWrhEnr srWrhEnr;
    private ISrDrItEnr srDrItEnr;
    private II18n i18n;

    public final MnfPrc process(Map<String, Object> pRvs, MnfPrc pEnt, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        if (pEnt.getRvId() != null) {
            MnfPrc revd = new MnfPrc();
            revd.setIid(pEnt.getRvId());
            this.orm.refrEnt(pRvs, vs, (IHasId)revd);
            if (revd.getQuan().compareTo(revd.getItLf()) == 1) {
                throw new ExcCode(1003, "where_is_withdraw");
            }
            this.utlBas.chDtForg(pRvs, revd, revd.getDat());
            pEnt.setDbOr(this.orm.getDbId());
            pEnt.setTot(revd.getTot().negate());
            this.srEntr.revEntrs(pRvs, pEnt, revd);
            vs.put("MnpMcsdpLv", 1);
            List rdmls = this.orm.retLstCnd(pRvs, vs, MnpMcs.class, "where RVID is null and OWNR=" + revd.getIid());
            vs.clear();
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            for (MnpMcs rdml : rdmls) {
                MnpMcs rgl = new MnpMcs();
                rgl.setDbOr(this.orm.getDbId());
                rgl.setOwnr(pEnt);
                rgl.setRvId(rdml.getIid());
                rgl.setItm(rdml.getItm());
                rgl.setUom(rdml.getUom());
                rgl.setQuan(rdml.getQuan().negate());
                StringBuffer sb = new StringBuffer();
                if (rgl.getDscr() != null) {
                    sb.append(rgl.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
                sb.append(" #" + rdml.getDbOr() + "-" + rdml.getIid());
                rgl.setDscr(sb.toString());
                this.orm.insIdLn(pRvs, vs, (IHasId)rgl);
                sb.delete(0, sb.length());
                if (rdml.getDscr() != null) {
                    sb.append(rdml.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
                sb.append(" #" + rgl.getDbOr() + "-" + rgl.getIid());
                rdml.setDscr(sb.toString());
                rdml.setRvId(rgl.getIid());
                Object[] upFds = new String[]{"rvId", "dscr", "ver"};
                Arrays.sort(upFds);
                vs.put("ndFds", upFds);
                this.orm.update(pRvs, vs, (IHasId)rdml);
                vs.clear();
                this.srDrItEnr.rvDraw(pRvs, rgl);
                this.srWrhEnr.revDraw(pRvs, rgl);
            }
            vs.put("MnpAcsdpLv", 1);
            List rdals = this.orm.retLstCnd(pRvs, vs, MnpAcs.class, "where RVID is null and OWNR=" + revd.getIid());
            vs.clear();
            for (MnpAcs rdal : rdals) {
                MnpAcs rgl = new MnpAcs();
                rgl.setDbOr(this.orm.getDbId());
                rgl.setOwnr(pEnt);
                rgl.setRvId(rdal.getIid());
                rgl.setAcc(rdal.getAcc());
                rgl.setSaId(rdal.getSaId());
                rgl.setSaNm(rdal.getSaNm());
                rgl.setSaTy(rdal.getSaTy());
                rgl.setTot(rdal.getTot().negate());
                StringBuffer sb = new StringBuffer();
                if (rgl.getDscr() != null) {
                    sb.append(rgl.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
                sb.append(" #" + rdal.getDbOr() + "-" + rdal.getIid());
                rgl.setDscr(sb.toString());
                this.orm.insIdLn(pRvs, vs, (IHasId)rgl);
                sb.delete(0, sb.length());
                if (rdal.getDscr() != null) {
                    sb.append(rdal.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
                sb.append(" #" + rgl.getDbOr() + "-" + rgl.getIid());
                rdal.setDscr(sb.toString());
                rdal.setRvId(rgl.getIid());
                Object[] upFds = new String[]{"rvId", "dscr", "ver"};
                Arrays.sort(upFds);
                vs.put("ndFds", upFds);
                this.orm.update(pRvs, vs, (IHasId)rdal);
                vs.clear();
            }
            pRvs.put("msgSuc", "reverse_ok");
        } else {
            this.utlBas.chDtForg(pRvs, pEnt, pEnt.getDat());
            if (pEnt.getQuan().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ExcCode(1003, "quantity_less_or_equal_zero");
            }
            pEnt.setItLf(pEnt.getQuan());
            if (pEnt.getIsNew().booleanValue()) {
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                pRvs.put("msgSuc", "insert_ok");
            } else {
                Object[] slFds = new String[]{"tot", "mdEnr"};
                Arrays.sort(slFds);
                vs.put("MnfPrcndFds", slFds);
                MnfPrc old = (MnfPrc)this.orm.retEnt(pRvs, vs, (IHasId)pEnt);
                vs.clear();
                pEnt.setMdEnr(old.getMdEnr());
                if (pEnt.getMdEnr().booleanValue()) {
                    throw new ExcCode(100, "Trying to change accounted!");
                }
                AcStg as = (AcStg)((Object)pRvs.get("astg"));
                pEnt.setPri(pEnt.getTot().divide(pEnt.getQuan(), (int)as.getPrDp(), as.getRndm()));
                if ("mkEnr".equals(pRqDt.getParam("acAd"))) {
                    if (old.getTot().compareTo(BigDecimal.ZERO) == 0) {
                        throw new ExcCode(1003, "amount_eq_zero");
                    }
                    if (!pEnt.getCmpl().booleanValue()) {
                        throw new ExcCode(1003, "complite_first");
                    }
                    pEnt.setMdEnr(true);
                    Object[] upFds = new String[]{"dat", "dscr", "ver", "cmpl", "quan", "pri", "itm", "uom", "wrhp", "mdEnr", "itLf"};
                    Arrays.sort(upFds);
                    vs.put("ndFds", upFds);
                    this.getOrm().update(pRvs, vs, (IHasId)pEnt);
                    vs.clear();
                    this.srWrhEnr.load(pRvs, pEnt, pEnt.getWrhp());
                    this.srEntr.mkEntrs(pRvs, pEnt);
                    pRvs.put("msgSuc", "account_ok");
                } else {
                    Object[] upFds = new String[]{"dat", "dscr", "ver", "cmpl", "quan", "pri", "itm", "uom", "wrhp", "itLf"};
                    Arrays.sort(upFds);
                    vs.put("ndFds", upFds);
                    this.getOrm().update(pRvs, vs, (IHasId)pEnt);
                    vs.clear();
                    pRvs.put("msgSuc", "update_ok");
                }
            }
        }
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setEnt((IHasId)pEnt);
        return pEnt;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrEntr getSrEntr() {
        return this.srEntr;
    }

    public final void setSrEntr(ISrEntr pSrEntr) {
        this.srEntr = pSrEntr;
    }

    public final UtlBas getUtlBas() {
        return this.utlBas;
    }

    public final void setUtlBas(UtlBas pUtlBas) {
        this.utlBas = pUtlBas;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ISrDrItEnr getSrDrItEnr() {
        return this.srDrItEnr;
    }

    public final void setSrDrItEnr(ISrDrItEnr pSrDrItEnr) {
        this.srDrItEnr = pSrDrItEnr;
    }
}

