/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdl.MnfFdDe;
import org.beigesoft.acc.mdl.MnfFdWe;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Mnfct;
import org.beigesoft.acc.srv.ISrDrItEnr;
import org.beigesoft.acc.srv.ISrEntr;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.acc.srv.UtlBas;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;

public class MnfctSv
implements IPrcEnt<Mnfct, Long> {
    private IOrm orm;
    private ISrEntr srEntr;
    private UtlBas utlBas;
    private ISrWrhEnr srWrhEnr;
    private ISrDrItEnr srDrItEnr;

    public final Mnfct process(Map<String, Object> pRvs, Mnfct pEnt, IReqDt pRqDt) throws Exception {
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getMnp());
        MnfFdWe mnfFdWe = new MnfFdWe(pEnt);
        MnfFdDe mnfFdDe = new MnfFdDe(pEnt);
        if (pEnt.getRvId() != null) {
            Mnfct revd = new Mnfct();
            revd.setIid(pEnt.getRvId());
            this.orm.refrEnt(pRvs, vs, (IHasId)revd);
            if (revd.getQuan().compareTo(revd.getItLf()) == 1) {
                throw new ExcCode(1003, "where_is_withdraw");
            }
            this.utlBas.chDtForg(pRvs, revd, revd.getDat());
            pEnt.setDbOr(this.orm.getDbId());
            pEnt.setTot(revd.getTot().negate());
            this.srEntr.revEntrs(pRvs, pEnt, revd);
            this.srDrItEnr.rvDraw(pRvs, mnfFdDe);
            this.srWrhEnr.revDraw(pRvs, mnfFdWe);
            this.srWrhEnr.revLoad(pRvs, pEnt);
            pRvs.put("msgSuc", "reverse_ok");
        } else {
            this.utlBas.chDtForg(pRvs, pEnt, pEnt.getDat());
            if (pEnt.getQuan().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ExcCode(1003, "quantity_less_or_equal_zero");
            }
            if (pEnt.getQuan().compareTo(pEnt.getMnp().getItLf()) == 1) {
                throw new ExcCode(1003, "LINE_HAS_NO_GOODS");
            }
            pEnt.setItLf(pEnt.getQuan());
            AcStg as = (AcStg)((Object)pRvs.get("astg"));
            if (pEnt.getMnp().getItLf().compareTo(pEnt.getQuan()) == 0) {
                pEnt.setTot(pEnt.getMnp().getToLf());
            } else {
                pEnt.setTot(pEnt.getMnp().getToLf().divide(pEnt.getMnp().getItLf(), 15, as.getRndm()).multiply(pEnt.getQuan()).setScale((int)as.getPrDp(), as.getRndm()));
            }
            pEnt.setPri(pEnt.getTot().divide(pEnt.getQuan(), (int)as.getPrDp(), as.getRndm()));
            pEnt.setToLf(pEnt.getTot());
            if (pEnt.getIsNew().booleanValue()) {
                if ("mkEnr".equals(pRqDt.getParam("acAd"))) {
                    pEnt.setMdEnr(true);
                } else {
                    pRvs.put("msgSuc", "insert_ok");
                }
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
            } else {
                Object[] slFds = new String[]{"tot", "mdEnr"};
                Arrays.sort(slFds);
                vs.put("MnfctndFds", slFds);
                Mnfct old = (Mnfct)this.orm.retEnt(pRvs, vs, (IHasId)pEnt);
                vs.clear();
                pEnt.setMdEnr(old.getMdEnr());
                if (pEnt.getMdEnr().booleanValue()) {
                    throw new ExcCode(100, "Trying to change accounted!");
                }
                if ("mkEnr".equals(pRqDt.getParam("acAd"))) {
                    if (old.getTot().compareTo(BigDecimal.ZERO) == 0) {
                        throw new ExcCode(1003, "amount_eq_zero");
                    }
                    pEnt.setMdEnr(true);
                } else {
                    pRvs.put("msgSuc", "update_ok");
                }
                this.getOrm().update(pRvs, vs, (IHasId)pEnt);
            }
            if ("mkEnr".equals(pRqDt.getParam("acAd"))) {
                this.srDrItEnr.drawFr(pRvs, mnfFdDe, pEnt.getMnp(), pEnt.getQuan());
                this.srWrhEnr.load(pRvs, pEnt, pEnt.getWrhp());
                this.srEntr.mkEntrs(pRvs, pEnt);
                pRvs.put("msgSuc", "account_ok");
            }
        }
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setEnt((IHasId)pEnt);
        return pEnt;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrEntr getSrEntr() {
        return this.srEntr;
    }

    public final void setSrEntr(ISrEntr pSrEntr) {
        this.srEntr = pSrEntr;
    }

    public final UtlBas getUtlBas() {
        return this.utlBas;
    }

    public final void setUtlBas(UtlBas pUtlBas) {
        this.utlBas = pUtlBas;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final ISrDrItEnr getSrDrItEnr() {
        return this.srDrItEnr;
    }

    public final void setSrDrItEnr(ISrDrItEnr pSrDrItEnr) {
        this.srDrItEnr = pSrDrItEnr;
    }
}

