/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.acc.mdl.EAccTy;
import org.beigesoft.acc.mdl.ENrBlTy;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.MnpAcs;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class MnpAcsSv<RS>
implements IPrcEnt<MnpAcs, Long> {
    private IOrm orm;
    private II18n i18n;
    private IRdb<RS> rdb;

    public final MnpAcs process(Map<String, Object> pRvs, MnpAcs pEnt, IReqDt pRqDt) throws Exception {
        Object[] upFds;
        HashMap<String, Object[]> vs = new HashMap<String, Object[]>();
        this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getOwnr());
        long owVrWs = Long.parseLong(pRqDt.getParam("owVr"));
        if (owVrWs != pEnt.getOwnr().getVer()) {
            throw new ExcCode(1151, "dirty_read");
        }
        if (pEnt.getRvId() != null) {
            MnpAcs revd = new MnpAcs();
            revd.setIid(pEnt.getRvId());
            this.orm.refrEnt(pRvs, vs, (IHasId)revd);
            pEnt.setDbOr(this.orm.getDbId());
            pEnt.setAcc(revd.getAcc());
            pEnt.setSaId(revd.getSaId());
            pEnt.setSaNm(revd.getSaNm());
            pEnt.setSaTy(revd.getSaTy());
            pEnt.setTot(revd.getTot().negate());
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            StringBuffer sb = new StringBuffer();
            if (pEnt.getDscr() != null) {
                sb.append(pEnt.getDscr() + " !");
            }
            sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
            sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
            pEnt.setDscr(sb.toString());
            this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
            sb.delete(0, sb.length());
            if (revd.getDscr() != null) {
                sb.append(revd.getDscr() + " !");
            }
            sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
            sb.append(" #" + pEnt.getDbOr() + "-" + pEnt.getIid());
            revd.setDscr(sb.toString());
            revd.setRvId(pEnt.getIid());
            upFds = new String[]{"rvId", "dscr", "ver"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            this.orm.update(pRvs, vs, (IHasId)revd);
            vs.clear();
            pRvs.put("msgSuc", "reverse_ok");
        } else {
            Object[] ndfAc = new String[]{"saTy", "typ", "blTy"};
            Arrays.sort(ndfAc);
            vs.put("AcntndFds", ndfAc);
            this.orm.refrEnt(pRvs, vs, (IHasId)pEnt.getAcc());
            vs.clear();
            if (pEnt.getSaId() == null || pEnt.getAcc().getSaTy() != 1000 || pEnt.getAcc().getTyp() != EAccTy.ASSET || pEnt.getAcc().getBlTy() != ENrBlTy.DEBIT) {
                throw new ExcCode(1003, "account_must_be_asset_exp");
            }
            pEnt.setSaTy(1000);
            if (pEnt.getIsNew().booleanValue()) {
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                pRvs.put("msgSuc", "insert_ok");
            } else {
                this.orm.update(pRvs, vs, (IHasId)pEnt);
                pRvs.put("msgSuc", "update_ok");
            }
        }
        String qu = "select sum(TOT) as TOT from MNPACS where RVID is null and OWNR=" + pEnt.getOwnr().getIid() + ";";
        Double tot = this.rdb.evDouble(qu, "TOT");
        if (tot == null) {
            tot = 0.0;
        }
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        pEnt.getOwnr().setAdCs(BigDecimal.valueOf(tot).setScale((int)as.getPrDp(), as.getRndm()));
        pEnt.getOwnr().setTot(pEnt.getOwnr().getMaCs().add(pEnt.getOwnr().getAdCs()).setScale((int)as.getPrDp(), as.getRndm()));
        pEnt.getOwnr().setToLf(pEnt.getOwnr().getTot());
        pEnt.getOwnr().setPri(pEnt.getOwnr().getTot().divide(pEnt.getOwnr().getQuan(), (int)as.getPrDp(), as.getRndm()));
        upFds = new String[]{"adCs", "tot", "pri", "toLf", "ver"};
        Arrays.sort(upFds);
        vs.put("ndFds", upFds);
        this.getOrm().update(pRvs, vs, (IHasId)pEnt.getOwnr());
        vs.clear();
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setOwnr((IHasId)pEnt.getOwnr());
        return null;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }
}

