/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.prc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.ETxTy;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.EmpWg;
import org.beigesoft.acc.mdlp.WagTt;
import org.beigesoft.acc.mdlp.WagTy;
import org.beigesoft.acc.mdlp.Wage;
import org.beigesoft.acc.mdlp.WgLn;
import org.beigesoft.acc.mdlp.WgTxl;
import org.beigesoft.acc.mdlp.WttEm;
import org.beigesoft.acc.mdlp.WttLn;
import org.beigesoft.acc.mdlp.WttWg;
import org.beigesoft.acc.srv.ISrEntr;
import org.beigesoft.acc.srv.UtlBas;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.UvdVar;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IReqDt;
import org.beigesoft.prc.IPrcEnt;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class WageSv<RS>
implements IPrcEnt<Wage, Long> {
    private IOrm orm;
    private ISrEntr srEntr;
    private UtlBas utlBas;
    private II18n i18n;
    private IRdb<RS> rdb;

    public final Wage process(Map<String, Object> pRvs, Wage pEnt, IReqDt pRqDt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        if (pEnt.getRvId() != null) {
            Wage revd = new Wage();
            revd.setIid(pEnt.getRvId());
            this.orm.refrEnt(pRvs, vs, (IHasId)revd);
            this.utlBas.chDtForg(pRvs, revd, revd.getDat());
            pEnt.setDbOr(this.orm.getDbId());
            pEnt.setTot(revd.getTot().negate());
            this.srEntr.revEntrs(pRvs, pEnt, revd);
            vs.put("WgLndpLv", 1);
            List rdls = this.orm.retLstCnd(pRvs, vs, WgLn.class, "where RVID is null and OWNR=" + revd.getIid());
            vs.clear();
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            for (WgLn rdl : rdls) {
                WgLn rgl = new WgLn();
                rgl.setDbOr(this.orm.getDbId());
                rgl.setOwnr(pEnt);
                rgl.setRvId(rdl.getIid());
                rgl.setWgTy(rdl.getWgTy());
                rgl.setAcWge(rdl.getAcWge());
                rgl.setTxEe(rdl.getTxEe().negate());
                rgl.setGrWg(rdl.getGrWg().negate());
                StringBuffer sb = new StringBuffer();
                if (rgl.getDscr() != null) {
                    sb.append(rgl.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
                sb.append(" #" + rdl.getDbOr() + "-" + rdl.getIid());
                rgl.setDscr(sb.toString());
                this.orm.insIdLn(pRvs, vs, (IHasId)rgl);
                sb.delete(0, sb.length());
                if (rdl.getDscr() != null) {
                    sb.append(rdl.getDscr() + " !");
                }
                sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
                sb.append(" #" + rgl.getDbOr() + "-" + rgl.getIid());
                rdl.setDscr(sb.toString());
                rdl.setRvId(rgl.getIid());
                Object[] upFds = new String[]{"rvId", "dscr", "ver"};
                Arrays.sort(upFds);
                vs.put("ndFds", upFds);
                this.orm.update(pRvs, vs, (IHasId)rdl);
                vs.clear();
            }
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            vs.put("WgLndpLv", 1);
            revd.setWags(this.getOrm().retLstCnd(pRvs, vs, WgLn.class, "where OWNR=" + revd.getIid()));
            vs.clear();
            for (WgLn wl : revd.getWags()) {
                EmpWg empWg = (EmpWg)this.orm.retEntCnd(pRvs, vs, EmpWg.class, "OWNR=" + revd.getEmpl().getIid() + " and YER=" + year + " and WGTY=" + wl.getWgTy().getIid());
                empWg.setTot(empWg.getTot().subtract(wl.getGrWg()).add(wl.getTxEe()));
                this.getOrm().update(pRvs, vs, (IHasId)empWg);
            }
            pRvs.put("msgSuc", "reverse_ok");
        } else {
            this.utlBas.chDtForg(pRvs, pEnt, pEnt.getDat());
            if (pEnt.getIsNew().booleanValue()) {
                this.orm.insIdLn(pRvs, vs, (IHasId)pEnt);
                pRvs.put("msgSuc", "insert_ok");
            } else if ("mkTxs".equals(pRqDt.getParam("acAd"))) {
                this.mkTxs(pRvs, pEnt);
            } else {
                Object[] slFds = new String[]{"tot", "mdEnr"};
                Arrays.sort(slFds);
                vs.put("WagendFds", slFds);
                Wage old = (Wage)this.orm.retEnt(pRvs, vs, (IHasId)pEnt);
                vs.clear();
                if (old.getMdEnr().booleanValue()) {
                    throw new ExcCode(100, "Trying to change accounted!");
                }
                if ("mkEnr".equals(pRqDt.getParam("acAd"))) {
                    if (old.getTot().compareTo(BigDecimal.ZERO) == 0) {
                        throw new ExcCode(1003, "amount_eq_zero");
                    }
                    pEnt.setMdEnr(true);
                    Object[] upFds = new String[]{"dat", "dscr", "ver", "mdEnr", "acTx", "empl"};
                    Arrays.sort(upFds);
                    vs.put("ndFds", upFds);
                    this.getOrm().update(pRvs, vs, (IHasId)pEnt);
                    vs.clear();
                    this.srEntr.mkEntrs(pRvs, pEnt);
                    Calendar cal = Calendar.getInstance();
                    int year = cal.get(1);
                    vs.put("WgLndpLv", 1);
                    pEnt.setWags(this.getOrm().retLstCnd(pRvs, vs, WgLn.class, "where OWNR=" + pEnt.getIid()));
                    vs.clear();
                    for (WgLn wl : pEnt.getWags()) {
                        EmpWg empWg = (EmpWg)this.orm.retEntCnd(pRvs, vs, EmpWg.class, "OWNR=" + pEnt.getEmpl().getIid() + " and YER=" + year + " and WGTY=" + wl.getWgTy().getIid());
                        if (empWg == null) {
                            empWg = new EmpWg();
                            empWg.setIsNew(true);
                            Integer rc = this.rdb.evInt("select count(*) as ROWCNT from EMPWG where OWNR=" + pEnt.getEmpl().getIid(), "ROWCNT");
                            if (rc == null) {
                                rc = 0;
                            }
                            Integer n = rc;
                            Integer n2 = rc = Integer.valueOf(rc + 1);
                            String elid = pEnt.getEmpl().getIid().toString() + n;
                            empWg.setIid(Long.valueOf(elid));
                            empWg.setOwnr(pEnt.getEmpl());
                            empWg.setWgTy(wl.getWgTy());
                            empWg.setYer(year);
                        }
                        empWg.setTot(empWg.getTot().add(wl.getGrWg()).subtract(wl.getTxEe()));
                        if (empWg.getIsNew().booleanValue()) {
                            this.getOrm().insIdLn(pRvs, vs, (IHasId)empWg);
                            continue;
                        }
                        this.getOrm().update(pRvs, vs, (IHasId)empWg);
                    }
                    pRvs.put("msgSuc", "account_ok");
                } else {
                    Object[] uFds = new String[]{"dat", "dscr", "ver", "acTx", "empl"};
                    Arrays.sort(uFds);
                    vs.put("ndFds", uFds);
                    this.getOrm().update(pRvs, vs, (IHasId)pEnt);
                    vs.clear();
                    pRvs.put("msgSuc", "update_ok");
                }
            }
        }
        UvdVar uvs = (UvdVar)pRvs.get("uvs");
        uvs.setEnt((IHasId)pEnt);
        return pEnt;
    }

    public final void mkTxs(Map<String, Object> pRvs, Wage pWage) throws Exception {
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        HashMap<String, Object> vs = new HashMap<String, Object>();
        vs.put("WttEmdpLv", 1);
        List wttEms = this.getOrm().retLstCnd(pRvs, vs, WttEm.class, "where EMPL=" + pWage.getEmpl().getIid());
        vs.clear();
        if (wttEms.size() > 0) {
            CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
            String quYerWg = "select sum(TOT) as TOT from EMPWG where OWNR=" + pWage.getEmpl().getIid();
            Double yearWgDbl = this.getRdb().evDouble(quYerWg, "TOT");
            if (yearWgDbl == null) {
                yearWgDbl = 0.0;
            }
            BigDecimal yearWg = BigDecimal.valueOf(yearWgDbl);
            this.getRdb().delete("WGTXL", "OWNR=" + pWage.getIid());
            BigDecimal bgd100 = new BigDecimal("100.00");
            BigDecimal txEe = BigDecimal.ZERO;
            BigDecimal txEr = BigDecimal.ZERO;
            vs.put("WgLndpLv", 1);
            pWage.setWags(this.getOrm().retLstCnd(pRvs, vs, WgLn.class, "where OWNR=" + pWage.getIid()));
            vs.clear();
            HashMap<WagTy, BigDecimal> empTotTxMp = new HashMap<WagTy, BigDecimal>();
            for (WgLn wl : pWage.getWags()) {
                empTotTxMp.put(wl.getWgTy(), BigDecimal.ZERO);
            }
            for (WttEm wttEm : wttEms) {
                if (wttEm.getOwnr().getTax() == null) {
                    this.getOrm().refrEnt(pRvs, vs, (IHasId)wttEm.getOwnr());
                    vs.put("WttLndpLv", 1);
                    wttEm.getOwnr().setLns(this.getOrm().retLstCnd(pRvs, vs, WttLn.class, "where OWNR=" + wttEm.getOwnr().getIid()));
                    vs.clear();
                    vs.put("WttWgdpLv", 1);
                    wttEm.getOwnr().setWags(this.getOrm().retLstCnd(pRvs, vs, WttWg.class, "where OWNR=" + wttEm.getOwnr().getIid()));
                    vs.clear();
                }
                BigDecimal totTxb = BigDecimal.ZERO;
                for (WgLn wl : pWage.getWags()) {
                    if (!this.isWageApplied(wl.getWgTy(), wttEm.getOwnr())) continue;
                    totTxb = totTxb.add(wl.getGrWg());
                }
                if (!(totTxb.doubleValue() > 0.0)) continue;
                BigDecimal wgMnsAlw = totTxb.subtract(wttEm.getAlw());
                boolean isFilled = false;
                for (WttLn wttLn : wttEm.getOwnr().getLns()) {
                    if (wgMnsAlw.compareTo(wttLn.getWgFr()) < 0 || wgMnsAlw.compareTo(wttLn.getWgTo()) >= 0 || yearWg.compareTo(wttLn.getYwgFr()) < 0 || yearWg.compareTo(wttLn.getYwgTo()) >= 0) continue;
                    WgTxl wtl = new WgTxl();
                    wtl.setIsNew(true);
                    wtl.setDbOr(this.getOrm().getDbId());
                    wtl.setOwnr(pWage);
                    wtl.setAlw(wttEm.getAlw());
                    wtl.setPlAm(wttLn.getPlAm());
                    wtl.setTax(wttEm.getOwnr().getTax());
                    wtl.setRate(wttLn.getRate());
                    wtl.setTot(wgMnsAlw.subtract(wttLn.getAlw()).multiply(wttLn.getRate()).divide(bgd100, (int)as.getPrDp(), as.getRndm()).add(wttLn.getPlAm()));
                    wtl.setDscr(this.getI18n().getMsg("TIDNametaxb", cpf.getLngDef().getIid()) + ": " + wttEm.getOwnr().getIid() + "/" + wttEm.getOwnr().getNme() + "/" + totTxb);
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)wtl);
                    if (wtl.getTax().getTyp().equals((Object)ETxTy.TEMPLOYEE)) {
                        txEe = txEe.add(wtl.getTot());
                        for (WgLn wl : pWage.getWags()) {
                            BigDecimal newTxEeLn = ((BigDecimal)empTotTxMp.get(wl.getWgTy())).add(wl.getGrWg().multiply(wtl.getTot()).divide(totTxb, (int)as.getPrDp(), as.getRndm()));
                            empTotTxMp.put(wl.getWgTy(), newTxEeLn);
                        }
                    } else if (wtl.getTax().getTyp().equals((Object)ETxTy.TEMPLOYER)) {
                        txEr = txEr.add(wtl.getTot());
                    }
                    isFilled = true;
                    break;
                }
                if (isFilled) continue;
                throw new ExcCode(1003, "there_is_no_suitable_tax_percent_entry");
            }
            Object[] upFds = new String[]{"txEe", "ver"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            for (WgLn wl : pWage.getWags()) {
                wl.setTxEe((BigDecimal)empTotTxMp.get(wl.getWgTy()));
                this.getOrm().update(pRvs, vs, (IHasId)wl);
            }
            vs.clear();
            pWage.setTxEe(txEe);
            pWage.setTxEr(txEr);
            pWage.setNtWg(pWage.getTot().subtract(pWage.getTxEe()));
            upFds = new String[]{"ntWg", "txEe", "txEr", "ver"};
            Arrays.sort(upFds);
            vs.put("ndFds", upFds);
            this.getOrm().update(pRvs, vs, (IHasId)pWage);
        }
    }

    public final boolean isWageApplied(WagTy pWgTy, WagTt pWagTt) {
        for (WttWg wttWg : pWagTt.getWags()) {
            if (!wttWg.getWgTy().getIid().equals(pWgTy.getIid())) continue;
            return true;
        }
        return false;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrEntr getSrEntr() {
        return this.srEntr;
    }

    public final void setSrEntr(ISrEntr pSrEntr) {
        this.srEntr = pSrEntr;
    }

    public final UtlBas getUtlBas() {
        return this.utlBas;
    }

    public final void setUtlBas(UtlBas pUtlBas) {
        this.utlBas = pUtlBas;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }
}

