/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.rep;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdl.BlnSht;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.I18Acc;
import org.beigesoft.acc.mdlp.I18Curr;
import org.beigesoft.acc.rep.IBlnPdf;
import org.beigesoft.acc.srv.ISrAcStg;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdlp.UsPrf;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.srv.II18n;
import org.beigesoft.srv.INumStr;

public class BlnPdf<WI>
implements IBlnPdf {
    private IPdfFactory<WI> pdfFactory;
    private ISrAcStg srvAcStg;
    private II18n i18n;
    private INumStr numStr;

    @Override
    public final void report(Map<String, Object> pRvs, BlnSht pBalance, OutputStream pOus) throws Exception {
        String curSign;
        boolean isPrnCurLf;
        AcStg as = this.srvAcStg.lazAcStg(pRvs);
        UsPrf upf = (UsPrf)pRvs.get("upf");
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(upf.getLng().getIid()));
        I18Curr i18Curr = (I18Curr)((Object)pRvs.get("i18Curr"));
        if (i18Curr != null) {
            isPrnCurLf = i18Curr.getCurl();
            curSign = i18Curr.getCurs().booleanValue() ? i18Curr.getHasNm().getSgn() : " " + i18Curr.getNme() + " ";
        } else {
            curSign = as.getCurs() != false ? as.getCurr().getSgn() : " " + as.getCurr().getNme() + " ";
            isPrnCurLf = as.getCurl();
        }
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(as.getPgSz(), as.getPgOr());
        doc.setFontSize(as.getFnSz().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginBottom(as.getMrBo().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginTop(as.getMrTo().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginLeft(as.getMrLf().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginRight(as.getMrRi().doubleValue());
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft(TM) EIS, " + as.getOrg());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, as.getTtff());
        if (as.getTtfb() != null) {
            pdfMaker.addFontTtf(docPdf, as.getTtfb());
        }
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContainerMarginBottom(this.mmToDocUom(3.5, doc.getUnitOfMeasure()));
        doc.setContentPaddingBottom(this.mmToDocUom(0.5, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.CENTER);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 3);
        I18Acc i18Acc = (I18Acc)((Object)pRvs.get("i18Acc"));
        if (i18Acc != null) {
            ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(i18Acc.getOrg());
        } else {
            ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(as.getOrg());
        }
        ((TableCell)tblTitle.getItsCells().get(1)).setItsContent(this.i18n.getMsg("balance_sheet", upf.getLng().getIid()));
        ((TableCell)tblTitle.getItsCells().get(2)).setItsContent(dateFormat.format(pBalance.getDat()));
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        docMaker.makeDocTableWrapping(tblTitle);
        doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.LEFT);
        DocTable tblBal = docMaker.addDocTable(doc, 4, pBalance.getDetRc() + 2);
        ((TableColumn)tblBal.getItsColumns().get(0)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(0)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(1)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(1)).setWidthInPercentage(20.0);
        ((TableColumn)tblBal.getItsColumns().get(2)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(2)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(3)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(3)).setWidthInPercentage(20.0);
        ((TableCell)tblBal.getItsCells().get(0)).setItsContent(this.i18n.getMsg("AssetsTitle", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(0)).setMergedCell((TableCell)tblBal.getItsCells().get(1));
        ((TableCell)tblBal.getItsCells().get(2)).setItsContent(this.i18n.getMsg("LiabilitiesTitle", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(2)).setMergedCell((TableCell)tblBal.getItsCells().get(3));
        int row = 1;
        for (int i = 0; i < pBalance.getToLnAs(); ++i) {
            String cnt = pBalance.getLns().get(i).getDebit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(as, cpf, upf, pBalance.getLns().get(i).getDebit()) : "(" + this.prn(as, cpf, upf, pBalance.getLns().get(i).getCredit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4)).setItsContent(pBalance.getLns().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setFontNumber(1);
            ++row;
        }
        int totLeabOwnEq = pBalance.getToLnLi() + pBalance.getToLnOe();
        int lastRowIdx = Math.max(pBalance.getToLnAs() + 1, totLeabOwnEq + 4);
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4)).setItsContent(this.i18n.getMsg("total_assets", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        String cntc = isPrnCurLf ? curSign + this.prn(as, cpf, upf, pBalance.getTotAss()) : this.prn(as, cpf, upf, pBalance.getTotAss()) + curSign;
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setItsContent(cntc);
        row = 1;
        int totAssLeab = pBalance.getToLnAs() + pBalance.getToLnLi();
        for (int i = pBalance.getToLnAs().intValue(); i < totAssLeab; ++i) {
            String cnt = pBalance.getLns().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(as, cpf, upf, pBalance.getLns().get(i).getCredit()) : "(" + this.prn(as, cpf, upf, pBalance.getLns().get(i).getDebit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getLns().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get(pBalance.getToLnLi() * 4 + 6)).setItsContent(this.i18n.getMsg("total_l", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(pBalance.getToLnLi() * 4 + 7)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get(pBalance.getToLnLi() * 4 + 7)).setItsContent(this.prn(as, cpf, upf, pBalance.getTotLia()));
        int oetIdx = pBalance.getToLnLi() * 4 + 10;
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setItsContent(this.i18n.getMsg("OwnersEquityTitle", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setMergedCell((TableCell)tblBal.getItsCells().get(oetIdx + 1));
        row = 1 + pBalance.getToLnLi() + 2;
        for (int i = totAssLeab; i < totAssLeab + pBalance.getToLnOe(); ++i) {
            String cnt = pBalance.getLns().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(as, cpf, upf, pBalance.getLns().get(i).getCredit()) : "(" + this.prn(as, cpf, upf, pBalance.getLns().get(i).getDebit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getLns().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 2)).setItsContent(this.i18n.getMsg("total_oe", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setItsContent(this.prn(as, cpf, upf, pBalance.getTotOwe()));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 2)).setItsContent(this.i18n.getMsg("total_l_oe", upf.getLng().getIid()));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        cntc = isPrnCurLf ? curSign + this.prn(as, cpf, upf, pBalance.getTotOwe().add(pBalance.getTotLia())) : this.prn(as, cpf, upf, pBalance.getTotOwe().add(pBalance.getTotLia())) + curSign;
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setItsContent(cntc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final String prn(AcStg pAs, CmnPrf pCpf, UsPrf pUpf, BigDecimal pVal) {
        return this.numStr.frmt(pVal.toString(), pCpf.getDcSpv(), pCpf.getDcGrSpv(), pAs.getRpDp(), pUpf.getDgInGr());
    }

    public final double mmToDocUom(double pValue, EUnitOfMeasure pUom) {
        if (pUom.equals((Object)EUnitOfMeasure.INCH)) {
            return pValue / 25.4;
        }
        return pValue;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final ISrAcStg getSrAcStg() {
        return this.srvAcStg;
    }

    public final void setSrAcStg(ISrAcStg pSrAcStg) {
        this.srvAcStg = pSrAcStg;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final INumStr getNumStr() {
        return this.numStr;
    }

    public final void setNumStr(INumStr pNumStr) {
        this.numStr = pNumStr;
    }
}

