/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdlb.APaym;
import org.beigesoft.acc.mdlb.APrep;
import org.beigesoft.acc.mdlp.PaymTo;
import org.beigesoft.acc.mdlp.PrepTo;
import org.beigesoft.acc.mdlp.PuInGdLn;
import org.beigesoft.acc.mdlp.PurInv;
import org.beigesoft.acc.srv.IRvInvLn;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.HldUvd;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class RvPuGdLn<RS>
implements IRvInvLn<PurInv, PuInGdLn> {
    private IRdb<RS> rdb;
    private IOrm orm;
    private ISrWrhEnr srWrhEnr;
    private HldUvd hldUvd;
    private II18n i18n;

    @Override
    public final List<PuInGdLn> retChkLns(Map<String, Object> pRvs, Map<String, Object> pVs, PurInv pEnt) throws Exception {
        String[] lstFds = this.hldUvd.lazLstFds(PuInGdLn.class);
        Object[] ndFds = Arrays.copyOf(lstFds, lstFds.length);
        Arrays.sort(ndFds);
        pVs.put("PuInGdLnndFds", ndFds);
        pVs.put("PuInGdLndpLv", 1);
        List lst = this.orm.retLstCnd(pRvs, pVs, PuInGdLn.class, "where PUINGDLN.RVID is null and PUINGDLN.OWNR=" + pEnt.getIid());
        pVs.clear();
        for (PuInGdLn gl : lst) {
            if (gl.getQuan().compareTo(gl.getItLf()) != 1) continue;
            throw new ExcCode(1003, "where_is_withdraw");
        }
        return lst;
    }

    @Override
    public final void revLns(Map<String, Object> pRvs, Map<String, Object> pVs, PurInv pEnt, PuInGdLn pRvng, PuInGdLn pRved) throws Exception {
        this.rdb.delete("PUINGDTXLN", "OWNR=" + pRved.getIid());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        pRvng.setWrhp(pRved.getWrhp());
        StringBuffer sb = new StringBuffer();
        if (pRvng.getDscr() != null) {
            sb.append(pRvng.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + pRved.getDbOr() + "-" + pRved.getIid());
        pRvng.setDscr(sb.toString());
        this.orm.insIdLn(pRvs, pVs, (IHasId)pRvng);
        this.srWrhEnr.revLoad(pRvs, pRvng);
        sb.delete(0, sb.length());
        if (pRved.getDscr() != null) {
            sb.append(pRved.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
        sb.append(" #" + pRvng.getDbOr() + "-" + pRvng.getIid());
        pRved.setDscr(sb.toString());
        pRved.setRvId(pRvng.getIid());
        pRved.setItLf(BigDecimal.ZERO);
        pRved.setToLf(BigDecimal.ZERO);
        Object[] ndFds = new String[]{"dscr", "itLf", "rvId", "toLf", "ver"};
        Arrays.sort(ndFds);
        pVs.put("ndFds", ndFds);
        this.orm.update(pRvs, pVs, (IHasId)pRved);
        pVs.clear();
    }

    @Override
    public final Class<? extends APrep> getPrepCls() {
        return PrepTo.class;
    }

    @Override
    public final Class<? extends APaym<?>> getPaymCls() {
        return PaymTo.class;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final ISrWrhEnr getSrWrhEnr() {
        return this.srWrhEnr;
    }

    public final void setSrWrhEnr(ISrWrhEnr pSrWrhEnr) {
        this.srWrhEnr = pSrWrhEnr;
    }

    public final HldUvd getHldUvd() {
        return this.hldUvd;
    }

    public final void setHldUvd(HldUvd pHldUvd) {
        this.hldUvd = pHldUvd;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }
}

