/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.acc.mdl.TrBlLn;
import org.beigesoft.acc.mdlb.ISacnt;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Acnt;
import org.beigesoft.acc.mdlp.BlnCh;
import org.beigesoft.acc.mdlp.Blnc;
import org.beigesoft.acc.mdlp.Entr;
import org.beigesoft.acc.mdlp.SacCh;
import org.beigesoft.acc.mdlp.Sacnt;
import org.beigesoft.acc.srv.ISrAcStg;
import org.beigesoft.acc.srv.ISrBlnc;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.ColVals;
import org.beigesoft.mdl.EPeriod;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rdb.SrvClVl;

public class SrBlnc<RS>
implements ISrBlnc {
    private ILog log;
    private IOrm orm;
    private IRdb<RS> rdb;
    private ISrAcStg srAcStg;
    private SrvClVl srvClVl;
    private boolean isAndr;
    private String quBlnc;
    private final Date iniDt = new Date(BlnCh.INITDT);
    private BlnCh blnCh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized List<TrBlLn> retTrBlnc(Map<String, Object> pRvs, Date pDt) throws Exception {
        this.chngSacsIfNd(pRvs);
        this.recalcIfNd(pRvs, pDt);
        ArrayList<TrBlLn> rz = new ArrayList<TrBlLn>();
        if (this.blnCh.getStDt().getTime() != BlnCh.INITDT.longValue()) {
            String query = this.evQuBlnc(pRvs, pDt);
            try (IRecSet rs = null;){
                rs = this.getRdb().retRs(query);
                AcStg as = this.getSrAcStg().lazAcStg(pRvs);
                if (rs.first()) {
                    do {
                        Double debt = rs.getDouble("DEBT");
                        Double cred = rs.getDouble("CRED");
                        if (debt == 0.0 && cred == 0.0) continue;
                        TrBlLn tbl = new TrBlLn();
                        tbl.setAcId(rs.getStr("ACID"));
                        tbl.setAcNm(rs.getStr("ACNM"));
                        tbl.setAcNb(rs.getStr("ACNB"));
                        tbl.setSaNm(rs.getStr("SANM"));
                        tbl.setDebt(BigDecimal.valueOf(debt).setScale((int)as.getRpDp(), as.getRndm()));
                        tbl.setCred(BigDecimal.valueOf(cred).setScale((int)as.getRpDp(), as.getRndm()));
                        if (tbl.getDebt().compareTo(BigDecimal.ZERO) == 0 && tbl.getCred().compareTo(BigDecimal.ZERO) == 0) continue;
                        rz.add(tbl);
                    } while (rs.next());
                }
            }
            BigDecimal debitAcc = null;
            BigDecimal creditAcc = null;
            String accCurr = null;
            int lineCurr = 0;
            int lineStartAcc = 0;
            for (TrBlLn tbl : rz) {
                if (!tbl.getAcId().equals(accCurr)) {
                    if (accCurr != null) {
                        for (int j = lineStartAcc; j < lineCurr; ++j) {
                            ((TrBlLn)rz.get(j)).setDebtAcc(debitAcc);
                            ((TrBlLn)rz.get(j)).setCredAcc(creditAcc);
                        }
                    }
                    lineStartAcc = lineCurr;
                    accCurr = tbl.getAcId();
                    debitAcc = BigDecimal.ZERO;
                    creditAcc = BigDecimal.ZERO;
                }
                debitAcc = debitAcc.add(tbl.getDebt());
                creditAcc = creditAcc.add(tbl.getCred());
                ++lineCurr;
            }
            for (int j = lineStartAcc; j < lineCurr; ++j) {
                ((TrBlLn)rz.get(j)).setDebtAcc(debitAcc);
                ((TrBlLn)rz.get(j)).setCredAcc(creditAcc);
            }
        }
        return rz;
    }

    @Override
    public final synchronized boolean recalcIfNd(Map<String, Object> pRvs, Date pDtFor) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        this.lazBlnCh(pRvs, vs);
        this.evBlStPer(pRvs, vs);
        if (this.evBlStDt(pRvs, vs).getTime() == BlnCh.INITDT.longValue()) {
            return false;
        }
        Date dtSt = this.evDtStPer(pRvs, pDtFor);
        Calendar calStBl = Calendar.getInstance();
        calStBl.setTime(this.blnCh.getStDt());
        calStBl.set(2, 0);
        calStBl.set(5, 1);
        calStBl.set(11, 0);
        calStBl.set(12, 0);
        calStBl.set(13, 0);
        calStBl.set(14, 0);
        if (this.blnCh.getLeDt().getTime() < this.blnCh.getStDt().getTime()) {
            this.blnCh.setStDt(this.iniDt);
            this.blnCh.setLeDt(this.iniDt);
            if (this.evBlStDt(pRvs, vs).getTime() != BlnCh.INITDT.longValue()) {
                this.recalc(pRvs, vs, pDtFor);
                return true;
            }
        } else if (this.blnCh.getPrCh().booleanValue() || dtSt.getTime() > this.blnCh.getCuDt().getTime() || this.blnCh.getLeDt().getTime() < this.blnCh.getCuDt().getTime()) {
            this.recalc(pRvs, vs, pDtFor);
            return true;
        }
        return false;
    }

    @Override
    public final synchronized void hndNewEntr(Map<String, Object> pRvs, Date pDtAt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        if (this.lazBlnCh(pRvs, vs).getLeDt().getTime() > pDtAt.getTime()) {
            boolean dbgSh = this.getLog().getDbgSh(this.getClass(), 11100);
            if (dbgSh) {
                this.getLog().debug(pRvs, SrBlnc.class, "change least last entry date from " + this.blnCh.getLeDt() + " to " + pDtAt);
            }
            this.blnCh.setLeDt(pDtAt);
            this.getOrm().update(pRvs, vs, (IHasId)this.blnCh);
        }
    }

    @Override
    public final synchronized Date evDtStPer(Map<String, Object> pRvs, Date pDtFor) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        this.lazBlnCh(pRvs, vs);
        EPeriod per = this.evBlStPer(pRvs, vs);
        if (!per.equals((Object)EPeriod.MONTHLY) && !per.equals((Object)EPeriod.DAILY)) {
            throw new ExcCode(1003, "stored_balance_period_must_be_wm");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDtFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (per.equals((Object)EPeriod.MONTHLY)) {
            cal.set(5, 1);
        }
        return cal.getTime();
    }

    @Override
    public final synchronized int chngSacsIfNd(Map<String, Object> pRvs) throws Exception {
        HashMap vs = new HashMap();
        List lsSacCh = this.orm.retLstCnd(pRvs, vs, SacCh.class, "where DRT=1");
        if (lsSacCh.size() > 0) {
            this.log.info(pRvs, this.getClass(), "Try to update subacc names in entries, count dirtied: " + lsSacCh.size());
            int rz = 0;
            for (SacCh sacCh : lsSacCh) {
                ColVals cv = new ColVals();
                this.srvClVl.put(cv, "sadNm", sacCh.getNme());
                if (!this.isAndr) {
                    this.srvClVl.put(cv, "ver", "VER+1");
                    this.srvClVl.putExpr(cv, "ver");
                }
                int esdc = this.rdb.update(Entr.class, cv, "SADID=" + sacCh.getSaId() + " and SADTY=" + sacCh.getSaTy());
                this.log.info(pRvs, this.getClass(), "Updated Entr.sadNm = " + esdc);
                cv = new ColVals();
                this.srvClVl.put(cv, "sacNm", sacCh.getNme());
                if (!this.isAndr) {
                    this.srvClVl.put(cv, "ver", "VER+1");
                    this.srvClVl.putExpr(cv, "ver");
                }
                int escc = this.rdb.update(Entr.class, cv, "SACID=" + sacCh.getSaId() + " and SACTY=" + sacCh.getSaTy());
                this.log.info(pRvs, this.getClass(), "Updated Entr.sacNm = " + escc);
                cv = new ColVals();
                this.srvClVl.put(cv, "saNm", sacCh.getNme());
                if (!this.isAndr) {
                    this.srvClVl.put(cv, "ver", "VER+1");
                    this.srvClVl.putExpr(cv, "ver");
                }
                int bsc = this.rdb.update(Blnc.class, cv, "SAID=" + sacCh.getSaId() + " and SATY=" + sacCh.getSaTy());
                this.log.info(pRvs, this.getClass(), "Updated Blnc.saNm = " + bsc);
                cv = new ColVals();
                this.srvClVl.put(cv, "saNm", sacCh.getNme());
                if (!this.isAndr) {
                    this.srvClVl.put(cv, "ver", "VER+1");
                    this.srvClVl.putExpr(cv, "ver");
                }
                int sacntc = this.rdb.update(Sacnt.class, cv, "SAID=" + sacCh.getSaId() + " and SATY=" + sacCh.getSaTy());
                this.log.info(pRvs, this.getClass(), "Updated Sacnt.saNm = " + sacntc);
                rz += esdc + escc + bsc + sacntc;
                sacCh.setDrt(Boolean.FALSE);
                this.orm.update(pRvs, vs, (IHasId)sacCh);
            }
            return rz;
        }
        return 0;
    }

    @Override
    public final synchronized void hndSacntCh(Map<String, Object> pRvs, ISacnt pSacnt) throws Exception {
        SacCh sacCh = new SacCh();
        sacCh.setSaTy(pSacnt.cnsTy());
        sacCh.setSaId((Long)pSacnt.getIid());
        HashMap vs = new HashMap();
        this.orm.refrEnt(pRvs, vs, (IHasId)sacCh);
        if (sacCh.getIid() == null) {
            sacCh.setIsNew(Boolean.TRUE);
            sacCh.setSaTy(pSacnt.cnsTy());
            sacCh.setSaId((Long)pSacnt.getIid());
        }
        sacCh.setNme(pSacnt.getNme());
        sacCh.setDrt(Boolean.TRUE);
        if (sacCh.getIsNew().booleanValue()) {
            this.orm.insIdNln(pRvs, vs, (IHasId)sacCh);
        } else {
            this.orm.update(pRvs, vs, (IHasId)sacCh);
        }
    }

    @Override
    public final synchronized Date evDtNxtPerSt(Map<String, Object> pRvs, Map<String, Object> pVs, Date pDtFor) throws Exception {
        this.lazBlnCh(pRvs, pVs);
        EPeriod per = this.evBlStPer(pRvs, pVs);
        if (!per.equals((Object)EPeriod.MONTHLY) && !per.equals((Object)EPeriod.DAILY)) {
            throw new ExcCode(1003, "stored_balance_period_must_be_wm");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDtFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (per.equals((Object)EPeriod.MONTHLY)) {
            cal.add(2, 1);
            cal.set(5, 1);
        } else if (per.equals((Object)EPeriod.DAILY)) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    @Override
    public final synchronized Date evDtPrvPerSt(Map<String, Object> pRvs, Map<String, Object> pVs, Date pDtFor) throws Exception {
        this.lazBlnCh(pRvs, pVs);
        EPeriod per = this.evBlStPer(pRvs, pVs);
        if (!per.equals((Object)EPeriod.MONTHLY) && !per.equals((Object)EPeriod.DAILY)) {
            throw new ExcCode(1003, "stored_balance_period_must_be_wm");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDtFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (per.equals((Object)EPeriod.MONTHLY)) {
            cal.add(2, -1);
            cal.set(5, 1);
        } else if (per.equals((Object)EPeriod.DAILY)) {
            cal.add(5, -1);
        }
        return cal.getTime();
    }

    public final synchronized void hndRlBk(Map<String, Object> pRvs) throws Exception {
        this.getLog().warn(pRvs, this.getClass(), "Clear cache cause transaction rollback!");
        this.blnCh = null;
    }

    public final synchronized void recalc(Map<String, Object> pRvs, Map<String, Object> pVs, Date pDtFor) throws Exception {
        Date lstBlStDt;
        Date curDt;
        Date dtEndRec = null;
        Long dtLsEnrLn = this.rdb.evLong("select max(DAT) as MAXDT from ENTR where RVID is null;", "MAXDT");
        Date dtLstEntr = null;
        dtEndRec = dtLsEnrLn != null ? ((dtLstEntr = new Date(dtLsEnrLn)).getTime() > pDtFor.getTime() ? dtLstEntr : pDtFor) : pDtFor;
        Long dtLsBlnLn = this.rdb.evLong("select max(DAT) as MAXDT from BLNC;", "MAXDT");
        Date dtLstBlnc = null;
        if (dtLsBlnLn != null && (dtLstBlnc = new Date(dtLsBlnLn)).getTime() > dtEndRec.getTime()) {
            dtEndRec = dtLstBlnc;
        }
        this.getLog().info(pRvs, SrBlnc.class, "recalculation start for " + pDtFor + " BlnCh was " + (Object)((Object)this.blnCh) + ", dtLstEntr = " + dtLstEntr + ", dtLsBlnLn = " + dtLsBlnLn);
        if (this.blnCh.getPrCh().booleanValue()) {
            this.getLog().info(pRvs, SrBlnc.class, "deleting all stored balances cause period has changed");
            this.getRdb().delete(Blnc.class.getSimpleName().toUpperCase(), null);
            this.blnCh.setPrCh(false);
            this.blnCh.setCuDt(this.iniDt);
        }
        if (this.blnCh.getLeDt().getTime() < this.blnCh.getCuDt().getTime()) {
            curDt = this.evDtPrvPerSt(pRvs, pVs, this.blnCh.getLeDt());
            if (curDt.getTime() <= this.blnCh.getStDt().getTime()) {
                curDt = this.evDtNxtPerSt(pRvs, pVs, this.blnCh.getStDt());
                this.getLog().info(pRvs, SrBlnc.class, "recalculating balances from start " + curDt + " <- " + this.blnCh.getStDt());
            } else {
                this.getLog().info(pRvs, SrBlnc.class, "recalculating balances from previous " + curDt);
            }
        } else {
            curDt = this.evDtNxtPerSt(pRvs, pVs, this.blnCh.getCuDt());
            this.getLog().info(pRvs, SrBlnc.class, "recalc balances from current end " + curDt + " <- " + this.blnCh.getCuDt());
        }
        do {
            lstBlStDt = curDt;
            String query = this.evQuBlnc(pRvs, new Date(lstBlStDt.getTime() - 1L));
            List<TrBlLn> tbls = this.retBlnLnsToSv(query);
            pVs.put("AcntdpLv", 0);
            List blncs = this.getOrm().retLstCnd(pRvs, pVs, Blnc.class, " where DAT=" + lstBlStDt.getTime());
            pVs.clear();
            for (TrBlLn tbl : tbls) {
                Blnc blnc = null;
                for (Blnc bl : blncs) {
                    if ((!bl.getAcc().getIid().equals(tbl.getAcId()) || bl.getSaTy() != null || tbl.getSaTy() != null) && (bl.getSaTy() == null || !bl.getSaTy().equals(tbl.getSaTy()) || !bl.getSaId().equals(tbl.getSaId()))) continue;
                    blnc = bl;
                    blncs.remove((Object)blnc);
                    break;
                }
                if (blnc == null) {
                    blnc = new Blnc();
                    blnc.setIsNew(true);
                }
                blnc.setDat(lstBlStDt);
                Acnt acc = new Acnt();
                acc.setIid(tbl.getAcId());
                blnc.setAcc(acc);
                if (tbl.getDebt().compareTo(BigDecimal.ZERO) != 0) {
                    blnc.setBln(tbl.getDebt());
                } else {
                    blnc.setBln(tbl.getCred());
                }
                blnc.setSaTy(tbl.getSaTy());
                blnc.setSaId(tbl.getSaId());
                blnc.setSaNm(tbl.getSaNm());
                if (blnc.getIsNew().booleanValue()) {
                    this.getOrm().insIdLn(pRvs, pVs, (IHasId)blnc);
                    blnc.setIsNew(false);
                    continue;
                }
                this.getOrm().update(pRvs, pVs, (IHasId)blnc);
            }
            for (Blnc bl : blncs) {
                this.getOrm().del(pRvs, pVs, (IHasId)bl);
            }
        } while ((curDt = this.evDtNxtPerSt(pRvs, pVs, curDt)).getTime() <= dtEndRec.getTime());
        this.getLog().info(pRvs, SrBlnc.class, "last stored balance lstBlStDt " + lstBlStDt + ", dtEndRecal = " + dtEndRec);
        this.blnCh.setCuDt(lstBlStDt);
        this.blnCh.setLeDt(this.blnCh.getCuDt());
        this.getOrm().update(pRvs, pVs, (IHasId)this.blnCh);
        this.getLog().info(pRvs, SrBlnc.class, "recalculation end BlnCh is " + (Object)((Object)this.blnCh));
    }

    public final synchronized EPeriod evBlStPer(Map<String, Object> pRvs, Map<String, Object> pVs) throws Exception {
        AcStg as = this.getSrAcStg().lazAcStg(pRvs);
        if (!this.blnCh.getPrCh().booleanValue() && !this.blnCh.getStPr().equals((Object)as.getBlPr())) {
            this.getLog().info(pRvs, SrBlnc.class, "changing period from " + this.blnCh.getStPr() + " to " + as.getBlPr());
            this.blnCh.setStPr(as.getBlPr());
            this.blnCh.setPrCh(true);
            this.blnCh.setLeDt(this.iniDt);
            this.getOrm().update(pRvs, pVs, (IHasId)this.blnCh);
        }
        return this.blnCh.getStPr();
    }

    public final synchronized Date evBlStDt(Map<String, Object> pRvs, Map<String, Object> pVs) throws Exception {
        if (this.blnCh.getStDt().getTime() == BlnCh.INITDT.longValue()) {
            Long dtFsEnrLn = this.rdb.evLong("select min(DAT) as MINDT from ENTR where RVID is null;", "MINDT");
            if (dtFsEnrLn != null) {
                this.blnCh.setStDt(this.evDtStPer(pRvs, new Date(dtFsEnrLn)));
                this.getOrm().update(pRvs, pVs, (IHasId)this.blnCh);
            } else if (this.blnCh.getCuDt().getTime() != BlnCh.INITDT.longValue()) {
                this.getLog().error(pRvs, this.getClass(), "Dirty balances!");
                this.getLog().info(pRvs, SrBlnc.class, "deleting all stored balances cause where is no entries");
                this.getRdb().delete(Blnc.class.getSimpleName().toUpperCase(), null);
                this.blnCh.setPrCh(false);
                this.blnCh.setStDt(this.iniDt);
                this.blnCh.setLeDt(this.iniDt);
                this.blnCh.setCuDt(this.iniDt);
                this.getOrm().update(pRvs, pVs, (IHasId)this.blnCh);
            }
        }
        return this.blnCh.getStDt();
    }

    public final synchronized String evQuBlnc(Map<String, Object> pRvs, Date pDt) throws Exception {
        if (this.quBlnc == null) {
            String flName = "/acc/blnc.sql";
            this.quBlnc = this.loadStr(flName);
        }
        String query = this.quBlnc.replace(":DT1", String.valueOf(this.evDtStPer(pRvs, pDt).getTime()));
        query = query.replace(":DT2", String.valueOf(pDt.getTime()));
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized List<TrBlLn> retBlnLnsToSv(String pQu) throws Exception {
        ArrayList<TrBlLn> rz = new ArrayList<TrBlLn>();
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(pQu);
            if (rs.first()) {
                do {
                    Double debt = rs.getDouble("DEBT");
                    Double cred = rs.getDouble("CRED");
                    TrBlLn tbl = new TrBlLn();
                    tbl.setAcId(rs.getStr("ACID"));
                    tbl.setAcNm(rs.getStr("ACNM"));
                    tbl.setAcNb(rs.getStr("ACNB"));
                    tbl.setSaId(rs.getLong("SAID"));
                    tbl.setSaTy(rs.getInt("SATY"));
                    tbl.setSaNm(rs.getStr("SANM"));
                    tbl.setDebt(BigDecimal.valueOf(debt));
                    tbl.setCred(BigDecimal.valueOf(cred));
                    rz.add(tbl);
                } while (rs.next());
            }
        }
        return rz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadStr(String pFlNm) throws IOException {
        URL urlFile = SrBlnc.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream is = null;){
                is = SrBlnc.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[is.available()];
                is.read(bArray, 0, is.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final synchronized BlnCh lazBlnCh(Map<String, Object> pRvs, Map<String, Object> pVs) throws Exception {
        if (this.blnCh == null) {
            BlnCh balLoc = new BlnCh();
            balLoc.setIid(1L);
            this.getOrm().refrEnt(pRvs, pVs, (IHasId)balLoc);
            if (balLoc.getIid() == null) {
                balLoc.setIid(1L);
                this.getOrm().insIdLn(pRvs, pVs, (IHasId)balLoc);
                balLoc.setIsNew(false);
            }
            this.blnCh = balLoc;
        }
        return this.blnCh;
    }

    public final synchronized IOrm getOrm() {
        return this.orm;
    }

    public final synchronized void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final synchronized IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final synchronized void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final synchronized String getQuBlnc() {
        return this.quBlnc;
    }

    public final synchronized void setQuBlnc(String pQuBlnc) {
        this.quBlnc = pQuBlnc;
    }

    public final synchronized ILog getLog() {
        return this.log;
    }

    public final synchronized void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final synchronized ISrAcStg getSrAcStg() {
        return this.srAcStg;
    }

    public final synchronized void setSrAcStg(ISrAcStg pSrAcStg) {
        this.srAcStg = pSrAcStg;
    }

    public final synchronized SrvClVl getSrvClVl() {
        return this.srvClVl;
    }

    public final synchronized void setSrvClVl(SrvClVl pSrvClVl) {
        this.srvClVl = pSrvClVl;
    }

    public final synchronized boolean getIsAndr() {
        return this.isAndr;
    }

    public final synchronized void setIsAndr(boolean pIsAndr) {
        this.isAndr = pIsAndr;
    }
}

