/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdlb.IDoci;
import org.beigesoft.acc.mdlb.IEntrSrc;
import org.beigesoft.acc.mdlp.AcStg;
import org.beigesoft.acc.mdlp.Acnt;
import org.beigesoft.acc.mdlp.EnrSrc;
import org.beigesoft.acc.mdlp.Entr;
import org.beigesoft.acc.srv.ISrBlnc;
import org.beigesoft.acc.srv.ISrEntr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.mdl.IRecSet;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.srv.II18n;

public class SrEntr<RS>
implements ISrEntr {
    private IOrm orm;
    private IRdb<RS> rdb;
    private II18n i18n;
    private ISrBlnc srBlnc;
    private Map<String, String> entrQus = new HashMap<String, String>();
    private List<EnrSrc> entrSrcs;

    @Override
    public final synchronized void hndStgCng(Map<String, Object> pRvs) throws Exception {
        this.entrSrcs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mkEntrs(Map<String, Object> pRvs, IDoci pDoc) throws Exception {
        AcStg as = (AcStg)((Object)pRvs.get("astg"));
        HashMap vs = new HashMap();
        if (this.entrSrcs == null) {
            SrEntr srEntr = this;
            synchronized (srEntr) {
                if (this.entrSrcs == null) {
                    this.entrSrcs = this.orm.retLst(pRvs, vs, EnrSrc.class);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        boolean isFst = true;
        for (EnrSrc ensr : this.entrSrcs) {
            if (!ensr.getUsed().booleanValue() || !ensr.getSrTy().equals(pDoc.cnsTy())) continue;
            String qu = this.lazEntrQu(ensr.getQuFl());
            String wheDocId = ensr.getSrIdNm() + "=" + pDoc.getIid();
            if (qu.contains(":WHEAD")) {
                qu = qu.replace(":WHEAD", "and " + wheDocId);
            } else if (qu.contains(":WHE")) {
                qu = qu.replace(":WHE", "where " + wheDocId);
            }
            if (isFst) {
                isFst = false;
            } else {
                sb.append("\nunion all\n");
            }
            sb.append(qu);
        }
        if (isFst) {
            throw new ExcCode(1003, "doc_entr_src_no_set");
        }
        String qu = sb.toString().trim() + ";";
        HashSet<ISrBlnc> hnsTrRlBk = (HashSet<ISrBlnc>)pRvs.get("hnsTrRlBk");
        if (hnsTrRlBk == null) {
            hnsTrRlBk = new HashSet<ISrBlnc>();
            pRvs.put("hnsTrRlBk", hnsTrRlBk);
        }
        hnsTrRlBk.add(this.srBlnc);
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        String dcDscr = pDoc.getDscr() != null ? pDoc.getDscr() : "";
        try (IRecSet rs = null;){
            rs = this.getRdb().retRs(qu);
            long dt = pDoc.getDat().getTime();
            if (rs.first()) {
                do {
                    String acCrs;
                    Entr entr = new Entr();
                    entr.setDbOr(this.orm.getDbId());
                    entr.setSrId((Long)pDoc.getIid());
                    entr.setSrTy(pDoc.cnsTy());
                    entr.setDat(new Date(dt++));
                    String acDbs = rs.getStr("ACDB");
                    if (acDbs != null) {
                        Acnt acDb = new Acnt();
                        acDb.setIid(acDbs);
                        entr.setAcDb(acDb);
                        entr.setSadNm(rs.getStr("SADNM"));
                        entr.setSadId(rs.getLong("SADID"));
                        entr.setSadTy(rs.getInt("SADTY"));
                        Double debt = rs.getDouble("DEBT");
                        entr.setDebt(BigDecimal.valueOf(debt).setScale((int)as.getPrDp(), as.getRndm()));
                    }
                    if ((acCrs = rs.getStr("ACCR")) != null) {
                        Acnt acCr = new Acnt();
                        acCr.setIid(acCrs);
                        entr.setAcCr(acCr);
                        entr.setSacNm(rs.getStr("SACNM"));
                        entr.setSacId(rs.getLong("SACID"));
                        entr.setSacTy(rs.getInt("SACTY"));
                        Double cred = rs.getDouble("CRED");
                        entr.setCred(BigDecimal.valueOf(cred).setScale((int)as.getPrDp(), as.getRndm()));
                    }
                    entr.setDscr(this.getI18n().getMsg(pDoc.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + pDoc.getDbOr() + "-" + pDoc.getIid() + ", " + dateFormat.format(pDoc.getDat()) + ". " + dcDscr);
                    this.getOrm().insIdLn(pRvs, vs, (IHasId)entr);
                    this.getSrBlnc().hndNewEntr(pRvs, entr.getDat());
                } while (rs.next());
            }
        }
    }

    @Override
    public final void revEntrs(Map<String, Object> pRvs, IDoci pRvng, IDoci pRved) throws Exception {
        if (pRved.getRvId() != null) {
            throw new ExcCode(100, "Attempt to reverse reversed!");
        }
        if (!pRved.getMdEnr().booleanValue()) {
            throw new ExcCode(100, "Attempt to reverse non-accounted!");
        }
        HashMap vs = new HashMap();
        List entrs = this.orm.retLstCnd(pRvs, vs, Entr.class, "where SRID=" + pRved.getIid() + " and SRTY=" + pRved.cnsTy());
        HashSet<ISrBlnc> hnsTrRlBk = (HashSet<ISrBlnc>)pRvs.get("hnsTrRlBk");
        if (hnsTrRlBk == null) {
            hnsTrRlBk = new HashSet<ISrBlnc>();
            pRvs.put("hnsTrRlBk", hnsTrRlBk);
        }
        hnsTrRlBk.add(this.srBlnc);
        pRvng.setDat(pRved.getDat());
        pRvng.setTot(pRved.getTot().negate());
        pRvng.setMdEnr(true);
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        StringBuffer sb = new StringBuffer();
        if (pRvng.getDscr() != null) {
            sb.append(pRvng.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + pRved.getDbOr() + "-" + pRved.getIid());
        pRvng.setDscr(sb.toString());
        if (pRvng.getIsNew().booleanValue()) {
            this.getOrm().insIdLn(pRvs, vs, (IHasId)pRvng);
        } else {
            this.getOrm().update(pRvs, vs, (IHasId)pRvng);
        }
        for (Entr revd : entrs) {
            Entr revg = new Entr();
            revg.setDbOr(this.orm.getDbId());
            revg.setSrId((Long)pRvng.getIid());
            revg.setSrTy(pRvng.cnsTy());
            this.mkReving(pRvs, revg, revd, pRvng, dateFormat);
            this.orm.insIdLn(pRvs, vs, (IHasId)revg);
            this.getSrBlnc().hndNewEntr(pRvs, revg.getDat());
            this.mkReved(pRvs, revg, revd);
            this.orm.update(pRvs, vs, (IHasId)revd);
            this.getSrBlnc().hndNewEntr(pRvs, revd.getDat());
        }
        sb.delete(0, sb.length());
        if (pRved.getDscr() != null) {
            sb.append(pRved.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
        sb.append(" #" + pRvng.getDbOr() + "-" + pRvng.getIid());
        pRved.setDscr(sb.toString());
        pRved.setRvId((Long)pRved.getIid());
        this.getOrm().update(pRvs, vs, (IHasId)pRved);
    }

    @Override
    public final List<Entr> retEntrs(Map<String, Object> pRvs, IEntrSrc pSrc) throws Exception {
        Long iid = pSrc.getIdOr() != null ? pSrc.getIdOr() : (Long)pSrc.getIid();
        HashMap vs = new HashMap();
        return this.orm.retLstCnd(pRvs, vs, Entr.class, "where SRID=" + iid + " and SRTY=" + pSrc.cnsTy());
    }

    public final void mkReving(Map<String, Object> pRvs, Entr pRving, Entr pRved, IEntrSrc pSrc, DateFormat pDtFrm) {
        pRving.setRvId(pRved.getIid());
        pRving.setDat(pRved.getDat());
        pRving.setDebt(pRved.getDebt().negate());
        pRving.setCred(pRved.getCred().negate());
        pRving.setAcDb(pRved.getAcDb());
        pRving.setSadId(pRved.getSadId());
        pRving.setSadTy(pRved.getSadTy());
        pRving.setSadNm(pRved.getSadNm());
        pRving.setAcCr(pRved.getAcCr());
        pRving.setSacId(pRved.getSacId());
        pRving.setSacTy(pRved.getSacTy());
        pRving.setSacNm(pRved.getSacNm());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getI18n().getMsg(pSrc.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + pSrc.getDbOr() + "-" + pSrc.getIid() + ", " + pDtFrm.format(pSrc.getDat()));
        if (pSrc.getDscr() != null) {
            sb.append(", " + pSrc.getDscr());
        }
        sb.append(" ," + this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + pRved.getDbOr() + "-" + pRved.getIid());
        pRving.setDscr(sb.toString() + "!");
    }

    public final void mkReved(Map<String, Object> pRvs, Entr pRving, Entr pRved) {
        pRved.setRvId(pRving.getIid());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = new StringBuffer();
        if (pRved.getDscr() != null) {
            sb.append(pRved.getDscr() + " !");
        }
        sb.append(this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()));
        sb.append(" #" + pRving.getDbOr() + "-" + pRving.getIid());
        pRved.setDscr(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String lazEntrQu(String pFlNm) throws IOException {
        String rz = this.entrQus.get(pFlNm);
        if (rz == null) {
            SrEntr srEntr = this;
            synchronized (srEntr) {
                rz = this.entrQus.get(pFlNm);
                if (rz == null) {
                    rz = this.loadStr("/acc/entr/" + pFlNm + ".sql");
                    this.entrQus.put(pFlNm, rz);
                }
            }
        }
        return rz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadStr(String pFlNm) throws IOException {
        URL urlFile = SrEntr.class.getResource(pFlNm);
        if (urlFile != null) {
            try (InputStream is = null;){
                is = SrEntr.class.getResourceAsStream(pFlNm);
                byte[] bArray = new byte[is.available()];
                is.read(bArray, 0, is.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        throw new RuntimeException("File not found: " + pFlNm);
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final ISrBlnc getSrBlnc() {
        return this.srBlnc;
    }

    public final void setSrBlnc(ISrBlnc pSrBlnc) {
        this.srBlnc = pSrBlnc;
    }
}

