/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.acc.srv;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.acc.mdl.EDocTy;
import org.beigesoft.acc.mdlb.IDocb;
import org.beigesoft.acc.mdlb.IMkWsEnr;
import org.beigesoft.acc.mdlp.WrhEnr;
import org.beigesoft.acc.mdlp.WrhItm;
import org.beigesoft.acc.mdlp.WrhPl;
import org.beigesoft.acc.srv.ISrWrhEnr;
import org.beigesoft.exc.ExcCode;
import org.beigesoft.hld.IHlIntCls;
import org.beigesoft.log.ILog;
import org.beigesoft.mdl.CmnPrf;
import org.beigesoft.mdl.ColVals;
import org.beigesoft.mdl.IHasId;
import org.beigesoft.rdb.IOrm;
import org.beigesoft.rdb.IRdb;
import org.beigesoft.rdb.SrvClVl;
import org.beigesoft.srv.II18n;

public class SrWrhEnr<RS>
implements ISrWrhEnr {
    private ILog log;
    private IOrm orm;
    private IRdb<RS> rdb;
    private II18n i18n;
    private SrvClVl srvClVl;
    private IHlIntCls hlTyEnSr;
    private boolean isAndr;

    @Override
    public final void load(Map<String, Object> pRvs, IMkWsEnr pEnt, WrhPl pWrp) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        this.mkEntr(pRvs, vs, pEnt, null, pWrp, pEnt.getQuan(), dtFr);
        this.mkWrhItm(pRvs, vs, pEnt, pWrp, pEnt.getQuan());
    }

    @Override
    public final void draw(Map<String, Object> pRvs, IMkWsEnr pEnt, WrhPl pWrp, BigDecimal pQuan) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        long lim = pQuan.longValue() + 1L;
        String where = pWrp != null ? "where ITM=" + pEnt.getItm().getIid() + " and UOM=" + pEnt.getUom().getIid() + " and WRHP=" + pWrp.getIid() + " and ITLF>0 limit " + lim : "where ITM=" + pEnt.getItm().getIid() + " and UOM=" + pEnt.getUom().getIid() + " and ITLF>0 limit " + lim;
        vs.put("WrhItmndFds", new String[]{"itLf"});
        vs.put("WrhItmdpLv", 1);
        List lst = this.orm.retLstCnd(pRvs, vs, WrhItm.class, where);
        vs.clear();
        if (lst.size() == 0) {
            throw new ExcCode(1003, "THERE_IS_NO_GOODS");
        }
        BigDecimal drLf = pQuan;
        for (WrhItm wi : lst) {
            drLf = drLf.subtract(wi.getItLf());
        }
        if (drLf.compareTo(BigDecimal.ZERO) == 1) {
            throw new ExcCode(1003, "THERE_IS_NO_GOODS");
        }
        drLf = pQuan;
        for (WrhItm wi : lst) {
            BigDecimal drCn = drLf.min(wi.getItLf());
            this.mkEntr(pRvs, vs, pEnt, wi.getWrhp(), null, drCn, dtFr);
            this.mkWrhItm(pRvs, vs, pEnt, wi.getWrhp(), drCn.negate());
            if ((drLf = drLf.subtract(drCn)).compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
    }

    @Override
    public final void move(Map<String, Object> pRvs, IMkWsEnr pEnt, WrhPl pWrpFr, WrhPl pWrpTo) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        this.mkEntr(pRvs, vs, pEnt, pWrpFr, pWrpTo, pEnt.getQuan(), dtFr);
        this.mkWrhItm(pRvs, vs, pEnt, pWrpFr, pEnt.getQuan().negate());
        this.mkWrhItm(pRvs, vs, pEnt, pWrpTo, pEnt.getQuan());
    }

    @Override
    public final void revLoad(Map<String, Object> pRvs, IMkWsEnr pEnt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        WrhEnr[] rz = this.mkRevEntr(pRvs, vs, pEnt, dtFr);
        this.mkWrhItm(pRvs, vs, pEnt, rz[1].getWpTo(), rz[1].getQuan().negate());
    }

    @Override
    public final void revDraw(Map<String, Object> pRvs, IMkWsEnr pEnt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        List revds = this.orm.retLstCnd(pRvs, vs, WrhEnr.class, "where SRTY=" + pEnt.cnsTy() + " and SRID=" + pEnt.getRvId() + " and ITM=" + pEnt.getItm().getIid());
        if (revds.size() == 0) {
            throw new ExcCode(1001, "Can't reverse for CLS/RVID/ID/TY: " + pEnt.getClass() + "/" + pEnt.getRvId() + "/" + pEnt.getIid() + "/" + pEnt.cnsTy());
        }
        for (WrhEnr revd : revds) {
            if (revd.getRvId() != null) {
                throw new ExcCode(1001, "Reverse reversed for CLS/RVID/ID/TY: " + pEnt.getClass() + "/" + pEnt.getRvId() + "/" + pEnt.getIid() + "/" + pEnt.cnsTy());
            }
            WrhEnr revg = new WrhEnr();
            revg.setDbOr(this.orm.getDbId());
            revg.setRvId(revd.getIid());
            revg.setSrTy(pEnt.cnsTy());
            revg.setSrId((Long)pEnt.getIid());
            revg.setSowTy(pEnt.getOwnrTy());
            revg.setSowId(pEnt.getOwnrId());
            revg.setItm(revd.getItm());
            revg.setUom(revd.getUom());
            revg.setQuan(revd.getQuan().negate());
            revg.setWpFr(revd.getWpFr());
            revg.setWpTo(revd.getWpTo());
            StringBuffer sb = this.mkDscr(pRvs, pEnt, dtFr);
            sb.append(" ," + this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
            sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
            revg.setDscr(sb.toString() + "!");
            this.orm.insIdLn(pRvs, vs, (IHasId)revg);
            revd.setRvId(revg.getIid());
            revd.setDscr(revd.getDscr() + ", !" + this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()) + " #" + revg.getDbOr() + "-" + revg.getIid() + "!");
            Object[] ndFds = new String[]{"dscr", "rvId", "ver"};
            Arrays.sort(ndFds);
            vs.put("ndFds", ndFds);
            this.orm.update(pRvs, vs, (IHasId)revd);
            vs.clear();
            this.mkWrhItm(pRvs, vs, pEnt, revd.getWpFr(), revd.getQuan());
        }
    }

    @Override
    public final void revMove(Map<String, Object> pRvs, IMkWsEnr pEnt) throws Exception {
        HashMap<String, Object> vs = new HashMap<String, Object>();
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        DateFormat dtFr = DateFormat.getDateTimeInstance(2, 3, new Locale(cpf.getLngDef().getIid()));
        WrhEnr[] rz = this.mkRevEntr(pRvs, vs, pEnt, dtFr);
        this.mkWrhItm(pRvs, vs, pEnt, rz[1].getWpFr(), rz[1].getQuan());
        this.mkWrhItm(pRvs, vs, pEnt, rz[1].getWpTo(), rz[1].getQuan().negate());
    }

    @Override
    public final List<WrhEnr> retEntrs(Map<String, Object> pRvs, IDocb pDoc) throws Exception {
        if (pDoc.getDocTy() == EDocTy.ACC) {
            throw new ExcCode(1001, "Document should not has warehouse entries!");
        }
        HashMap vs = new HashMap();
        List rz = null;
        if (pDoc.getDocTy() == EDocTy.DRAW || pDoc.getDocTy() == EDocTy.DRAWBTH || pDoc.getDocTy() == EDocTy.ITSR || pDoc.getDocTy() == EDocTy.ITSRBTH || pDoc.getDocTy() == EDocTy.WRH || pDoc.getDocTy() == EDocTy.WRHBTH || pDoc.getDocTy() == EDocTy.ITSRDRAWLN || pDoc.getDocTy() == EDocTy.ITSRDRAW) {
            rz = this.orm.retLstCnd(pRvs, vs, WrhEnr.class, "where SRTY=" + pDoc.cnsTy() + " and SRID=" + pDoc.getIid() + ";");
        }
        if (pDoc.getDocTy() == EDocTy.DRAWLN || pDoc.getDocTy() == EDocTy.DRAWBTH || pDoc.getDocTy() == EDocTy.ITSRLN || pDoc.getDocTy() == EDocTy.ITSRBTH || pDoc.getDocTy() == EDocTy.WRHLN || pDoc.getDocTy() == EDocTy.WRHBTH || pDoc.getDocTy() == EDocTy.ITSRDRAWLN) {
            List rzt = this.orm.retLstCnd(pRvs, vs, WrhEnr.class, "where SOWTY=" + pDoc.cnsTy() + " and SOWID=" + pDoc.getIid() + ";");
            if (rz == null) {
                rz = rzt;
            } else {
                rz.addAll(rzt);
            }
        }
        return rz;
    }

    public final void mkWrhItm(Map<String, Object> pRvs, Map<String, Object> pVs, IMkWsEnr pEnt, WrhPl pWrp, BigDecimal pQuan) throws Exception {
        WrhItm rz = new WrhItm();
        rz.setWrhp(pWrp);
        rz.setItm(pEnt.getItm());
        rz.setUom(pEnt.getUom());
        rz.setIsNew(true);
        WrhItm rzt = (WrhItm)this.orm.retEnt(pRvs, pVs, (IHasId)rz);
        if (rzt != null) {
            rz = rzt;
        }
        rz.setItLf(rz.getItLf().add(pQuan));
        if (rz.getItLf().compareTo(BigDecimal.ZERO) == -1) {
            throw new ExcCode(1003, "THERE_IS_NO_GOODS");
        }
        if (rz.getIsNew().booleanValue()) {
            this.orm.insIdNln(pRvs, pVs, (IHasId)rz);
        } else if (this.isAndr) {
            this.orm.update(pRvs, pVs, (IHasId)rz);
        } else {
            ColVals cv = new ColVals();
            if (pQuan.compareTo(BigDecimal.ZERO) == -1) {
                this.srvClVl.put(cv, "itLf", "ITLF-" + pQuan.negate());
            } else {
                this.srvClVl.put(cv, "itLf", "ITLF+" + pQuan);
            }
            this.srvClVl.putExpr(cv, "itLf");
            this.srvClVl.put(cv, "ver", "VER+1");
            this.srvClVl.putExpr(cv, "ver");
            try {
                int ur = this.rdb.update(WrhItm.class, cv, "WRHP=" + rz.getWrhp().getIid() + " and ITM=" + rz.getItm().getIid() + " and UOM=" + rz.getUom().getIid());
                if (ur == 0) {
                    throw new Exception("Something wrong!");
                }
            }
            catch (Exception e) {
                this.log.error(pRvs, this.getClass(), "THERE_IS_NO_GOODS", (Throwable)e);
                throw new ExcCode(1003, "THERE_IS_NO_GOODS");
            }
        }
    }

    public final WrhEnr mkEntr(Map<String, Object> pRvs, Map<String, Object> pVs, IMkWsEnr pEnt, WrhPl pWpFr, WrhPl pWpTo, BigDecimal pQuan, DateFormat pDtFrm) throws Exception {
        WrhEnr rz = new WrhEnr();
        rz.setDbOr(this.orm.getDbId());
        rz.setSrTy(pEnt.cnsTy());
        rz.setSrId((Long)pEnt.getIid());
        rz.setSowTy(pEnt.getOwnrTy());
        rz.setSowId(pEnt.getOwnrId());
        rz.setItm(pEnt.getItm());
        rz.setUom(pEnt.getUom());
        rz.setQuan(pQuan);
        rz.setWpFr(pWpFr);
        rz.setWpTo(pWpTo);
        StringBuffer sb = this.mkDscr(pRvs, pEnt, pDtFrm);
        rz.setDscr(sb.toString());
        this.orm.insIdLn(pRvs, pVs, (IHasId)rz);
        return rz;
    }

    public final WrhEnr[] mkRevEntr(Map<String, Object> pRvs, Map<String, Object> pVs, IMkWsEnr pEnt, DateFormat pDtFrm) throws Exception {
        WrhEnr revd = (WrhEnr)this.orm.retEntCnd(pRvs, pVs, WrhEnr.class, "SRTY=" + pEnt.cnsTy() + " and SRID=" + pEnt.getRvId() + " and ITM=" + pEnt.getItm().getIid());
        if (revd == null) {
            throw new ExcCode(1001, "Can't reverse for CLS/RVID/ID/TY: " + pEnt.getClass() + "/" + pEnt.getRvId() + "/" + pEnt.getIid() + "/" + pEnt.cnsTy());
        }
        if (revd.getRvId() != null) {
            throw new ExcCode(1001, "Reverse reversed for CLS/RVID/ID/TY: " + pEnt.getClass() + "/" + pEnt.getRvId() + "/" + pEnt.getIid() + "/" + pEnt.cnsTy());
        }
        WrhEnr revg = new WrhEnr();
        revg.setDbOr(this.orm.getDbId());
        revg.setRvId(revd.getIid());
        revg.setSrTy(pEnt.cnsTy());
        revg.setSrId((Long)pEnt.getIid());
        revg.setSowTy(pEnt.getOwnrTy());
        revg.setSowId(pEnt.getOwnrId());
        revg.setItm(revd.getItm());
        revg.setUom(revd.getUom());
        revg.setQuan(revd.getQuan().negate());
        revg.setWpFr(revd.getWpFr());
        revg.setWpTo(revd.getWpTo());
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = this.mkDscr(pRvs, pEnt, pDtFrm);
        sb.append(" ," + this.getI18n().getMsg("reversed", cpf.getLngDef().getIid()));
        sb.append(" #" + revd.getDbOr() + "-" + revd.getIid());
        revg.setDscr(sb.toString() + "!");
        this.orm.insIdLn(pRvs, pVs, (IHasId)revg);
        revd.setRvId(revg.getIid());
        revd.setDscr(revd.getDscr() + ", !" + this.getI18n().getMsg("reversing", cpf.getLngDef().getIid()) + " #" + revg.getDbOr() + "-" + revg.getIid() + "!");
        Object[] ndFds = new String[]{"dscr", "rvId", "ver"};
        Arrays.sort(ndFds);
        pVs.put("ndFds", ndFds);
        this.orm.update(pRvs, pVs, (IHasId)revd);
        pVs.clear();
        return new WrhEnr[]{revg, revd};
    }

    public final StringBuffer mkDscr(Map<String, Object> pRvs, IMkWsEnr pSrc, DateFormat pDtFrm) throws Exception {
        CmnPrf cpf = (CmnPrf)pRvs.get("cpf");
        StringBuffer sb = new StringBuffer();
        sb.append(this.getI18n().getMsg("Made_at", cpf.getLngDef().getIid()) + " " + pDtFrm.format(new Date()) + " ");
        sb.append(this.getI18n().getMsg("by_who", cpf.getLngDef().getIid()) + ": ");
        sb.append(this.getI18n().getMsg(pSrc.getClass().getSimpleName() + "sht", cpf.getLngDef().getIid()) + " #" + pSrc.getDbOr() + "-" + pSrc.getIid() + ", " + pDtFrm.format(pSrc.getDocDt()));
        if (pSrc.getOwnrId() != null) {
            sb.append(", " + this.getI18n().getMsg("in", cpf.getLngDef().getIid()) + " " + this.getI18n().getMsg(this.hlTyEnSr.get(pSrc.getOwnrTy()).getSimpleName() + "sht", cpf.getLngDef().getIid()));
            sb.append(" #" + pSrc.getDbOr() + "-" + pSrc.getOwnrId());
        }
        return sb;
    }

    public final ILog getLog() {
        return this.log;
    }

    public final void setLog(ILog pLog) {
        this.log = pLog;
    }

    public final IOrm getOrm() {
        return this.orm;
    }

    public final void setOrm(IOrm pOrm) {
        this.orm = pOrm;
    }

    public final IRdb<RS> getRdb() {
        return this.rdb;
    }

    public final void setRdb(IRdb<RS> pRdb) {
        this.rdb = pRdb;
    }

    public final II18n getI18n() {
        return this.i18n;
    }

    public final void setI18n(II18n pI18n) {
        this.i18n = pI18n;
    }

    public final SrvClVl getSrvClVl() {
        return this.srvClVl;
    }

    public final void setSrvClVl(SrvClVl pSrvClVl) {
        this.srvClVl = pSrvClVl;
    }

    public final boolean getIsAndr() {
        return this.isAndr;
    }

    public final void setIsAndr(boolean pIsAndr) {
        this.isAndr = pIsAndr;
    }

    public final IHlIntCls getHlTyEnSr() {
        return this.hlTyEnSr;
    }

    public final void setHlTyEnSr(IHlIntCls pHlTyEnSr) {
        this.hlTyEnSr = pHlTyEnSr;
    }
}

